/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.custompanel.api.CustomPanelWrapper;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.common.core.utils.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TemplateCustomPanelFactory {
    protected static final String TAG_TEMPLATE_PANEL = "templatePanel";
    protected static final String TAG_ATTR_CLASS = "class";
    protected static final String TAG_FLOW_TYPE = "flowType";
    protected static final String TAG_ATTR_FLOW = "flow";

    protected void parseTemplatePanelDefinitions(IConfigurationElement[] elements, List<TemplatePanelDefinition> panelExt, int offeringNum, int bundleNum, int extensionNum, int offeringBindingNum) {
        if (elements != null && elements.length > 0) {
            int panelNum = 0;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals(TAG_TEMPLATE_PANEL)) {
                    ++panelNum;
                    TemplatePanelDefinition panelDef = new TemplatePanelDefinition(element);
                    panelDef.offeringNum = offeringNum;
                    panelDef.bundleNum = bundleNum;
                    panelDef.extensionNum = extensionNum;
                    panelDef.offeringBindingNum = offeringBindingNum;
                    panelDef.panelNum = panelNum;
                    panelExt.add(panelDef);
                }
                ++n2;
            }
        }
    }

    protected Collection<AgentJob[]> getSortedJobs(AgentJob[] allJobs, boolean isSilentInstall, boolean isMultipleProfile, boolean isUninstall) {
        Collection<Object> sortedJobArrays = new ArrayList<AgentJob[]>();
        if (isSilentInstall || isMultipleProfile) {
            SortUtil.sortByProfileNameAndVersion(allJobs, isUninstall);
            sortedJobArrays = AgentUtil.groupByProfile(allJobs, false);
        } else if (allJobs != null && allJobs.length > 0) {
            List<AgentJob> allProductJobList = Arrays.asList(allJobs);
            List<AgentJob> sortedJobList = SortUtil.sortByNameAndVersion(allProductJobList);
            AgentJob[] sortedJobsArray = sortedJobList.toArray(new AgentJob[sortedJobList.size()]);
            sortedJobArrays.add(sortedJobsArray);
        }
        return sortedJobArrays;
    }

    protected static class BaseTemplatePanelExtList {
        private final List<TemplatePanelDefinition> templatePanels = new LinkedList<TemplatePanelDefinition>();

        protected BaseTemplatePanelExtList() {
        }

        public void addTemplatePanels(List<TemplatePanelDefinition> panels) {
            for (TemplatePanelDefinition def : panels) {
                if (this.templatePanels.contains(def)) continue;
                this.templatePanels.add(def);
            }
        }

        public List<TemplatePanelDefinition> getSortedPanelDefinition() {
            if (this.templatePanels.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<TemplatePanelDefinition> result = new ArrayList<TemplatePanelDefinition>(this.templatePanels);
            Collections.sort(result, new Comparator<TemplatePanelDefinition>(){

                @Override
                public int compare(TemplatePanelDefinition panel1, TemplatePanelDefinition panel2) {
                    int offeringNum1 = panel1.getOfferingNum();
                    int bundleNum1 = panel1.getBundleNum();
                    int extensionNum1 = panel1.getExtensionNum();
                    int offeringBindingNum1 = panel1.getOfferingBindingNum();
                    int panelNum1 = panel1.getPanelNum();
                    int offeringNum2 = panel2.getOfferingNum();
                    int bundleNum2 = panel2.getBundleNum();
                    int extensionNum2 = panel2.getExtensionNum();
                    int offeringBindingNum2 = panel2.getOfferingBindingNum();
                    int panelNum2 = panel2.getPanelNum();
                    if (offeringNum1 != offeringNum2) {
                        return offeringNum1 - offeringNum2;
                    }
                    if (bundleNum1 != bundleNum2) {
                        return bundleNum1 - bundleNum2;
                    }
                    if (extensionNum1 != extensionNum2) {
                        return extensionNum1 - extensionNum2;
                    }
                    if (offeringBindingNum1 != offeringBindingNum2) {
                        return offeringBindingNum1 - offeringBindingNum2;
                    }
                    return panelNum1 - panelNum2;
                }
            });
            return result;
        }
    }

    protected static class TemplatePanelDefinition {
        private final IConfigurationElement element;
        private Set<String> flowTypes;
        private int offeringNum = 0;
        private int bundleNum = 0;
        private int extensionNum = 0;
        private int offeringBindingNum = 0;
        private int panelNum = 0;

        public TemplatePanelDefinition(IConfigurationElement element) {
            this.element = element;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Panel for <").append(this.element.getName());
            String[] stringArray = this.element.getAttributeNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                sb.append(' ').append(attr).append("='").append(this.element.getAttribute(attr)).append('\'');
                ++n2;
            }
            sb.append('>');
            return sb.toString();
        }

        public CustomPanelWrapper createCustomPanelTemplateInstance() throws CoreException {
            if (this.element.getAttribute(TemplateCustomPanelFactory.TAG_ATTR_CLASS) != null) {
                Object extn = this.element.createExecutableExtension(TemplateCustomPanelFactory.TAG_ATTR_CLASS);
                if (!TemplateCustomPanel.class.isInstance(extn)) {
                    throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, NLS.bind((String)"Class specified by \"{0}\" attribute of \"{1}\" element in {2} must be a subtype of {3}; actual type is {4}", (Object[])new Object[]{TemplateCustomPanelFactory.TAG_ATTR_CLASS, this.element.getName(), this.element.getContributor().getName(), TemplateCustomPanel.class.getName(), extn.getClass().getName()})));
                }
                TemplateCustomPanel template = (TemplateCustomPanel)extn;
                return new CustomPanelWrapper(template);
            }
            return null;
        }

        public Set<String> getWizardTypes() {
            if (this.flowTypes == null) {
                this.flowTypes = new LinkedHashSet<String>();
                IConfigurationElement[] iConfigurationElementArray = this.element.getChildren(TemplateCustomPanelFactory.TAG_FLOW_TYPE);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement child = iConfigurationElementArray[n2];
                    String type = child.getAttribute(TemplateCustomPanelFactory.TAG_ATTR_FLOW);
                    if (type != null && type.length() > 0) {
                        this.flowTypes.add(type);
                    }
                    ++n2;
                }
            }
            return this.flowTypes;
        }

        public int getOfferingNum() {
            return this.offeringNum;
        }

        public int getBundleNum() {
            return this.bundleNum;
        }

        public int getExtensionNum() {
            return this.extensionNum;
        }

        public int getOfferingBindingNum() {
            return this.offeringBindingNum;
        }

        public int getPanelNum() {
            return this.panelNum;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TemplatePanelDefinition) {
                TemplatePanelDefinition that = (TemplatePanelDefinition)obj;
                if (this.toString().equals(that.toString())) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

