/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;

public class SharedUpdateAgentUtils {
    public static final int USER_CANCEL = -50;
    public static final int AGENT_UPDATE_NOT_REQUIRED = -51;

    public static IStatus loadAgentServiceRepositories(IOffering agentOffering, Map repLocationMsgMap, IProgressMonitor monitor) {
        IOffering[] offerings = null;
        Agent agent = Agent.getInstance();
        if (agentOffering == null) {
            IOffering[] iOfferingArray;
            agentOffering = agent.getAgentOffering();
            if (agentOffering == null) {
                iOfferingArray = new IOffering[]{};
            } else {
                IOffering[] iOfferingArray2 = new IOffering[1];
                iOfferingArray = iOfferingArray2;
                iOfferingArray2[0] = agentOffering;
            }
            offerings = iOfferingArray;
        } else {
            offerings = new IOffering[]{agentOffering};
        }
        return ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet((Map)repLocationMsgMap, (IRepositoryGroup)agent.getRepositoryGroup(), (IOffering[])offerings, (IProgressMonitor)monitor);
    }

    public static void unloadServiceRepositories(boolean otherServiceRepositoriesLoaded) {
        if (!otherServiceRepositoriesLoaded) {
            ServiceRepositoryUtils.unloadServiceRepositories((IRepositoryGroup)Agent.getInstance().getRepositoryGroup());
        }
    }

    public static IOffering getAgentUpdateOffering(IProgressMonitor monitor, CicMultiStatus status) {
        String msg = Messages.ProgressDialog_Checking_Agent_Update;
        monitor.beginTask(msg, 1);
        monitor.setTaskName(msg);
        try {
            IOffering iOffering = Agent.getInstance().checkForAgentUpdate(status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return iOffering;
        }
        finally {
            monitor.done();
        }
    }

    public static IOffering getAgentUpdateOfferingForSelectedAgentOffering(IOffering selectedAgent, IProgressMonitor monitor, CicMultiStatus status) {
        String msg = Messages.ProgressDialog_Checking_Agent_Update;
        monitor.setTaskName(msg);
        monitor.beginTask(msg, 1);
        IOffering agentUpdate = null;
        Agent agent = Agent.getInstance();
        try {
            agentUpdate = agent.getUpdateForSelectedAgent(selectedAgent, monitor, status);
        }
        finally {
            monitor.done();
        }
        return agentUpdate;
    }

    private static void addToMultiStatus(CicMultiStatus multiStatus, IStatus status) {
        if (!status.isMultiStatus()) {
            multiStatus.add(status);
        } else if (!status.getMessage().isEmpty()) {
            if (!SharedUpdateAgentUtils.hasSameMessage(multiStatus, status)) {
                multiStatus.add(status);
            }
        } else {
            IStatus[] nested;
            IStatus[] iStatusArray = nested = status.getChildren();
            int n = nested.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                if (!SharedUpdateAgentUtils.hasSameMessage(multiStatus, element)) {
                    multiStatus.add(element);
                }
                ++n2;
            }
        }
    }

    private static boolean hasSameMessage(CicMultiStatus multiStatus, IStatus element) {
        boolean hasSameMsg = false;
        IStatus[] children = multiStatus.getChildren();
        if (children != null) {
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element2 = iStatusArray[n2];
                if (element2.getMessage().equals(element.getMessage())) {
                    hasSameMsg = true;
                    break;
                }
                ++n2;
            }
        }
        return hasSameMsg;
    }

    private static void collectionChildrenStatus(IStatus status, Map map) {
        block3: {
            block2: {
                if (status == null || status.getCode() != 6002) break block2;
                if (!(status instanceof RepositoryStatus)) break block3;
                RepositoryStatus repStatus = (RepositoryStatus)status;
                String repMsg = repStatus.getMessage();
                String repLocation = repStatus.getLocation();
                if (repMsg == null || repMsg.trim().length() <= 0 || repLocation == null || repLocation.trim().length() <= 0) break block3;
                ArrayList<RepositoryStatus> repStatusList = new ArrayList<RepositoryStatus>();
                repStatusList.add(repStatus);
                map.put(repLocation, repStatusList);
                break block3;
            }
            if (status != null && status.isMultiStatus()) {
                IStatus[] children;
                IStatus[] iStatusArray = children = status.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus element = iStatusArray[n2];
                    SharedUpdateAgentUtils.collectionChildrenStatus(element, map);
                    ++n2;
                }
            }
        }
    }

    private static String getRepositoryMessages(IStatus status, Boolean[] isWarning) {
        HashMap repLocationMsgList = new HashMap();
        if (!status.isOK() && status.isMultiStatus()) {
            SharedUpdateAgentUtils.collectionChildrenStatus(status, repLocationMsgList);
        }
        IRepositoryGroup repGroup = Agent.getInstance().getRepositoryGroup();
        for (Object element : repGroup) {
            IRepository rep = (IRepository)element;
            IRepositoryInfo repInfo = rep.getRepositoryInfo();
            CommonSharedUIUtils.generateRepositoryStatusList((IRepositoryInfo)repInfo, repLocationMsgList);
        }
        isWarning[0] = CommonSharedUIUtils.repositoryMessageContainWarning(repLocationMsgList);
        return CommonSharedUIUtils.constructRepositoryMessages(repLocationMsgList, (boolean)false);
    }

    public static CicMultiStatus getConnectionAndRepositoryMessageStatus(IStatus status, Boolean[] isWarning) {
        if (!status.isOK()) {
            String msg = String.valueOf(com.ibm.cic.common.core.sharedUI.Messages.TestConnectionResultDlg_notConnected) + "\n\n" + status.getMessage();
            String repMessages = SharedUpdateAgentUtils.getRepositoryMessages(status, isWarning);
            if (repMessages.length() > 0) {
                msg = String.valueOf(msg) + "\n\n";
                msg = String.valueOf(msg) + repMessages;
            }
            CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(status.getPlugin(), 2, status.getCode(), null, status.getException(), msg);
            if (status.isMultiStatus()) {
                IStatus[] children;
                IStatus[] iStatusArray = children = status.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus element = iStatusArray[n2];
                    if (element.getCode() != 6002) {
                        RepositoryStatus.StatusAndErrorType displayStatus = RepositoryStatus.getDisplayStatusForCanAddExisting((String)msg, (IStatus)element);
                        SharedUpdateAgentUtils.addToMultiStatus(multiStatus, (IStatus)displayStatus);
                    }
                    ++n2;
                }
            }
            return multiStatus;
        }
        String repMessages = SharedUpdateAgentUtils.getRepositoryMessages(status, isWarning);
        if (repMessages.length() > 0) {
            CicMultiStatus multiStatus = Statuses.ST.createMultiStatus(Agent.PI_AGENT, 2, 0, null, null, repMessages);
            return multiStatus;
        }
        return Statuses.ST.createMultiStatus();
    }

    public static boolean areOtherServiceRepositoriesLoaded() {
        return ServiceRepositoryUtils.areServiceRepositoriesLoaded((IRepositoryGroup)Agent.getInstance().getRepositoryGroup());
    }
}

