/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.sharedUI.IContainsOffering;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import org.eclipse.core.runtime.IAdaptable;

public class ProfileOffering
implements IContainsOffering,
IAdaptable {
    private final IOffering offering;
    private final Profile profile;

    public ProfileOffering(Profile profile, IOffering offering) {
        this.profile = profile;
        this.offering = offering;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IOffering.class)) {
            return this.offering;
        }
        return this.offering.getAdapter(adapter);
    }

    public static ProfileOffering[] getOfferingsFromProfile(Profile profile) {
        IOffering[] offerings = Agent.getInstance().getInstalledOfferings(profile);
        SortUtil.sortOfferings((IOfferingOrFix[])offerings);
        ProfileOffering[] result = new ProfileOffering[offerings.length];
        int i = 0;
        while (i < offerings.length) {
            result[i] = new ProfileOffering(profile, offerings[i]);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        return this.offering.getIdentity().hashCode() + this.offering.getVersion().hashCode() + this.profile.getProfileId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProfileOffering) {
            if (obj == this) {
                return true;
            }
            ProfileOffering other = (ProfileOffering)obj;
            if (!other.profile.getProfileId().equals(this.profile.getProfileId())) {
                return false;
            }
            if (!other.offering.getIdentity().equals(this.offering.getIdentity())) {
                return false;
            }
            return other.offering.getVersion().equals((Object)this.offering.getVersion());
        }
        return false;
    }

    @Override
    public IOffering getOffering() {
        return this.offering;
    }

    public Profile getProfile() {
        return this.profile;
    }
}

