/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.sharedUI.FeatureGroupStatus;
import com.ibm.cic.agent.core.sharedUI.FeatureStatus;
import com.ibm.cic.agent.core.sharedUI.Messages;
import com.ibm.cic.agent.core.sharedUI.OfferingFeatureStatus;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class PrerequisiteCheckerUtils {
    public static List<OfferingFeatureStatus> validateFeatures(IProgressMonitor monitor, List allJobs, boolean displayInternalVersion, boolean isSingleProfileInstall) {
        ArrayList<OfferingFeatureStatus> statusList = new ArrayList<OfferingFeatureStatus>();
        AgentJob[] allJobsArray = AgentJob.toArray(allJobs);
        Set offeringsSeenBefore = AgentJob.getOfferingSetFromJobs(allJobsArray);
        monitor.beginTask(Messages.ConditionalInstallPage_ProgressCheckPrereq, 9 * allJobs.size());
        try {
            int i = 0;
            while (i < allJobs.size()) {
                IStatus status;
                ArrayList<FeatureStatus> featureStatusList = new ArrayList<FeatureStatus>();
                ArrayList<FeatureGroupStatus> featureGroupStatusList = new ArrayList<FeatureGroupStatus>();
                AbstractJob job = (AbstractJob)allJobs.get(i);
                if (isSingleProfileInstall) {
                    job.setRelatedJobs(allJobsArray, true);
                } else {
                    job.setRelatedJobs(allJobsArray);
                }
                IOfferingOrFix selectedOfferingOrFix = job.getOfferingOrFix();
                CicMultiStatus offeringOrFixStatus = Statuses.ST.createMultiStatus();
                IStatus agentToleranceStatus = Agent.getInstance().checkAgentRequirement(selectedOfferingOrFix, displayInternalVersion);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    agentToleranceStatus = new Status(8, Agent.getBundleId(), Messages.ConditionalInstallPage_ProgressCheckPrereqCanceled);
                }
                offeringOrFixStatus.add(agentToleranceStatus);
                if (!offeringOrFixStatus.isErrorOrCancel() && selectedOfferingOrFix != null && !(status = PrerequisiteCheckerUtils.runPrereqBundles(job)).isOK()) {
                    offeringOrFixStatus.add(status);
                }
                PrerequisiteCheckerUtils.validateOfferingFeaturesAndFeatureGroups(job, offeringOrFixStatus, offeringsSeenBefore, featureStatusList, featureGroupStatusList, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                if (!(offeringOrFixStatus.isOK() && featureStatusList.isEmpty() && featureGroupStatusList.isEmpty())) {
                    if (offeringOrFixStatus.isOK()) {
                        statusList.add(new OfferingFeatureStatus(selectedOfferingOrFix, null, featureStatusList, featureGroupStatusList));
                    } else {
                        statusList.add(new OfferingFeatureStatus(selectedOfferingOrFix, offeringOrFixStatus, featureStatusList, featureGroupStatusList));
                    }
                }
                if (monitor.isCanceled()) {
                    ArrayList<OfferingFeatureStatus> arrayList = statusList;
                    return arrayList;
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return statusList;
    }

    private static void validateOfferingFeaturesAndFeatureGroups(AbstractJob job, CicMultiStatus offeringOrFixStatus, Set offeringsSeenBefore, List<FeatureStatus> featureStatusList, List<FeatureGroupStatus> featureGroupStatusList, IProgressMonitor monitor) {
        Collection offerings = job.getOfferingsForPreReqCheck(offeringsSeenBefore);
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(offerings.size() * 8));
        Iterator j = offerings.iterator();
        while (!offeringOrFixStatus.isErrorOrCancel() && j.hasNext()) {
            IOffering selectedOffering = (IOffering)j.next();
            IFeatureGroup rootGroup = selectedOffering.getFeatureGroup();
            IStatus rootFeatureGroupStatus = Agent.getInstance().checkPrerequisite((IFeatureBase)rootGroup, job);
            sm.worked(2);
            if (monitor.isCanceled()) {
                rootFeatureGroupStatus = new Status(8, Agent.getBundleId(), Messages.ConditionalInstallPage_ProgressCheckGroupCanceled);
            }
            if (!rootFeatureGroupStatus.isOK()) {
                offeringOrFixStatus.add(rootFeatureGroupStatus);
            }
            if (offeringOrFixStatus.isErrorOrCancel()) continue;
            SubMonitor subMonitor = sm.newChild(6);
            PrerequisiteCheckerUtils.collectStatus(job, rootGroup, featureStatusList, featureGroupStatusList, (IProgressMonitor)subMonitor);
        }
    }

    private static void collectStatus(AbstractJob job, IFeatureGroup group, List<FeatureStatus> featureStatusList, List<FeatureGroupStatus> featureGroupStatusList, IProgressMonitor monitor) {
        List features = group.getFeatures();
        List groups = group.getGroups();
        monitor.beginTask(Messages.ConditionalInstallPage_ProgressCheckFeatureGroup, features.size() + 2 * groups.size());
        try {
            IStatus status;
            int i = 0;
            while (i < features.size()) {
                IFeature feature = (IFeature)features.get(i);
                if (feature.isRequired() && !(status = Agent.getInstance().checkPrerequisite((IFeatureBase)feature, job)).isOK()) {
                    featureStatusList.add(new FeatureStatus(SharedUIUtils.getFeatureBaseLabel((IFeatureBase)feature), status));
                }
                if (monitor.isCanceled()) {
                    featureStatusList.add(new FeatureStatus(SharedUIUtils.getFeatureBaseLabel((IFeatureBase)feature), (IStatus)new Status(8, Agent.getBundleId(), Messages.ConditionalInstallPage_ProgressCheckFeatureCanceled)));
                    return;
                }
                monitor.worked(1);
                ++i;
            }
            i = 0;
            while (i < groups.size()) {
                IFeatureGroup featureGroup = (IFeatureGroup)groups.get(i);
                if (featureGroup.isRequired()) {
                    status = Agent.getInstance().checkPrerequisite((IFeatureBase)featureGroup, job);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        featureGroupStatusList.add(new FeatureGroupStatus(SharedUIUtils.getFeatureBaseLabel((IFeatureBase)featureGroup), (IStatus)new Status(8, Agent.getBundleId(), Messages.ConditionalInstallPage_ProgressCheckGroupCanceled)));
                        return;
                    }
                    if (!status.isOK()) {
                        featureGroupStatusList.add(new FeatureGroupStatus(SharedUIUtils.getFeatureBaseLabel((IFeatureBase)featureGroup), status));
                    }
                    if (status.isOK() || status.matches(3)) {
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                        PrerequisiteCheckerUtils.collectStatus(job, featureGroup, featureStatusList, featureGroupStatusList, (IProgressMonitor)subMonitor);
                    }
                } else {
                    if (monitor.isCanceled()) {
                        featureGroupStatusList.add(new FeatureGroupStatus(SharedUIUtils.getFeatureBaseLabel((IFeatureBase)featureGroup), (IStatus)new Status(8, Agent.getBundleId(), Messages.ConditionalInstallPage_ProgressCheckGroupCanceled)));
                        return;
                    }
                    monitor.worked(1);
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static IStatus runPrereqBundles(AgentJob job) {
        if (job == null) {
            throw new IllegalArgumentException("job cannot be null");
        }
        IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
        if (offeringOrFix != null && OfferingProperty.getPrereqBundlesProperty((IOfferingOrFix)offeringOrFix).length() > 0) {
            return Agent.getInstance().evaluatePrereqBundles(offeringOrFix, job);
        }
        return Status.OK_STATUS;
    }
}

