/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.sharedUI.BoundToOfferingExtensionFactory;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public final class CustomPanelOrderFactory
extends BoundToOfferingExtensionFactory {
    private static final String TAG_CUSTOMIZED_PANELS_ORDER = "customPanelsOrder";
    private static final String TAG_PANEL = "panel";
    private static final String TAG_PANEL_ID = "id";
    private static final CustomPanelOrderFactory INSTANCE = new CustomPanelOrderFactory();

    public static CustomPanelOrderFactory getInstance() {
        return INSTANCE;
    }

    public List<JobPanelList> createCustomPanelOrder(WizardType type, AgentJob[] allProductJobs) {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.agent.ui", TAG_CUSTOMIZED_PANELS_ORDER).getExtensions();
        if (extensions.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<JobPanelList> result = new ArrayList<JobPanelList>();
        Collection jobArrays = AgentUtil.groupByProfile(allProductJobs, false);
        for (AgentJob[] jobsInOneProfile : jobArrays) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                this.parseDefinitions(extension, type, jobsInOneProfile, result);
                ++n2;
            }
        }
        return result;
    }

    private void parseDefinitions(IExtension extension, WizardType type, AgentJob[] jobsInOneProfile, List<JobPanelList> result) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String offeringVersion;
            String offeringId;
            AgentJob matchedJob;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("wizardOfferingBinding") && (matchedJob = SharedUIUtils.getJob(offeringId = element.getAttribute("offeringId"), offeringVersion = element.getAttribute("offeringVersion"), jobsInOneProfile)) != null) {
                this.parseWizardExtension(element, type, matchedJob, jobsInOneProfile, result);
            }
            ++n2;
        }
    }

    private void parseWizardExtension(IConfigurationElement element, WizardType type, AgentJob job, AgentJob[] jobsInOneProfile, List<JobPanelList> result) {
        ArrayList<String> panelIds = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren("wizardExtension");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement wizardElement = iConfigurationElementArray[n2];
            String wizardType = wizardElement.getAttribute("wizardType");
            if (wizardType.equals(type.getType())) {
                IConfigurationElement[] iConfigurationElementArray2 = wizardElement.getChildren(TAG_PANEL);
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement panelElement = iConfigurationElementArray2[n4];
                    panelIds.add(panelElement.getAttribute(TAG_PANEL_ID));
                    ++n4;
                }
            }
            ++n2;
        }
        if (!panelIds.isEmpty()) {
            result.add(new JobPanelList(job, panelIds, jobsInOneProfile));
        }
    }

    static class JobPanelList {
        private final AgentJob job;
        private final List<String> panelIds;
        private final AgentJob[] jobsInOneProfile;

        public JobPanelList(AgentJob job, List<String> panelIds, AgentJob[] jobs) {
            this.job = job;
            this.panelIds = panelIds;
            this.jobsInOneProfile = jobs;
        }

        public AgentJob getJob() {
            return this.job;
        }

        public List<String> getPanelIds() {
            return this.panelIds;
        }

        public AgentJob[] getProfileJobs() {
            return this.jobsInOneProfile;
        }
    }
}

