/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.sharedUI.IRepositoryOpener;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AgentReopenRepositoryUtil {

    public static class RepositoryOpener
    implements IRepositoryOpener {
        private final IOfferingOrFix offeringOrFix;
        private final IRepositoryInfo originalRepoInfo;
        private final IRepositoryGroup group;
        private final IArtifact artifact;
        private final IArtifactSession session;
        private final String title;
        private final String titleMessage;
        private String diskLabel;
        private IRepository repo;

        public RepositoryOpener(IRepositoryGroup group, IOfferingOrFix offeringOrFix, IArtifactSession session, IArtifact artifact, IRepositoryInfo originalRepoInfo) {
            this.session = session;
            this.group = group;
            this.offeringOrFix = offeringOrFix;
            this.artifact = artifact;
            this.originalRepoInfo = originalRepoInfo;
            IRepositoryInfo repoInfo = originalRepoInfo;
            if (repoInfo.getType().equals("Volume")) {
                this.diskLabel = repoInfo.getStringProperty("diskSetLabel");
                if (this.diskLabel == null) {
                    this.diskLabel = repoInfo.getStringProperty("diskSetId");
                }
                this.title = Messages.AgentReopenRepositoryPrompter_VolumeRepo_title;
                this.titleMessage = Messages.AgentReopenRepositoryPrompter_VolumeRepo_titleMessage;
            } else {
                this.title = Messages.AgentReopenRepositoryPrompter_title;
                this.titleMessage = Messages.AgentReopenRepositoryPrompter_titleMessage;
            }
        }

        public String getTitle() {
            return this.title;
        }

        public String getTitleMessage() {
            return this.titleMessage;
        }

        public String getDiskLabel() {
            return this.diskLabel;
        }

        public IOfferingOrFix getOfferingOrFix() {
            return this.offeringOrFix;
        }

        public IStatus openAndValidateRepository(String location, IProgressMonitor monitor) {
            IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)RepositoryGroup.getDefault(), (String)location, null, null, (String)location, null);
            String originalDiskSetId = this.originalRepoInfo.getStringProperty("diskSetId");
            if (originalDiskSetId != null) {
                repInfo.setProperty("diskSetId", (Object)originalDiskSetId);
            }
            try {
                this.repo = RepositoryUtils.openExistingRepository((IRepositoryGroup)this.group, (IRepositoryInfo)repInfo, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status.matches(12)) {
                    return status;
                }
                return MultiStatusUtil.recodeLevel((IStatus)status, (int)4);
            }
            boolean hasArtifact = false;
            if (this.repo != null) {
                IStatus statusExists = RepoAs.IArtifactGet((IReadArtifactRepo)this.repo).existsArtifact(this.session, this.artifact, monitor);
                hasArtifact = StatusCodes.isContentFound((IStatus)statusExists);
            }
            if (!hasArtifact) {
                String diskLabelNow;
                String diskSetIdNow = repInfo.getStringProperty("diskSetId");
                String message = diskSetIdNow != null ? ((diskLabelNow = repInfo.getStringProperty("diskSetLabel")) != null ? NLS.bind((String)Messages.AgentReopenRepositoryPrompter_VolumeRepo_artifactNotAvailableOnDiskSetLabeled, (Object[])new Object[]{this.artifact.toUserString(), OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)this.offeringOrFix, (boolean)false), diskLabelNow}) : NLS.bind((String)Messages.AgentReopenRepositoryPrompter_VolumeRepo_artifactNotAvailableOnUnknownDiskSet, (Object)this.artifact.toUserString(), (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)this.offeringOrFix, (boolean)false))) : NLS.bind((String)Messages.AgentReopenRepositoryPrompter_offeringNotAvailable, (Object)this.artifact.toUserString(), (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)this.offeringOrFix, (boolean)false));
                this.group.removeAllRepositories();
                return new Status(4, AgentActivator.getPluginId(), 1, message, null);
            }
            HashMap repLocationMsgList = new HashMap();
            CommonSharedUIUtils.generateRepositoryStatusList((IRepositoryInfo)repInfo, repLocationMsgList);
            return CommonSharedUIUtils.constructRepositoryStatus(repLocationMsgList);
        }

        public IRepository getOpenedRepository() {
            return this.repo;
        }

        public void release() {
            this.group.removeAllRepositories();
            this.repo = null;
        }

        public IRepositoryInfo getRepositoryInfo() {
            return this.originalRepoInfo;
        }
    }
}

