/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response.impl;

import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.agent.core.internal.response.impl.DiffHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Diff {
    public static final int REMOVE = 0;
    public static final int CREATE = 1;
    public static final int REPLACE = 2;
    private final DiffHelper diffHelper = new DiffHelper();
    private final IElementProxy source;
    private final IElementProxy target;
    private final List children = new ArrayList();
    private int kind;

    public Diff(IElementProxy source, IElementProxy target) {
        this.source = source;
        this.target = target;
    }

    public boolean isCreate() {
        return this.kind == 1;
    }

    public boolean isReplace() {
        return this.kind == 2;
    }

    public boolean isRemove() {
        return this.kind == 0;
    }

    public Diff addReplace(IElementProxy srcElement, IElementProxy targetElement) {
        Diff diff = this.diffHelper.diffReplace(srcElement, targetElement);
        if (diff != null) {
            this.children.add(diff);
        }
        return diff;
    }

    public Diff addCreate(IElementProxy srcElement) {
        Diff diff = this.diffHelper.diffCreate(srcElement);
        if (diff != null) {
            this.children.add(diff);
        }
        return diff;
    }

    public void addRemove(IElementProxy srcElement, List targetElms) {
        for (IElementProxy tgt : targetElms) {
            List diffs = this.diffHelper.diffRemove(srcElement, tgt);
            this.addChild(diffs);
        }
    }

    public void addRemove(IElementProxy srcElement, IElementProxy targetElm) {
        if (srcElement == null || targetElm == null) {
            throw new IllegalArgumentException();
        }
        List diffs = this.diffHelper.diffRemove(srcElement, targetElm);
        this.addChild(diffs);
    }

    public IElementProxy getSourceElement() {
        return this.source;
    }

    public IElementProxy getTargetElement() {
        return this.target;
    }

    public void addRemoveSource(IElementProxy sourceElement) {
        List diffs = this.diffHelper.diffRemoveSource(sourceElement);
        this.addChild(diffs);
    }

    private void addChild(List diffs) {
        this.children.addAll(diffs);
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addRemoveTarget(IElementProxy targetElement) {
        List diffs = this.diffHelper.diffRemoveTarget(targetElement);
        this.addChild(diffs);
    }

    public void setKind(int kind) {
        this.kind = kind;
    }
}

