/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.headless;

import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InstallFixesAction {
    public static final String S_NONE = "none";
    public static final String S_RECOMMENDED = "recommended";
    public static final String S_ALL = "all";
    public static final InstallFixesAction NONE = new InstallFixesAction("none");
    public static final InstallFixesAction RECOMMENDED = new InstallFixesAction("recommended");
    public static final InstallFixesAction ALL = new InstallFixesAction("all");
    private static final InstallFixesAction DEFAULT_INSTALLFIXES_INSTALLCMD_OFFVSN = NONE;
    private static final InstallFixesAction DEFAULT_INSTALLFIXES_INSTALLCMD_NO_OFFVSN = ALL;
    private final String name;
    private final List<String> superset;

    private InstallFixesAction(String name) {
        this.name = name;
        this.superset = S_ALL.equals(name) ? Arrays.asList(S_ALL) : (S_RECOMMENDED.equals(name) ? Arrays.asList(S_ALL, S_RECOMMENDED) : (S_NONE.equals(name) ? Arrays.asList(S_ALL, S_RECOMMENDED, S_NONE) : Collections.emptyList()));
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstallFixesAction) {
            InstallFixesAction ifAction = (InstallFixesAction)obj;
            return ifAction.getName().equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static boolean isValidInstallFixesString(String aname) {
        return S_NONE.equals(aname) || S_RECOMMENDED.equals(aname) || S_ALL.equals(aname);
    }

    public static IStatus isValidShowFixesValue(InstallFixesAction ifAction, InstallFixesAction sfAction, boolean installFixesSpecified, boolean showFixesSpecified) {
        if (!showFixesSpecified) {
            return Status.OK_STATUS;
        }
        if (!ifAction.superset.contains(sfAction.getName())) {
            if (!installFixesSpecified) {
                assert (ifAction.equals(ALL));
                return Statuses.ERROR.get(Messages.InstallFixesAction_InvalidShowFixesValueForInstallFixesNotSpecified, new Object[]{sfAction.getName(), S_ALL, S_ALL});
            }
            if (ifAction.equals(ALL)) {
                return Statuses.ERROR.get(Messages.InstallFixesAction_InvalidShowFixesValueForInstallFixesSpecified, new Object[]{sfAction.getName(), S_ALL, S_ALL});
            }
            assert (ifAction.equals(RECOMMENDED));
            return Statuses.ERROR.get(Messages.InstallFixesAction_InvalidShowFixesValueForInstallFixesSpecifiedTwoValues, new Object[]{sfAction.getName(), S_RECOMMENDED, S_ALL, S_RECOMMENDED});
        }
        return Status.OK_STATUS;
    }

    public static InstallFixesAction getInstallFixesAction(String installFixesStr) {
        if (installFixesStr == null) {
            return null;
        }
        if (installFixesStr.equals(S_NONE)) {
            return NONE;
        }
        if (installFixesStr.equals(S_RECOMMENDED)) {
            return RECOMMENDED;
        }
        if (installFixesStr.equals(S_ALL)) {
            return ALL;
        }
        return new InstallFixesAction(installFixesStr);
    }

    public static InstallFixesAction getInstallFixesAction(String installFixesStr, boolean versionSpecified) {
        if (installFixesStr != null) {
            return InstallFixesAction.getInstallFixesAction(installFixesStr);
        }
        if (versionSpecified) {
            return DEFAULT_INSTALLFIXES_INSTALLCMD_OFFVSN;
        }
        return DEFAULT_INSTALLFIXES_INSTALLCMD_NO_OFFVSN;
    }
}

