/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.IViewLogCommand;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.parser.CicLogParser;
import com.ibm.cic.common.logging.parser.EntryRecord;
import com.ibm.cic.common.logging.parser.LogRecord;
import com.ibm.cic.common.logging.parser.Messages;
import com.ibm.cic.common.logging.parser.ThrownRecord;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ViewLogCommand
extends AbstractCommand
implements IViewLogCommand {
    private final String logFileName;
    private static final String LogFileFormat = "%4s. ";
    private static final String LogEntryHeaderFormat = "%s. ";
    private static final String LogEntryFormat = "%-25s:  %s";

    public ViewLogCommand(String logFileName) {
        super("viewLog");
        this.logFileName = logFileName;
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        OutputFormatter output = new OutputFormatter();
        File logDirectory = LogManager.getDirectory();
        File[] logFiles = AgentUtil.getLogFiles(true);
        if (this.logFileName == null || this.logFileName.trim().length() == 0) {
            if (logFiles == null || logFiles.length == 0) {
                output.appendNT(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Cmd_viewLog_Error_NoLogFiles, (Object)logDirectory));
            } else {
                output.appendNTnl(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Cmd_viewLog_File_Header, (Object)logDirectory));
                output.appendTnl(new String[]{""});
                int i = 0;
                while (i < logFiles.length) {
                    output.appendNT(String.format(LogFileFormat, i + 1));
                    output.appendNTnl(logFiles[i].getName());
                    ++i;
                }
            }
        } else {
            File logFile = null;
            File absoluteFile = new File(this.logFileName);
            logFile = absoluteFile.isAbsolute() ? absoluteFile : new File(logDirectory, this.logFileName);
            boolean logFileExist = false;
            if (logFiles != null && logFiles.length > 0) {
                File[] fileArray = logFiles;
                int n = logFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File logFile2 = fileArray[n2];
                    if (logFile.equals(logFile2)) {
                        logFileExist = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!logFileExist) {
                output.appendNTnl(com.ibm.cic.agent.internal.core.Messages.Cmd_viewLog_Error_LogFileNotExist);
            } else {
                LogRecord record = null;
                try {
                    record = new CicLogParser().parse(logFile);
                }
                catch (Exception e) {
                    return Statuses.ERROR.get((Throwable)e, Messages.CicLogParser_error_parsing_log_record, new Object[0]);
                }
                output.appendNTnl(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Cmd_viewLog_Entry_Header, (Object)logFile.getAbsolutePath()));
                output.appendTnl(new String[]{""});
                List records = record.getRecords();
                int i = 0;
                while (i < records.size()) {
                    Object element = records.get(i);
                    if (element != null && element instanceof EntryRecord) {
                        EntryRecord entry = (EntryRecord)element;
                        output.appendNTnl(String.format(LogEntryHeaderFormat, i + 1));
                        output.incTab();
                        output.appendTnl(new String[]{String.format(LogEntryFormat, com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_dateCol, LogUtil.toISO8601((long)entry.getTime()))});
                        output.appendTnl(new String[]{String.format(LogEntryFormat, com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_severityCol, SharedUIUtils.getLogSeverity(entry.getLevel()))});
                        String messageId = entry.getUid();
                        if (messageId != null) {
                            output.appendTnl(new String[]{String.format(LogEntryFormat, com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_messageIDCol, messageId)});
                        }
                        output.appendTnl(new String[]{String.format(LogEntryFormat, com.ibm.cic.agent.core.sharedUI.Messages.AgentLogView_desCol, SharedUIUtils.constructLogDescription(entry))});
                        ThrownRecord stackTrace = entry.getThrownRecord();
                        if (SharedUIUtils.displayStatckTrace(stackTrace)) {
                            output.appendTnl(new String[]{String.format(LogEntryFormat, com.ibm.cic.agent.internal.core.Messages.ConPageLogEntry_Exception, SharedUIUtils.formatStackTrace(stackTrace))});
                        }
                        output.decTab();
                    }
                    ++i;
                }
            }
        }
        System.out.print(output.toString());
        return Status.OK_STATUS;
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }
}

