/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.ErrorJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.internal.commands.AbstractInstallCommand;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IUpdateCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IOffering;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class UpdateCommand
extends AbstractInstallCommand
implements IUpdateCommand {
    public UpdateCommand() {
        super("update");
    }

    @Override
    protected IStatus execute(Agent agent, AgentJob[] agentJobs, IProgressMonitor monitor) {
        return new Status(4, Agent.PI_AGENT, 4, Messages.UpdateCommand_ExecuteError, null);
    }

    @Override
    protected AgentJob[] getAsInputJob(Agent agent, XMLElement unit, boolean isWizardMode, Profile defaultProfile) {
        UpdateOfferingJob job;
        String profileId = unit.getAttribute("profile");
        Profile profile = agent.getProfile(profileId);
        String idString = unit.getAttribute("id");
        if (profile == null) {
            String installLocation = unit.getAttribute("installLocation");
            if (installLocation != null) {
                profile = agent.getProfileByInstallLocation(installLocation);
                if (profile == null) {
                    return ErrorJob.create(false, Messages.UnisntallCommand_NoPackageIsInstalledAtLocation, installLocation);
                }
            } else if (idString != null) {
                List profiles = agent.getProfilesByOfferingOrFixId(idString);
                if (profiles.size() == 1) {
                    profile = (Profile)profiles.get(0);
                } else if (profiles.size() > 1) {
                    return ErrorJob.create(false, Messages.UpdateCommand_InstalledInMoreThenOneLocation, idString);
                }
            }
        }
        if (profile != null) {
            if (idString == null) {
                job = new UpdateOfferingJob(profile, null);
            } else {
                IOffering[] offerings;
                IOffering offering = null;
                IOffering[] iOfferingArray = offerings = agent.getInstalledOfferings(profile);
                int n = offerings.length;
                int n2 = 0;
                while (n2 < n) {
                    IOffering offering2 = iOfferingArray[n2];
                    if (offering2.getIdentity().getId().equals(idString)) {
                        offering = offering2;
                        break;
                    }
                    ++n2;
                }
                if (offering == null) {
                    String fileName = this.getInput().getInputFilePath();
                    String errorMsg = fileName != null ? NLS.bind((String)Messages.UpdateCommand_offeringNotInstalled_InFile, (Object)idString, (Object)fileName) : NLS.bind((String)Messages.UpdateCommand_offeringNotInstalled, (Object)idString);
                    return ErrorJob.create(false, errorMsg, new Object[0]);
                }
                job = new UpdateOfferingJob(profile, offering);
            }
        } else {
            return ErrorJob.create(true, Messages.HeadlessApplication_Cannot_Find_Profile, profileId);
        }
        return new AgentJob[]{job};
    }
}

