/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.headless.IPreferenceCommand;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class PreferenceCommand
extends AbstractCommand
implements IPreferenceCommand {
    private static final Logger log = Logger.getLogger(PreferenceCommand.class, (Plugin)AgentActivator.getDefault());

    PreferenceCommand() {
        super("preference");
    }

    public PreferenceCommand(String name, String value) {
        this();
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.addAttribute("name", name);
        this.addAttribute("value", value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        String name = this.getAttribute("name");
        String value = this.getAttribute("value");
        if (name == null || value == null) {
            return Statuses.ERROR.get(Messages.HeadlessApplication_No_Value_Specified, new Object[0]);
        }
        if (name.equals("com.ibm.cic.common.core.preferences.eclipseCache")) {
            value = new File(value).getAbsolutePath();
            boolean openRegistry = false;
            try {
                if (!InstallRegistry.getInstance().isOpen()) {
                    InstallRegistry.getInstance().open();
                    openRegistry = true;
                }
                if (CacheLocationManager.getInstance().isCacheLocationChangeable()) {
                    CacheLocationManager.getInstance().setCacheLocation(value);
                    return Status.OK_STATUS;
                }
                if (FileUtil.filesAreSame((String)CacheLocationManager.getInstance().getCacheLocation(), (String)value)) return Status.OK_STATUS;
                log.warning(Messages.Agent_Cache_Location_Not_Changeable, new Object[]{CacheLocationManager.getInstance().getCacheLocation(), value});
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                if (!openRegistry || !InstallRegistry.getInstance().isOpen()) return e.getStatus();
                InstallRegistry.getInstance().close();
                return e.getStatus();
            }
        } else {
            ICicPreferenceHandler handler = CicPreferenceManager.getInstance().getCurrentPreferenceHandler();
            if (!value.isEmpty()) {
                handler.setValue(name, value);
                return Status.OK_STATUS;
            } else {
                handler.remove(name);
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public int getExecutionPoint() {
        return 1;
    }

    @Override
    public String getPreferenceName() {
        return this.getAttribute("name");
    }

    @Override
    public String getPreferenceValue() {
        return this.getAttribute("value");
    }

    @Override
    public boolean needAccessRepositories() {
        return false;
    }
}

