/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.ErrorJob;
import com.ibm.cic.agent.core.ModifyJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.commands.AbstractInstallCommand;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IModifyCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class ModifyCommand
extends AbstractInstallCommand
implements IModifyCommand {
    public ModifyCommand() {
        super("modify");
    }

    @Override
    protected IStatus execute(Agent agent, AgentJob[] agentJobs, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AgentJob[] getAsInputJob(Agent agent, XMLElement unit, boolean isWizardMode, Profile defaultProfile) {
        IOffering[] offerings;
        String profileId = unit.getAttribute("profile");
        Profile profile = agent.getProfile(profileId);
        String idString = unit.getAttribute("id");
        if (profile == null) {
            return ErrorJob.create(true, Messages.HeadlessApplication_Cannot_Find_Profile, profileId);
        }
        if (idString == null) {
            return new AgentJob[]{new ModifyJob(profile, null)};
        }
        IOffering offering = null;
        IOffering[] iOfferingArray = offerings = agent.getInstalledOfferings(profile);
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering2 = iOfferingArray[n2];
            if (offering2.getIdentity().getId().equals(idString)) {
                offering = offering2;
                break;
            }
            ++n2;
        }
        if (offering == null) {
            String fileName = this.getInput().getInputFilePath();
            String errorMsg = fileName != null ? NLS.bind((String)Messages.ModifyCommand_offeringNotInstalled_InFile, (Object)idString, (Object)fileName) : NLS.bind((String)Messages.ModifyCommand_offeringNotInstalled, (Object)idString);
            return ErrorJob.create(false, errorMsg, new Object[0]);
        }
        return new AgentJob[]{new ModifyJob(profile, (IOfferingOrFix)offering)};
    }
}

