/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.IListInstalledFeaturesCommand;
import com.ibm.cic.agent.core.internal.commands.ListCommandUtil;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ListInstalledFeaturesCommand
extends AbstractCommand
implements IListInstalledFeaturesCommand {
    public ListInstalledFeaturesCommand() {
        super("listInstalledFeatures");
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        Collection<InstallRegistry.ProfileInstallRegistry> pirs = InstallRegistry.getInstance().getProfileInstallRegistries();
        String offeringIdVersion = CmdLine.CL.getParam1StrVal("listInstalledFeatures");
        String installationDirectory = CmdLine.CL.getInstallationDirectory();
        ArrayList<IOffering> offerings = new ArrayList<IOffering>(pirs.size());
        ArrayList<Profile> profiles = new ArrayList<Profile>(pirs.size());
        boolean found = this.searchOffering(pirs, offerings, profiles, offeringIdVersion, installationDirectory);
        if (installationDirectory == null) {
            if (offerings.size() > 1) {
                return this.getMultipleInstancesError(profiles, offeringIdVersion);
            }
            if (offerings.size() == 1) {
                this.outputFeatures(agent, (IOffering)offerings.get(0), (Profile)profiles.get(0));
                return Status.OK_STATUS;
            }
            return Statuses.ERROR.get(Messages.AbstractCommand_PackageIsNotInstalled, new Object[]{offeringIdVersion});
        }
        if (!found) {
            return Statuses.ERROR.get(Messages.Cmd_installationDirectory_notFound, new Object[]{installationDirectory});
        }
        return this.listFeaturesForDirectory(agent, offerings, profiles, offeringIdVersion, installationDirectory);
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }

    private boolean searchOffering(Collection<InstallRegistry.ProfileInstallRegistry> pirs, List offerings, List profiles, String offeringIdVersion, String installationDirectory) {
        boolean found = false;
        for (InstallRegistry.ProfileInstallRegistry pir : pirs) {
            IOffering[] installedOfferings;
            Profile p = pir.getProfile();
            if (!found && installationDirectory != null && FileUtil.filesAreSame((String)installationDirectory, (String)p.getInstallLocation())) {
                found = true;
            }
            IOffering[] iOfferingArray = installedOfferings = pir.getInstalledOfferings();
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering installedOffering = iOfferingArray[n2];
                if (OfferingUtil.offeringMatchesIdVersion((IOffering)installedOffering, (String)offeringIdVersion)) {
                    offerings.add(installedOffering);
                    profiles.add(p);
                }
                ++n2;
            }
        }
        return found;
    }

    private IStatus getMultipleInstancesError(List<Profile> profiles, String offeringIdVersion) {
        StringBuffer msg = new StringBuffer(32 + profiles.size() * 32);
        for (Profile p : profiles) {
            msg.append(OutputFormatter.NEW_LINE_STR);
            msg.append("listInstalledFeatures");
            msg.append(" ");
            msg.append(offeringIdVersion);
            msg.append(" ");
            msg.append("-installationDirectory");
            msg.append(" ");
            msg.append("\"");
            msg.append(p.getInstallLocation());
            msg.append("\"");
        }
        return Statuses.ERROR.get(Messages.Cmd_listInstalledFeatures_multipleInstancesError, new Object[]{offeringIdVersion, msg.toString()});
    }

    private IStatus listFeaturesForDirectory(Agent agent, List<IOffering> offerings, List<Profile> profiles, String offeringIdVersion, String installationDirectory) {
        int i = 0;
        while (i < offerings.size()) {
            Profile p = profiles.get(i);
            if (FileUtil.filesAreSame((String)installationDirectory, (String)p.getInstallLocation())) {
                this.outputFeatures(agent, offerings.get(i), p);
                return Status.OK_STATUS;
            }
            ++i;
        }
        return Statuses.ERROR.get(Messages.AbstractCommand_PackageIsNotInstalledAtDirectory, new Object[]{offeringIdVersion, installationDirectory});
    }

    private void outputFeatures(Agent agent, IOffering offering, Profile profile) {
        OutputFormatter output = new OutputFormatter();
        boolean longListing = CmdLine.CL.containsCommand("-long");
        Collection<IFeature> optionalFeatures = AgentUtil.getVisibleOptionalInstalledFeatures(agent, profile, offering);
        for (IFeature f : optionalFeatures) {
            ListCommandUtil.listFeature(output, f, longListing, false);
        }
        System.out.print(output.toString());
    }
}

