/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.IListInstallationDirectoriesCommand;
import com.ibm.cic.agent.core.internal.commands.ListCommandUtil;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.common.core.utils.OutputFormatter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ListInstallationDirectoriesCommand
extends AbstractCommand
implements IListInstallationDirectoriesCommand {
    public ListInstallationDirectoriesCommand() {
        super("listInstallationDirectories");
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        OutputFormatter output = new OutputFormatter();
        boolean longListing = CmdLine.CL.containsCommand("-long");
        boolean verboseListing = CmdLine.CL.containsCommand("-verbose");
        ListCommandUtil.listSharedInformation(output, longListing, verboseListing);
        for (InstallRegistry.ProfileInstallRegistry pir : InstallRegistry.getInstance().getProfileInstallRegistries()) {
            Profile p = pir.getProfile();
            if (p.isAgentProfile() || !p.shouldBeVisible()) continue;
            ListCommandUtil.listProfile(output, p, longListing, verboseListing);
        }
        System.out.print(output.toString());
        return Status.OK_STATUS;
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }
}

