/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.OutputFormatter;
import java.util.Collection;
import java.util.List;

public class ListCommandUtil {
    public static void listSharedInformation(OutputFormatter output, boolean longFormat, boolean verboseForamt) {
        if (longFormat) {
            output.appendTnl(new String[]{"*", " : ", CacheLocationManager.getInstance().getCacheLocation()});
        } else if (verboseForamt) {
            output.appendNTnl(Messages.Cmd_verbose_shared);
            output.appendTnl(new String[]{Messages.Cmd_verbose_sharedResourcesDirectory, " ", CacheLocationManager.getInstance().getCacheLocation()});
            output.nl();
        }
    }

    public static void listProfile(OutputFormatter output, Profile p, boolean longFormat, boolean verboseForamt) {
        if (longFormat) {
            String nlData = p.getData("cic.selector.nl");
            output.appendTnl(new String[]{p.getInstallLocation(), " : ", p.getProfileId(), " : ", nlData == null ? "" : nlData});
        } else if (verboseForamt) {
            output.appendNTnl(Messages.Cmd_verbose_packageGroup);
            output.appendTnl(new String[]{Messages.Cmd_verbose_name, " ", p.getProfileId()});
            output.appendTnl(new String[]{Messages.Cmd_verbose_installationDirectory, " ", p.getInstallLocation()});
            output.appendTnl(new String[]{Messages.Cmd_verbose_translations, " ", ProfileLanguageUtils.getLabelString((String)p.getData("cic.selector.nl"))});
            if (BitModeUtils.isBitModeApplicable(p)) {
                output.appendTnl(new String[]{Messages.Cmd_verbose_architecture, " ", BitModeUtils.getBitModeText(p)});
            }
            output.nl();
        } else {
            output.appendNTnl(p.getInstallLocation());
        }
    }

    public static void listFeature(OutputFormatter output, IFeature f, boolean longFormat, boolean verboseForamt) {
        if (verboseForamt) {
            output.appendT(new String[]{"    ", f.getInformation().getName(), " ", "(", f.getIdentity().getId(), ") "});
        } else {
            output.appendNT(f.getIdentity().getId());
            if (longFormat) {
                output.appendT(new String[]{" : ", f.getInformation().getName()});
            }
        }
        output.nl();
    }

    private static void listInstalledFeatures(OutputFormatter output, Profile p, IOffering offering, Agent agent) {
        output.appendNTnl(Messages.Cmd_verbose_features);
        Collection<IFeature> optionalFeatures = AgentUtil.getVisibleOptionalInstalledFeatures(agent, p, offering);
        if (optionalFeatures.size() > 0) {
            for (IFeature feature : optionalFeatures) {
                ListCommandUtil.listFeature(output, feature, false, true);
            }
        } else {
            output.appendTnl(new String[]{"    ", Messages.Cmd_verbose_none});
        }
    }

    private static void listInstalledFixes(OutputFormatter output, Profile p, IOffering offering, Agent agent) {
        output.appendNTnl(Messages.Cmd_verbose_fixes);
        IFix[] fixes = agent.getInstalledFixes(p, offering);
        if (fixes.length > 0) {
            IFix[] iFixArray = fixes;
            int n = fixes.length;
            int n2 = 0;
            while (n2 < n) {
                IFix fix = iFixArray[n2];
                output.appendTnl(new String[]{"    ", fix.getName(), " ", "(", fix.getIdentity().getId(), ") "});
                ++n2;
            }
        } else {
            output.appendTnl(new String[]{"    ", Messages.Cmd_verbose_none});
        }
    }

    private static void listRollbackVersions(OutputFormatter output, Profile p, IOffering offering, Agent agent) {
        output.appendNTnl(Messages.Cmd_verbose_rollbackVersions);
        List<IOffering> rollbackOfferings = agent.getRollbackOfferings(p, offering);
        if (rollbackOfferings.isEmpty()) {
            output.appendTnl(new String[]{"    ", Messages.Cmd_verbose_none});
        } else {
            for (IOffering rollbackOffering : rollbackOfferings) {
                output.appendTnl(new String[]{"    ", OfferingUtil.getDisplayableVersion((IOfferingOrFix)rollbackOffering), " ", "(", rollbackOffering.getVersion().toString(), ") "});
            }
        }
    }

    public static void listInstalledOfferings(OutputFormatter output, Profile p, Agent agent) {
        IOffering[] iOfferingArray = p.getInstalledOfferings();
        int n = iOfferingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            output.appendNTnl(Messages.Cmd_verbose_package);
            output.appendTnl(new String[]{Messages.Cmd_verbose_name, " ", offering.getName(), " ", "(", offering.getIdentity().getId(), ") "});
            output.appendTnl(new String[]{Messages.Cmd_verbose_version, " ", OfferingUtil.getDisplayableVersion((IOfferingOrFix)offering), " ", "(", offering.getVersion().toString(), ") "});
            String repInfo = p.getInstallRegistry().getInstalledRepositoryInfo((IOfferingOrFix)offering);
            String repLocation = RepositoryInfo.deserialize((String)repInfo).getLocationStr();
            output.appendTnl(new String[]{Messages.Cmd_verbose_repository, " ", repLocation});
            ListCommandUtil.listInstalledFeatures(output, p, offering, agent);
            ListCommandUtil.listInstalledFixes(output, p, offering, agent);
            ListCommandUtil.listRollbackVersions(output, p, offering, agent);
            output.nl();
            ++n2;
        }
    }
}

