/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.internal.commands.DataElement;
import com.ibm.cic.agent.core.internal.commands.IParseMessageFormatter;
import com.ibm.cic.agent.core.internal.commands.ImportCommand;
import com.ibm.cic.agent.core.internal.commands.InstallAllCommand;
import com.ibm.cic.agent.core.internal.commands.InstallCommand;
import com.ibm.cic.agent.core.internal.commands.LicenseCommand;
import com.ibm.cic.agent.core.internal.commands.MissingRequiredAttrException;
import com.ibm.cic.agent.core.internal.commands.ModifyCommand;
import com.ibm.cic.agent.core.internal.commands.PreferenceCommand;
import com.ibm.cic.agent.core.internal.commands.ProfileCommand;
import com.ibm.cic.agent.core.internal.commands.RollbackCommand;
import com.ibm.cic.agent.core.internal.commands.ServerCommand;
import com.ibm.cic.agent.core.internal.commands.UninstallAllCommand;
import com.ibm.cic.agent.core.internal.commands.UninstallCommand;
import com.ibm.cic.agent.core.internal.commands.UpdateAllCommand;
import com.ibm.cic.agent.core.internal.commands.UpdateCommand;
import com.ibm.cic.agent.core.internal.commands.ValidateAllCommand;
import com.ibm.cic.agent.core.internal.commands.ValidateCommand;
import com.ibm.cic.agent.core.internal.commands.VariablesCommand;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.commands.XMLRule;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InputParser
extends DefaultHandler
implements IParseMessageFormatter {
    private static ServiceTracker xmlTracker = null;
    private final BundleContext context;
    private final String path;
    private final Stack ruleStack = new Stack();
    private XMLRule currentRule;
    private final Stack elementStack = new Stack();
    private XMLElement currentElement;
    private Locator locator = null;
    private CicMultiStatus parserStatus = null;

    public static SAXParserFactory acquireXMLParsing(BundleContext context) {
        if (xmlTracker == null) {
            xmlTracker = new ServiceTracker(context, "javax.xml.parsers.SAXParserFactory", null);
            xmlTracker.open();
        }
        return (SAXParserFactory)xmlTracker.getService();
    }

    public static void releaseXMLParsing() {
        if (xmlTracker != null) {
            xmlTracker.close();
        }
    }

    public InputParser(String path) {
        this.path = path;
        this.context = AgentActivator.getDefault().getContext();
    }

    public XMLElement parse(InputStream input, XMLRule rule, CicMultiStatus status) throws IOException, SAXException, ParserConfigurationException {
        this.currentRule = rule;
        this.parserStatus = Statuses.ST.createMultiStatus();
        try {
            this.getParser().parse(input, (DefaultHandler)this);
        }
        catch (SAXException e) {
            throw new SAXException(this.formatMessage(e.getMessage()));
        }
        if (!this.parserStatus.isOK()) {
            status.add((IStatus)this.parserStatus);
        }
        if (!this.currentElement.isEmpty()) {
            return this.currentElement.getChild(0);
        }
        return null;
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = InputParser.acquireXMLParsing(this.context);
        if (factory == null) {
            throw new SAXException(Messages.InputParser_No_SAX_Parser_Found);
        }
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/string-interning", true);
        factory.setValidating(false);
        return factory.newSAXParser();
    }

    @Override
    public void startDocument() {
        this.currentElement = new XMLElement(this.currentRule.getElementName());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.ruleStack.push(this.currentRule);
        this.elementStack.push(this.currentElement);
        try {
            this.currentRule = this.currentRule.validateChildElement(localName, attrs, this.parserStatus, this);
        }
        catch (MissingRequiredAttrException e) {
            throw new SAXException(NLS.bind((String)Messages.HeadlessApplication_Missing_Required_Attribute, (Object)e.getAttribute()));
        }
        this.currentElement = this.createElement(this.currentElement, this.currentRule, localName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.currentRule.isValidElementName(localName)) {
            throw new SAXException(Messages.InputParser_Unexpected_EndOfElement);
        }
        this.currentRule = (XMLRule)this.ruleStack.pop();
        this.currentElement = (XMLElement)this.elementStack.pop();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private XMLElement createElement(XMLElement parentElement, XMLRule rule, String elmName, Attributes attrs) {
        XMLElement element = this.createElement(rule, elmName);
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                element.addAttribute(attrs.getLocalName(i), attrs.getValue(i));
                ++i;
            }
        }
        if (rule.getId() != 26) {
            parentElement.addChild(element);
        }
        return element;
    }

    private XMLElement createElement(XMLRule rule, String elmName) {
        XMLElement element;
        int elementId = rule.getId();
        switch (elementId) {
            case 2: {
                element = new InstallCommand();
                break;
            }
            case 24: {
                element = new UpdateCommand();
                break;
            }
            case 25: {
                element = new ModifyCommand();
                break;
            }
            case 3: {
                element = new UninstallCommand();
                break;
            }
            case 19: {
                element = new RollbackCommand();
                break;
            }
            case 8: {
                element = new ProfileCommand();
                break;
            }
            case 11: {
                element = new PreferenceCommand();
                break;
            }
            case 12: {
                element = new ServerCommand();
                break;
            }
            case 16: {
                element = new ValidateCommand();
                break;
            }
            case 18: {
                element = new ValidateAllCommand();
                break;
            }
            case 21: {
                element = new UpdateAllCommand();
                break;
            }
            case 22: {
                element = new InstallAllCommand();
                break;
            }
            case 28: {
                element = new UninstallAllCommand();
                break;
            }
            case 23: {
                element = new LicenseCommand();
                break;
            }
            case 10: {
                element = new DataElement();
                break;
            }
            case 29: {
                element = new VariablesCommand();
                break;
            }
            case 27: {
                element = new ImportCommand();
                break;
            }
            default: {
                element = new XMLElement(elmName);
            }
        }
        return element;
    }

    @Override
    public String formatMessage(String msg) {
        int line;
        int n = line = this.locator == null ? -1 : this.locator.getLineNumber();
        if (line <= 0) {
            return NLS.bind((String)Messages.InputParser_problem_at_name, (Object)this.path, (Object)msg);
        }
        return NLS.bind((String)Messages.InputParser_problem_at_name_line, (Object[])new Object[]{this.path, line, msg});
    }
}

