/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.DataElement;
import com.ibm.cic.agent.core.internal.commands.HeadlessApplicationException;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.ICommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.internal.WebUiSafeProgressMonitor;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public abstract class AbstractCommand
extends XMLElement
implements ICommand {
    private IInput input = null;
    protected static final int LIGHT_WEIGHT = 1;
    protected static final int HEAVY_WEIGHT = 100;

    public AbstractCommand(String name) {
        super(name);
    }

    public static Version getVersion(String idString, String versionString) throws HeadlessApplicationException {
        try {
            return new Version(versionString);
        }
        catch (IllegalArgumentException e) {
            AbstractCommand.throwHeadlessApplicationException(Messages.HeadlessApplication_Invalid_Version_Format, versionString, idString);
            return null;
        }
    }

    protected IOffering getOffering(Agent agent, String idString, String versionString) throws HeadlessApplicationException {
        SimpleIdentity identity = new SimpleIdentity(idString);
        Version version = AbstractCommand.getVersion(idString, versionString);
        IOffering offering = agent.findOffering((IIdentity)identity, version);
        if (offering == null) {
            AbstractCommand.throwHeadlessApplicationException(Messages.HeadlessApplication_Cannot_Find_Offering, identity, version);
        }
        return offering;
    }

    protected IOfferingOrFix getOfferingOrFix(Agent agent, String idString, String versionString, boolean isModify, String profileId) throws HeadlessApplicationException {
        SimpleIdentity identity = new SimpleIdentity(idString);
        Version version = AbstractCommand.getVersion(idString, versionString);
        IOfferingOrFix result = null;
        if (isModify) {
            if (profileId != null) {
                Profile profile = agent.getProfile(profileId);
                if (profile != null) {
                    result = this.getInstalledOfferingOrFix(profile, idString, versionString);
                }
            } else {
                result = agent.findOfferingOrFix(true, (IIdentity)identity, version, null);
            }
        } else {
            result = agent.findOfferingOrFix(true, (IIdentity)identity, version, null);
        }
        if (result == null) {
            String fileName = this.getInput().getInputFilePath();
            if (fileName != null) {
                AbstractCommand.throwHeadlessApplicationException(Messages.AbstractCommand_Cannot_Find_Offering_Or_Fix_Version_InFile, idString, versionString, fileName);
            } else {
                AbstractCommand.throwHeadlessApplicationException(Messages.AbstractCommand_Cannot_Find_Offering_Or_Fix_Version, idString, versionString);
            }
        }
        return result;
    }

    protected IOfferingOrFix getInstalledOfferingOrFix(Profile profile, String idString, String versionString) throws HeadlessApplicationException {
        if (idString == null) {
            AbstractCommand.throwHeadlessApplicationException(Messages.AbstractCommand_MustSpecifyPackageId, new Object[0]);
        }
        if (profile == null) {
            AbstractCommand.throwHeadlessApplicationException(Messages.AbstractCommand_Cannot_Find_Installed_Offering_Or_Fix_No_Profile, idString);
        }
        SimpleIdentity identity = new SimpleIdentity(idString);
        IOffering offering = profile.getInstallRegistry().getInstalledOffering((IIdentity)identity);
        Version version = null;
        if (versionString != null) {
            version = AbstractCommand.getVersion(idString, versionString);
        }
        if (offering != null) {
            if (version != null && !offering.getVersion().equals((Object)version)) {
                AbstractCommand.throwHeadlessApplicationException(Messages.AbstractCommand_Expected_Installed_Offering, identity, versionString, offering.getVersion());
            }
            return offering;
        }
        IFix fix = profile.getInstallRegistry().getInstalledFix((IIdentity)identity);
        if (fix != null) {
            if (version != null && !fix.getVersion().equals((Object)version)) {
                AbstractCommand.throwHeadlessApplicationException(Messages.AbstractCommand_Expected_Installed_Fix, identity, versionString, fix.getVersion());
            }
            return fix;
        }
        if (versionString == null) {
            AbstractCommand.throwHeadlessApplicationException(Messages.AbstractCommand_Cannot_Find_Installed_Offering_Or_Fix, identity, profile.getProfileId());
        } else {
            AbstractCommand.throwHeadlessApplicationException(Messages.AbstractCommand_Cannot_Find_Installed_Offering_Or_Fix_Version, identity, versionString, profile.getProfileId());
        }
        return null;
    }

    private static void throwHeadlessApplicationException(String msg, Object ... args) throws HeadlessApplicationException {
        throw new HeadlessApplicationException((IStatus)Statuses.ERROR.get(msg, args));
    }

    @Override
    public void setInput(IInput input) {
        this.input = input;
    }

    @Override
    public IInput getInput() {
        return this.input;
    }

    protected String getNormalizedLocation(String location, IInput.ILocationNormalizer locationNormalizer) {
        File parent;
        File file;
        File inputFile;
        String normalizedLocation = location;
        if (normalizedLocation != null) {
            normalizedLocation = CmdLine.CL.replacePlatformLocationVar(normalizedLocation);
        }
        if (this.input != null && (inputFile = this.input.getInputFile()) != null && (file = new File(parent = inputFile.getAbsoluteFile().getParentFile(), location)).exists()) {
            try {
                normalizedLocation = file.getCanonicalPath();
            }
            catch (IOException e) {
                normalizedLocation = file.getAbsolutePath();
            }
        }
        if (locationNormalizer != null && normalizedLocation != null) {
            normalizedLocation = locationNormalizer.getNormalizedLocation(normalizedLocation);
        }
        return normalizedLocation;
    }

    protected boolean doesRepositoryGroupContainOffering(IRepositoryGroup repoGroup, IIdentity offeringId, IProgressMonitor progressMonitor) {
        boolean found = false;
        List offerings = repoGroup.getAllOfferings(progressMonitor);
        Iterator iterator = offerings.iterator();
        while (iterator.hasNext() && !found) {
            IOffering offering = (IOffering)iterator.next();
            found = offeringId.getId().equals(offering.getIdentity().getId());
        }
        if (!found) {
            List updateOfferings = repoGroup.getAllUpdates(offeringId, null, progressMonitor);
            found = !updateOfferings.isEmpty();
        }
        return found;
    }

    protected boolean installAgentUpdate(Agent agent, CicMultiStatus status, boolean isUpdateRequired, IProgressMonitor monitor) {
        monitor = new WebUiSafeProgressMonitor(monitor);
        if (CmdLine.CL.isConsoleMode()) {
            monitor.done();
            return false;
        }
        IOffering runningAgentOffering = agent.getAgentOffering();
        if (runningAgentOffering == null || !agent.searchForAgentUpdate()) {
            monitor.done();
            return false;
        }
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 3, 1, 1, 7});
        IRepositoryGroup repoGroup = agent.getRepositoryGroup();
        ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet((IRepositoryGroup)repoGroup, (IOffering[])new IOffering[]{runningAgentOffering}, (IProgressMonitor)spm.next());
        try {
            IStatus updateStatus;
            IOffering offering = agent.checkForAgentUpdate(null, spm.next());
            IProgressMonitor drgcoMon = spm.next();
            if (offering == null) {
                if (isUpdateRequired && !this.doesRepositoryGroupContainOffering(repoGroup, agent.getAgentOffering().getIdentity(), drgcoMon)) {
                    status.add((IStatus)Statuses.ERROR.get(4, Messages.AbstractCommand_Cannot_Find_Offering_Or_Fix, new Object[]{agent.getAgentOffering().getIdentity().getId()}));
                }
                return false;
            }
            IStatus agentRequirementStatus = agent.checkAgentRequirement((IOfferingOrFix)offering);
            if (!agentRequirementStatus.isOK()) {
                status.add((IStatus)Statuses.ST.createMultiStatus(agentRequirementStatus.getPlugin(), agentRequirementStatus.getSeverity(), agentRequirementStatus.getCode(), null, null, agentRequirementStatus.getMessage()));
                return false;
            }
            UpdateOfferingJob job = agent.createAgentUpdateOfferingJob(offering);
            IStatus prepareStatus = agent.prepareAgentUpdate(job, spm.next());
            if (!prepareStatus.isOK()) {
                status.add(prepareStatus);
                return false;
            }
            IStatus applicabilityStatus = job.checkOfferingApplicability();
            if (!applicabilityStatus.isOK()) {
                status.add(applicabilityStatus);
                if (StatusUtil.isErrorOrCancel((IStatus)applicabilityStatus)) {
                    return false;
                }
            }
            if (!(updateStatus = agent.updateAgent(job, spm.next())).isOK()) {
                status.add(updateStatus);
                if (StatusUtil.isErrorOrCancel((IStatus)updateStatus)) {
                    return false;
                }
            }
            AgentRelaunch.getInstance().setNeedsRelaunch(true);
            this.outputCompletedAgentJobs(agent, new AgentJob[]{job});
            return true;
        }
        finally {
            ServiceRepositoryUtils.unloadServiceRepositories((IRepositoryGroup)repoGroup);
            spm.done();
            monitor.done();
        }
    }

    @Override
    public void normalizeLocations(IInput.ILocationNormalizer locationNormalizer) {
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public boolean needAccessRepositories() {
        return true;
    }

    public void addData(String key, String value) {
        if (key == null && value == null) {
            throw new IllegalArgumentException();
        }
        XMLElement data = null;
        for (XMLElement element : this.children()) {
            String attributeKey = element.getAttribute("key");
            if (attributeKey == null || !attributeKey.equals(key)) continue;
            data = element;
            break;
        }
        if (data == null) {
            data = new DataElement();
            this.addChild(data);
        }
        data.addAttribute("key", key);
        data.addAttribute("value", value);
    }

    protected IStatus prepareInstalledFixes(Agent agent, Profile profile, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        IFix[] fixes = agent.getInstalledFixes(profile);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, fixes.length);
        try {
            IFix[] iFixArray = fixes;
            int n = fixes.length;
            int n2 = 0;
            while (n2 < n) {
                IFix fix = iFixArray[n2];
                status.add(agent.prepare((IOfferingOrFix)fix, ExtensionCategory.ALL, spm.next()));
                ++n2;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return status;
    }

    protected IStatus prepareInstalledOfferings(Agent agent, Profile profile, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        IOffering[] offerings = agent.getInstalledOfferings(profile);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, offerings.length);
        try {
            IOffering[] iOfferingArray = offerings;
            int n = offerings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering = iOfferingArray[n2];
                status.add(agent.prepare((IOfferingOrFix)offering, ExtensionCategory.ALL, spm.next()));
                ++n2;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return status;
    }

    protected void outputCompletedAgentJobs(Agent agent, AgentJob[] agentJobs) {
        if (CmdLine.CL.isConsoleMode()) {
            return;
        }
        OutputFormatter output = agent.getStdoutBuffer();
        AgentJob[] agentJobArray = agentJobs;
        int n = agentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob agentJob = agentJobArray[n2];
            String packageIdAndVersion = OfferingUtil.getPackageIdVersion((IOfferingOrFix)agentJob.getOfferingOrFix());
            String location = agentJob.getProfile().getInstallLocation();
            if (agentJob.isModify()) {
                String modifyMsg = NLS.bind((String)Messages.Cmd_install_modified, (Object)packageIdAndVersion, (Object)location);
                if (!output.toString().contains(modifyMsg)) {
                    output.appendNTnl(modifyMsg);
                }
            } else if (agentJob.isInstall()) {
                output.appendNTnl(NLS.bind((String)Messages.Cmd_install_installed, (Object)packageIdAndVersion, (Object)location));
            } else if (agentJob.isUpdate()) {
                output.appendNTnl(NLS.bind((String)Messages.Cmd_install_updated, (Object)packageIdAndVersion, (Object)location));
            } else if (agentJob.isRollback()) {
                output.appendNTnl(NLS.bind((String)Messages.Cmd_install_rolledBack, (Object)packageIdAndVersion, (Object)location));
            } else if (agentJob.isUninstall()) {
                String msgID = this.doesOfferingOrFixExist(agent, agentJob) ? Messages.Cmd_uninstall_failed : Messages.Cmd_uninstall_uninstalled;
                output.appendNTnl(NLS.bind((String)msgID, (Object)packageIdAndVersion, (Object)location));
            }
            ++n2;
        }
    }

    private boolean doesOfferingOrFixExist(Agent agent, AgentJob agentJob) {
        boolean offeringOrFixExists = false;
        if (agentJob.getFix() != null) {
            IFix[] installedFixesArray;
            IFix[] iFixArray = installedFixesArray = agent.getInstalledFixes(agentJob.getProfile());
            int n = installedFixesArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFix installedFix = iFixArray[n2];
                if (installedFix.getIdentity().equals(agentJob.getOfferingOrFix().getIdentity())) {
                    offeringOrFixExists = true;
                    break;
                }
                ++n2;
            }
        } else {
            offeringOrFixExists = agent.getInstalledOfferings(agentJob.getProfile(), agentJob.getOffering().getIdentity()).length > 0;
        }
        return offeringOrFixExists;
    }
}

