/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.PlatformFilter;
import com.ibm.cic.common.core.model.utils.SupportedPlatforms;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class WindowSystemUtils {
    private WindowSystemUtils() {
        assert (false);
    }

    public static IStatus checkWindowSystemCompatible(List oofs, Profile profile) {
        if (WindowSystemUtils.suppressPlatformChecks()) {
            return Status.OK_STATUS;
        }
        List<IOfferingOrFix> nwsaOofs = WindowSystemUtils.getNonWindowSystemAgnosticOofs(oofs);
        if (nwsaOofs.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (profile != null) {
            WindowSystemPlatform wsp = new WindowSystemPlatform(profile.getOS(), profile.getArch());
            String ws = wsp.getSupportedWindowSystem(nwsaOofs);
            if (!profile.getWS().equals(ws)) {
                return Statuses.ERROR.get(Messages.AgentUtil_Validate_Cannot_Coexist, new Object[0]);
            }
        } else {
            String ws32 = null;
            if (BitModeUtils.supports32bits(nwsaOofs)) {
                WindowSystemPlatform wsp = new WindowSystemPlatform(Platform.getOS(), BitModeUtils.get32bitArch());
                ws32 = wsp.getSupportedWindowSystem(nwsaOofs);
            }
            String ws64 = null;
            if (BitModeUtils.supports64bits(nwsaOofs)) {
                WindowSystemPlatform wsp = new WindowSystemPlatform(Platform.getOS(), BitModeUtils.get64bitArch());
                ws64 = wsp.getSupportedWindowSystem(nwsaOofs);
            }
            if (ws32 == null && ws64 == null) {
                return Statuses.ERROR.get(Messages.AgentUtil_Validate_Cannot_Coexist, new Object[0]);
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkWindowSystemSupported(AgentJob job) {
        IOffering offering = job.getOffering();
        if (offering == null || WindowSystemUtils.suppressPlatformChecks() || WindowSystemUtils.isWindowSystemAgnostic((IOfferingOrFix)offering)) {
            return Status.OK_STATUS;
        }
        Profile profile = job.getProfile();
        String os = profile.getOS();
        String arch = profile.getArch();
        WindowSystemPlatform wsp = new WindowSystemPlatform(os, arch);
        String offeringSupportedWs = wsp.getSupportedWindowSystem((IOfferingOrFix)offering);
        String ws = profile.getWS();
        if (!ws.equals(offeringSupportedWs)) {
            if (WindowSystemUtils.isWindowSystemConversionAllowed(profile, job)) {
                BitModeUtils.setProfilePlatformProperties(profile, new AgentJob[]{job}, arch);
                return Status.OK_STATUS;
            }
            if (job.isUpdate()) {
                return Statuses.ERROR.get(Messages.WindowSystemUtils_unsupportedWindowsSystemInUpdate, new Object[]{profile.getProfileId(), ws, offering.getName(), offeringSupportedWs});
            }
            return Statuses.ERROR.get(Messages.WindowSystemUtils_unsupportedWindowsSystemInProfile, new Object[]{offering.getName(), offeringSupportedWs, profile.getProfileId(), ws});
        }
        return Status.OK_STATUS;
    }

    public static String getPreferredWsValue(Profile profile, IOfferingOrFix[] oofs) {
        List<IOfferingOrFix> oofList;
        String arch;
        String os;
        WindowSystemPlatform wsp;
        String supportedWindowSystem;
        if (!profile.isAgentProfile() && (supportedWindowSystem = (wsp = new WindowSystemPlatform(os = profile.getOS(), arch = profile.getArch())).getSupportedWindowSystem(oofList = WindowSystemUtils.getNonWindowSystemAgnosticOofs(Arrays.asList(oofs)))) != null) {
            return supportedWindowSystem;
        }
        return Platform.getWS();
    }

    private static boolean suppressPlatformChecks() {
        return AgentUserOptions.CIC_CCB_CLASSIC_ECLIPSE.isSet() || AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet();
    }

    private static List<IOfferingOrFix> getNonWindowSystemAgnosticOofs(List<IOfferingOrFix> oofs) {
        ArrayList<IOfferingOrFix> result = new ArrayList<IOfferingOrFix>(oofs.size());
        for (IOfferingOrFix oof : oofs) {
            if (WindowSystemUtils.isWindowSystemAgnostic(oof)) continue;
            result.add(oof);
        }
        return result;
    }

    private static boolean isWindowSystemAgnostic(IOfferingOrFix oof) {
        return !(oof instanceof IOffering) || Agent.isExtensionOffering(oof);
    }

    private static boolean isWindowSystemConversionAllowed(Profile profile, AgentJob job) {
        if (AgentInstall.getInstance().isAgentInstallerRunning() && profile.isAgentProfile()) {
            return true;
        }
        IOffering offering = job.getOffering();
        Set shareSet = OfferingProperty.getProfileShareSet((IOffering)offering);
        if (shareSet.isEmpty() && !Agent.isExtensionOffering((IOfferingOrFix)offering)) {
            String prop = offering.getProperties().getProperty("intuitive.uninstall.install.order.required");
            if (Boolean.TRUE.equals(Boolean.valueOf(prop))) {
                return true;
            }
            if (job.isRollback()) {
                return true;
            }
        }
        return false;
    }

    public static class WindowSystemPlatform {
        private final String os;
        private final String arch;
        private final Set<String> possibleWindowSystems;

        public WindowSystemPlatform(String os, String arch) {
            this.os = os;
            this.arch = arch;
            this.possibleWindowSystems = SupportedPlatforms.getInstance().getWsValues(os, arch);
        }

        public String getSupportedWindowSystem(List<IOfferingOrFix> oofs) {
            String[] supportedWindowSystemsArray = new String[oofs.size()];
            int i = 0;
            for (IOfferingOrFix oof : oofs) {
                supportedWindowSystemsArray[i++] = OfferingProperty.getSupportedWindowSystems((IOfferingOrFix)oof);
            }
            return this.getSupportedWindowSystem(supportedWindowSystemsArray);
        }

        public String getSupportedWindowSystem(String ... supportedWindowSystemsArray) {
            String result = null;
            String[] stringArray = supportedWindowSystemsArray;
            int n = supportedWindowSystemsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String supportedWindowSystems = stringArray[n2];
                String oofWindowSystem = this.getSupportedWindowSystem(supportedWindowSystems);
                if (oofWindowSystem == null) {
                    return null;
                }
                if (result == null) {
                    result = oofWindowSystem;
                } else if (!result.equals(oofWindowSystem)) {
                    return null;
                }
                ++n2;
            }
            return result;
        }

        public String getSupportedWindowSystem(IOfferingOrFix oof) {
            String supportedWindowSystems = OfferingProperty.getSupportedWindowSystems((IOfferingOrFix)oof);
            return this.getSupportedWindowSystem(supportedWindowSystems);
        }

        public String getSupportedWindowSystem(String supportedWindowSystems) {
            String allowedWindowSystem;
            if (supportedWindowSystems != null && (allowedWindowSystem = this.getAllowedWindowSystem(supportedWindowSystems)) != null) {
                return allowedWindowSystem;
            }
            return this.getDefaultWindowSystem();
        }

        private String getDefaultWindowSystem() {
            String defaultWs = null;
            for (String ws : this.possibleWindowSystems) {
                if (!this.isDefaultWindowSystem(ws)) continue;
                assert (defaultWs == null);
                defaultWs = ws;
            }
            return defaultWs;
        }

        private boolean isDefaultWindowSystem(String ws) {
            if ("aix".equals(this.os)) {
                if ("ppc".equals(this.arch)) {
                    return "motif".equals(ws);
                }
                if ("ppc64".equals(this.arch)) {
                    return "gtk".equals(ws);
                }
                return false;
            }
            if ("hpux".equals(this.os) && ("ia64_32".equals(this.arch) || "ia64".equals(this.arch))) {
                return "motif".equals(ws);
            }
            assert (this.possibleWindowSystems.size() == 1);
            return this.possibleWindowSystems.iterator().next().equals(ws);
        }

        private String getAllowedWindowSystem(String filter) {
            PlatformFilter f = new PlatformFilter(filter);
            String result = null;
            for (String ws : this.possibleWindowSystems) {
                if (!f.matchesPlatform(ws, this.os, this.arch).isOK()) continue;
                if (result == null) {
                    result = ws;
                    continue;
                }
                return null;
            }
            return result;
        }
    }
}

