/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.VariableProvider;
import com.ibm.cic.common.core.api.utils.EncryptionUtils;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.PPSettings;
import com.ibm.cic.common.core.utils.FileName;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class SubstitutionOperation
extends AbstractVariableSubstitution {
    private static final Logger log = Logger.getLogger();
    public static final String PROFILE_ID_VAR = "profileId";
    public static final String CONTEXT_ID_VAR = "contextId";
    public static final String AGENT_PROPERTY_VAR = "agent";
    public static final String PROFILE_PROPERTY_VAR = "profile";
    public static final String ENCRYPT_VAR = "encrypt";
    public static final String DECRYPT_VAR = "decrypt";
    public static final String CONTEXT_PROPERTY_VAR = "context";
    @Deprecated
    public static final String INSTALL_LOCATION_VAR = "installLocation";
    private static boolean loggedDeprecatedInstallLocation = false;
    @Deprecated
    public static final String AGENT_PROPERTY_OLD = "agentProperty";
    private static boolean loggedDeprecatedAgentProperty = false;
    @Deprecated
    public static final String PROFILE_PROPERTY_OLD = "profileProperty";
    private static boolean loggedDeprecatedProfileProperty = false;
    @Deprecated
    public static final String CONTEXT_PROPERTY_OLD = "contextProperty";
    private static boolean loggedDeprecatedContextProperty = false;
    private final InstallContext context;
    private boolean for64bit;
    private static Set<String> relativePathVaribles = null;

    static {
        relativePathVaribles = new HashSet<String>();
        relativePathVaribles.add("bundleLocation");
        relativePathVaribles.add("eclipseIdeLocation");
        relativePathVaribles.add("eclipseJreLocation");
        relativePathVaribles.add("eclipseLauncher");
        relativePathVaribles.add("cacheLocation");
        relativePathVaribles.add("configLocation");
        relativePathVaribles.add(INSTALL_LOCATION_VAR);
    }

    public SubstitutionOperation(InstallContext context) {
        this(context, false);
        if (context != null) {
            this.for64bit = context.is64bit();
        }
    }

    public SubstitutionOperation(InstallContext context, boolean for64bit) {
        assert (context != null) : "Null install context argument for install operation";
        this.context = context;
        this.for64bit = for64bit;
    }

    public Profile getProfile() {
        return this.context.getEnclosingProfile();
    }

    public InstallContext getInstallContext() {
        return this.context;
    }

    @Override
    protected String substitute(String variableName, String variableArg, AbstractVariableSubstitution.AllowAbsolutePath allowAbsolutePath) throws AbstractVariableSubstitution.VariableSubstitutionException {
        String result;
        this.checkDeprecatedVariable(variableName);
        if (variableName.equals(INSTALL_LOCATION_VAR)) {
            return this.getCanonicalLocation(this.context.getProperty(INSTALL_LOCATION_VAR));
        }
        if (variableName.equals(PROFILE_ID_VAR)) {
            return this.getProfile().getProfileId();
        }
        if (variableName.equals(CONTEXT_ID_VAR)) {
            return this.context.getId();
        }
        if (variableName.equals(AGENT_PROPERTY_VAR) || variableName.equals(AGENT_PROPERTY_OLD)) {
            if (variableArg != null) {
                String data = this.getProfile().getData(variableArg);
                if (variableArg.equals("cic.appDataLocation") && !FileName.validateLumFileName((String)data)) {
                    data = PPSettings.getPolicy().getNonDbcsLumPath(data);
                }
                return SubstitutionOperation.fixNull(data);
            }
        } else if (variableName.equals(PROFILE_PROPERTY_VAR) || variableName.equals(PROFILE_PROPERTY_OLD)) {
            if (variableArg != null) {
                if (INSTALL_LOCATION_VAR.equals(variableArg)) {
                    return this.getProfileInstallLocation(allowAbsolutePath);
                }
                String data = null;
                String[] args = variableArg.split(String.valueOf(','));
                String key = args[0];
                if (args.length == 1) {
                    data = this.getProfile().getData(key);
                } else {
                    int i = 1;
                    while (i < args.length && data == null) {
                        data = this.getProfile().getOfferingUserData(key, args[i]);
                        ++i;
                    }
                }
                if ("cacheLocation".equals(variableArg)) {
                    return CicCommonSettings.isPortable() ? this.getCanonicalLocation(this.getProfile().getCacheLocation()) : this.getCanonicalLocation(SubstitutionOperation.fixNull(data));
                }
                return SubstitutionOperation.fixNull(data);
            }
        } else if (variableName.equals(CONTEXT_PROPERTY_VAR) || variableName.equals(CONTEXT_PROPERTY_OLD)) {
            if (variableArg != null) {
                if (!INSTALL_LOCATION_VAR.equals(variableArg)) {
                    String data = this.context.getProperty(variableArg);
                    if ("cacheLocation".equals(variableArg)) {
                        return this.makeRelativeToContextLocationInPortableMode(this.getCanonicalLocation(SubstitutionOperation.fixNull(data)), allowAbsolutePath);
                    }
                    return SubstitutionOperation.fixNull(data);
                }
                return this.makeRelativeToContextLocationInPortableMode(this.getCanonicalLocation(this.context.getInstallLocation()), allowAbsolutePath);
            }
        } else {
            if (variableName.equals(DECRYPT_VAR)) {
                return SubstitutionOperation.fixNull(EncryptionUtils.decrypt((String)variableArg));
            }
            if (variableName.equals(ENCRYPT_VAR)) {
                return SubstitutionOperation.fixNull(EncryptionUtils.encrypt((String)variableArg));
            }
        }
        if ((result = this.substituteNoVP(variableName, variableArg)) == null) {
            result = VariableProvider.getInstance().substitute(this, variableName, variableArg);
        }
        if (CicCommonSettings.isPortable() && allowAbsolutePath == AbstractVariableSubstitution.AllowAbsolutePath.FALSE) {
            this.checkRelativity(variableName, result);
        }
        return result;
    }

    private String getProfileInstallLocation(AbstractVariableSubstitution.AllowAbsolutePath allowAbsolutePath) {
        return CicCommonSettings.isPortable() && allowAbsolutePath == AbstractVariableSubstitution.AllowAbsolutePath.FALSE ? "." : this.getCanonicalLocation(this.getProfile().getInstallLocation());
    }

    public String makeRelativeToContextLocationInPortableMode(String filePath, AbstractVariableSubstitution.AllowAbsolutePath allowAbsolutePath) {
        if (CicCommonSettings.isPortable() && allowAbsolutePath == AbstractVariableSubstitution.AllowAbsolutePath.FALSE) {
            if (filePath.equals(".")) {
                return filePath;
            }
            Path path = new Path(filePath);
            Path contextInstallLocationPath = new Path(this.getInstallContext().getInstallLocation());
            IPath relativePath = path.makeRelativeTo((IPath)contextInstallLocationPath);
            return relativePath.equals((Object)Path.EMPTY) ? "." : relativePath.toString();
        }
        return filePath;
    }

    private void checkRelativity(String variableName, String result) throws AbstractVariableSubstitution.VariableSubstitutionException {
        if (result != null && relativePathVaribles.contains(variableName) && new File(result).isAbsolute()) {
            throw new AbstractVariableSubstitution.VariableSubstitutionException((IStatus)Statuses.ERROR.get(Messages.SubstitutionOperation_RelativeLocationVariableFailed, new Object[]{variableName, result}));
        }
    }

    private static String fixNull(String s) {
        return s != null ? s : "";
    }

    protected File resolvePath(String path) {
        Path destPath = new Path(path);
        if (destPath.isAbsolute()) {
            return destPath.toFile();
        }
        File installDir = new File(this.getInstallContext().getLocation(INSTALL_LOCATION_VAR));
        return ".".equals(path) ? installDir : new File(installDir, path);
    }

    protected File performVariableSubstitutionsAndResolvePath(String path) throws AbstractVariableSubstitution.VariableSubstitutionException {
        return this.resolvePath(this.performVariableSubstitutions(path));
    }

    @Override
    @Deprecated
    protected void checkDeprecatedVariable(String variableName) {
        if (variableName.equals(INSTALL_LOCATION_VAR) && !loggedDeprecatedInstallLocation) {
            log.warningNoUid("Substitution variable ''{0}'' is deprecated because it is ambiguous; use ''{1}'' or ''{2}'' instead", new Object[]{INSTALL_LOCATION_VAR, "profile:installLocation", "context:installLocation"});
            loggedDeprecatedInstallLocation = true;
        } else if (variableName.equals(AGENT_PROPERTY_OLD) && !loggedDeprecatedAgentProperty) {
            this.reportDeprecatedVariable(AGENT_PROPERTY_OLD, AGENT_PROPERTY_VAR);
            loggedDeprecatedAgentProperty = true;
        } else if (variableName.equals(PROFILE_PROPERTY_OLD) && !loggedDeprecatedProfileProperty) {
            this.reportDeprecatedVariable(PROFILE_PROPERTY_OLD, PROFILE_PROPERTY_VAR);
            loggedDeprecatedProfileProperty = true;
        } else if (variableName.equals(CONTEXT_PROPERTY_OLD) && !loggedDeprecatedContextProperty) {
            this.reportDeprecatedVariable(CONTEXT_PROPERTY_OLD, CONTEXT_PROPERTY_VAR);
            loggedDeprecatedContextProperty = true;
        }
    }

    @Override
    @Deprecated
    protected void reportDeprecatedVariable(String oldVar, String newVar) {
        log.warningNoUid("Substitution variable ''{0}'' is deprecated; use ''{1}'' instead", new Object[]{oldVar, newVar});
    }

    @Override
    public boolean is64bit() {
        return this.for64bit;
    }
}

