/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IStartupExtender;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.extensions.ExtensionManager;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StartupManager {
    private static final String PT_STARTUP = "startupExtenders";
    private static final String PT_CLASS_ATTR = "class";
    private static StartupManager instance;
    private static final Logger log;

    static {
        log = Logger.getLogger(StartupManager.class);
    }

    public static StartupManager getInstance() {
        if (instance == null) {
            instance = new StartupManager();
        }
        return instance;
    }

    public IStatus runStartups(IProgressMonitor monitor) {
        IConfigurationElement[] elements;
        CicMultiStatus retStatus = Statuses.ST.createMultiStatus();
        IConfigurationElement[] iConfigurationElementArray = elements = ExtensionManager.getInstance().getConfigurationElements(Agent.PI_AGENT, PT_STARTUP);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IStatus status;
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    Object extensionClass = element.createExecutableExtension(PT_CLASS_ATTR);
                    if (extensionClass instanceof IStartupExtender) {
                        try {
                            status = ((IStartupExtender)extensionClass).run(monitor);
                            if (!status.isOK()) {
                                retStatus.add(status);
                                retStatus.setMessage(String.valueOf(retStatus.getMessage()) + status.getMessage());
                            }
                            break block7;
                        }
                        catch (Throwable e) {
                            log.error(e);
                            retStatus.add((IStatus)new Status(4, Agent.PI_AGENT, 0, e.getLocalizedMessage(), null));
                        }
                        break block7;
                    }
                    status = new Status(4, Agent.PI_AGENT, 0, NLS.bind((String)Messages.StartupManager_Doesnot_implement_interface, (Object[])new Object[]{element.getAttribute(PT_CLASS_ATTR), PT_STARTUP, IStartupExtender.class.getName()}), null);
                    retStatus.add(status);
                    log.statusNotOK(status);
                }
                catch (CoreException e) {
                    status = new Status(4, Agent.PI_AGENT, 0, NLS.bind((String)Messages.StartupManager_Fail_to_create_executable_class, (Object)element.getAttribute(PT_CLASS_ATTR), (Object)((Object)e)), (Throwable)e);
                    retStatus.add(status);
                    log.statusNotOK(status);
                }
            }
            ++n2;
        }
        return retStatus;
    }
}

