/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.CommandFactory;
import com.ibm.cic.agent.core.internal.headless.IAbstractInstallCommand;
import com.ibm.cic.agent.core.internal.headless.ICommand;
import com.ibm.cic.agent.core.internal.headless.IImportCommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IInstallCommand;
import com.ibm.cic.agent.core.internal.headless.ILicenseCommand;
import com.ibm.cic.agent.core.internal.headless.IProfileCommand;
import com.ibm.cic.agent.core.internal.headless.IRollbackCommand;
import com.ibm.cic.agent.core.internal.headless.IServerCommand;
import com.ibm.cic.agent.core.internal.headless.IUninstallAllCommand;
import com.ibm.cic.agent.core.internal.headless.IUninstallCommand;
import com.ibm.cic.agent.core.internal.headless.IUpdateAllCommand;
import com.ibm.cic.agent.core.internal.headless.IVariablesCommand;
import com.ibm.cic.agent.core.internal.headless.InstallFixesAction;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Version;

public class ResponseFileBuilder {
    static final String SHARED_LOCATION_VAR = "sharedLocation";
    private final IInput input;
    private final CurrentProfile currentProfile = new CurrentProfile();
    private IVariablesCommand variablesCommand;
    private boolean haveVariables = false;
    private IServerCommand serverCommand = null;
    private IAbstractInstallCommand currentOp = null;
    private boolean includeDefaults = false;

    public ResponseFileBuilder() {
        this.input = CommandFactory.createCommandScript();
        this.getVariablesCommand();
    }

    public String toString() {
        return this.input.toXML();
    }

    public ResponseFileBuilder includeDefaults(boolean b) {
        this.includeDefaults = b;
        return this;
    }

    public IInput getAsInput() {
        return this.input;
    }

    public void save(File file) throws CoreException {
        if (!this.haveVariables) {
            this.input.removeCommand(this.variablesCommand);
        }
        try {
            this.input.save(file);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)Statuses.ERROR.get((Throwable)e, Messages.CommandRecorder_Cannot_Save_Response_File, new Object[]{file}));
        }
        if (!file.exists()) {
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.CommandRecorder_Cannot_Save_Response_File, new Object[]{file}));
        }
    }

    public ResponseFileBuilder cleanMode(boolean cleanMode) {
        this.input.setCleanMode(cleanMode);
        return this;
    }

    public ResponseFileBuilder temporaryMode(boolean temporaryMode) {
        this.input.setTemporaryMode(temporaryMode);
        return this;
    }

    public ResponseFileBuilder rebootLater(boolean rebootLater) {
        this.input.setRebootLater(rebootLater);
        return this;
    }

    public ResponseFileBuilder acceptLicense(boolean acceptLicense) {
        this.input.setAcceptLicense(acceptLicense);
        return this;
    }

    public IVariablesCommand.IVariable addVariable(String name, String value) {
        this.haveVariables = true;
        return this.getVariablesCommand().addVariable(name, value);
    }

    public ResponseFileBuilder profile(String id, File installLocation) {
        return this.profile(id, "product", installLocation);
    }

    public ResponseFileBuilder profile(Profile p) {
        String installLocation = p.getInstallLocation();
        this.profile(p.getProfileId(), p.getProfileKind(), installLocation == null ? null : new File(installLocation));
        LinkedProperties profileData = p.getAllData();
        String[] stringArray = profileData.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = profileData.getProperty(key);
            if (value != null && Profile.isUserSettableProperty(key) && (this.includeDefaults || !value.isEmpty() && !p.hasDefaultValue(key))) {
                this.currentProfile.addData(key, value);
            }
            ++n2;
        }
        return this;
    }

    public ResponseFileBuilder profile(String id, String kind, File installLocation) {
        if (this.currentProfile.set(id, kind, installLocation)) {
            this.currentOp = null;
        }
        return this;
    }

    public ResponseFileBuilder profileData(String key, String value) {
        this.currentProfile.addData(key, value);
        return this;
    }

    public ResponseFileBuilder comment(String comment) {
        this.getLastElement().addComment(comment);
        return this;
    }

    public ResponseFileBuilder install(IOffering offering, IFeature ... features) {
        return this.install(offering, Arrays.asList(features));
    }

    public ResponseFileBuilder install(IOffering offering, Collection<IFeature> features) {
        return this.install(offering, features.isEmpty() ? "-" : Util.toFeatureIdString(features));
    }

    public ResponseFileBuilder install(IOffering offering, String features) {
        this.install(offering.getIdentity(), offering.getVersion(), features);
        this.getLastElement().addComment(String.valueOf(offering.getName()) + ' ' + OfferingUtil.getDisplayableVersion((IOfferingOrFix)offering));
        return this;
    }

    private XMLElement getLastElement() {
        ICommand[] cmds = this.input.getCommands(-1);
        XMLElement cmd = (XMLElement)((Object)cmds[cmds.length - 1]);
        int n = cmd.getNumChildren();
        return n == 0 ? cmd : cmd.getChild(n - 1);
    }

    public ResponseFileBuilder install(IFix fix) {
        this.install(fix.getIdentity());
        this.getLastElement().addComment(fix.getName());
        return this;
    }

    public ResponseFileBuilder install(IIdentity id) {
        return this.install(id, null);
    }

    public ResponseFileBuilder install(IIdentity id, Version version) {
        return this.install(id, version, null, null);
    }

    public ResponseFileBuilder install(IIdentity id, Version version, String features) {
        this.getInstallCommand(false);
        if (this.includeDefaults) {
            return this.addOffering(id, version, features, InstallFixesAction.getInstallFixesAction(null, version != null));
        }
        return this.addOffering(id, version, features);
    }

    public ResponseFileBuilder install(IIdentity id, Version version, InstallFixesAction ifAction) {
        return this.install(id, version, null, ifAction);
    }

    public ResponseFileBuilder install(IIdentity id, Version version, boolean selected) {
        return this.install(id, version, null, selected);
    }

    public ResponseFileBuilder install(IIdentity id, Version version, String features, InstallFixesAction ifAction) {
        this.getInstallCommand(false);
        return this.addOffering(id, version, features, ifAction);
    }

    public ResponseFileBuilder install(IIdentity id, Version version, String features, boolean selected) {
        this.getInstallCommand(false);
        return this.addOffering(id, version, features, selected);
    }

    public ResponseFileBuilder modifyInstall(IOffering offering, IFeature[] features) {
        return this.modifyInstall(offering.getIdentity(), offering.getVersion(), Util.toFeatureIdString((IFeature[])features));
    }

    public ResponseFileBuilder modifyInstall(IIdentity id, Version version, String features) {
        this.getInstallCommand(true);
        return this.addOffering(id, version, features.isEmpty() ? "-" : features);
    }

    public ResponseFileBuilder modifyUninstall(IOffering offering, IFeature[] features) {
        return this.modifyUninstall(offering.getIdentity(), offering.getVersion(), Util.toFeatureIdString((IFeature[])features));
    }

    public ResponseFileBuilder modifyUninstall(IIdentity id, Version version, String features) {
        this.getUninstallCommand(true);
        return this.addOffering(id, version, features);
    }

    public ResponseFileBuilder rollback(IOffering offering) {
        return this.rollback(offering.getIdentity(), offering.getVersion());
    }

    public ResponseFileBuilder rollback(IIdentity id, Version version) {
        this.getRollbackCommand();
        return this.addOffering(id, version, null);
    }

    public ResponseFileBuilder uninstall(IOffering offering) {
        return this.uninstall(offering.getIdentity(), offering.getVersion());
    }

    public ResponseFileBuilder uninstall(IFix fix) {
        return this.uninstall(fix.getIdentity(), fix.getVersion());
    }

    public ResponseFileBuilder uninstall(IIdentity id) {
        return this.uninstall(id, null);
    }

    public ResponseFileBuilder uninstall(IIdentity id, Version version) {
        this.getUninstallCommand(false);
        return this.addOffering(id, version, null);
    }

    public ResponseFileBuilder doImport(String type, Profile profile, Properties dataProps) {
        IImportCommand cmd = this.add(CommandFactory.createImportCommand());
        cmd.setImportType(type);
        cmd.setProfileId(profile.getProfileId());
        for (String key : dataProps.stringPropertyNames()) {
            cmd.addData(key, dataProps.getProperty(key));
        }
        return this;
    }

    public ResponseFileBuilder license(String licenseFileName) {
        ILicenseCommand cmd = this.add(CommandFactory.createLicenseCommand());
        cmd.setPolicyFile(licenseFileName);
        return this;
    }

    public ResponseFileBuilder uninstallAll(String profile) {
        IUninstallAllCommand cmd = this.add(CommandFactory.createUnInstallAllCommand());
        cmd.addProfile(profile);
        this.currentOp = null;
        return this;
    }

    public ResponseFileBuilder updateAll() {
        return this.updateAll(null, null);
    }

    public ResponseFileBuilder updateAll(String profile, String installFixes) {
        return this.updateAll(profile, null, installFixes);
    }

    public ResponseFileBuilder updateAll(String profile, String installLocation, String installFixes) {
        IUpdateAllCommand cmd = this.add(CommandFactory.createUpdateAllCommand());
        cmd.addProfile(profile);
        cmd.addInstallLocation(installLocation);
        cmd.addInstallFixesAttribute(InstallFixesAction.getInstallFixesAction(installFixes));
        this.currentOp = null;
        return this;
    }

    public ResponseFileBuilder repository(ICicLocation location) {
        return this.repository(location.toURL().toString());
    }

    public ResponseFileBuilder repository(String location) {
        this.getServerCommand().addRepository(location);
        return this;
    }

    public ResponseFileBuilder sharedLocation() {
        return this.sharedLocation(CacheLocationManager.getInstance().getCacheLocation());
    }

    public ResponseFileBuilder sharedLocation(String path) {
        if (!path.isEmpty()) {
            this.addVariable(SHARED_LOCATION_VAR, path);
            this.preference("com.ibm.cic.common.core.preferences.eclipseCache", PlatformUtils.variableRef((String)SHARED_LOCATION_VAR));
        }
        return this;
    }

    public ResponseFileBuilder preference(ICicPreferenceConstants.PreferenceTag tag) {
        CicPreferenceManager pm;
        String value;
        if (tag.isNeedRecord() && !(value = (pm = CicPreferenceManager.getInstance()).getString(tag.key())).isEmpty() && (this.includeDefaults || !value.equals(pm.getDefaultString(tag.key())))) {
            this.preference(tag.key(), value);
        }
        return this;
    }

    public ResponseFileBuilder preference(String name, String value) {
        this.add(CommandFactory.createPreferenceCommand(name, value));
        return this;
    }

    public IInstallCommand getInstallCommand(boolean modify) {
        if (!(this.currentOp instanceof IInstallCommand) || ((IInstallCommand)this.currentOp).isModify() != modify) {
            this.currentOp = this.add(CommandFactory.createInstallCommand());
            if (modify || this.includeDefaults) {
                this.currentOp.setModify(modify);
            }
        }
        return (IInstallCommand)this.currentOp;
    }

    private ResponseFileBuilder addOffering(IIdentity id, Version version, String features) {
        this.currentOp.addOffering(id.getId(), ResponseFileBuilder.toString(version), this.currentProfile.getId(), features);
        return this;
    }

    private ResponseFileBuilder addOffering(IIdentity id, Version version, String features, InstallFixesAction ifAction) {
        ((IInstallCommand)this.currentOp).addOffering(id.getId(), ResponseFileBuilder.toString(version), this.currentProfile.getId(), features, ifAction);
        return this;
    }

    private ResponseFileBuilder addOffering(IIdentity id, Version version, String features, boolean selected) {
        ((IInstallCommand)this.currentOp).addOffering(id.getId(), ResponseFileBuilder.toString(version), this.currentProfile.getId(), features, selected);
        return this;
    }

    private IVariablesCommand getVariablesCommand() {
        if (this.variablesCommand == null) {
            this.variablesCommand = this.add(CommandFactory.createVariablesCommand());
        }
        return this.variablesCommand;
    }

    private IServerCommand getServerCommand() {
        if (this.serverCommand == null) {
            this.serverCommand = this.add(CommandFactory.createServerCommand());
        }
        return this.serverCommand;
    }

    private IRollbackCommand getRollbackCommand() {
        if (!(this.currentOp instanceof IRollbackCommand)) {
            this.currentOp = this.add(CommandFactory.createRollbackCommand());
        }
        return (IRollbackCommand)this.currentOp;
    }

    public IUninstallCommand getUninstallCommand(boolean modify) {
        if (!(this.currentOp instanceof IUninstallCommand) || ((IUninstallCommand)this.currentOp).isModify() != modify) {
            this.currentOp = this.add(CommandFactory.createUnInstallCommand());
            if (modify || this.includeDefaults) {
                this.currentOp.setModify(modify);
            }
        }
        return (IUninstallCommand)this.currentOp;
    }

    private <T extends ICommand> T add(T cmd) {
        this.input.addCommand(cmd);
        cmd.setInput(this.input);
        return cmd;
    }

    private static String toString(Version version) {
        return version == null ? null : version.toString();
    }

    private class CurrentProfile {
        private String id;
        private String kind;
        private File installLocation;
        private IProfileCommand command;

        private CurrentProfile() {
        }

        String getId() {
            return this.id;
        }

        boolean set(String id, String kind, File installLocation) {
            if (id.equals(this.id) && kind.equals(this.kind) && Util.equals((Object)installLocation, (Object)this.installLocation)) {
                return false;
            }
            this.kind = kind;
            if (kind.equals("license")) {
                return true;
            }
            this.id = id;
            this.installLocation = installLocation;
            this.command = (IProfileCommand)ResponseFileBuilder.this.add(CommandFactory.createProfileCommand(id));
            if (installLocation != null) {
                this.command.setInstallLocation(installLocation.getPath());
            }
            if (kind.equals("self")) {
                this.command.setProfileKind(kind);
            }
            return true;
        }

        void addData(String key, String value) {
            if (this.command == null) {
                assert (this.kind.equals("license")) : "Missing profile() call";
            } else {
                this.command.addData(key, value);
            }
        }
    }
}

