/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.UserFeedback;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;

public final class InstallTransaction {
    public static final InstallTransaction NULL = new InstallTransaction("NULL", false, Statuses.ST.createMultiStatus(), null);
    private static final Logger log = Logger.getLogger(InstallTransaction.class);
    private final ArrayList operations = new ArrayList();
    private final String description;
    private boolean isUndoable;
    private CicMultiStatus result;
    private TransactionProgressMonitor transactionMonitor;
    private String topLevelErrorMessage = "";
    private boolean isUndoing = false;

    private InstallTransaction(String description, boolean isUndoable, boolean isUndoing, CicMultiStatus result, IProgressMonitor monitor) {
        this.description = description;
        this.isUndoable = isUndoable;
        this.isUndoing = isUndoing;
        this.result = result;
        this.transactionMonitor = monitor instanceof TransactionProgressMonitor ? (TransactionProgressMonitor)monitor : new TransactionProgressMonitor(monitor);
    }

    public InstallTransaction(String description, boolean isUndoable, CicMultiStatus result, IProgressMonitor monitor) {
        this(description, isUndoable, false, result, monitor);
    }

    public InstallTransaction(String description, InstallTransaction transaction) {
        this(description, transaction.isUndoable, transaction.isUndoing(), transaction.result, (IProgressMonitor)transaction.transactionMonitor);
    }

    public IStatus performOperation(IInstallOperation operation, IProgressMonitor monitor) {
        IStatus status;
        this.operations.add(operation);
        IStatus opStatus = operation.perform(this, monitor);
        if (!this.isUndoable) {
            this.result.add(opStatus);
            status = Status.OK_STATUS;
        } else {
            if (StatusUtil.isErrorOrCancel((IStatus)opStatus) || monitor.isCanceled()) {
                if (StatusUtil.isErrorOrCancel((IStatus)opStatus)) {
                    int length = this.operations.size();
                    IInstallOperation lastOperation = (IInstallOperation)this.operations.get(length - 1);
                    if (!lastOperation.shouldUndoOnError()) {
                        this.operations.remove(length - 1);
                    }
                } else {
                    opStatus = ICicStatus.CANCEL_STATUS;
                }
            }
            status = opStatus;
        }
        if (opStatus.matches(4) && this.result.getMessage().length() == 0) {
            this.result.setMessage(this.topLevelErrorMessage);
        } else if (opStatus.matches(8) && this.result.getMessage().length() == 0) {
            this.result = Statuses.ST.createMultiStatusFromStatus((IStatus)ICicStatus.CANCEL_STATUS);
        }
        monitor.done();
        return status;
    }

    public IStatus performOperations(IInstallOperation[] ops, int[] weights, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, weights);
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        try {
            IInstallOperation[] iInstallOperationArray = ops;
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallOperation operation = iInstallOperationArray[n2];
                IProgressMonitor sub = pm.next();
                IStatus subStatus = this.performOperation(operation, sub);
                status.add(subStatus);
                if (StatusUtil.isErrorOrCancel((IStatus)subStatus)) {
                    break;
                }
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        return status;
    }

    public void undoTransaction(IProgressMonitor monitor) {
        if (!this.isUndoable) {
            return;
        }
        this.isUndoable = false;
        this.isUndoing = true;
        ArrayList undoOperations = (ArrayList)this.operations.clone();
        Collections.reverse(undoOperations);
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, undoOperations.size());
        int i = 0;
        while (i < undoOperations.size()) {
            block7: {
                IInstallOperation operation = (IInstallOperation)undoOperations.get(i);
                CacheManager.getDefaultInstance().setDownloadOnDemand(true);
                try {
                    try {
                        IStatus status = operation.undoPerform(this, pm.next());
                        log.statusNotOK(status);
                    }
                    catch (Throwable t) {
                        log.error(t);
                        CacheManager.getDefaultInstance().setDownloadOnDemand(false);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    CacheManager.getDefaultInstance().setDownloadOnDemand(false);
                    throw throwable;
                }
                CacheManager.getDefaultInstance().setDownloadOnDemand(false);
            }
            ++i;
        }
    }

    public IProgressMonitor getTransactionMonitor() {
        return this.transactionMonitor;
    }

    public boolean isUndoable() {
        return this.isUndoable;
    }

    public void setNeedArtifacts(boolean needArtifacts) {
        this.transactionMonitor.setNeedArtifacts(needArtifacts);
    }

    public void setTopLevelErrorMessage(String topLevelErrorMessage) {
        if (topLevelErrorMessage != null) {
            this.topLevelErrorMessage = topLevelErrorMessage;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Transaction: ");
        sb.append(this.description);
        sb.append(", ").append(this.operations.size()).append(" operations performed");
        if (!this.isUndoable) {
            sb.append(", isUndoable=").append(this.isUndoable);
        }
        return sb.toString();
    }

    public boolean isUndoing() {
        return this.isUndoing;
    }

    private static class TransactionProgressMonitor
    extends ProgressMonitorWrapper {
        private boolean confirmed = false;
        private boolean needArtifacts = false;

        protected TransactionProgressMonitor(IProgressMonitor monitor) {
            super((IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
        }

        public synchronized boolean isCanceled() {
            boolean isCanceled = super.isCanceled();
            if (isCanceled && !this.confirmed) {
                if (this.askConfirm()) {
                    this.confirmed = true;
                } else {
                    super.setCanceled(false);
                    isCanceled = false;
                }
            }
            return isCanceled;
        }

        private boolean askConfirm() {
            return UserFeedback.isOkToCancel(this.needArtifacts ? Messages.Engine_Confirm_Cancel_Artifacts_Needed : null, true);
        }

        public void setNeedArtifacts(boolean needArtifacts) {
            this.needArtifacts = needArtifacts;
        }
    }
}

