/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IAgentEngine;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.UndoProgress;
import com.ibm.cic.agent.internal.core.AdaptorManager;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebug;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.utils.InstallableUnitSizeUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.DeviceSystem;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Engine
implements IAgentEngine {
    private static final Logger log = Logger.getLogger(Engine.class);
    private static final Logger slog = Logger.getLogger((String)"InstallSize");
    private static final Logger plog = Logger.getLogger((Logger)log, (String)"timing");

    @Override
    public IStatus install(InstallTransaction directorTransaction, InstallableUnitPair[] ius, InstallContext context, IProgressMonitor monitor) {
        String description = "Engine install performing phase operations for " + Integer.toString(ius.length) + " IU pairs in " + context.getId();
        InstallTransaction engineTransaction = new InstallTransaction(description, directorTransaction);
        GetAdaptersOperation getOp = new GetAdaptersOperation(context, ius);
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 99});
        IStatus status = engineTransaction.performOperation(getOp, pm.next());
        if (!status.isOK()) {
            pm.done();
            return status;
        }
        IInstallAdaptor[] adapters = getOp.getAdapters();
        Phase[] phases = new Phase[]{new Phase.Initialize(1, ius, adapters, context), new Phase.PreInstallConfigure(1, ius, context), new Phase.PreInstall(1, ius, adapters, context), new Phase.Install(10, ius, context), new Phase.PostInstall(1, ius, adapters, context), new Phase.PostInstallConfigure(1, ius, context), new Phase.Complete(1, ius, adapters, context)};
        status = Phase.perform(phases, engineTransaction, pm.next());
        pm.done();
        return status;
    }

    @Override
    public IStatus uninstall(InstallTransaction directorTransaction, InstallableUnitPair[] ius, InstallContext context, IProgressMonitor monitor) {
        String description = "Engine uninstall performing phase operations for " + Integer.toString(ius.length) + " IU pairs in " + context.getId();
        InstallTransaction engineTransaction = new InstallTransaction(description, directorTransaction);
        GetAdaptersOperation getOp = new GetAdaptersOperation(context, ius);
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 99});
        IStatus status = engineTransaction.performOperation(getOp, pm.next());
        if (!status.isOK()) {
            pm.done();
            return status;
        }
        IInstallAdaptor[] adapters = getOp.getAdapters();
        Phase[] phases = new Phase[]{new Phase.Initialize(1, ius, adapters, context), new Phase.PreInstallConfigure(1, ius, context), new Phase.PreInstall(1, ius, adapters, context), new Phase.Install(10, ius, context), new Phase.PostInstall(1, ius, adapters, context), new Phase.PostInstallConfigure(10, ius, context), new Phase.Complete(1, ius, adapters, context)};
        status = Phase.perform(phases, engineTransaction, pm.next());
        pm.done();
        return status;
    }

    public IStatus restart(Profile profile) {
        return this.restart(profile.getRootContext());
    }

    private IStatus restart(InstallContext context) {
        InstallContext[] subContexts;
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        if (context.needsRestart(true)) {
            status.add(this.doRestart(context));
        }
        InstallContext[] installContextArray = subContexts = context.getSubcontexts();
        int n = subContexts.length;
        int n2 = 0;
        while (n2 < n) {
            InstallContext subContext = installContextArray[n2];
            status.add(this.restart(subContext));
            ++n2;
        }
        return status;
    }

    private IStatus doRestart(InstallContext context) {
        if (context.needsRestart(false)) {
            String[] adaptors = context.getAdaptorTypes();
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            String[] stringArray = adaptors;
            int n = adaptors.length;
            int n2 = 0;
            while (n2 < n) {
                String adaptor2 = stringArray[n2];
                IInstallAdaptor adaptor = AdaptorManager.getInstance().getAdaptor(adaptor2);
                if (adaptor != null) {
                    status.add(adaptor.restart(context));
                }
                ++n2;
            }
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus start() {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus stop() {
        IInstallAdaptor[] adaptors;
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        IInstallAdaptor[] iInstallAdaptorArray = adaptors = AdaptorManager.getInstance().getCreatedAdaptors();
        int n = adaptors.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
            status.add(adaptor.stop(null));
            ++n2;
        }
        return status;
    }

    @Override
    public String getName() {
        return "";
    }

    private static class GetAdaptersOperation
    implements IInstallOperation {
        private final InstallContext context;
        private final InstallableUnitPair[] ius;
        private final Set adapterIds = new HashSet();
        private final List adapters = new ArrayList();

        public GetAdaptersOperation(InstallContext context, InstallableUnitPair[] ius) {
            this.context = context;
            this.ius = ius;
        }

        @Override
        public IStatus perform(InstallTransaction directorTransaction, IProgressMonitor monitor) {
            InstallableUnitPair[] installableUnitPairArray = this.ius;
            int n = this.ius.length;
            int n2 = 0;
            while (n2 < n) {
                InstallableUnitPair iu = installableUnitPairArray[n2];
                this.adapterIds.add(iu.getAdapterId());
                ++n2;
            }
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            Iterator j = this.adapterIds.iterator();
            while (j.hasNext()) {
                String adapterId = (String)j.next();
                IInstallAdaptor adapter = AdaptorManager.getInstance().getAdaptor(adapterId);
                if (adapter == null) {
                    String msg = NLS.bind((String)Messages.Engine_No_Install_Adapter_Registered_For_Type, (Object)adapterId);
                    status.add((IStatus)new Status(4, Agent.PI_AGENT, 0, msg, null));
                    j.remove();
                    continue;
                }
                this.adapters.add(adapter);
            }
            return status;
        }

        @Override
        public IStatus undoPerform(InstallTransaction directorTransaction, IProgressMonitor monitor) {
            return Status.OK_STATUS;
        }

        @Override
        public boolean shouldUndoOnError() {
            return false;
        }

        public IInstallAdaptor[] getAdapters() {
            return this.adapters.toArray(new IInstallAdaptor[this.adapters.size()]);
        }

        public String toString() {
            return "Get adapters for " + Integer.toString(this.ius.length) + " IU pairs in " + this.context.getId() + ": " + this.adapterIds.toString();
        }
    }

    private static abstract class Phase
    implements IInstallOperation {
        private static IProgressMonitor undoProgressMonitor;
        protected final int weight;
        protected String phaseName;
        protected String undoPhaseName;
        protected InstallableUnitPair[] ius;
        protected InstallContext context;
        protected InstallTransaction phaseTransaction;

        public static IStatus perform(Phase[] phases, InstallTransaction engineTransaction, IProgressMonitor monitor) {
            Phase.setUndoProgressMonitor(null);
            IStatus status = engineTransaction.performOperations(phases, Phase.getWeights(phases), monitor);
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                log.status(status);
                engineTransaction.undoTransaction(Phase.getUndoProgressMonitor());
            }
            return status;
        }

        protected static IProgressMonitor getUndoProgressMonitor() {
            if (undoProgressMonitor == null) {
                undoProgressMonitor = UndoProgress.getUndoProgressMonitor();
            }
            return undoProgressMonitor;
        }

        protected static void setUndoProgressMonitor(IProgressMonitor monitor) {
            undoProgressMonitor = monitor;
        }

        protected Phase(int weight, String phaseName, String undoPhaseName, InstallableUnitPair[] ius, InstallContext context) {
            this.weight = weight;
            this.phaseName = phaseName;
            this.undoPhaseName = undoPhaseName;
            this.ius = ius;
            this.context = context;
        }

        public String toString() {
            return "Phase: " + this.phaseName + " - " + this.weight;
        }

        @Override
        public IStatus perform(InstallTransaction engineTransaction, IProgressMonitor monitor) {
            log.start(log.info(Messages.Engine_Performing_Phase, new Object[]{this.phaseName}));
            this.phaseTransaction = new InstallTransaction(NLS.bind((String)Messages.Engine_Performing_Phase, (Object)this.phaseName), engineTransaction);
            this.phaseTransaction.setTopLevelErrorMessage(NLS.bind((String)Messages.Engine_Error_During_Phase, (Object)this.phaseName));
            InstallOperationDebug.INSTANCE.setEnginePhase(this.phaseName);
            IStatus status = this.doPerform(monitor);
            InstallOperationDebug.INSTANCE.setEnginePhase(null);
            log.stop();
            return status;
        }

        @Override
        public IStatus undoPerform(InstallTransaction transaction, IProgressMonitor monitor) {
            String name = this.phaseName;
            this.phaseName = this.undoPhaseName;
            this.undoPhaseName = name;
            log.debug("Undo {0} phase", new Object[]{this.undoPhaseName});
            InstallOperationDebug.INSTANCE.setEnginePhase(this.phaseName);
            this.phaseTransaction.undoTransaction(monitor);
            InstallOperationDebug.INSTANCE.setEnginePhase(null);
            return Status.OK_STATUS;
        }

        @Override
        public boolean shouldUndoOnError() {
            return true;
        }

        protected abstract IStatus doPerform(IProgressMonitor var1);

        private static int[] getWeights(Phase[] phases) {
            int[] weights = new int[phases.length];
            int i = 0;
            while (i < phases.length) {
                weights[i] = phases[i].weight;
                ++i;
            }
            return weights;
        }

        private static String getMessage(IStatus status) {
            IStatus[] children;
            String msg = status.getMessage();
            if (msg.length() > 0) {
                return msg;
            }
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                msg = Phase.getMessage(element);
                if (msg.length() > 0) {
                    return msg;
                }
                ++n2;
            }
            return "";
        }

        private static abstract class AdapterPhase
        extends Phase {
            protected IInstallAdaptor[] adapters;

            protected AdapterPhase(int weight, String phaseName, String undoPhaseName, InstallableUnitPair[] ius, IInstallAdaptor[] adapters, InstallContext context) {
                super(weight, phaseName, undoPhaseName, ius, context);
                this.adapters = adapters;
            }

            @Override
            protected IStatus doPerform(IProgressMonitor monitor) {
                SplitProgressMonitor pm = new SplitProgressMonitor(monitor, this.adapters.length);
                IInstallAdaptor[] iInstallAdaptorArray = this.adapters;
                int n = this.adapters.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstallAdaptor adapter = iInstallAdaptorArray[n2];
                    AdapterPhaseSubOperation subOp = new AdapterPhaseSubOperation(adapter);
                    IProgressMonitor sub = pm.next();
                    IStatus subOpStatus = this.phaseTransaction.performOperation(subOp, sub);
                    if (StatusUtil.isErrorOrCancel((IStatus)subOpStatus)) {
                        pm.done();
                        return subOpStatus;
                    }
                    ++n2;
                }
                pm.done();
                return Status.OK_STATUS;
            }

            protected abstract IStatus performAdapter(IInstallAdaptor var1, IProgressMonitor var2);

            protected abstract IStatus undoPerformAdapter(IInstallAdaptor var1, IProgressMonitor var2);

            private class AdapterPhaseSubOperation
            implements IInstallOperation {
                private final IInstallAdaptor adapter;

                public AdapterPhaseSubOperation(IInstallAdaptor adapter) {
                    this.adapter = adapter;
                }

                @Override
                public IStatus perform(InstallTransaction phazeTransaction, IProgressMonitor monitor) {
                    AdapterPhase.this.context.setAdaptorTransaction(phazeTransaction);
                    try {
                        IStatus status = AdapterPhase.this.performAdapter(this.adapter, monitor);
                        if (status == null) {
                            status = Status.OK_STATUS;
                        }
                        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                            InstallOperationDebug.INSTANCE.suspendByErrorOrCancelInAdapterPhase(status);
                        }
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    finally {
                        AdapterPhase.this.context.setAdaptorTransaction(null);
                    }
                }

                @Override
                public IStatus undoPerform(InstallTransaction phazeTransaction, IProgressMonitor monitor) {
                    AdapterPhase.this.context.setAdaptorTransaction(phazeTransaction);
                    try {
                        log.debug("Undo {0} phase for {1}", new Object[]{AdapterPhase.this.undoPhaseName, this.adapter.getId()});
                        IStatus status = AdapterPhase.this.undoPerformAdapter(this.adapter, monitor);
                        if (status == null) {
                            status = Status.OK_STATUS;
                        }
                        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                            InstallOperationDebug.INSTANCE.suspendByErrorOrCancelInAdapterPhase(status);
                        }
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    finally {
                        AdapterPhase.this.context.setAdaptorTransaction(null);
                    }
                }

                @Override
                public boolean shouldUndoOnError() {
                    return true;
                }

                public String toString() {
                    return String.valueOf(AdapterPhase.this.phaseName) + ' ' + this.adapter.getId();
                }
            }
        }

        public static class Complete
        extends AdapterPhase {
            protected Complete(int weight, InstallableUnitPair[] ius, IInstallAdaptor[] adapters, InstallContext context) {
                super(weight, Messages.Engine_Complete_Phase, Messages.Engine_Initialize_Phase, ius, adapters, context);
            }

            @Override
            protected IStatus performAdapter(IInstallAdaptor adapter, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Complete_For_Adapter, (Object)adapter.getId()));
                return adapter.complete(this.context, monitor);
            }

            @Override
            protected IStatus undoPerformAdapter(IInstallAdaptor adapter, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Initialize_For_Adapter, (Object)adapter.getId()));
                return adapter.initialize(this.context);
            }
        }

        private static abstract class IUPhase
        extends Phase {
            protected IUPhase(int weight, String phaseName, String undoPhaseName, InstallableUnitPair[] ius, InstallContext context) {
                super(weight, phaseName, undoPhaseName, ius, context);
            }

            @Override
            protected IStatus doPerform(IProgressMonitor monitor) {
                final boolean[] wasCanceled = new boolean[1];
                final boolean[] cancellable = new boolean[1];
                ProgressMonitorWrapper wrapperMonitor = new ProgressMonitorWrapper(monitor){

                    public boolean isCanceled() {
                        if (!wasCanceled[0] && this.getWrappedProgressMonitor().isCanceled()) {
                            wasCanceled[0] = true;
                            return cancellable[0];
                        }
                        return false;
                    }
                };
                SplitProgressMonitor pm = new SplitProgressMonitor((IProgressMonitor)wrapperMonitor, this.ius.length);
                CicMultiStatus opStatus = Statuses.OK.getMultiStatus();
                InstallableUnitPair[] installableUnitPairArray = this.ius;
                int n = this.ius.length;
                int n2 = 0;
                while (n2 < n) {
                    InstallableUnitPair pair = installableUnitPairArray[n2];
                    IInstallAdaptor adapter = AdaptorManager.getInstance().getAdaptor(pair.getAdapterId());
                    IProgressMonitor sub = pm.next();
                    long beginSpace = this.getFreeSpaceForDebugLog();
                    cancellable[0] = this.isCancellable(pair.getTo());
                    IUPhaseSubOperation subOp = new IUPhaseSubOperation(adapter, pair);
                    IStatus subOpStatus = this.phaseTransaction.performOperation(subOp, sub);
                    this.showSpaceUsed(beginSpace, pair);
                    if (StatusUtil.isErrorOrCancel((IStatus)subOpStatus)) {
                        pm.done();
                        return subOpStatus;
                    }
                    if (wasCanceled[0]) {
                        subOpStatus = ICicStatus.CANCEL_STATUS;
                        pm.done();
                        return subOpStatus;
                    }
                    opStatus.add(subOpStatus);
                    ++n2;
                }
                pm.done();
                return opStatus;
            }

            protected abstract IStatus performIU(IInstallAdaptor var1, InstallableUnitPair var2, IProgressMonitor var3);

            protected abstract IStatus undoPerformIU(IInstallAdaptor var1, InstallableUnitPair var2, IProgressMonitor var3);

            protected void logStartDebug(InstallableUnitPair pair) {
                LogEntry le = log.debug("Perform {0} on {1}", new Object[]{this.phaseName, pair});
                if (plog.isDebugLoggable()) {
                    if (le == null) {
                        le = plog.debug("Perform {0} on {1}", new Object[]{this.phaseName, pair});
                    }
                    plog.start(le);
                }
            }

            protected void logStopDebug() {
                if (plog.isDebugLoggable()) {
                    plog.stop();
                }
            }

            private long getFreeSpaceForDebugLog() {
                if (!slog.isDebugLoggable()) {
                    return 0L;
                }
                Profile profile = this.context.getEnclosingProfile();
                if (profile.getInstallLocation() == null) {
                    return 0L;
                }
                return DeviceSystem.getFreeSpace((File)new File(profile.getInstallLocation()));
            }

            private void showSpaceUsed(long beginSpace, InstallableUnitPair pair) {
                long actualUse = beginSpace - this.getFreeSpaceForDebugLog();
                if (actualUse == 0L) {
                    return;
                }
                SizeInfo toSizeInfo = IUPhase.getSizeInfo(pair.getTo());
                long expectedUse = toSizeInfo.getInstallSize();
                expectedUse = pair.getAdapterId().equals("eclipse") ? (expectedUse -= toSizeInfo.getDownloadSize()) : (expectedUse -= IUPhase.getSizeInfo(pair.getFrom()).getInstallSize());
                slog.debug("Used {0} for {1} {2} (expected: {3})", new Object[]{actualUse, this.phaseName, pair.getQualifiedId().getId(), expectedUse});
            }

            private static SizeInfo getSizeInfo(IInstallableUnit iu) {
                return InstallableUnitSizeUtil.getSizeInfo((IInstallableUnit)iu);
            }

            private boolean isCancellable(IInstallableUnit iu) {
                if (iu != null) {
                    boolean definedWithinIU;
                    boolean bl = definedWithinIU = iu.getProperty("allow.cancel.during.iu.phase") != null;
                    if (definedWithinIU) {
                        return Boolean.valueOf(iu.getProperty("allow.cancel.during.iu.phase"));
                    }
                    return Boolean.valueOf(iu.getParent().getProperty("allow.cancel.during.iu.phase"));
                }
                return false;
            }

            private class IUPhaseSubOperation
            implements IInstallOperation {
                private final IInstallAdaptor adapter;
                private InstallableUnitPair pair;
                private InstallTransaction iuTransaction;

                public IUPhaseSubOperation(IInstallAdaptor adapter, InstallableUnitPair pair) {
                    this.adapter = adapter;
                    this.pair = pair;
                }

                @Override
                public IStatus perform(InstallTransaction phazeTransaction, IProgressMonitor monitor) {
                    this.iuTransaction = new InstallTransaction(this.toString(), phazeTransaction);
                    IUPhase.this.context.setInstallableUnitTransaction(this.iuTransaction);
                    InstallOperationDebug.INSTANCE.setPair(this.pair);
                    try {
                        IStatus status = IUPhase.this.performIU(this.adapter, this.pair, monitor);
                        if (status == null) {
                            status = Status.OK_STATUS;
                        }
                        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
                            this.iuTransaction = null;
                        } else if (status.matches(4)) {
                            IInstallableUnitContainer parent = this.pair.getParent();
                            log.info(Messages.Engine_Error_Occurred, new Object[]{IUPhase.this.phaseName, parent.getIdentity(), parent.getVersion(), this.pair, Phase.getMessage(status)});
                        }
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    finally {
                        IUPhase.this.context.setInstallableUnitTransaction(null);
                        InstallOperationDebug.INSTANCE.setPair(null);
                    }
                }

                @Override
                public IStatus undoPerform(InstallTransaction phazeTransaction, IProgressMonitor monitor) {
                    log.debug("Undo {0} phase for {1}", new Object[]{IUPhase.this.undoPhaseName, this.pair});
                    InstallOperationDebug.INSTANCE.reverseInstallOrderPairs();
                    InstallableUnitPair reversedPair = this.pair.reverse();
                    if (this.iuTransaction != null) {
                        try {
                            InstallOperationDebug.INSTANCE.setPair(reversedPair);
                            IUPhase.this.context.setInstallableUnitTransaction(this.iuTransaction);
                            this.iuTransaction.undoTransaction(monitor);
                        }
                        finally {
                            IUPhase.this.context.setInstallableUnitTransaction(null);
                            InstallOperationDebug.INSTANCE.setPair(null);
                        }
                        return Status.OK_STATUS;
                    }
                    this.pair = reversedPair;
                    this.iuTransaction = new InstallTransaction(this.toString(), phazeTransaction);
                    IUPhase.this.context.setInstallableUnitTransaction(this.iuTransaction);
                    InstallOperationDebug.INSTANCE.setPair(this.pair);
                    try {
                        IStatus status = IUPhase.this.undoPerformIU(this.adapter, this.pair, monitor);
                        if (status == null) {
                            status = Status.OK_STATUS;
                        }
                        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
                            this.iuTransaction = null;
                        } else if (status.matches(4)) {
                            IInstallableUnitContainer parent = this.pair.getParent();
                            log.info(Messages.Engine_Error_Occurred, new Object[]{IUPhase.this.phaseName, parent.getIdentity(), parent.getVersion(), this.pair, Phase.getMessage(status)});
                        }
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    finally {
                        IUPhase.this.context.setInstallableUnitTransaction(null);
                        InstallOperationDebug.INSTANCE.setPair(null);
                    }
                }

                @Override
                public boolean shouldUndoOnError() {
                    return true;
                }

                public String toString() {
                    return String.valueOf(IUPhase.this.phaseName) + ' ' + this.pair.toString();
                }
            }
        }

        public static class Initialize
        extends AdapterPhase {
            protected Initialize(int weight, InstallableUnitPair[] ius, IInstallAdaptor[] adapters, InstallContext context) {
                super(weight, Messages.Engine_Initialize_Phase, Messages.Engine_Complete_Phase, ius, adapters, context);
            }

            @Override
            protected IStatus performAdapter(IInstallAdaptor adapter, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Initialize_For_Adapter, (Object)adapter.getId()));
                return adapter.initialize(this.context);
            }

            @Override
            protected IStatus undoPerformAdapter(IInstallAdaptor adapter, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Complete_For_Adapter, (Object)adapter.getId()));
                return adapter.complete(this.context, monitor);
            }
        }

        public static class Install
        extends IUPhase {
            protected Install(int weight, InstallableUnitPair[] ius, InstallContext context) {
                super(weight, Messages.Engine_Install_Phase, Messages.Engine_Install_Phase, ius, context);
            }

            @Override
            protected IStatus performIU(IInstallAdaptor adapter, InstallableUnitPair pair, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Installing_IU, (Object)pair.getIdentity()));
                this.logStartDebug(pair);
                IStatus s = adapter.install(pair, this.context, monitor);
                this.logStopDebug();
                return s;
            }

            @Override
            protected IStatus undoPerformIU(IInstallAdaptor adapter, InstallableUnitPair pair, IProgressMonitor monitor) {
                return this.performIU(adapter, pair, monitor);
            }
        }

        public static class PostInstall
        extends AdapterPhase {
            protected PostInstall(int weight, InstallableUnitPair[] ius, IInstallAdaptor[] adapters, InstallContext context) {
                super(weight, Messages.Engine_Post_Install_Phase, Messages.Engine_Pre_Install_Phase, ius, adapters, context);
            }

            @Override
            protected IStatus performAdapter(IInstallAdaptor adapter, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Post_Install_For_Adapter, (Object)adapter.getId()));
                return adapter.postInstall(this.context, monitor);
            }

            @Override
            protected IStatus undoPerformAdapter(IInstallAdaptor adapter, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Pre_Install_For_Adapter, (Object)adapter.getId()));
                return adapter.preInstall(this.context, monitor);
            }
        }

        public static class PostInstallConfigure
        extends IUPhase {
            protected PostInstallConfigure(int weight, InstallableUnitPair[] ius, InstallContext context) {
                super(weight, Messages.Engine_Post_Install_Configure_Phase, Messages.Engine_Pre_Install_Configure_Phase, ius, context);
            }

            @Override
            protected IStatus performIU(IInstallAdaptor adapter, InstallableUnitPair pair, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Configuring_IU, (Object)pair.getIdentity()));
                this.logStartDebug(pair);
                IStatus s = adapter.postInstallConfigure(pair, this.context, monitor);
                this.logStopDebug();
                return s;
            }

            @Override
            protected IStatus undoPerformIU(IInstallAdaptor adapter, InstallableUnitPair pair, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Pre_Configuring_IU, (Object)pair.getIdentity()));
                this.logStartDebug(pair);
                IStatus s = adapter.preInstallConfigure(pair, this.context, monitor);
                this.logStopDebug();
                return s;
            }
        }

        public static class PreInstall
        extends AdapterPhase {
            protected PreInstall(int weight, InstallableUnitPair[] ius, IInstallAdaptor[] adapters, InstallContext context) {
                super(weight, Messages.Engine_Pre_Install_Phase, Messages.Engine_Post_Install_Phase, ius, adapters, context);
            }

            @Override
            protected IStatus performAdapter(IInstallAdaptor adapter, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Pre_Install_For_Adapter, (Object)adapter.getId()));
                return adapter.preInstall(this.context, monitor);
            }

            @Override
            protected IStatus undoPerformAdapter(IInstallAdaptor adapter, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Post_Install_For_Adapter, (Object)adapter.getId()));
                return adapter.postInstall(this.context, monitor);
            }
        }

        public static class PreInstallConfigure
        extends IUPhase {
            protected PreInstallConfigure(int weight, InstallableUnitPair[] ius, InstallContext context) {
                super(weight, Messages.Engine_Pre_Install_Configure_Phase, Messages.Engine_Post_Install_Configure_Phase, ius, context);
            }

            @Override
            protected IStatus performIU(IInstallAdaptor adapter, InstallableUnitPair pair, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Pre_Configuring_IU, (Object)pair.getIdentity()));
                this.logStartDebug(pair);
                IStatus s = adapter.preInstallConfigure(pair, this.context, monitor);
                this.logStopDebug();
                return s;
            }

            @Override
            protected IStatus undoPerformIU(IInstallAdaptor adapter, InstallableUnitPair pair, IProgressMonitor monitor) {
                monitor.subTask(NLS.bind((String)Messages.Engine_Configuring_IU, (Object)pair.getIdentity()));
                this.logStartDebug(pair);
                IStatus s = adapter.postInstallConfigure(pair, this.context, monitor);
                this.logStopDebug();
                return s;
            }
        }
    }
}

