/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.ProvideAlternativeRepositories;
import com.ibm.cic.agent.core.UserFeedback;
import com.ibm.cic.agent.core.internal.expander.ProfileSelectorExpander;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.NoCancelProgressMonitor;
import com.ibm.cic.agent.internal.core.VisibleDiskSetsUtil;
import com.ibm.cic.common.core.artifactrepo.ArtifactOfInstallableUnit;
import com.ibm.cic.common.core.artifactrepo.AssignArtifacts;
import com.ibm.cic.common.core.artifactrepo.IAlternativeRepositories;
import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.ReferenceContexts;
import com.ibm.cic.common.core.artifactrepo.ValidationPolicy;
import com.ibm.cic.common.core.artifactrepo.base.AbstractAddCopyArtifacts;
import com.ibm.cic.common.core.artifactrepo.base.AddArtifacts;
import com.ibm.cic.common.core.artifactrepo.base.AddArtifactsByDisk;
import com.ibm.cic.common.core.artifactrepo.base.AddArtifactsProgress;
import com.ibm.cic.common.core.artifactrepo.base.DetermineDisksNeeded;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.base.RemoveArtifacts;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AddOption;
import com.ibm.cic.common.core.artifactrepo.impl.AddOptions;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactToPathUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactsOnDisksInfo;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactTocRead;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactTocUpdate;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.WebUiSafeProgressMonitor;
import com.ibm.cic.common.core.internal.agentAndAuthor.TruncatedArtifactWarningExceptions;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.KeyBasedArtifact;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.OppositeExplodedArtifact;
import com.ibm.cic.common.core.model.expander.ExpanderUtils;
import com.ibm.cic.common.core.model.expander.SelectorExpander;
import com.ibm.cic.common.core.model.utils.InstallableUnitUtil;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskRepository;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.CompositeRepository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IReopenRepositoryPrompter;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryIdentity;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRevealFileLocations;
import com.ibm.cic.common.core.repository.RepositoryDescriptor;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.repository.ZipRepository;
import com.ibm.cic.common.core.utils.BackupDirectoryFilesKeepStructure;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileName;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.MapListUtil;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OmitSubTaskProgressMonitor;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.SortedProperties;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class CacheManager {
    public static final String CACHE_MANAGER_VERSION = "CACHE_MANAGER_VERSION";
    private static final Version CM_VERSION_0 = new Version(0, 0, 0);
    private static final Version CM_VERSION_1;
    public static final Version CM_VERSION_LATEST;
    private static final VersionRange CM_TOLERANCE;
    static final String PROP_CM_VERSION = "cic.cacheManager.version";
    static final String PROP_CM_TOLERANCE = "cic.cacheManager.tolerance";
    static final String CACHE_MANAGER_REPOSITORY = "CACHE_MANAGER_REPOSITORY";
    private static final Logger log;
    private static final Logger plog;
    public static final String DEFAULT_CACHE_NAME = "cache";
    private static final String DEFAULT_DESCRIPTION = "Common Components";
    private static CacheManager defaultInstance;
    private static final CacheManager DEFAULT_CACHE_MANAGER;
    private static final String pluginId;
    private static final Map<String, IReopenRepositoryPrompter> reopenRepositoryPrompters;
    private String repositoryPath;
    private final String repositoryName;
    private final String description;
    private File location;
    private final IRepositoryGroup group;
    private IRepository repo;
    private IRepository repoTrackExploded;
    private List<File> createdDirs = null;
    private IArtifactSession session = null;
    private boolean downloadOnDemand = false;
    private ArtifactsToDownload atd;
    private OnDemandFetching onDemand;
    private Boolean agentSelf = null;
    private Boolean agentSelfProfile = null;

    static {
        CM_VERSION_LATEST = CM_VERSION_1 = new Version(0, 0, 1);
        CM_TOLERANCE = new VersionRange(CM_VERSION_0, true, CM_VERSION_LATEST, true);
        log = Logger.getLogger(CacheManager.class, (Plugin)AgentActivator.getDefault());
        plog = Logger.getLogger((Logger)log, (String)"timing");
        defaultInstance = null;
        DEFAULT_CACHE_MANAGER = new CacheManager(null, DEFAULT_CACHE_NAME, DEFAULT_DESCRIPTION);
        pluginId = AgentActivator.getPluginId();
        reopenRepositoryPrompters = new HashMap<String, IReopenRepositoryPrompter>();
    }

    private static String getDefaultCachePath() {
        return CacheLocationManager.getInstance().getCacheLocation();
    }

    static boolean hasDefaultCache() {
        String path = CacheManager.getDefaultCachePath();
        return path != null && path.length() > 0;
    }

    public static IStatus setDefaultInstance() {
        DEFAULT_CACHE_MANAGER.resetLocation(CacheManager.getDefaultCachePath());
        return CacheManager.setDefaultInstance(DEFAULT_CACHE_MANAGER);
    }

    public static IStatus setDefaultInstance(CacheManager cacheManager) {
        if (defaultInstance != null) {
            log.errorNoUid("Default instance is already set: {0}", new Object[]{defaultInstance});
        }
        if (!(defaultInstance = cacheManager).isOpen()) {
            try {
                defaultInstance.open();
            }
            catch (CacheManagerException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    public static void clearDefaultInstance() {
        if (defaultInstance != null) {
            if (defaultInstance.isOpen()) {
                defaultInstance.close();
            }
            defaultInstance = null;
        }
    }

    public static CacheManager pushDefaultInstance(CicMultiStatus status, CacheManager cacheManager) {
        CacheManager result = defaultInstance;
        defaultInstance = null;
        status.add(CacheManager.setDefaultInstance(cacheManager));
        return result;
    }

    public static void popDefaultInstance(CacheManager cacheManager) {
        if (defaultInstance == null) {
            throw new IllegalStateException("popDefaultInstance called without pushDefaultInstance");
        }
        CacheManager.clearDefaultInstance();
        if (cacheManager != null) {
            CacheManager.setDefaultInstance(cacheManager);
        }
    }

    public static CacheManager getDefaultInstance() {
        if (defaultInstance == null) {
            throw new IllegalStateException("setDefaultInstance has not been called");
        }
        return defaultInstance;
    }

    protected CacheManager(String repositoryPath, String repositoryName, String description) {
        this.repositoryPath = repositoryPath;
        this.repositoryName = repositoryName;
        this.description = description;
        this.group = new RepositoryGroup(repositoryName);
    }

    private IReopenRepositoryPrompter getReopenRepositoryPrompter() {
        return reopenRepositoryPrompters.get(this.repositoryName);
    }

    public static void setReopenRepositoryPrompter(String cacheName, IReopenRepositoryPrompter reopenRepositoryPrompter) {
        reopenRepositoryPrompters.put(cacheName, reopenRepositoryPrompter);
    }

    public String toString() {
        return String.valueOf(this.repositoryName) + (this.isOpen() ? " (open) " : " (closed) ") + this.repositoryPath;
    }

    private boolean isOpen() {
        return this.location != null;
    }

    public boolean isAgentSelf() {
        if (this.agentSelf == null) {
            this.agentSelf = FileUtil.filesAreSame((File)this.location, (File)Agent.getInstance().getAgentSelfLocation());
        }
        return this.agentSelf;
    }

    private boolean isAgentSelfProfile() {
        if (this.agentSelfProfile == null) {
            boolean isSelfProfile;
            Profile selfProfile = Agent.getInstance().getAgentProfile();
            if (selfProfile == null) {
                isSelfProfile = false;
            } else {
                File selfProfileLocation = new File(selfProfile.getInstallLocation());
                isSelfProfile = FileUtil.filesAreSame((File)this.location, (File)selfProfileLocation);
            }
            this.agentSelfProfile = isSelfProfile;
        }
        return this.agentSelfProfile;
    }

    public boolean isAgentBundle() {
        return this == Agent.getInstance().getAgentBundleCacheManager();
    }

    public File getCacheLocation() {
        return this.location;
    }

    protected InstallRegistry.ProfileInstallRegistry[] getProfileInstallRegistries() {
        Collection<InstallRegistry.ProfileInstallRegistry> registries = InstallRegistry.getInstance().getProfileInstallRegistries();
        ArrayList<InstallRegistry.ProfileInstallRegistry> result = new ArrayList<InstallRegistry.ProfileInstallRegistry>();
        for (InstallRegistry.ProfileInstallRegistry registry : registries) {
            Profile profile = registry.getProfile();
            if (profile == null || profile.isAgentProfile()) continue;
            assert (!profile.isPhantom());
            result.add(registry);
        }
        return result.toArray(new InstallRegistry.ProfileInstallRegistry[result.size()]);
    }

    private IStatus getArtifactLocator(IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] locatorRef) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return RepoAs.IArtifactGet((IReadArtifactRepo)this.getRepo(artifact)).getArtifactLocator(this.session, artifact, monitor, locatorRef);
    }

    public void open() throws CacheManagerException {
        if (this.isOpen()) {
            throw new CacheManagerException(Messages.CacheManager_Cache_Is_Already_Open, this.description);
        }
        String path = this.repositoryPath;
        if (this.repositoryPath == null) {
            path = CacheManager.getDefaultCachePath();
        } else {
            IStatus status = CacheManager.isValidCacheLocation(this.repositoryPath);
            if (!status.isOK()) {
                throw new CacheManagerException(status.getMessage(), new Object[0]);
            }
        }
        this.location = new File(path);
        try {
            this.location = this.location.getCanonicalFile();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        log.debug("Open cache at {0}", new Object[]{this.location});
    }

    private static IStatus isValidCacheLocation(String cacheLocation) {
        if (cacheLocation.equals(CacheManager.getDefaultCachePath())) {
            return Status.OK_STATUS;
        }
        if (cacheLocation.length() == 0) {
            return new Status(4, AgentActivator.getPluginId(), -1, Messages.CacheManager_Cache_Location_Not_Specified, null);
        }
        IStatus status = PlatformUtils.validatePath((String)cacheLocation);
        if (!status.isOK()) {
            return new Status(4, AgentActivator.getPluginId(), -1, String.valueOf(Messages.CacheManager_Invalid_Cache_Location) + " " + status.getMessage(), null);
        }
        return Status.OK_STATUS;
    }

    private IRepository createRepo(File loc, String name) throws CacheManagerException {
        try {
            this.createDir(loc.getCanonicalFile());
        }
        catch (IOException e) {
            throw new CacheManagerException(e);
        }
        IRepositoryInfo repoInfo = this.group.createRepositoryInfo(name, "Dir", "0.0.0.1", (ICicLocation)new CicFileLocation(loc.getPath()), null);
        RepositoryDescriptor repoDescr = repoInfo.getRepositoryDescriptor();
        IRepository repository = null;
        try {
            repository = repoDescr.createInitializedExistingOrNewRepositoryObject(repoInfo, true);
            if (repository != null) {
                RepositorySiteProperties rsp = repository.getSiteProperties();
                String prop = rsp.getProperty(CACHE_MANAGER_REPOSITORY);
                if (prop.length() == 0) {
                    rsp.setProperty(CACHE_MANAGER_REPOSITORY, name);
                    rsp.save();
                } else if (!prop.equalsIgnoreCase(name)) {
                    repository = null;
                }
            }
        }
        catch (CoreException e) {
            throw new CacheManagerException(e);
        }
        catch (IOException e) {
            throw new CacheManagerException(e);
        }
        if (repository == null) {
            throw new CacheManagerException(Messages.CacheManager_Failed_To_Create_Cache, this.description, repoInfo.getLocation());
        }
        repoInfo.setProperty("SUPPRESS_ATOC_VALIDATION", (Object)Boolean.TRUE);
        return repository;
    }

    private void createDir(File dir) {
        if (!dir.exists()) {
            File parent = dir.getParentFile();
            if (parent != null) {
                this.createDir(parent);
            }
            dir.mkdir();
            this.createdDirs.add(dir);
        }
    }

    private File getRepoTrackExplodedDir() {
        File dir = this.getExtraDir();
        return new File(dir, "trackex");
    }

    private File getExtraDir() {
        IRevealFileLocations reveal = (IRevealFileLocations)this.repo.getAdapter(IRevealFileLocations.class);
        File dir = AgentUserOptions.CIC_AGENT_USE_EXTRA_TRACKEX.isSet() ? reveal.getExtraDir() : reveal.getTempDir();
        return dir;
    }

    private File getDeletionDir() {
        return this.getExtraSubdir("deleted");
    }

    private File getExtraSubdir(String subdir) {
        boolean wasOpen = this.isOpen();
        try {
            if (!wasOpen) {
                this.open();
            }
            this.checkOpen();
            IRevealFileLocations reveal = (IRevealFileLocations)this.repo.getAdapter(IRevealFileLocations.class);
            File file = new File(reveal.getExtraDir(), subdir);
            return file;
        }
        catch (CacheManagerException e) {
            log.error((Throwable)((Object)e));
            return null;
        }
        finally {
            if (!wasOpen) {
                this.close();
            }
        }
    }

    private void close() {
        if (!this.isOpen()) {
            return;
        }
        this.closeRepos();
        this.location = null;
        this.createdDirs = null;
    }

    private void openRepos() throws CacheManagerException {
        if (this.repo == null) {
            this.createdDirs = new ArrayList<File>();
            this.repo = this.createRepo(this.location, this.repositoryName);
            File trackLocation = this.getRepoTrackExplodedDir();
            this.repoTrackExploded = this.createRepo(trackLocation, String.valueOf(this.repositoryName) + "_trackExploded");
            this.upgradeSharedLocationIfNeeded();
        }
    }

    private void closeRepos() {
        try {
            if (this.repo != null) {
                if (this.isEmpty()) {
                    this.removeP2ArtifactsXml();
                    CheckConsistency.removeCheckingFiles(this);
                    this.repoTrackExploded.delete(false);
                    this.removeExtraDir();
                    this.repo.delete(false);
                    FileUtil.removeEmptyDirs((File)this.location, (boolean)true, (String[])new String[0]);
                    if (CicCommonSettings.isPortable()) {
                        if (!".ibmim/shared".equals(".ibmim/shared")) {
                            throw new AssertionError((Object)"The 'portable' shared location has changed. Make sure the code below still works.");
                        }
                        File ibmimDir = this.location.getParentFile();
                        ibmimDir.delete();
                        File installationDir = ibmimDir.getParentFile();
                        installationDir.delete();
                    }
                }
                this.group.removeRepository(this.repo);
                this.group.removeRepository(this.repoTrackExploded);
            }
            if (this.createdDirs != null) {
                for (File dir : Util.reverse(this.createdDirs)) {
                    dir.delete();
                }
            }
        }
        finally {
            this.repo = null;
            this.repoTrackExploded = null;
            this.closeArtifactSession();
        }
    }

    private void removeExtraDir() {
        File extraDir = this.getExtraDir();
        FileUtil.rm_r((File)extraDir, (boolean)true);
    }

    private void removeP2ArtifactsXml() {
        this.removeP2ArtifactsXml(new File(this.location, "plugins"));
        this.removeP2ArtifactsXml(this.location);
    }

    private void removeP2ArtifactsXml(File dir) {
        File artifactsXml = new File(dir, "artifacts.xml");
        if (artifactsXml.isFile()) {
            FileUtil.rm((File)artifactsXml);
        }
    }

    public void resetLocation(String newRepositoryPath) {
        if (this.isOpen()) {
            this.close();
            try {
                this.repositoryPath = newRepositoryPath;
                if (newRepositoryPath != null) {
                    this.open();
                }
            }
            catch (CacheManagerException e) {
                log.error((Throwable)((Object)e));
            }
        } else {
            this.repositoryPath = newRepositoryPath;
        }
    }

    private static boolean isAlreadyOpen(IRepositoryGroup group, IRepositoryInfo repoInfo) {
        IRepository repo = group.findRepository(repoInfo);
        return repo != null && repo.getStatus(true, null).isOK() && repo.isOpen();
    }

    public void beginCollection(AgentJob[] jobs, Agent.IAssignedArtifacts assignedArtifacts) throws CacheManagerException {
        assert (assignedArtifacts != null);
        this.checkOpen();
        this.closeArtifactSession();
        this.openArtifactSession();
        ProvideAlternativeRepositories arp = this.setupAlternativeRepositoryProvider(jobs);
        ArtifactsToDownload varAtd = (ArtifactsToDownload)assignedArtifacts;
        varAtd.startCollectFor(arp, jobs);
    }

    private ProvideAlternativeRepositories setupAlternativeRepositoryProvider(AgentJob[] jobs) {
        ProvideAlternativeRepositories pars = new ProvideAlternativeRepositories(this.getProvideAlternativeRepoHelper(), this.downloadOnDemand);
        if (jobs != null) {
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                CacheManager.setupAlternativeRepositoryProvider(pars, job);
                ++n2;
            }
        }
        if (!pars.isEnabled()) {
            log.debug("Not using repositories based on install registry");
            return null;
        }
        return pars;
    }

    private static void setupAlternativeRepositoryProvider(ProvideAlternativeRepositories pars, AgentJob job) {
        Profile profile = job.getProfile();
        AgentJob.AgentJobType jobType = job.getType();
        if (jobType.isInstall()) {
            pars.setEnabled(true);
        } else if (jobType.isUpdate()) {
            IOffering offering = CacheManager.getAndLogOfferingFromJob(job);
            if (offering != null && UpdateOfferingUtils.isUpdate((IContent)offering)) {
                Version ov = UpdateOfferingUtils.getBaseOfferingVersion((IOfferingOrFix)offering);
                VersionRange offeringTolerance = new VersionRange(new Version(ov.getMajor(), 0, 0), true, ov, true);
                pars.addInstalledOfferingRepositories(profile, offering, offeringTolerance);
            }
        } else if (jobType.isModify()) {
            IOffering offering = CacheManager.getAndLogOfferingFromJob(job);
            if (offering != null) {
                pars.addInstalledOfferingRepositories(profile, offering, null);
            }
        } else if (jobType.isUninstall() || jobType.isRollback()) {
            IFix fix = job.getFix();
            if (fix != null) {
                pars.addPrimaryInstalledFixRepositories(profile, fix);
            } else {
                IOffering offering = CacheManager.getAndLogOfferingFromJob(job);
                if (offering != null) {
                    Version ov = offering.getVersion();
                    VersionRange offeringTolerance = new VersionRange(new Version(ov.getMajor(), 0, 0), true, ov, true);
                    pars.addInstalledOfferingRepositories(profile, offering, offeringTolerance);
                }
            }
        }
    }

    private ProvideAlternativeRepositories.IHelper getProvideAlternativeRepoHelper() {
        return new ProvideAlternativeRepositories.IHelper(){

            @Override
            public IReopenRepositoryPrompter getReopenPrompter() {
                return CacheManager.this.getReopenRepositoryPrompter();
            }

            @Override
            public boolean isAlreadyOpen(IRepositoryGroup aGroup, IRepositoryInfo repoInfo) {
                return CacheManager.isAlreadyOpen(aGroup, repoInfo);
            }
        };
    }

    private static IOffering getAndLogOfferingFromJob(AgentJob job) {
        IOffering offering = job.getOffering();
        if (offering == null) {
            log.debug("Expected offering to be non null. ActiveAgentJob={0}", new Object[]{job});
        }
        return offering;
    }

    public IStatus collect(Agent.IAssignedArtifacts artifactsToDownload, IInstallableUnit iu, IProgressMonitor monitor) {
        return this.collect((ArtifactsToDownload)artifactsToDownload, iu, monitor);
    }

    private IStatus collect(ArtifactsToDownload artifactsToDownload, IInstallableUnit iu, IProgressMonitor monitor) {
        assert (artifactsToDownload != null);
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        Collection artifacts = iu.getAdapterData().getArtifacts();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, artifacts.size());
        for (IArtifact artifact : artifacts) {
            IStatus status = this.collect(artifactsToDownload, iu, artifact, pm.next());
            result.add(status);
            if (!result.matches(8)) continue;
            return result;
        }
        return result;
    }

    private IStatus collect(ArtifactsToDownload artifactsToDownload, IInstallableUnit iu, IArtifact artifact, IProgressMonitor monitor) {
        try {
            return artifactsToDownload.collect(this, iu, artifact, monitor);
        }
        catch (CacheManagerException e) {
            return e.getStatus();
        }
    }

    public ArtifactsToDownload downloadArtifacts(CicMultiStatus status, AgentJob[] jobs, Agent.IAssignedArtifacts assignedArtifacts, IProgressMonitor monitor) {
        try {
            this.checkOpen();
        }
        catch (CacheManagerException e) {
            status.add(e.getStatus());
            return null;
        }
        this.openArtifactSession();
        for (IRepository arepo : assignedArtifacts.getRepositories()) {
            CacheManager.logArtifacts("artifacts to download from repository " + arepo.getLocationStr(), assignedArtifacts.getAssignedArtifacts(arepo));
        }
        AddArtifactsProgress.AddArtifactsProgressHelper progressHelper = new AddArtifactsProgress.AddArtifactsProgressHelper(this.session);
        ValidationPolicy oldVP = this.session.getValidationPolicy();
        this.session.setValidationPolicy(ValidationPolicy.VP_WARN);
        try {
            IArtifactsToDownload toDownload = (IArtifactsToDownload)assignedArtifacts;
            ArtifactsToDownload artifactsToDownload = toDownload.download(status, jobs, this, monitor);
            return artifactsToDownload;
        }
        finally {
            progressHelper.restorePrevious();
            this.session.setValidationPolicy(oldVP);
        }
    }

    public void setDownloadedArtifacts(ArtifactsToDownload downloaded) {
        this.atd = downloaded;
    }

    public Agent.IPurgeableFiles getDownloadedArtifacts(ArtifactsToDownload artifactsToDownload, IProgressMonitor monitor) throws CacheManagerException {
        return artifactsToDownload.getDownloadedArtifacts(this, monitor);
    }

    public void forgetDownloadState() {
        List partialRequests = DownloadInProgressManager.INSTANCE.getPartialRequests();
        for (DownloadInProgressManager.IDownloadInProgress dip : partialRequests) {
            DownloadInProgressManager.INSTANCE.forgetPartialRequest(dip);
        }
        if (this.onDemand != null) {
            this.onDemand.getArtifactsToDownload().releaseNonAgentGroupInputRepos();
            this.onDemand = null;
        }
        if (this.atd != null) {
            this.atd.releaseAlternativeRepositoryProvidersInputRepos();
            this.atd = null;
        }
    }

    private File getExistingExplodedLocation(IArtifact artifact) throws CacheManagerException {
        if (!artifact.isExploded()) {
            return null;
        }
        File result = this.getExplodedLocation(artifact);
        return result.exists() ? result : null;
    }

    private File getExplodedLocation(IArtifact artifact) throws CacheManagerException {
        IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath((IArtifact)artifact);
        if (relPath == null) {
            String msg = NLS.bind((String)Messages.CacheManager_Failed_To_Determine_Path, (Object)artifact.toUserString());
            throw new CacheManagerException(msg, new Object[0]);
        }
        Path destPath = new Path(this.location.getPath());
        return Exploder.getLocation(destPath.append(relPath).toFile());
    }

    private boolean haveArtifactInSameExplodedState(IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
        return this.haveArtifactInRepo(this.getRepo(artifact), artifact, monitor);
    }

    private boolean haveArtifactInOppositeExplodedState(IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
        return this.haveArtifactInRepo(this.getOppositeRepo(artifact), artifact, monitor);
    }

    private boolean haveArtifactInRepo(IRepository repository, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        try {
            IArtifactTocRead tocRead = RepoAs.IArtifactTocRead((IReadArtifactRepo)repository);
            IReadArtifactRepo.IArtifactToc atoc = tocRead.getArtifactToc(this.session, false, pm.next());
            return atoc.getArtifactInfo((IDownloadSession)this.session, artifact.getKey(), pm.next()) != null;
        }
        catch (CoreException e) {
            throw new CacheManagerException(e);
        }
    }

    void setDownloadOnDemand(boolean downloadOnDemand) {
        this.downloadOnDemand = downloadOnDemand;
    }

    static boolean supportsDirectAccess(IInstallableUnit iu, IArtifact artifact) {
        IAdapterData ad = iu.getAdapterData();
        return ad.supportsDirectAccess(artifact) && !ad.isActiveArtifact(artifact);
    }

    public File getArtifactLocation(IInstallableUnit iu, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
        this.checkOpen();
        if (this.atd.useDirectArtifactAccess() && CacheManager.supportsDirectAccess(iu, artifact)) {
            Object fileOrSourceLoc = this.getArtifactDirect(iu, artifact, monitor);
            if (fileOrSourceLoc instanceof File) {
                File file = (File)fileOrSourceLoc;
                return file;
            }
            IArtifactLocator sourceLoc = (IArtifactLocator)fileOrSourceLoc;
            File file = sourceLoc.revealFile();
            return file;
        }
        return this.getArtifactLocationNoDirectAccess(iu, artifact, monitor);
    }

    private File getArtifactLocationNoDirectAccess(IInstallableUnit iu, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
        if (artifact.isExploded()) {
            File exploded = this.getExistingExplodedLocation(artifact);
            if (exploded == null) {
                File file = this.getLocationNoExplode(artifact, false);
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
                if (!file.exists()) {
                    file = this.getLocationNoExplode(iu, artifact, true, (IProgressMonitor)sm.newChild(1));
                }
                sm.setWorkRemaining(6);
                exploded = Exploder.explodeFile(file, this.repositoryPath, artifact, (IProgressMonitor)sm.newChild(5));
                if (!this.haveArtifactInOppositeExplodedState(artifact, (IProgressMonitor)sm.newChild(1))) {
                    file.delete();
                }
            }
            return exploded;
        }
        return this.getLocationNoExplode(iu, artifact, true, monitor);
    }

    public ContentInfoComputation.IValidatingInputStream getArtifactStream(IInstallableUnit iu, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
        this.checkOpen();
        if (this.atd.useDirectArtifactAccess() && CacheManager.supportsDirectAccess(iu, artifact)) {
            Object fileOrSourceLoc = this.getArtifactDirect(iu, artifact, monitor);
            if (fileOrSourceLoc instanceof File) {
                File file = (File)fileOrSourceLoc;
                return this.openValidatingInputStream(file, (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO);
            }
            IArtifactLocator sourceLoc = (IArtifactLocator)fileOrSourceLoc;
            File file = sourceLoc.revealFile();
            return this.openValidatingInputStream(file, sourceLoc.getContentInfo());
        }
        File file = this.getArtifactLocationNoDirectAccess(iu, artifact, monitor);
        return this.openValidatingInputStream(file, (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO);
    }

    private ContentInfoComputation.IValidatingInputStream openValidatingInputStream(File file, IContentInfo contentInfo) throws CacheManagerException {
        BufferedInputStream in;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new CacheManagerException(e);
        }
        return TransferUtils.validateInputStreamContentInfo((File)file, (InputStream)in, (IContentInfo)contentInfo);
    }

    private Object getArtifactDirect(IInstallableUnit iu, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
        IArtifactLocator[] locatorRef = new IArtifactLocator[1];
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IStatus status = this.getArtifactLocator(artifact, (IProgressMonitor)sm.newChild(1), locatorRef);
        if (StatusCodes.isContentFound((IStatus)status)) {
            sm.done();
            return this.getLocationNoExplode(artifact, true);
        }
        IArtifactLocator locator = this.atd.getDirectSourceFileLocator(artifact);
        if (locator != null) {
            sm.done();
            return locator;
        }
        if (!this.downloadOnDemand) {
            throw new CacheManagerException(Messages.CacheManager_failedToLocateInSharedLocationOrInputRepos, artifact.toUserString(), this.location);
        }
        if (this.onDemand != null && (locator = this.onDemand.getArtifactsToDownload().getDirectSourceFileLocator(artifact)) != null) {
            sm.done();
            return locator;
        }
        status = this.fetchOnDemand(iu, artifact, (IProgressMonitor)sm.newChild(1), locatorRef, null);
        if ((status = StatusCodes.recodeNotFoundToSeverity((IStatus)status, (int)4)).matches(12)) {
            throw new CacheManagerException(status);
        }
        locator = this.onDemand.getArtifactsToDownload().getDirectSourceFileLocator(artifact);
        if (locator == null) {
            throw new CacheManagerException(Messages.CacheManager_failedToLocateInSharedLocationOrInputRepos, artifact.toUserString(), this.location);
        }
        sm.done();
        return locator;
    }

    private File getLocationNoExplode(IInstallableUnit iu, IArtifact artifact, boolean checkExists, IProgressMonitor monitor) throws CacheManagerException {
        IArtifactLocator[] locatorRef = new IArtifactLocator[1];
        IStatus status = this.getArtifactLocator(artifact, monitor, locatorRef);
        if (StatusCodes.isContentNotFound((IStatus)status) && this.downloadOnDemand) {
            status = this.fetchOnDemand(iu, artifact, (IProgressMonitor)new NullProgressMonitor(), locatorRef, null);
        }
        if ((status = StatusCodes.recodeNotFoundToSeverity((IStatus)status, (int)4)).matches(12)) {
            throw new CacheManagerException(status);
        }
        return this.getLocationNoExplode(artifact, checkExists);
    }

    private IStatus fetchOnDemand(IInstallableUnit iu, IArtifact artifact, IProgressMonitor monitor, IArtifactLocator[] locatorRef, ArtifactsToDownload[] artifactToDownloadsRef) throws CacheManagerException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{3, 10});
        assert (this.downloadOnDemand);
        this.checkOpen();
        this.closeArtifactSession();
        this.openArtifactSession();
        if (this.onDemand == null) {
            this.onDemand = new OnDemandFetching(this.atd);
        }
        this.onDemand.begin();
        if (artifactToDownloadsRef != null) {
            artifactToDownloadsRef[0] = this.onDemand.getArtifactsToDownload();
        }
        try {
            this.collect(this.onDemand.getArtifactsToDownload(), iu, artifact, spm.next());
            this.downloadArtifacts(Statuses.ST.createMultiStatus(), null, this.onDemand.getArtifactsToDownload(), spm.next());
            if (iu.getAdapterData().isActiveArtifact(artifact)) {
                IStatus iStatus = this.getArtifactLocator(artifact, null, locatorRef);
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.onDemand.end();
            spm.done();
        }
    }

    private File getLocationNoExplode(IArtifact artifact, boolean checkExists) throws CacheManagerException {
        IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath((IArtifact)artifact);
        if (relPath == null) {
            throw new CacheManagerException(Messages.CacheManager_Failed_To_Determine_Path, artifact.toUserString());
        }
        Path destPath = new Path(this.location.getPath());
        destPath = destPath.append(relPath);
        File file = destPath.toFile();
        if (checkExists && !file.exists()) {
            throw new CacheManagerException(Messages.CacheManager_Failed_To_Get_Location, file.toString());
        }
        return file;
    }

    private IRepository getRepo(IArtifact artifact) {
        return artifact.isExploded() ? this.repoTrackExploded : this.repo;
    }

    private IRepository getOppositeRepo(IArtifact artifact) {
        return artifact.isExploded() ? this.repo : this.repoTrackExploded;
    }

    private void upgradeSharedLocationIfNeeded() throws CacheManagerException {
        Version effective;
        RepositorySiteProperties rsp = this.repo.getSiteProperties();
        String prop = rsp.getProperty(CACHE_MANAGER_VERSION);
        if (prop.length() == 0) {
            effective = CM_VERSION_0;
        } else {
            try {
                effective = new Version(prop);
            }
            catch (IllegalArgumentException e) {
                throw new CacheManagerException(Messages.CacheManager_bad_version_syntax, this.repo.getLocationStr(), CACHE_MANAGER_VERSION, prop);
            }
        }
        if (!CM_TOLERANCE.isIncluded(effective)) {
            throw new CacheManagerException(Messages.CacheManager_incompatible_version, this.repo.getLocation(), CACHE_MANAGER_VERSION, effective, CM_TOLERANCE);
        }
        if (effective.equals((Object)CM_VERSION_LATEST)) {
            return;
        }
        if (!effective.equals((Object)CM_VERSION_0)) {
            throw new CacheManagerException(Messages.CacheManager_dont_know_how_to_convert_from_version, this.repo.getLocationStr(), effective);
        }
        this.upgrade_fromVersion0to1();
        rsp.setProperty(CACHE_MANAGER_VERSION, CM_VERSION_LATEST.toString());
        rsp.save();
    }

    private Set<IArtifact> getArtifactsSet(Collection<IArtifact> artifacts, boolean wantExploded) {
        LinkedHashSet<IArtifact> result = new LinkedHashSet<IArtifact>(artifacts.size());
        for (IArtifact artifact : artifacts) {
            if (artifact.isExploded() != wantExploded) continue;
            result.add(artifact);
        }
        return result;
    }

    private void upgrade_fromVersion0to1() throws CacheManagerException {
        ArrayList<IArtifact> rootArtifacts = new ArrayList<IArtifact>();
        NullProgressMonitor npm = new NullProgressMonitor();
        plog.start(plog.debug("computing current root atoc artifacts"));
        try {
            this.getArtifacts(rootArtifacts, this.repo, (IProgressMonitor)npm);
        }
        catch (CoreException e) {
            throw new CacheManagerException(e);
        }
        plog.stop();
        ArrayList<IArtifact> trackexArtifacts = new ArrayList<IArtifact>();
        plog.start(plog.debug("computing current exploded artifacts"));
        try {
            this.getArtifacts(trackexArtifacts, this.repoTrackExploded, (IProgressMonitor)npm);
        }
        catch (CoreException e) {
            throw new CacheManagerException(e);
        }
        plog.stop();
        Set<IArtifact> rootExploded = this.getArtifactsSet(rootArtifacts, true);
        ArrayList<IArtifact> removeFromRoot = new ArrayList<IArtifact>(rootExploded.size());
        ArrayList<IArtifact> updateInRoot = new ArrayList<IArtifact>(rootExploded.size());
        for (IArtifact artifact : rootExploded) {
            File fileUnexploded = this.getLocationNoExplode(artifact, false);
            if (fileUnexploded.exists()) {
                updateInRoot.add((IArtifact)new OppositeExplodedArtifact(artifact));
                continue;
            }
            removeFromRoot.add(artifact);
        }
        this.openArtifactSession();
        try {
            IStatus status;
            IArtifactTocUpdate tocUpdate;
            IArtifact[] artifacts;
            if (!rootExploded.isEmpty()) {
                artifacts = CacheManager.toArtifactArray(rootExploded);
                tocUpdate = RepoAs.IArtifactTocUpdate((IReadArtifactRepo)this.repoTrackExploded);
                status = tocUpdate.updateArtifactTocAddOrChange(this.session, artifacts, (IProgressMonitor)new NullProgressMonitor());
                if (!status.isOK()) {
                    throw new CacheManagerException(status);
                }
            }
            if (!updateInRoot.isEmpty()) {
                artifacts = CacheManager.toArtifactArray(updateInRoot);
                tocUpdate = RepoAs.IArtifactTocUpdate((IReadArtifactRepo)this.repo);
                status = tocUpdate.updateArtifactTocAddOrChange(this.session, artifacts, (IProgressMonitor)new NullProgressMonitor());
                if (!status.isOK()) {
                    throw new CacheManagerException(status);
                }
            }
            if (!removeFromRoot.isEmpty()) {
                artifacts = CacheManager.toArtifactArray(removeFromRoot);
                tocUpdate = RepoAs.IArtifactTocUpdate((IReadArtifactRepo)this.repo);
                status = tocUpdate.updateArtifactTocAddOrChange(this.session, artifacts, (IProgressMonitor)new NullProgressMonitor());
                if (!status.isOK()) {
                    throw new CacheManagerException(status);
                }
            }
        }
        finally {
            this.closeArtifactSession();
        }
    }

    public boolean keepFetchedFiles() {
        return CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.KEEP_FETCHED_FILES.key());
    }

    protected boolean preserveDownloadedArtifacts() {
        return CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.PRESERVE_DOWNLOADED_ARTIFACTS.key());
    }

    public boolean keepDownloadedArtifacts(IStatus status, int downloadedCount, long downloadedSize, boolean defaultResponse) {
        return UserFeedback.keepDownloadedArtifacts(status, downloadedCount, downloadedSize, defaultResponse);
    }

    public IStatus cleanup(IProgressMonitor monitor) {
        if (!CicCommonSettings.isPortable() && this.preserveDownloadedArtifacts()) {
            return new Cleanup().cleanup(false, monitor);
        }
        return this.purge(monitor);
    }

    Agent.IPurgeableFiles determinePurgeableFiles(IProgressMonitor monitor) throws CoreException {
        return new Cleanup().determineCleanup(true, monitor);
    }

    public IStatus purge(IProgressMonitor monitor) {
        return new Cleanup().cleanup(true, monitor);
    }

    private boolean containsArtifacts(IRepository repository) {
        try {
            IReadArtifactRepo.IArtifactToc atoc = repository.readArtifactToc(this.session, (IProgressMonitor)new NullProgressMonitor());
            return atoc != null && atoc.getSummary().getCount() > 0;
        }
        catch (CoreException e) {
            return true;
        }
    }

    public List<IArtifact> getArtifacts(IProgressMonitor monitor) throws CoreException {
        this.checkOpen();
        ArrayList<IArtifact> result = new ArrayList<IArtifact>();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        plog.start(plog.debug("computing current unexploded artifacts"));
        this.getArtifacts(result, this.repo, pm.next());
        plog.stop();
        plog.start(plog.debug("computing current exploded artifacts"));
        this.getArtifacts(result, this.repoTrackExploded, pm.next());
        plog.stop();
        return result;
    }

    public boolean hasArtifact(IArtifact artifact, IProgressMonitor monitor) throws CoreException {
        this.checkOpen();
        return this.haveArtifactInSameExplodedState(artifact, monitor);
    }

    private void getArtifacts(ArrayList<IArtifact> result, IRepository repository, IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        IReadArtifactRepo.IArtifactToc atoc = repository.readArtifactToc(this.session, pm.next());
        if (atoc == null) {
            plog.debug("no artifacts found");
            return;
        }
        result.ensureCapacity(result.size() + atoc.getSummary().getCount());
        List categories = atoc.getContainedCategories();
        SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), categories.size());
        for (IReadArtifactRepo.ICategory category : categories) {
            this.getArtifacts(result, atoc, category, pm2.next());
        }
        pm.done();
        plog.debug("{0} artifacts found", new Object[]{result.size()});
    }

    private void getArtifacts(List<IArtifact> list, IReadArtifactRepo.IArtifactToc atoc, IReadArtifactRepo.ICategory category, IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 10});
        List contents = atoc.getContents((IDownloadSession)this.session, category, pm.next());
        SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), contents.size());
        for (Object content : contents) {
            if (content instanceof IReadArtifactRepo.ICategory) {
                this.getArtifacts(list, atoc, (IReadArtifactRepo.ICategory)content, pm2.next());
                continue;
            }
            if (content instanceof IArtifact) {
                list.add((IArtifact)content);
                continue;
            }
            assert (false) : "Unexpected type: " + content;
        }
        pm.done();
    }

    private boolean isEmpty() {
        return !this.repo.containsMetadata() && !this.containsArtifacts(this.repo) && !this.containsArtifacts(this.repoTrackExploded);
    }

    private void openArtifactSession() {
        if (this.session == null) {
            this.session = IArtifactSessionFactory.INSTANCE.createArtifactSession();
        }
    }

    private void closeArtifactSession() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    private static IArtifact[] toArtifactArray(Collection<IArtifact> c) {
        return c.toArray(new IArtifact[c.size()]);
    }

    private List<IArtifact> doRemoveExplodedArtifacts(List<IArtifact> artifacts, IProgressMonitor monitor) {
        ArrayList<IArtifact> result = new ArrayList<IArtifact>(artifacts.size());
        DirectoryDeleter deleter = new DirectoryDeleter(this.getDeletionDir());
        plog.start(plog.debug("deleting {0} exploded artifacts", new Object[]{artifacts.size()}));
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, artifacts.size() + 1);
        IArtifact[] artifactArray = new IArtifact[1];
        Iterator<IArtifact> i = artifacts.iterator();
        while (i.hasNext() && !monitor.isCanceled()) {
            IArtifact artifact = i.next();
            String msgDelete = NLS.bind((String)Messages.CacheManager_Deleting, (Object)artifact.toUserString());
            SplitProgressMonitor pmDelete = new SplitProgressMonitor((IProgressMonitor)new OmitSubTaskProgressMonitor(pm.next()), msgDelete, 3);
            try {
                try {
                    IArtifactLocator[] locatorRef = new IArtifactLocator[1];
                    OppositeExplodedArtifact unexplodedOpposite = new OppositeExplodedArtifact(artifact);
                    this.getArtifactLocator((IArtifact)unexplodedOpposite, pmDelete.next(), locatorRef);
                    if (locatorRef[0] == null) {
                        boolean checkExists = false;
                        File file = this.getLocationNoExplode(artifact, checkExists);
                        FileUtil.rm((File)file);
                    }
                    File exploded = this.getExplodedLocation(artifact);
                    deleter.delete(exploded, pmDelete.next());
                    if (exploded.exists()) {
                        log.warning(Messages.CacheManager_Failed_To_DeleteWarning, new Object[]{exploded});
                    } else {
                        artifactArray[0] = artifact;
                        IStatus status = RepoAs.IArtifactTocUpdate((IReadArtifactRepo)this.repoTrackExploded).updateArtifactTocRemove(this.session, artifactArray, pmDelete.next());
                        log.statusNotOK(status);
                        if (status.isOK()) {
                            i.remove();
                            result.add(artifact);
                        }
                    }
                }
                catch (CacheManagerException e) {
                    log.error((Throwable)((Object)e));
                    pmDelete.done();
                    continue;
                }
            }
            catch (Throwable throwable) {
                pmDelete.done();
                throw throwable;
            }
            pmDelete.done();
        }
        deleter.cleanup(pm.next());
        pm.done();
        plog.stop();
        return result;
    }

    private List<IArtifact> doRemoveArtifacts(List<IArtifact> artifacts, IProgressMonitor monitor) {
        plog.start(plog.debug("deleting {0} unexploded artifacts", new Object[]{artifacts.size()}));
        ArrayList<IArtifact> result = new ArrayList<IArtifact>(artifacts.size());
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 10});
        SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), artifacts.size());
        IMultiArtifactOperationArguments args = RemoveArtifacts.INSTANCE.createArguments();
        HashMap<IArtifactOperation.IArtifactOperationRecord, Integer> record2Index = new HashMap<IArtifactOperation.IArtifactOperationRecord, Integer>(artifacts.size());
        int index = 0;
        for (IArtifact artifact : artifacts) {
            IArtifactLocator[] locatorRef = new IArtifactLocator[1];
            IStatus status = this.getArtifactLocator(artifact, pm2.next(), locatorRef);
            log.statusNotOK(status);
            if (locatorRef[0] != null) {
                IArtifactOperation.IArtifactOperationRecord record = args.addInput(RemoveArtifacts.createRemoveRequest((IArtifactLocator)locatorRef[0]));
                record2Index.put(record, index);
            }
            ++index;
            if (monitor.isCanceled()) break;
        }
        if (!monitor.isCanceled()) {
            RemoveArtifacts.INSTANCE.execute(this.session, RemoveArtifacts.createOperationTarget((IReadArtifactRepo)this.repo), MultiArtifactOperationOptions.newContinueOnErrorOptions(), args, pm.next());
        }
        for (IArtifactOperation.IArtifactOperationRecord record : Util.reverse((List)args.getRecords())) {
            if (RemoveArtifacts.INSTANCE.isSuccessRecord(record)) {
                Integer index2 = (Integer)record2Index.get(record);
                if (index2 != null) {
                    IArtifact artifact = artifacts.get(index2);
                    result.add(artifact);
                    artifacts.remove(index2);
                }
            } else {
                IStatus status = record.getTotalStatus();
                log.statusNotOK(status);
            }
            if (monitor.isCanceled()) break;
        }
        pm.done();
        plog.stop();
        return result;
    }

    private void checkOpen() throws CacheManagerException {
        if (!this.isOpen()) {
            throw new CacheManagerException(Messages.CacheManager_Cache_Is_Not_Open, this.description);
        }
        this.openRepos();
    }

    private static void logArtifacts(String msg, Collection<IArtifact> artifacts) {
        if (!log.isDebugLoggable()) {
            return;
        }
        if (artifacts == null || artifacts.size() == 0) {
            log.debug("No {0}", new Object[]{msg});
        } else {
            StringBuilder sb = new StringBuilder(30 * (artifacts.size() + 1));
            sb.append(artifacts.size()).append(' ').append(msg);
            for (IArtifact artifact : artifacts) {
                IPath path = ArtifactToPathUtil.getArtifactPath((IArtifactKey)artifact.getKey());
                sb.append('\n').append(path).append(" (").append(artifact).append(')');
            }
            log.debug(sb.toString());
        }
    }

    private Set<IInstallableUnit> getNeededIUs(IProgressMonitor monitor) {
        plog.start(plog.debug("computing needed IUs"));
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        Collection<IInstallableUnit> installedIUs = this.getAllInstalledIUs(pm.next());
        HashSet<IInstallableUnit> neededIUs = new HashSet<IInstallableUnit>(2 * installedIUs.size());
        neededIUs.addAll(installedIUs);
        InstallRegistry.ProfileInstallRegistry[] registries = this.getProfileInstallRegistries();
        SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), registries.length);
        InstallRegistry.ProfileInstallRegistry[] profileInstallRegistryArray = registries;
        int n = registries.length;
        int n2 = 0;
        while (n2 < n) {
            InstallRegistry.ProfileInstallRegistry registry = profileInstallRegistryArray[n2];
            this.addNeededIUs(neededIUs, registry, pm2.next());
            ++n2;
        }
        plog.debug("{0} needed ius", new Object[]{neededIUs.size()});
        plog.stop();
        return neededIUs;
    }

    private void addNeededIUs(Set<IInstallableUnit> needed, InstallRegistry.ProfileInstallRegistry registry, IProgressMonitor monitor) {
        IOffering[] offerings = registry.getInstalledOfferings();
        ProfileSelectorExpander expander = new ProfileSelectorExpander(registry.getProfile());
        expander.setAllowMultipleVersions(true);
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering[] versions;
            IOffering offering = iOfferingArray[n2];
            IOffering[] iOfferingArray2 = versions = registry.getInstalledOfferings(offering.getIdentity());
            int n3 = versions.length;
            int n4 = 0;
            while (n4 < n3) {
                IFix[] fixes;
                IOffering version = iOfferingArray2[n4];
                expander.addOffering(version, registry.getInstalledFeatures(version));
                IFix[] iFixArray = fixes = registry.getInstalledFixes(version);
                int n5 = fixes.length;
                int n6 = 0;
                while (n6 < n5) {
                    IFix fix = iFixArray[n6];
                    expander.addFix(fix);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        expander.expand(monitor);
        needed.addAll(ExpanderUtils.getAllIUs((SelectorExpander)expander));
    }

    private Collection<IInstallableUnit> getAllInstalledIUs(IProgressMonitor monitor) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(256);
        InstallRegistry.ProfileInstallRegistry[] registries = this.getProfileInstallRegistries();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, registries.length);
        InstallRegistry.ProfileInstallRegistry[] profileInstallRegistryArray = registries;
        int n = registries.length;
        int n2 = 0;
        while (n2 < n) {
            InstallRegistry.ProfileInstallRegistry registry = profileInstallRegistryArray[n2];
            try {
                result.addAll(registry.getAllInstalledIUs(pm.next()));
            }
            catch (IllegalStateException e) {
                log.error("Internal error in install registry: {0}", new Object[]{e.getMessage()});
                log.error((Throwable)e);
            }
            ++n2;
        }
        return result;
    }

    private static Agent.IPurgeableFiles getAllIncompleteDownloads(CacheManager cm) {
        ArrayList<File> files = new ArrayList<File>();
        DownloadInProgressManager.getAllPartialFiles((File)AddArtifacts.getUniqueTempDir((IReadArtifactRepo)cm.repo), files);
        return new PurgeableFile(files);
    }

    static File getIncompleteDownloadsDir(File cacheLocation) {
        String oldUniqueifier = TempUtil.getUniqueifier();
        try {
            TempUtil.setUniqueifier((String)"");
            File file = AddArtifacts.getUniqueTempDir((File)cacheLocation);
            return file;
        }
        finally {
            TempUtil.setUniqueifier((String)oldUniqueifier);
        }
    }

    @Deprecated
    public static List<File> getAllIncompleteDownloads(File cacheLocation) {
        ArrayList<File> files = new ArrayList<File>();
        File incompleteDownloadDir = CacheManager.getIncompleteDownloadsDir(cacheLocation);
        DownloadInProgressManager.getAllPartialFiles((File)incompleteDownloadDir, files);
        return files;
    }

    private static Agent.IPurgeableFiles getIncompleteDownloads() {
        List dips = DownloadInProgressManager.INSTANCE.getPartialRequests();
        return new PurgeableDownloadsInProgress(dips);
    }

    private static class ArtifactArgumentFactory
    implements AssignArtifacts.IArgumentFactory {
        private ArtifactArgumentFactory() {
        }

        public IMultiArtifactOperationArguments createArguments() {
            return AddArtifactsByDisk.INSTANCE.createArguments();
        }

        public IArtifactOperation.IArtifactOperationInput createInput(IArtifact artifact, IRepository sourceRepo, IContentLocator locator) {
            return AddArtifactsByDisk.createGetRequest((IArtifact)artifact, (IContentLocator)locator);
        }

        public IArtifact getArtifact(IArtifactOperation.IArtifactOperationInput input) {
            if (input instanceof AddArtifacts.AddInput) {
                AddArtifacts.AddInput addInput = (AddArtifacts.AddInput)input;
                return addInput.getArtifact();
            }
            return null;
        }
    }

    public static class ArtifactsToDownload
    implements IArtifactsToDownload {
        private final boolean useDirectArtifactAccess = CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.DIRECT_ARTIFACT_ACCESS_MODE.key());
        private final List<CollectInfo> collectInfos = new ArrayList<CollectInfo>();
        private final AssignArtifacts assigned;
        private final Map<IArtifactKey, DirectAccessInfo> directAccess;
        private final Map<IArtifact, IArtifactOperation.IArtifactOperationRecord> haveOppositeDownload;
        private final Map<IArtifact, IArtifactLocator> haveOppositeInCacheStillUnexploded;
        private final Map<IArtifact, IArtifactLocator> haveOppositeInCacheNeedDownload;
        private final ReferenceContexts referenceContexts;
        private int unexplodedCount;
        private int explodedCount;
        private ArtifactsToDownload priorDownloads = null;

        public ArtifactsToDownload() {
            ArtifactArgumentFactory argFactory = new ArtifactArgumentFactory();
            this.assigned = new AssignArtifacts(new AssignArtifacts.ILazySourceRepositoriesFactory(){

                public IAlternativeRepositories getAlternativeRepositories() {
                    return ((ArtifactsToDownload)this).getCurrentCollectInfo().alternativeRepositories;
                }

                public IRepositoryGroup createSourceRepositoriesGroup(IProgressMonitor monitor) {
                    return Agent.getInstance().getRepositoryGroup();
                }

                public AssignArtifacts.DiskSetPriority determineDiskSetsPriority(IVolumeAccessByDisk diskRepo, IArtifactSession session, IVolumeAccessByDisk.IDiskSet[] allDiskSets, IProgressMonitor monitor) throws CoreException, IOException {
                    VisibleDiskSetsUtil diskSetUtil = ((ArtifactsToDownload)this).getCurrentCollectInfo().diskSetUtil;
                    if (diskSetUtil == null) {
                        return null;
                    }
                    return diskSetUtil.determineDiskSetsPriority(diskRepo, session, allDiskSets, monitor);
                }

                public IStatus validateRepository(IRepository repo, IProgressMonitor monitor) {
                    return Agent.getInstance().validateAgentGroupRepo(repo, monitor);
                }
            }, (AssignArtifacts.IArgumentFactory)argFactory);
            this.directAccess = new LinkedHashMap<IArtifactKey, DirectAccessInfo>();
            this.haveOppositeDownload = new LinkedHashMap<IArtifact, IArtifactOperation.IArtifactOperationRecord>();
            this.haveOppositeInCacheStillUnexploded = new LinkedHashMap<IArtifact, IArtifactLocator>();
            this.haveOppositeInCacheNeedDownload = new LinkedHashMap<IArtifact, IArtifactLocator>();
            this.referenceContexts = new ReferenceContexts();
            this.unexplodedCount = 0;
            this.explodedCount = 0;
        }

        ArtifactsToDownload(IAlternativeRepositories alternativeRepositories, AgentJob[] jobs) {
            this();
            this.startCollectFor(alternativeRepositories, jobs);
        }

        public ArtifactsToDownload(ArtifactsToDownload priorDownloads) {
            this();
            this.priorDownloads = priorDownloads;
        }

        boolean useDirectArtifactAccess() {
            return this.useDirectArtifactAccess;
        }

        void startCollectFor(IAlternativeRepositories alternativeRepositories, AgentJob[] jobs) {
            Profile profile = null;
            VisibleDiskSetsUtil diskSetUtil = null;
            if (jobs != null) {
                diskSetUtil = new VisibleDiskSetsUtil(jobs);
                LinkedHashMap<String, Profile> profiles = new LinkedHashMap<String, Profile>(1);
                AgentJob[] agentJobArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentJob agentJob = agentJobArray[n2];
                    if (agentJob != null) {
                        Profile p = agentJob.getProfile();
                        profiles.put(p.getProfileId(), p);
                    }
                    ++n2;
                }
                assert (profiles.size() <= 1);
                if (profiles.size() == 1) {
                    profile = (Profile)profiles.values().iterator().next();
                }
            }
            this.collectInfos.add(0, new CollectInfo(profile, alternativeRepositories, diskSetUtil));
        }

        private IArtifactLocator getDirectSourceFileLocator(IArtifact artifact) throws CacheManagerException {
            DirectAccessInfo dai = this.directAccess.get(artifact.getKey());
            if (dai != null) {
                IArtifactOperation.IArtifactOperationRecord record = dai.record;
                assert (record != null);
                AddArtifacts.AddInput input = AddArtifacts.getAddInput((IArtifactOperation.IArtifactOperationRecord)record);
                assert (input != null);
                IArtifactLocator sourceLocator = (IArtifactLocator)input.getLocator();
                if (sourceLocator == null) {
                    throw new CacheManagerException("Failed to access previously determined {0} from {1}.", artifact.toUserString(), dai.repo.getLocation());
                }
                File file = sourceLocator.revealFile();
                if (file == null) {
                    throw new CacheManagerException("Failed to access {0} from {1}. ", artifact.toUserString(), dai.repo.getLocation());
                }
                if (!file.exists()) {
                    IRepository fromRepo = dai.repo;
                    throw new CacheManagerException(Messages.CacheManager_fileFoundInAtocDoesNotExist, file, fromRepo != null ? fromRepo.getLocation() : "");
                }
                return sourceLocator;
            }
            return null;
        }

        public String toString() {
            return "ArtifactsToDownload: " + this.assigned.getArtifacts().size();
        }

        private CollectInfo getCurrentCollectInfo() {
            return this.collectInfos.get(0);
        }

        @Override
        public boolean hasArtifactsForProfile(Profile profile) {
            assert (profile != null);
            for (CollectInfo ci : this.collectInfos) {
                if (ci.profile == null || !profile.getProfileId().equals(ci.profile.getProfileId())) continue;
                return true;
            }
            return false;
        }

        void releaseNonAgentGroupInputRepos() {
            this.releaseAlternativeRepositoryProvidersInputRepos();
        }

        private void releaseAlternativeRepositoryProvidersInputRepos() {
            for (CollectInfo collectInfo : this.collectInfos) {
                if (collectInfo.alternativeRepositories == null) continue;
                collectInfo.alternativeRepositories.done();
            }
            this.collectInfos.clear();
        }

        IAlternativeRepositories getAlternativeRepos() {
            return this.assigned.getAlternativeRepos();
        }

        private boolean alreadyProcessedSameExplodedness(IArtifact artifact) {
            if (this.assigned.contains(artifact) || this.haveOppositeDownload.containsKey(artifact) || this.haveOppositeInCacheStillUnexploded.containsKey(artifact)) {
                return true;
            }
            if (this.priorDownloads != null) {
                return this.priorDownloads.alreadyProcessedSameExplodedness(artifact);
            }
            return false;
        }

        private IStatus assignArtifact(CacheManager cm, IInstallableUnit iu, IArtifact artifact, IProgressMonitor monitor) {
            return this.assigned.assignArtifact(cm.session, null, (Object)iu, artifact, monitor);
        }

        @Override
        public Collection<IRepository> getRepositories() {
            return this.assigned.getAssignedRepos();
        }

        @Override
        public Collection<IArtifact> getAssignedArtifacts(IRepository arepo) {
            return this.assigned.getAssignedArtifacts(arepo);
        }

        public Collection<IArtifact> getArtifacts() {
            return this.assigned.getArtifacts();
        }

        IArtifactOperation.IArtifactOperationRecord getAssignedRecord(IArtifact artifact) {
            return this.assigned.getAssignedRecord(artifact);
        }

        public ArtifactOfInstallableUnit findMetadataArtifactReference(IArtifact artifact) {
            for (ArtifactOfInstallableUnit aiu : this.getReferences(artifact)) {
                if (!aiu.getArtifact().equals(artifact)) continue;
                return aiu;
            }
            return null;
        }

        private void updateCount(IArtifact artifact) {
            if (artifact.isExploded()) {
                ++this.explodedCount;
            } else {
                ++this.unexplodedCount;
            }
        }

        IStatus collect(CacheManager cm, IInstallableUnit iu, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            try {
                this.rememberReferences(iu, artifact);
                if (this.alreadyProcessedSameExplodedness(artifact)) {
                    log.debug("Artifact already collected: {0}", new Object[]{artifact});
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                OppositeExplodedArtifact oppositeExploded = new OppositeExplodedArtifact(artifact);
                IArtifactOperation.IArtifactOperationRecord record = this.assigned.getAssignedRecord((IArtifact)oppositeExploded);
                if (record != null) {
                    this.haveOppositeDownload.put(artifact, record);
                    log.debug("Artifact download of opposite requested: {0}", new Object[]{artifact});
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                if (cm.haveArtifactInSameExplodedState(artifact, (IProgressMonitor)sm.newChild(1))) {
                    log.debug("Artifact is already in cache: {0}", new Object[]{artifact});
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                IArtifactLocator[] locatorRef = new IArtifactLocator[1];
                IStatus status = cm.getArtifactLocator((IArtifact)oppositeExploded, (IProgressMonitor)sm.newChild(1), locatorRef);
                if (status.matches(12)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                if (locatorRef[0] != null) {
                    if (artifact.isExploded()) {
                        log.debug("Unexploded artifact is already in cache, no need to download bits for exploded artifact again: {0}", new Object[]{artifact});
                        this.haveOppositeInCacheStillUnexploded.put(artifact, locatorRef[0]);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    boolean checkExists = false;
                    File file = cm.getLocationNoExplode((IArtifact)oppositeExploded, checkExists);
                    if (file.exists()) {
                        log.debug("Exploded artifact does exist in unpacked form, no need to download bits for unexploded artifact again: {0}", new Object[]{artifact});
                        this.haveOppositeInCacheStillUnexploded.put(artifact, locatorRef[0]);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    log.debug("Exploded artifact does exist but already unpacked, need to download bits for unexploded artifact again: {0}", new Object[]{artifact});
                    this.haveOppositeInCacheNeedDownload.put(artifact, locatorRef[0]);
                }
                if ((status = this.assignArtifact(cm, iu, artifact, (IProgressMonitor)sm.newChild(1))).isOK()) {
                    this.updateCount(artifact);
                }
                IStatus iStatus = status;
                return iStatus;
            }
            finally {
                sm.done();
            }
        }

        private void rememberReferences(IInstallableUnit iu, IArtifact artifact) {
            this.referenceContexts.rememberReference(new MapListUtil.ICollectionFactory(){

                public Collection createCollection() {
                    return new LinkedHashSet();
                }
            }, (Object)new ArtifactOfInstallableUnit(iu, artifact), (Object)artifact.getKey());
        }

        private Collection<ArtifactOfInstallableUnit> getReferences(IArtifact artifact) {
            return this.referenceContexts.getReferences((Object)artifact.getKey());
        }

        private static boolean isSuccessRecord(IArtifactOperation.IArtifactOperationRecord record) {
            return AddArtifacts.INSTANCE.isSuccessRecord(record);
        }

        private List<IArtifactOperation.IArtifactOperationRecord> getAssignedRecords(boolean exploded, int capacity) {
            ArrayList<IArtifactOperation.IArtifactOperationRecord> list = new ArrayList<IArtifactOperation.IArtifactOperationRecord>(capacity);
            for (Object element : this.assigned.getAssignedRepos()) {
                IRepository sourceRepo = (IRepository)element;
                IMultiArtifactOperationArguments arguments = this.assigned.getArguments(sourceRepo);
                for (Object element2 : arguments.getRecords()) {
                    IArtifact artifact;
                    IArtifactOperation.IArtifactOperationRecord record = (IArtifactOperation.IArtifactOperationRecord)element2;
                    if (!ArtifactsToDownload.isSuccessRecord(record) || (artifact = AddArtifacts.getAddInputArtifact((IArtifactOperation.IArtifactOperationRecord)record)) == null || exploded != artifact.isExploded()) continue;
                    list.add(record);
                }
            }
            return list;
        }

        @Override
        public void validate(CicMultiStatus ms, IArtifactSession session, IProgressMonitor monitor) {
            if (this.useDirectArtifactAccess()) {
                HashSet<IRepositoryIdentity> validated = new HashSet<IRepositoryIdentity>();
                Collection ar = this.assigned.getAssignedRepos();
                SplitProgressMonitor spm = new SplitProgressMonitor(monitor, ar.size());
                for (IRepository arepo : ar) {
                    this.validateDirectArtifactUsage(ms, session, arepo, validated, spm.next());
                }
            }
        }

        private void validateDirectArtifactUsage(CicMultiStatus ms, IArtifactSession session, IRepository repo, Set<IRepositoryIdentity> validated, IProgressMonitor monitor) {
            CompositeRepository composite;
            IRepositoryIdentity repoId = (IRepositoryIdentity)repo.getAdapter(IRepositoryIdentity.class);
            if (!validated.add(repoId)) {
                return;
            }
            ICicLocation location = repo.getLocation();
            if (!FileURLUtil.isFileLocation((String)location.toString())) {
                ICicStatus status = Statuses.ERROR.get(Messages.CacheManager_directAccessSupportedForFileSystemOnly, new Object[]{location});
                ms.add((IStatus)status);
                return;
            }
            IVolumeAccessByDisk byDisk = RepoAs.IVolumeAccessByDisk((IReadArtifactRepo)repo);
            if (byDisk != null) {
                this.validateDirectAccessUsageAllDisksAreAvailable(ms, session, byDisk, monitor);
            }
            if ((composite = (CompositeRepository)repo.getAdapter(CompositeRepository.class)) != null) {
                this.validateComposite(ms, session, composite, validated, monitor);
            }
        }

        private void validateComposite(CicMultiStatus ms, IArtifactSession session, CompositeRepository composite, Set<IRepositoryIdentity> validated, IProgressMonitor monitor) {
            IRepositoryGroup group = composite.getGroup();
            Collection repos = group.getRepositories();
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, repos.size());
            CicMultiStatus ms1 = Statuses.ST.createMultiStatus(0, Messages.CacheManager_provideRepositoryContext, new Object[]{composite.getLocation()});
            for (IRepository repo : repos) {
                this.validateDirectArtifactUsage(ms1, session, repo, validated, spm.next());
            }
            if (!ms1.isOK()) {
                ms.add((IStatus)ms1);
            }
        }

        private void validateDirectAccessUsageAllDisksAreAvailable(CicMultiStatus ms, IArtifactSession session, IVolumeAccessByDisk diskRepo, IProgressMonitor monitor) {
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
            IRepository repo = diskRepo.getRepository();
            Collection<IArtifact> artifacts = this.getAssignedArtifacts(diskRepo.getRepository());
            ArtifactsOnDisksInfo aod = DetermineDisksNeeded.execute((IArtifactSession)session, (IVolumeAccessByDisk)diskRepo, artifacts, (IProgressMonitor)spm.next());
            Set neededDiskSets = aod.getUsedDiskSets();
            SplitProgressMonitor spm2 = new SplitProgressMonitor(spm.next(), neededDiskSets.size());
            for (IVolumeAccessByDisk.IDiskSet diskSet : neededDiskSets) {
                CicMultiStatus ms1;
                if (diskSet.equals(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET)) continue;
                IVolumeAccessByDisk.IDiskSetDisks neededDisks = aod.getDiskSetDisksUsed(diskSet);
                try {
                    IVolumeAccessByDisk.IDiskSetDisks unavailable = DiskUtil.getUnavailableNeededDisks((IArtifactSession)session, (IVolumeAccessByDisk)diskRepo, (IVolumeAccessByDisk.IDiskSetDisks)neededDisks, (IProgressMonitor)spm2.next());
                    if (unavailable.getDisks().size() <= 0) continue;
                    ms1 = Statuses.ERROR.getMultiStatus(Messages.CacheManager_directAccessToDiskSetNotSupported, new Object[]{DiskUtil.getDiskSetLabelOrId((IVolumeAccessByDisk.IDiskSet)diskSet), repo.getLocationStr()});
                    ms1.add((IStatus)Statuses.ERROR.get(Messages.CacheManager_neededDisksNotFound, new Object[]{DiskUtil.formatDiskNumbers((IVolumeAccessByDisk.IDiskSetDisks)unavailable)}));
                    ms.add((IStatus)ms1);
                }
                catch (CoreException e) {
                    ms1 = Statuses.ST.createMultiStatus(Messages.CacheManager_failedToDetermineWhetherDirectAccessToDisksIsSupported, new Object[]{DiskUtil.getDiskSetLabelOrId((IVolumeAccessByDisk.IDiskSet)diskSet), repo.getLocationStr()});
                    ms1.add((IStatus)Statuses.ERROR.get(Messages.CacheManager_problemFindingNeededDisks, new Object[0]));
                    ms1.add(e.getStatus());
                    ms.add((IStatus)ms1);
                }
                catch (IOException e) {
                    ms1 = Statuses.ST.createMultiStatus(Messages.CacheManager_failedToDetermineWhetherDirectAccessToDisksIsSupported, new Object[]{DiskUtil.getDiskSetLabelOrId((IVolumeAccessByDisk.IDiskSet)diskSet), repo.getLocationStr()});
                    ms1.add((IStatus)Statuses.ERROR.get((Throwable)e, Messages.CacheManager_problemFindingNeededDisks, new Object[0]));
                    ms.add((IStatus)ms1);
                }
            }
        }

        @Override
        public ArtifactsToDownload download(CicMultiStatus ms, AgentJob[] ajobs, final CacheManager cm, IProgressMonitor monitor) {
            int numArtifacts = this.assigned.getArtifacts().size();
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 + numArtifacts + 1 + 1));
            this.validate(ms, cm.session, (IProgressMonitor)sm.newChild(1));
            if (ms.matches(12)) {
                return this;
            }
            if (this.useDirectArtifactAccess()) {
                this.prepareDirectAccessRecords(ms, cm.session, (IProgressMonitor)sm.newChild(1));
                if (ms.matches(4)) {
                    return this;
                }
            }
            sm.setWorkRemaining(numArtifacts + 1 + 1);
            boolean continueOnError = false;
            IArtifactOperationMultiple instance = AddArtifactsByDisk.INSTANCE;
            AddOptions addOptions = new AddOptions(continueOnError, MultiArtifactOperationOptions.ArgumentProcessingOrder.OPTIMIZE_TIME, MultiArtifactOperationOptions.OperationFlags.UPDATE_FILES, AddOption.newAddModeMismatchIsError());
            MultiArtifactOperationOptions.ProcessRecordListener listener = null;
            if (!cm.isAgentSelfProfile() || !AgentInstall.getInstance().isAgentInstallerRunning()) {
                listener = new MultiArtifactOperationOptions.ProcessRecordListener(){
                    private final ThreadLocal<IVolumeAccessByDisk.IDisk> perThreadDisk = new ThreadLocal();

                    public void onBeforeUseDisk(IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs) {
                        this.perThreadDisk.set(disk);
                    }

                    public void onUsedDisk(IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs) {
                        this.perThreadDisk.set(null);
                    }

                    public synchronized void onProcessedRecord(MultiArtifactOperationOptions options, IMultiArtifactOperationArguments multiArgs, IArtifactOperation.IArtifactOperationRecord record, boolean processed) {
                        this.logUnsafeDownload(cm.location.getPath(), record);
                        IVolumeAccessByDisk.IDisk disk = this.perThreadDisk.get();
                        this.logDownload(cm.location.getPath(), disk, record);
                    }
                };
                addOptions.addListener(listener);
            }
            this.assigned.executeWithoutStatusSummary(cm.session, new AssignArtifacts.IContextFactory(){

                public IArtifactOperation.IOperationContext createContext(IRepository sourceRepo) {
                    return new AddArtifactsByDisk.AddGroupedContext(sourceRepo, cm.repo);
                }
            }, instance, (MultiArtifactOperationOptions)addOptions, (IProgressMonitor)sm.newChild(this.assigned.getArtifacts().size()));
            if (listener != null) {
                addOptions.removeListener(listener);
            }
            IMultiArtifactOperationArguments argsExploded = AddArtifacts.INSTANCE.createArguments();
            IMultiArtifactOperationArguments argsUnexploded = AddArtifacts.INSTANCE.createArguments();
            this.addAndLogHaveOppositeExplodedDownloaded(cm.session, argsUnexploded, argsExploded, true);
            this.addHaveOppositeInCache(cm.session, argsUnexploded, argsExploded);
            this.logHaveOppositeInCache(this.haveOppositeInCacheNeedDownload);
            this.logHaveOppositeInCache(this.haveOppositeInCacheStillUnexploded);
            ArrayList<IArtifactOperation.IArtifactOperationRecord> exploded = new ArrayList<IArtifactOperation.IArtifactOperationRecord>(this.getAssignedRecords(true, this.explodedCount));
            argsExploded.addRecords(exploded);
            List<IArtifact> allExplodedArtifacts = this.getTocArtifactsFromRecords(argsExploded);
            CacheManager.logArtifacts(NLS.bind((String)"updating atoc in {0} to track usage and/or download of exploded artifacts ", (Object)cm.repoTrackExploded.getLocationStr()), allExplodedArtifacts);
            AddArtifacts.INSTANCE.execute(cm.session, AddArtifacts.createOperationTarget((IReadArtifactRepo)cm.repoTrackExploded), (MultiArtifactOperationOptions)new AddOptions(continueOnError, MultiArtifactOperationOptions.ArgumentProcessingOrder.OPTIMIZE_TIME, MultiArtifactOperationOptions.OperationFlags.UPDATE_ATOC, AddOption.newAddModeMismatchIsError()), argsExploded, (IProgressMonitor)new NoCancelProgressMonitor((IProgressMonitor)sm.newChild(1)));
            ArrayList<IArtifactOperation.IArtifactOperationRecord> unexploded = new ArrayList<IArtifactOperation.IArtifactOperationRecord>(this.getAssignedRecords(false, this.unexplodedCount));
            argsUnexploded.addRecords(unexploded);
            List<IArtifact> allUnexplodedArtifacts = this.getTocArtifactsFromRecords(argsUnexploded);
            CacheManager.logArtifacts(NLS.bind((String)"updating atoc in {0} to track usage and/or download of unexploded artifacts ", (Object)cm.repo.getLocationStr()), allUnexplodedArtifacts);
            AddArtifacts.INSTANCE.execute(cm.session, AddArtifacts.createOperationTarget((IReadArtifactRepo)cm.repo), (MultiArtifactOperationOptions)new AddOptions(continueOnError, MultiArtifactOperationOptions.ArgumentProcessingOrder.OPTIMIZE_TIME, MultiArtifactOperationOptions.OperationFlags.UPDATE_ATOC, AddOption.newAddModeMismatchIsError()), argsUnexploded, (IProgressMonitor)new NoCancelProgressMonitor((IProgressMonitor)sm.newChild(1)));
            boolean makeNotFoundsErrors = true;
            boolean addRepoAllNotOkStatus = true;
            Collection statusCollection = this.assigned.getStatusCollection(instance, makeNotFoundsErrors, addRepoAllNotOkStatus);
            IStatus failedStatus = argsUnexploded.getFailedOperationStatus();
            if (!failedStatus.isOK()) {
                statusCollection.add(failedStatus);
            }
            statusCollection.addAll(AddArtifacts.INSTANCE.getTotalStatusCollection(argsUnexploded));
            failedStatus = argsExploded.getFailedOperationStatus();
            if (!failedStatus.isOK()) {
                statusCollection.add(failedStatus);
            }
            statusCollection.addAll(AddArtifacts.INSTANCE.getTotalStatusCollection(argsExploded));
            IStatus status = AssignArtifacts.getSummaryStatus((Collection)statusCollection, (boolean)false);
            ms.add(status);
            if (!status.matches(12)) {
                this.logDownloadSuccess();
            }
            return this;
        }

        private void prepareDirectAccessRecords(CicMultiStatus ms, final IArtifactSession session, final IProgressMonitor monitor) {
            final LinkedList errors = new LinkedList();
            VisitDirectAccessArtifacts v = new VisitDirectAccessArtifacts(this){

                @Override
                protected void onDirectAccess() {
                    if (this.addInput.getLocator() == null) {
                        IVolumeAccessByDisk diskRepo = RepoAs.IVolumeAccessByDisk((IReadArtifactRepo)this.repo);
                        if (diskRepo == null) {
                            ICicStatus status = Statuses.ERROR.get(Messages.CacheManager_artifactCannotBeAccessed, new Object[]{this.artifact.toUserString(), this.repo.getLocationStr()});
                            errors.add(status);
                            return;
                        }
                        IArtifactLocator[] result = new IArtifactLocator[1];
                        IStatus status = RepoAs.IArtifactGet((IReadArtifactRepo)diskRepo.getRepository()).getArtifactLocator(session, this.artifact, (IProgressMonitor)new SubProgressMonitor(monitor, 0), result);
                        if (result[0] == null) {
                            errors.add(status);
                        } else {
                            this.addInput.setLocator((IContentLocator)result[0]);
                        }
                    } else {
                        IArtifactLocator sourceLocator = (IArtifactLocator)this.addInput.getLocator();
                        File file = sourceLocator.revealFile();
                        if (file == null) {
                            errors.add(Statuses.ERROR.get(Messages.CacheManager_acessingArtifactAtLocationNotSupported, new Object[]{this.artifact.toUserString(), this.repo.getLocation()}));
                        } else if (!file.exists()) {
                            errors.add(Statuses.ERROR.get(Messages.CacheManager_fileFoundInAtocDoesNotExist, new Object[]{file, this.repo.getLocation()}));
                        }
                    }
                }
            };
            v.visit();
            if (errors.size() > 0) {
                CicMultiStatus st = Statuses.ERROR.getMultiStatus(Messages.CacheManager_installationFilesUsedDirectlyAreMissing, new Object[0]);
                st.addAll(errors);
                ms.add((IStatus)st);
                return;
            }
            new VisitDirectAccessArtifacts(this){

                @Override
                protected void onDirectAccess() {
                    directAccess.put(this.addInput.getArtifact().getKey(), new DirectAccessInfo(this.repo, this.record));
                    this.recordIterator.remove();
                }
            }.visit();
        }

        private boolean suppressChecksumWarnings(IRepository repo) {
            return AgentInstall.getInstance().isAgentInstallerLocation(repo) || repo instanceof ZipRepository;
        }

        private void logDownloadSuccess() {
            int downloadRequestCount = 0;
            int verifiedCount = 0;
            int unverifiedCount = 0;
            for (IRepository repo : this.assigned.getAssignedRepos()) {
                for (IArtifactOperation.IArtifactOperationRecord record : this.assigned.getArguments(repo).getRecords()) {
                    IArtifactLocator artifactLocator;
                    IRepository sourceRepo;
                    IContentLocator locator;
                    AddArtifacts.AddInput addInput = AddArtifacts.getAddInput((IArtifactOperation.IArtifactOperationRecord)record);
                    if (addInput == null || (locator = addInput.getLocator()) != null && locator instanceof IArtifactLocator && this.suppressChecksumWarnings(sourceRepo = (artifactLocator = (IArtifactLocator)locator).getArtifactRepository())) continue;
                    ++downloadRequestCount;
                    if (!ArtifactsToDownload.hasBeenDownloaded(record)) continue;
                    if (ArtifactsToDownload.hasBeenValidated(record)) {
                        ++verifiedCount;
                        continue;
                    }
                    ++unverifiedCount;
                }
            }
            int notProcessedCount = downloadRequestCount - verifiedCount - unverifiedCount;
            if (notProcessedCount > 0) {
                log.debug("{0} of {1} download requests were not processed at all", new Object[]{notProcessedCount, downloadRequestCount});
            }
            if (unverifiedCount > 0) {
                log.status((IStatus)Statuses.WARNING.get(Messages.CacheManager_Summary_Unverified_Downloads, new Object[]{unverifiedCount}));
            }
            if (verifiedCount > 0) {
                if (verifiedCount == downloadRequestCount) {
                    log.info(Messages.CacheManager_Summary_All_Downloads_Verified, new Object[]{verifiedCount});
                } else {
                    log.info(Messages.CacheManager_Summary_Verified_Downloads, new Object[]{verifiedCount});
                }
            }
        }

        private void logDownload(String cmLocationOrDescription, IVolumeAccessByDisk.IDisk disk, IArtifactOperation.IArtifactOperationRecord record) {
            AddArtifacts.AddInput addInput = AddArtifacts.getAddInput((IArtifactOperation.IArtifactOperationRecord)record);
            if (addInput == null) {
                return;
            }
            IContentLocator locator = addInput.getLocator();
            if (locator == null) {
                return;
            }
            IRepository repo = null;
            if (locator instanceof IArtifactLocator) {
                IArtifactLocator artifactLocator = (IArtifactLocator)locator;
                repo = artifactLocator.getArtifactRepository();
            }
            if (repo == null) {
                return;
            }
            if (!ArtifactsToDownload.hasBeenDownloaded(record)) {
                return;
            }
            String logName = locator.getUserNames().getLogicalName();
            if (disk != null) {
                String labelOrId = DiskUtil.getDiskSetLabelOrId((IVolumeAccessByDisk.IDiskSet)disk.getDiskSet());
                log.debug("Retrieved {0} from disk {1} of set ''{2}'' at {3} to {4}", new Object[]{logName, disk.getDiskNumber(), labelOrId, repo.getLocation(), cmLocationOrDescription});
            } else {
                String sysName = locator.getUserNames().getSystemName();
                log.debug("Retrieved {0} to {1}", new Object[]{sysName, cmLocationOrDescription});
            }
        }

        private void logUnsafeDownload(String cmLocationOrDescription, IArtifactOperation.IArtifactOperationRecord record) {
            IStatus status = record.getTotalStatus();
            if (MultiStatusUtil.hasStatus((IStatus)status, (String)IStatusCodes.PLUGIN_ID, (int)24)) {
                this.logUnsafeDownload(cmLocationOrDescription, record, status);
            }
        }

        private void logUnsafeDownload(String cmLocationOrDescription, IArtifactOperation.IArtifactOperationRecord record, IStatus status) {
            if (!this.logCustom(cmLocationOrDescription, record)) {
                log.status(status);
            }
        }

        private boolean logCustom(String cmLocationOrDescription, IArtifactOperation.IArtifactOperationRecord record) {
            IArtifactLocator artifactLocator;
            IRepository repo;
            AddArtifacts.AddInput addInput = AddArtifacts.getAddInput((IArtifactOperation.IArtifactOperationRecord)record);
            if (addInput == null) {
                return false;
            }
            IContentLocator locator = addInput.getLocator();
            if (locator == null) {
                return false;
            }
            if (locator instanceof IArtifactLocator && this.suppressChecksumWarnings(repo = (artifactLocator = (IArtifactLocator)locator).getArtifactRepository())) {
                return true;
            }
            String source = locator.getUserNames().getSystemName();
            log.status((IStatus)Statuses.WARNING.get(Messages.CacheManager_Unverified_Download, new Object[]{source, cmLocationOrDescription}));
            return true;
        }

        private List<IArtifact> getTocArtifactsFromRecords(IMultiArtifactOperationArguments args) {
            ArrayList<IArtifact> artifacts = new ArrayList<IArtifact>(args.getRecordCount());
            for (Object element : args.getRecords()) {
                IArtifact artifact;
                IArtifactOperation.IArtifactOperationRecord record = (IArtifactOperation.IArtifactOperationRecord)element;
                assert (ArtifactsToDownload.isSuccessRecord(record));
                IArtifactOperation.IArtifactOperationResult result = record.getResult();
                if (!(result instanceof AbstractAddCopyArtifacts.AddOrCopyResult)) continue;
                AbstractAddCopyArtifacts.AddOrCopyResult addResult = (AbstractAddCopyArtifacts.AddOrCopyResult)result;
                IArtifact iArtifact = artifact = addResult.getTargetLocator() != null ? addResult.getTargetLocator().getArtifact() : null;
                if (artifact == null) continue;
                artifacts.add(artifact);
            }
            return artifacts;
        }

        private void addHaveOppositeInCache(IArtifactSession session, IMultiArtifactOperationArguments argsUnexploded, IMultiArtifactOperationArguments argsExploded) {
            for (Map.Entry<IArtifact, IArtifactLocator> entry : this.haveOppositeInCacheStillUnexploded.entrySet()) {
                IArtifact artifact = entry.getKey();
                IArtifactLocator oppositeLocator = entry.getValue();
                ChangedArtifactLocator thisLocator = new ChangedArtifactLocator(oppositeLocator.getArtifactRepository(), artifact, oppositeLocator);
                this.addRecord(session, argsUnexploded, argsExploded, artifact, (IArtifactLocator)thisLocator);
            }
        }

        private void addRecord(IArtifactSession session, IMultiArtifactOperationArguments argsUnexploded, IMultiArtifactOperationArguments argsExploded, IArtifact artifact, IArtifactLocator locator) {
            IArtifactOperation.IArtifactOperationRecord record = artifact.isExploded() ? argsExploded.addInput(AddArtifacts.createGetRequest((IArtifactLocator)locator)) : argsUnexploded.addInput(AddArtifacts.createGetRequest((IArtifactLocator)locator));
            record.setResult((IArtifactOperation.IArtifactOperationResult)new AbstractAddCopyArtifacts.AddOrCopyResult(locator, Status.OK_STATUS));
            record.getHistory().setHistoryStatus((ILog)session, Status.OK_STATUS);
        }

        private void logHaveOppositeInCache(Map<IArtifact, IArtifactLocator> haveOppositeInCache) {
            for (Map.Entry<IArtifact, IArtifactLocator> entry : haveOppositeInCache.entrySet()) {
                IArtifact artifact = entry.getKey();
                IArtifactLocator oppositeLocator = entry.getValue();
                CicMultiStatus ms = Statuses.INFO.getMultiStatus(Messages.CacheManager_EncounteredInconsistentExplodedArtifacts, new Object[]{artifact.toUserString()});
                ms.add((IStatus)Statuses.INFO.get(Messages.CacheManager_InstallArea, new Object[]{CacheManager.getDefaultInstance().getCacheLocation()}));
                int i = 1;
                ms.add((IStatus)Statuses.INFO.get(Messages.CacheManager_InconsistentExplodedArtifactReferenceInCache, new Object[]{i++, oppositeLocator.getArtifact().isExploded()}));
                for (ArtifactOfInstallableUnit aiu : this.getReferences(artifact)) {
                    IInstallableUnit iu = aiu.getInstallableUnit();
                    ms.add((IStatus)Statuses.INFO.get(Messages.CacheManager_InconsistentExplodedArtifactReference, new Object[]{i++, aiu.getArtifact().isExploded(), iu, iu.getParent()}));
                }
                log.status((IStatus)ms);
            }
        }

        private void addAndLogHaveOppositeExplodedDownloaded(IArtifactSession session, IMultiArtifactOperationArguments argsUnexploded, IMultiArtifactOperationArguments argsExploded, boolean shouldLogInconsistentExploded) {
            for (Map.Entry<IArtifact, IArtifactOperation.IArtifactOperationRecord> entry : this.haveOppositeDownload.entrySet()) {
                IArtifactLocator oppositeLocator;
                IArtifact artifact = entry.getKey();
                IArtifactOperation.IArtifactOperationRecord record = entry.getValue();
                if (!ArtifactsToDownload.isSuccessRecord(record)) continue;
                AbstractAddCopyArtifacts.AddOrCopyResult copyResult = (AbstractAddCopyArtifacts.AddOrCopyResult)record.getResult();
                IArtifactLocator iArtifactLocator = oppositeLocator = copyResult == null ? null : copyResult.getTargetLocator();
                if (oppositeLocator == null) continue;
                if (shouldLogInconsistentExploded) {
                    CicMultiStatus ms = Statuses.INFO.getMultiStatus(Messages.CacheManager_EncounteredInconsistentExplodedArtifacts, new Object[]{artifact.toUserString()});
                    ms.add((IStatus)Statuses.INFO.get(Messages.CacheManager_InstallArea, new Object[]{CacheManager.getDefaultInstance().getCacheLocation()}));
                    int i = 1;
                    for (ArtifactOfInstallableUnit aiu : this.getReferences(artifact)) {
                        IInstallableUnit iu = aiu.getInstallableUnit();
                        ms.add((IStatus)Statuses.INFO.get(Messages.CacheManager_InconsistentExplodedArtifactReference, new Object[]{i++, aiu.getArtifact().isExploded(), iu, iu.getParent()}));
                    }
                    ms.add((IStatus)Statuses.INFO.get(Messages.CacheManager_DownloadedInconsistentExplodedArtifact, new Object[]{oppositeLocator.getArtifact().isExploded(), oppositeLocator.getUserNames().getSystemName()}));
                    log.status((IStatus)ms);
                }
                ChangedArtifactLocator thisLocator = new ChangedArtifactLocator(oppositeLocator.getArtifactRepository(), artifact, oppositeLocator);
                this.addRecord(session, argsUnexploded, argsExploded, artifact, (IArtifactLocator)thisLocator);
            }
        }

        static boolean hasBeenDownloaded(IArtifactOperation.IArtifactOperationRecord record) {
            if (ArtifactsToDownload.isSuccessRecord(record)) {
                IArtifactLocator locator = ArtifactsToDownload.getTargetLocator(record);
                return locator != null;
            }
            return false;
        }

        static boolean hasBeenValidated(IArtifactOperation.IArtifactOperationRecord record) {
            IStatus status = record.getLastStatus();
            boolean hasBeenDownloaded = MultiStatusUtil.hasFilteredStatus((IStatus)status, (MultiStatusUtil.IStatusFilter)new MultiStatusUtil.IStatusFilter(){

                public boolean considerChildren() {
                    return true;
                }

                public boolean include(IStatus astatus) {
                    if (!astatus.isOK()) {
                        return false;
                    }
                    if (!astatus.getPlugin().equals(IStatusCodes.PLUGIN_ID)) {
                        return false;
                    }
                    int code = astatus.getCode();
                    return code == 27 || code == 23 || code == 25;
                }
            });
            return hasBeenDownloaded;
        }

        private static IArtifactLocator getTargetLocator(IArtifactOperation.IArtifactOperationRecord record) {
            IArtifactOperation.IArtifactOperationResult result = record.getResult();
            if (result instanceof AbstractAddCopyArtifacts.AddOrCopyResult) {
                AbstractAddCopyArtifacts.AddOrCopyResult aresult = (AbstractAddCopyArtifacts.AddOrCopyResult)result;
                return aresult.getTargetLocator();
            }
            return null;
        }

        public void visitAssignedRecords(IVisitAssignedRecords callback) {
            for (IRepository repo : this.assigned.getAssignedRepos()) {
                IMultiArtifactOperationArguments args = this.assigned.getArguments(repo);
                if (args == null) continue;
                List records = args.getModifiableRecords();
                Iterator<IArtifactOperation.IArtifactOperationRecord> i = records.iterator();
                while (i.hasNext()) {
                    callback.record(repo, i);
                }
            }
        }

        private Collection<IArtifactOperation.IArtifactOperationRecord> getDownloadedRecords() {
            final ArrayList<IArtifactOperation.IArtifactOperationRecord> records = new ArrayList<IArtifactOperation.IArtifactOperationRecord>(this.assigned.getArtifacts().size());
            this.visitAssignedRecords(new IVisitAssignedRecords(){

                @Override
                public void record(IRepository repo, Iterator<IArtifactOperation.IArtifactOperationRecord> recordIterator) {
                    IArtifactOperation.IArtifactOperationRecord record = recordIterator.next();
                    if (ArtifactsToDownload.hasBeenDownloaded(record)) {
                        records.add(record);
                    }
                }
            });
            return records;
        }

        Collection<IArtifactLocator> getDownloadedLocators() {
            Collection<IArtifactOperation.IArtifactOperationRecord> records = this.getDownloadedRecords();
            ArrayList<IArtifactLocator> list = new ArrayList<IArtifactLocator>(records.size());
            for (IArtifactOperation.IArtifactOperationRecord record : records) {
                AbstractAddCopyArtifacts.AddOrCopyResult aresult = (AbstractAddCopyArtifacts.AddOrCopyResult)record.getResult();
                if (aresult.getTargetLocator() == null) continue;
                list.add(aresult.getTargetLocator());
            }
            return list;
        }

        Agent.IPurgeableFiles getDownloadedArtifacts(CacheManager cm, IProgressMonitor monitor) throws CacheManagerException {
            Collection<IArtifactOperation.IArtifactOperationRecord> records = this.getDownloadedRecords();
            int n = this.assigned.getArtifacts().size();
            PurgeableArtifacts stored = new PurgeableArtifacts(cm, n);
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, n);
            for (IArtifactOperation.IArtifactOperationRecord record : records) {
                IArtifactOperation.IArtifactOperationResult result = record.getResult();
                AbstractAddCopyArtifacts.AddOrCopyResult aresult = (AbstractAddCopyArtifacts.AddOrCopyResult)result;
                stored.addArtifact(aresult.getTargetLocator().getArtifact(), spm.next());
            }
            PurgeableFiles purgeable = new PurgeableFiles();
            purgeable.addPurgeable(CacheManager.getIncompleteDownloads());
            purgeable.addPurgeable(stored);
            spm.done();
            return purgeable;
        }

        private long calculateDownloadSize(IMultiArtifactOperationArguments args) {
            SizeInfo sizeInfo = new SizeInfo(0L, 0L);
            for (Object element : args.getRecords()) {
                IArtifactOperation.IArtifactOperationRecord record = (IArtifactOperation.IArtifactOperationRecord)element;
                IArtifactOperation.IArtifactOperationInput input = record.getInput();
                if (!(input instanceof AddArtifacts.AddInput)) continue;
                AddArtifacts.AddInput addInput = (AddArtifacts.AddInput)input;
                IContentInfo contentInfo = addInput.getLocator() != null ? addInput.getLocator().getContentInfo() : addInput.getArtifact().getContentInfo();
                sizeInfo.add(contentInfo.getSizeInfo());
            }
            return sizeInfo.getDownloadSize();
        }

        long getAssignedArtifactsSize() {
            Collection<IRepository> reps = this.getRepositories();
            long size = 0L;
            for (IRepository rep : reps) {
                IMultiArtifactOperationArguments args = this.assigned.getArguments(rep);
                if (args == null) continue;
                size += this.calculateDownloadSize(args);
            }
            return size;
        }

        long getDownloadedArtifactsSize() {
            SizeInfo sizeInfo = new SizeInfo(0L, 0L);
            for (IRepository arepo : this.assigned.getAssignedRepos()) {
                IMultiArtifactOperationArguments args = this.assigned.getArguments(arepo);
                if (args == null) continue;
                for (Object element2 : args.getRecords()) {
                    AbstractAddCopyArtifacts.AddOrCopyResult aresult;
                    IArtifactLocator targetLocator;
                    IArtifactOperation.IArtifactOperationResult result;
                    IArtifactOperation.IArtifactOperationRecord record = (IArtifactOperation.IArtifactOperationRecord)element2;
                    if (!ArtifactsToDownload.isSuccessRecord(record) || !((result = record.getResult()) instanceof AbstractAddCopyArtifacts.AddOrCopyResult) || (targetLocator = (aresult = (AbstractAddCopyArtifacts.AddOrCopyResult)result).getTargetLocator()) == null) continue;
                    sizeInfo.add(targetLocator.getArtifact().getContentInfo().getSizeInfo());
                }
            }
            return sizeInfo.getDownloadSize();
        }

        List<DownloadInProgressManager.IDownloadInProgress> getPartialDownloads() {
            return DownloadInProgressManager.INSTANCE.getPartialRequests();
        }

        static long getPartialDownloadSize(Object odip) {
            DownloadInProgressManager.IDownloadInProgress dip = (DownloadInProgressManager.IDownloadInProgress)odip;
            return dip.getInProgressLocation().toFile().length();
        }

        static Object getPartialArtifact(Object odip) {
            DownloadInProgressManager.IDownloadInProgress dip = (DownloadInProgressManager.IDownloadInProgress)odip;
            return dip.getArtifact();
        }

        public void undoTocUpdatesForNonDownloadedFile(CacheManager cm, IProgressMonitor amonitor) {
            NoCancelProgressMonitor monitor = new NoCancelProgressMonitor(amonitor);
            IMultiArtifactOperationArguments argsExploded = AddArtifacts.INSTANCE.createArguments();
            IMultiArtifactOperationArguments argsUnexploded = AddArtifacts.INSTANCE.createArguments();
            this.addAndLogHaveOppositeExplodedDownloaded(cm.session, argsUnexploded, argsExploded, false);
            this.addHaveOppositeInCache(cm.session, argsUnexploded, argsExploded);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            List<IArtifact> list = this.getTocArtifactsFromRecords(argsUnexploded);
            CacheManager.logArtifacts(NLS.bind((String)"undoing toc updates in {0} ", (Object)cm.repo.getLocationStr()), list);
            IArtifact[] artifacts = CacheManager.toArtifactArray(list);
            RepoAs.IArtifactTocUpdate((IReadArtifactRepo)cm.repo).updateArtifactTocRemove(cm.session, artifacts, (IProgressMonitor)sm.newChild(1));
            List<IArtifact> listExploded = this.getTocArtifactsFromRecords(argsExploded);
            CacheManager.logArtifacts(NLS.bind((String)"undoing toc updates in {0} ", (Object)cm.repoTrackExploded.getLocationStr()), listExploded);
            IArtifact[] artifactsExploded = CacheManager.toArtifactArray(listExploded);
            RepoAs.IArtifactTocUpdate((IReadArtifactRepo)cm.repoTrackExploded).updateArtifactTocRemove(cm.session, artifactsExploded, (IProgressMonitor)sm.newChild(1));
        }

        public void checkConsistency(CacheManager cm, IProgressMonitor monitor) {
            CheckConsistency.checkConsistency(cm, this, monitor);
        }

        public static interface IVisitAssignedRecords {
            public void record(IRepository var1, Iterator<IArtifactOperation.IArtifactOperationRecord> var2);
        }

        private abstract class VisitDirectAccessArtifacts {
            protected IRepository repo;
            protected Iterator<IArtifactOperation.IArtifactOperationRecord> recordIterator;
            protected IArtifactOperation.IArtifactOperationRecord record;
            protected AddArtifacts.AddInput addInput;
            protected IArtifact artifact;

            private VisitDirectAccessArtifacts() {
            }

            void visit() {
                ArtifactsToDownload.this.visitAssignedRecords(new IVisitAssignedRecords(){

                    @Override
                    public void record(IRepository arepo, Iterator<IArtifactOperation.IArtifactOperationRecord> iter) {
                        VisitDirectAccessArtifacts.this.repo = arepo;
                        VisitDirectAccessArtifacts.this.record = iter.next();
                        VisitDirectAccessArtifacts.this.recordIterator = iter;
                        VisitDirectAccessArtifacts.this.addInput = AddArtifacts.getAddInput((IArtifactOperation.IArtifactOperationRecord)VisitDirectAccessArtifacts.this.record);
                        if (VisitDirectAccessArtifacts.this.addInput == null) {
                            return;
                        }
                        VisitDirectAccessArtifacts.this.artifact = VisitDirectAccessArtifacts.this.addInput.getArtifact();
                        if (VisitDirectAccessArtifacts.this.artifact == null) {
                            return;
                        }
                        Collection refs = ArtifactsToDownload.this.getReferences(VisitDirectAccessArtifacts.this.artifact);
                        boolean hasNonDirectUsage = false;
                        boolean hasDirectAccessUsage = false;
                        for (ArtifactOfInstallableUnit aiu : refs) {
                            IInstallableUnit iu = aiu.getInstallableUnit();
                            boolean b = CacheManager.supportsDirectAccess(iu, aiu.getArtifact());
                            if (b) {
                                hasDirectAccessUsage = true;
                                continue;
                            }
                            hasNonDirectUsage = true;
                        }
                        if (!hasDirectAccessUsage) {
                            return;
                        }
                        if (!hasNonDirectUsage) {
                            VisitDirectAccessArtifacts.this.onDirectAccess();
                        }
                    }
                });
            }

            protected abstract void onDirectAccess();
        }
    }

    private static class CacheBackupDirectory
    extends BackupDirectoryFilesKeepStructure {
        CacheBackupDirectory(Logger log, File rootDir, File backupParentDir) {
            super(log, rootDir, backupParentDir);
        }
    }

    public static class CacheManagerException
    extends CoreException {
        CacheManagerException(IStatus status) {
            super(status);
        }

        CacheManagerException(String message, Object ... args) {
            this((IStatus)Statuses.ERROR.get(message, args));
        }

        CacheManagerException(CoreException e) {
            this(e.getStatus());
            this.initCause(e);
        }

        CacheManagerException(IOException e) {
            this(e.getMessage(), new Object[0]);
            this.initCause(e);
        }
    }

    private static class ChangedArtifactLocator
    extends AbstractArtifactLocator {
        private final IArtifactLocator locator;

        ChangedArtifactLocator(IRepository artifactRepoInstance, IArtifact artifact, IArtifactLocator locator) {
            super(artifactRepoInstance, artifact, locator.getContentInfo());
            this.locator = locator;
        }

        protected IDownloadedFile doDownloadToFileNoValidationNoResumeRetry(IDownloadSession session, IPath destination, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
            throw new UnsupportedOperationException();
        }

        public IStatus validateExists(int severity, IProgressMonitor monitor) {
            return this.locator.validateExists(severity, monitor);
        }

        public UserNames getUserNames() {
            return this.locator.getUserNames();
        }
    }

    public static class CheckConsistency {
        @Deprecated
        public static final String CHECKED_CONSISTENCY_STAMP_FILE_NAME = "check.properties";
        private static final String DEFAULT_EXCEPTIONS_RESOURCE_NAME = "exceptions.properties";
        @Deprecated
        public static final String LOCATION_TRUNCATION_EXCEPTIONS_FILE_NAME = "check_configure.properties";
        private static final String ATOC = "atoc/";
        private final CacheManager cm;
        private final ArtifactsToDownload toDownload;
        private final BackupDirectoryFilesKeepStructure backupArea;
        private static final Logger clog = Logger.getLogger(CheckConsistency.class, (Plugin)AgentActivator.getDefault());
        private ReferenceContexts neededReferences;
        private boolean atocsBackupAttempted;
        private boolean atocsBackupDone;
        private final Map<File, String> inconsistencies;
        private Map<String, Long> defaultTruncationExceptions;
        private Map<String, Long> newlyDownloadedTruncationExceptions;
        private Map<String, Long> locationTruncationExceptions;
        private final List<IArtifact> consistencyCheckExceptionForArtifacts;

        static void checkConsistency(CacheManager cm, ArtifactsToDownload toDownload, IProgressMonitor monitor) {
            CheckConsistency cc = new CheckConsistency(cm, toDownload);
            cc.checkConsistency(monitor);
        }

        private CheckConsistency(CacheManager cm, ArtifactsToDownload toDownload) {
            this.cm = cm;
            this.toDownload = toDownload;
            IRevealFileLocations reveal = (IRevealFileLocations)cm.repo.getAdapter(IRevealFileLocations.class);
            File backupParentDir = AgentUserOptions.CIC_AGENT_USE_EXTRA_TRACKEX.isSet() ? reveal.getExtraDir() : reveal.getTempDir();
            File rootDir = cm.getCacheLocation().getAbsoluteFile();
            this.backupArea = new CacheBackupDirectory(clog, rootDir, backupParentDir);
            this.atocsBackupAttempted = false;
            this.atocsBackupDone = false;
            this.consistencyCheckExceptionForArtifacts = new ArrayList<IArtifact>();
            this.inconsistencies = new LinkedHashMap<File, String>();
        }

        private static boolean isFixMode() {
            return AgentUserOptions.CIC_CACHE_REPAIR_MODE.isSet() || AgentUserOptions.CIC_CACHE_FIX_MODE.isSet();
        }

        private static boolean isUnpackAllMode() {
            return CheckConsistency.userWantsCheckOrRepair() || AgentUserOptions.CIC_CACHE_CHECK_CAN_UNPACK.isSet();
        }

        private boolean isForceCheckAll() {
            return CheckConsistency.userWantsCheckOrRepair() || AgentUserOptions.CIC_CACHE_FORCE_CHECK_ALL.isSet();
        }

        private static boolean isTruncationWarningEnabled() {
            return CheckConsistency.userWantsCheckOrRepair() || AgentUserOptions.CIC_CACHE_CHECK_ENABLE_TRUNCATION_WARNING.isSet();
        }

        private static boolean isCheckEnabled() {
            return AgentUserOptions.CIC_CACHE_CHECK_ENABLED.isSet();
        }

        private static boolean userWantsCheckOrRepair() {
            return AgentUserOptions.CIC_CACHE_REPAIR_MODE.isSet() || AgentUserOptions.CIC_CACHE_CHECK_MODE.isSet();
        }

        private void readDefaultExceptions() {
            InputStream input;
            this.defaultTruncationExceptions = new LinkedHashMap<String, Long>();
            String name = DEFAULT_EXCEPTIONS_RESOURCE_NAME;
            ClassLoader loader = CacheManager.class.getClassLoader();
            String resource = String.valueOf(CacheManager.class.getPackage().getName().replace('.', '/')) + '/' + name;
            InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(resource) : loader.getResourceAsStream(resource);
            if (input == null) {
                clog.debug("No default consistency checking exceptions found");
                return;
            }
            try {
                try {
                    Properties properties = new Properties();
                    properties.load(input);
                    this.defaultTruncationExceptions = new LinkedHashMap<String, Long>(properties.size());
                    TruncatedArtifactWarningExceptions.parseTruncationExceptions((String)"default consistency exceptions", (Properties)properties, this.defaultTruncationExceptions);
                }
                catch (IOException e) {
                    clog.error("Error reading default consistency checking exceptions: {0}", new Object[]{e});
                    FileUtil.close((Closeable)input);
                }
            }
            finally {
                FileUtil.close((Closeable)input);
            }
        }

        static void removeCheckingFiles(CacheManager cacheManager) {
            FileUtil.rm((File)CheckConsistency.getCacheTruncationExceptionsFile(cacheManager));
            FileUtil.rm((File)cacheManager.repo.getLocation().append(CHECKED_CONSISTENCY_STAMP_FILE_NAME).toFile());
        }

        private static File getCacheTruncationExceptionsFile(File cacheRoot) {
            File fileExceptions = new File(cacheRoot, LOCATION_TRUNCATION_EXCEPTIONS_FILE_NAME);
            return fileExceptions;
        }

        private static File getCacheTruncationExceptionsFile(CacheManager cm) {
            return CheckConsistency.getCacheTruncationExceptionsFile(cm.repo.getLocation().toFile());
        }

        private static Map<String, Long> readLocationTruncationExceptions(CacheManager cm) {
            File rootLocation = cm.repo.getLocation().toFile();
            return CheckConsistency.readLocationTruncationExceptions(rootLocation);
        }

        @Deprecated
        public static Map<String, Long> readLocationTruncationExceptions(File cacheRoot) {
            File file = CheckConsistency.getCacheTruncationExceptionsFile(cacheRoot);
            if (file.exists()) {
                try {
                    return TruncatedArtifactWarningExceptions.readLocationTruncationExceptions((File)file);
                }
                catch (IOException e) {
                    CicMultiStatus ms = Statuses.ST.createMultiStatus(Messages.CacheManager_checking_ErrorReadingConsistencyCheckingTruncationExceptions, new Object[]{file.getPath()});
                    ms.add((IStatus)new Status(4, pluginId, -1, "{0}", (Throwable)e));
                    ms.add((IStatus)new Status(1, pluginId, -1, Messages.CacheManager_checking_UsingDefaultConsistencyCheckExceptions, null));
                    log.status((IStatus)ms);
                }
            }
            return null;
        }

        static void purgeCheckConsistencyExceptions(CacheManager cm) {
            List<IArtifact> listHave;
            Map<String, Long> locationExceptions = CheckConsistency.readLocationTruncationExceptions(cm);
            if (locationExceptions == null) {
                return;
            }
            try {
                listHave = cm.getArtifacts((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                clog.debug("Error from getArtifacts: {0}", new Object[]{e});
                return;
            }
            LinkedHashSet<String> maintainExceptions = new LinkedHashSet<String>(listHave.size());
            for (IArtifact artifact : listHave) {
                IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath((IArtifact)artifact);
                if (relPath == null) {
                    log.debug("Failed to form path for artifact {0}", new Object[]{artifact});
                    continue;
                }
                maintainExceptions.add(relPath.toString());
            }
            LinkedHashSet<String> remove = new LinkedHashSet<String>(locationExceptions.size());
            Iterator<String> i = locationExceptions.keySet().iterator();
            while (i.hasNext()) {
                String path = i.next();
                if (maintainExceptions.contains(path)) continue;
                i.remove();
                remove.add(path);
            }
            if (remove.size() > 0) {
                if (locationExceptions.size() == 0) {
                    File file = CheckConsistency.getCacheTruncationExceptionsFile(cm);
                    FileUtil.rm((File)file);
                } else {
                    CheckConsistency.saveLocationTruncationExceptions(cm, locationExceptions);
                }
            }
        }

        private static void saveLocationTruncationExceptions(CacheManager cm, Map<String, Long> exceptions) {
            File file = CheckConsistency.getCacheTruncationExceptionsFile(cm);
            CheckConsistency.saveLocationTruncationExceptions(file, exceptions);
        }

        private static void saveLocationTruncationExceptions(File file, Map<String, Long> exceptions) {
            try {
                TruncatedArtifactWarningExceptions.saveLocationTruncationExceptions((File)file, (String)Messages.CacheManager_checking_ExplainExceptionsFile, exceptions);
            }
            catch (IOException e) {
                log.error(Messages.CacheManager_checking_FailedToWriteCheckConsistencyExceptionsFile, new Object[]{file, e});
            }
        }

        private static void store(Properties properties, OutputStream out, String comment) throws IOException {
            try {
                properties.store(out, LogUtil.fixNewlines((String)comment));
            }
            finally {
                FileUtil.close((Closeable)out);
            }
        }

        private long getMinimalKnownExceptionLength(IArtifact artifact) {
            Long minSize;
            IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath((IArtifact)artifact);
            if (relPath == null) {
                return Long.MIN_VALUE;
            }
            String mapKey = relPath.toString();
            if (this.locationTruncationExceptions != null && (minSize = this.locationTruncationExceptions.get(mapKey)) != null) {
                clog.debug("Found truncation exception for {0}: {1}", new Object[]{mapKey, minSize});
                return minSize;
            }
            minSize = this.defaultTruncationExceptions.get(mapKey);
            if (minSize != null) {
                clog.debug("Found default truncation exception for {0}: {1}", new Object[]{mapKey, minSize});
                return minSize;
            }
            return Long.MIN_VALUE;
        }

        private void addTruncationException(long fileLength, IArtifact artifact) {
            IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath((IArtifact)artifact);
            if (relPath != null) {
                this.newlyDownloadedTruncationExceptions.put(relPath.toString(), fileLength);
                clog.debug("Adding new truncation exception for {0}: {1}", new Object[]{relPath, fileLength});
            }
        }

        private static boolean hasJustBeenDownloadedAndVerified(ArtifactsToDownload downloads, IArtifact atocArtifact, long fileLength) {
            long downloadedSize;
            IArtifactOperation.IArtifactOperationRecord record = downloads.getAssignedRecord(atocArtifact);
            if (record == null) {
                return false;
            }
            if (!ArtifactsToDownload.hasBeenDownloaded(record)) {
                return false;
            }
            boolean hasBeenDownloaded = ArtifactsToDownload.hasBeenValidated(record);
            if (!hasBeenDownloaded) {
                return false;
            }
            IArtifactLocator locator = ArtifactsToDownload.getTargetLocator(record);
            long l = downloadedSize = locator != null ? locator.getContentInfo().getSizeInfo().getDownloadSize() : Long.MIN_VALUE;
            return downloadedSize == fileLength;
        }

        private void readTruncationExceptions() {
            this.readDefaultExceptions();
            this.locationTruncationExceptions = CheckConsistency.readLocationTruncationExceptions(this.cm);
        }

        private void updateTruncationExceptions() {
            if (this.newlyDownloadedTruncationExceptions.isEmpty()) {
                return;
            }
            if (this.locationTruncationExceptions == null) {
                this.locationTruncationExceptions = new LinkedHashMap<String, Long>(this.newlyDownloadedTruncationExceptions.size());
            }
            for (Map.Entry<String, Long> entry : this.newlyDownloadedTruncationExceptions.entrySet()) {
                this.locationTruncationExceptions.put(entry.getKey(), entry.getValue());
            }
            File file = CheckConsistency.getCacheTruncationExceptionsFile(this.cm);
            CheckConsistency.saveLocationTruncationExceptions(file, this.locationTruncationExceptions);
        }

        private void checkConsistency(IProgressMonitor monitor) {
            try {
                this.cm.checkOpen();
            }
            catch (CacheManagerException e) {
                clog.status(e.getStatus());
                return;
            }
            if (!CheckConsistency.isCheckEnabled()) {
                File checkStampFile = this.getCheckStampFile();
                FileUtil.rm((File)checkStampFile);
                return;
            }
            clog.start(clog.info(Messages.CacheManager_checking_consistency, new Object[]{this.cm.location}));
            try {
                this.doCheckConsistency(monitor);
            }
            finally {
                clog.stop();
            }
        }

        private void doCheckConsistency(IProgressMonitor monitor) {
            this.cm.openArtifactSession();
            this.readTruncationExceptions();
            this.newlyDownloadedTruncationExceptions = new LinkedHashMap<String, Long>();
            File checkStampFile = this.getCheckStampFile();
            if (this.isForceCheckAll() || !checkStampFile.exists()) {
                this.checkEntireCacheConsistency(monitor);
            } else {
                this.checkDownloadedCacheConsistency(monitor);
            }
            try {
                FileOutputStream out = new FileOutputStream(checkStampFile);
                CheckConsistency.store(new Properties(), out, Messages.CacheManager_checking_ExplainLastCheckTimeStampFile);
            }
            catch (IOException e) {
                clog.error(Messages.CacheManager_checking_FailedToWriteCheckTimeStampFile, new Object[]{checkStampFile, e});
            }
            this.updateTruncationExceptions();
        }

        private File getCheckStampFile() {
            File checkStampFile = this.cm.repo.getLocation().append(CHECKED_CONSISTENCY_STAMP_FILE_NAME).toFile();
            return checkStampFile;
        }

        private void checkEntireCacheConsistency(IProgressMonitor monitor) {
            Set<IArtifact> have;
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 1, 10});
            this.initNeededReferences(pm.next());
            try {
                have = this.getCacheArtifactsSet(pm.next());
            }
            catch (CoreException e) {
                log.debug("Error from getArtifacts: {0}", new Object[]{e});
                return;
            }
            SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), have.size());
            plog.start(plog.debug("checking artifacts for consistency"));
            for (IArtifact artifact : have) {
                this.checkConsistency(CheckConsistency.isFixMode(), artifact, pm2.next());
            }
        }

        private Set<IArtifact> getCacheArtifactsSet(IProgressMonitor monitor) throws CoreException {
            plog.start(plog.debug("get current artifacts"));
            List<IArtifact> listHave = this.cm.getArtifacts(monitor);
            plog.stop();
            return new LinkedHashSet<IArtifact>(listHave);
        }

        private void checkDownloadedCacheConsistency(IProgressMonitor monitor) {
            Set<IArtifact> have;
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 1, 10});
            this.initNeededReferences(pm.next());
            try {
                have = this.getCacheArtifactsSet(pm.next());
            }
            catch (CoreException e) {
                log.debug("Error from getArtifacts: {0}", new Object[]{e});
                return;
            }
            Collection<IArtifactLocator> locators = this.toDownload.getDownloadedLocators();
            SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), locators.size());
            for (IArtifactLocator locatorDownloaded : locators) {
                IArtifact atocArtifact = locatorDownloaded.getArtifact();
                if (!have.contains(atocArtifact)) continue;
                this.checkConsistency(CheckConsistency.isFixMode(), atocArtifact, pm2.next());
            }
        }

        private void initNeededReferences(IProgressMonitor monitor) {
            Set neededIU = this.cm.getNeededIUs(monitor);
            this.neededReferences = new ReferenceContexts();
            for (IInstallableUnit iu : neededIU) {
                IAdapterData adapterData = iu.getAdapterData();
                Collection artifacts = adapterData.getArtifacts();
                for (IArtifact artifact : artifacts) {
                    this.neededReferences.rememberReference(new MapListUtil.ICollectionFactory(){

                        public Collection createCollection() {
                            return new LinkedHashSet();
                        }
                    }, (Object)new ArtifactOfInstallableUnit(iu, artifact), (Object)artifact.getKey());
                }
            }
        }

        private String toMessage(IArtifact atocArtifact) {
            String msg = atocArtifact.isExploded() ? NLS.bind((String)Messages.CacheManager_exploded_artifact, (Object)atocArtifact.toUserString()) : atocArtifact.toUserString();
            return msg;
        }

        private void checkConsistency(boolean fixMode, IArtifact atocArtifact, IProgressMonitor monitor) {
            if (atocArtifact.isExploded()) {
                File file;
                try {
                    file = this.cm.getExistingExplodedLocation(atocArtifact);
                }
                catch (CacheManagerException e) {
                    clog.warning(Messages.CacheManager_checking_internal_error, new Object[]{this.toMessage(atocArtifact), e});
                    this.consistencyCheckExceptionForArtifacts.add(atocArtifact);
                    return;
                }
                if (file != null && file.exists()) {
                    clog.debug("No consistency checking for exploded artifact {0}", new Object[]{file});
                    return;
                }
            }
            this.checkForFileAtRootLocation(fixMode, atocArtifact, monitor);
        }

        private void checkForFileAtRootLocation(boolean fixMode, IArtifact atocArtifact, IProgressMonitor monitor) {
            File file;
            try {
                file = this.cm.getLocationNoExplode(atocArtifact, false);
            }
            catch (CacheManagerException e) {
                clog.warning(Messages.CacheManager_checking_internal_error, new Object[]{this.toMessage(atocArtifact), e});
                this.consistencyCheckExceptionForArtifacts.add(atocArtifact);
                return;
            }
            if (!file.exists()) {
                LogEntry logEntry = clog.warning(Messages.CacheManager_checking_missing_file, new Object[]{file});
                this.logInconsistent(file, logEntry);
                this.safeRefetch(fixMode, atocArtifact, file, monitor);
            } else {
                this.checkFileConsistency(fixMode, file, atocArtifact, monitor);
            }
        }

        private File backup(File file, IProgressMonitor monitor) {
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
            try {
                if (!this.backupAtocs(spm.next())) {
                    return null;
                }
                File file2 = this.backupArea.backupFile(file, spm.next());
                return file2;
            }
            finally {
                monitor.done();
            }
        }

        private boolean backupAtocs(IProgressMonitor monitor) {
            if (!this.atocsBackupAttempted) {
                this.atocsBackupAttempted = true;
                SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
                File atocDir = new File(this.backupArea.getBackedUpDir(), ATOC);
                if (!this.backupArea.backupDir(atocDir, spm.next())) {
                    return false;
                }
                File trackExAtocDir = new File(this.cm.getRepoTrackExplodedDir(), ATOC);
                if (!this.backupArea.backupDir(trackExAtocDir, spm.next())) {
                    return false;
                }
                this.atocsBackupDone = true;
            }
            return this.atocsBackupDone;
        }

        private void logInconsistent(File file, LogEntry logEntry) {
            this.inconsistencies.put(file, logEntry.getFormattedMessage());
        }

        private void checkFileConsistency(boolean fixMode, File file, IArtifact atocArtifact, IProgressMonitor monitor) {
            if (this.cm.isAgentSelfProfile() && AgentInstall.getInstance().isAgentInstallerRunning()) {
                return;
            }
            long fileLength = file.length();
            if (fileLength == 0L) {
                LogEntry logEntry = clog.warning(Messages.CacheManager_checking_zero_length_file, new Object[]{file});
                this.logInconsistent(file, logEntry);
                this.safeRefetch(fixMode, atocArtifact, file, monitor);
                return;
            }
            long minKnownMetadataLength = this.getMinimalKnownMetadataArtifactLength(atocArtifact);
            long minKnownExceptionLength = this.getMinimalKnownExceptionLength(atocArtifact);
            minKnownMetadataLength = this.minSizeInfo(minKnownMetadataLength, minKnownExceptionLength);
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 1 + (CheckConsistency.isUnpackAllMode() ? 1 : 0));
            try {
                if (this.isTruncated(file, minKnownMetadataLength, fileLength)) {
                    if (CheckConsistency.hasJustBeenDownloadedAndVerified(this.toDownload, atocArtifact, fileLength)) {
                        this.addTruncationException(fileLength, atocArtifact);
                    } else if (CheckConsistency.isTruncationWarningEnabled()) {
                        double fractionDelta = (double)(minKnownMetadataLength - fileLength) / (double)minKnownMetadataLength;
                        int percentDelta = (int)(fractionDelta * 100.0);
                        LogEntry logEntry = clog.warning(Messages.CacheManager_checking_file_seems_truncated, new Object[]{minKnownMetadataLength, fileLength, percentDelta, file});
                        this.logInconsistent(file, logEntry);
                        boolean[] refVerifiedDownload = new boolean[1];
                        File fetchedFile = this.safeRefetch(fixMode, atocArtifact, file, spm.next(), refVerifiedDownload);
                        if (refVerifiedDownload[0]) {
                            this.addTruncationException(fetchedFile.length(), atocArtifact);
                        }
                        return;
                    }
                }
                if (!CheckConsistency.isUnpackAllMode()) {
                    return;
                }
                String path = file.getPath();
                String suffix = FileName.getSuffix((String)path);
                if (CicConstants.getZipFileDotExt().equalsIgnoreCase(suffix)) {
                    this.checkZip(fixMode, atocArtifact, file, spm.next());
                } else if (CicConstants.getJarFileDotExt().equalsIgnoreCase(suffix)) {
                    this.checkJar(fixMode, atocArtifact, file, spm.next());
                }
            }
            finally {
                spm.done();
            }
        }

        private void checkJar(boolean repair, IArtifact atocArtifact, File file, IProgressMonitor monitor) {
            this.checkZip(repair, atocArtifact, file, monitor);
        }

        private void checkZip(boolean repair, IArtifact atocArtifact, File file, IProgressMonitor monitor) {
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
            try {
                IStatus status = Util.checkCanUnzipFile((File)file, (String)NLS.bind((String)Messages.CacheManager_checking_task_can_unpack, (Object)file), (IProgressMonitor)spm.next());
                if (!status.isOK()) {
                    LogEntry logEntry = clog.warning(Messages.CacheManager_checking_bad_file, new Object[]{file, status});
                    this.logInconsistent(file, logEntry);
                    this.safeRefetch(repair, atocArtifact, file, spm.next());
                }
            }
            finally {
                spm.done();
            }
        }

        private boolean isTruncated(File file, long minKnownLength, long fileLength) {
            if (minKnownLength == Long.MIN_VALUE) {
                return false;
            }
            long delta = minKnownLength - fileLength;
            double percentShort = (double)delta / (double)minKnownLength * 100.0;
            if (clog.isDebugLoggable()) {
                clog.debug("File percent short {2} estimate={0} len={1} : {3}", new Object[]{minKnownLength, fileLength, percentShort, file});
            }
            if (delta <= 0L) {
                return false;
            }
            if (minKnownLength < 100L) {
                return false;
            }
            if (minKnownLength < 2000L) {
                return percentShort > 25.0;
            }
            if (minKnownLength < 10000L) {
                return percentShort > 10.0;
            }
            if (minKnownLength < 100000L) {
                return percentShort > 7.0;
            }
            return percentShort > 5.0;
        }

        private long getMinimalKnownMetadataArtifactLength(IArtifact atocArtifact) {
            IArtifactKey key = atocArtifact.getKey();
            long min1 = this.getMinimalKnownMetadataArtifactLength(this.toDownload.getReferences(atocArtifact), key);
            long min2 = this.getMinimalKnownMetadataArtifactLength(this.getNeededReferences(atocArtifact), key);
            return this.minSizeInfo(min1, min2);
        }

        private long minSizeInfo(long m1, long m2) {
            if (m1 == Long.MIN_VALUE) {
                return m2;
            }
            if (m2 == Long.MIN_VALUE) {
                return m1;
            }
            if (m1 < m2) {
                return m1;
            }
            return m2;
        }

        private long getMinimalKnownMetadataArtifactLength(Collection<ArtifactOfInstallableUnit> refs, IArtifactKey key) {
            long min = Long.MIN_VALUE;
            for (ArtifactOfInstallableUnit aiu : refs) {
                SizeInfo sizeInfo;
                long downloadSize;
                if (!aiu.getArtifact().getKey().equals(key) || (downloadSize = (sizeInfo = aiu.getArtifact().getContentInfo().getSizeInfo()).getDownloadSize()) == Long.MIN_VALUE || min != Long.MIN_VALUE && downloadSize >= min) continue;
                min = downloadSize;
            }
            return min;
        }

        private File safeRefetch(boolean fixMode, IArtifact atocArtifact, File file, IProgressMonitor monitor) {
            return this.safeRefetch(fixMode, atocArtifact, file, monitor, new boolean[1]);
        }

        private File safeRefetch(boolean fixMode, IArtifact atocArtifact, File file, IProgressMonitor monitor, boolean[] refVerifiedDownload) {
            boolean prevDownloadOnDemand = this.cm.downloadOnDemand;
            this.cm.setDownloadOnDemand(true);
            BackupArtifact backup = new BackupArtifact(atocArtifact, file);
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 3);
            try {
                if (backup.backupAndRemoveArtifact(fixMode, spm.next())) {
                    File fetchedFile;
                    block12: {
                        fetchedFile = null;
                        try {
                            try {
                                fetchedFile = this.fetchArtifact(fixMode, atocArtifact, file, spm.next(), refVerifiedDownload);
                            }
                            catch (CacheManagerException e) {
                                clog.error(Messages.CacheManager_checking_failed_to_fetch_restoring, new Object[]{file});
                                this.consistencyCheckExceptionForArtifacts.add(atocArtifact);
                                if (fetchedFile == null) {
                                    backup.restoreBackup(fixMode, spm.next());
                                }
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fetchedFile == null) {
                                backup.restoreBackup(fixMode, spm.next());
                            }
                            throw throwable;
                        }
                        if (fetchedFile == null) {
                            backup.restoreBackup(fixMode, spm.next());
                        }
                    }
                    File file2 = fetchedFile;
                    return file2;
                }
                return null;
            }
            finally {
                this.cm.setDownloadOnDemand(prevDownloadOnDemand);
                spm.done();
            }
        }

        private File fetchArtifact(boolean repair, IArtifact atocArtifact, File file, IProgressMonitor monitor, boolean[] refVerifiedDownload) throws CacheManagerException {
            refVerifiedDownload[0] = false;
            ArtifactOfInstallableUnit aiu = this.findMetadataArtifact(atocArtifact);
            if (aiu == null) {
                clog.warning(Messages.CacheManager_checking_cant_fetch_no_package_found, new Object[]{file});
                return null;
            }
            if (!repair) {
                return null;
            }
            IArtifactLocator[] locatorRef = new IArtifactLocator[1];
            ArtifactsToDownload[] downloadsRef = new ArtifactsToDownload[1];
            IStatus status = this.cm.fetchOnDemand(aiu.getInstallableUnit(), aiu.getArtifact(), monitor, locatorRef, downloadsRef);
            clog.statusNotOK(status);
            if (StatusCodes.isContentFound((IStatus)status) && file.exists()) {
                clog.note(Messages.CacheManager_checking_repaired, new Object[]{file});
                clog.debug((Object)status);
                refVerifiedDownload[0] = CheckConsistency.hasJustBeenDownloadedAndVerified(downloadsRef[0], atocArtifact, file.length());
                return file;
            }
            return null;
        }

        private ArtifactOfInstallableUnit findMetadataArtifact(IArtifact atocArtifact) {
            ArtifactOfInstallableUnit aiu = this.toDownload.findMetadataArtifactReference(atocArtifact);
            if (aiu == null) {
                aiu = this.findArtifactOfInstallableUnit(this.getNeededReferences(atocArtifact), atocArtifact);
            }
            return aiu;
        }

        private ArtifactOfInstallableUnit findArtifactOfInstallableUnit(Collection<ArtifactOfInstallableUnit> refs, IArtifact artifact) {
            for (ArtifactOfInstallableUnit aiu : refs) {
                if (!aiu.getArtifact().equals(artifact)) continue;
                return aiu;
            }
            return null;
        }

        private Collection<ArtifactOfInstallableUnit> getNeededReferences(IArtifact artifact) {
            return this.neededReferences.getReferences((Object)artifact.getKey());
        }

        private class BackupArtifact {
            private final IArtifact atocArtifact;
            private final File file;
            private File backupFile = null;
            private IRepository repoUsed = null;

            BackupArtifact(IArtifact atocArtifact, File file) {
                this.atocArtifact = atocArtifact;
                this.file = file;
            }

            boolean backupAndRemoveArtifact(boolean fixMode, IProgressMonitor monitor) {
                if (fixMode) {
                    this.backupFile = CheckConsistency.this.backup(this.file, monitor);
                    if (this.backupFile == null) {
                        return false;
                    }
                    this.repoUsed = CheckConsistency.this.cm.getRepo(this.atocArtifact);
                    FileUtil.rm((File)this.file);
                    IArtifactTocUpdate tocUpdate = RepoAs.IArtifactTocUpdate((IReadArtifactRepo)this.repoUsed);
                    IStatus status = tocUpdate.updateArtifactTocRemove(CheckConsistency.this.cm.session, new IArtifact[]{this.atocArtifact}, monitor);
                    clog.statusNotOK(status);
                    return status.isOK();
                }
                return true;
            }

            void restoreBackup(boolean fixMode, IProgressMonitor monitor) {
                if (!fixMode) {
                    return;
                }
                IArtifactTocUpdate tocUpdate = RepoAs.IArtifactTocUpdate((IReadArtifactRepo)this.repoUsed);
                IStatus status = tocUpdate.updateArtifactTocAddOrChange(CheckConsistency.this.cm.session, new IArtifact[]{this.atocArtifact}, monitor);
                if (!status.isOK()) {
                    clog.error(Messages.CacheManager_checking_failed_to_restore_atoc_entry, new Object[]{CheckConsistency.this.toMessage(this.atocArtifact), status});
                } else {
                    try {
                        if (!this.backupFile.exists()) {
                            clog.info(Messages.CacheManager_checking_repair_failed_restoring_missing_file, new Object[]{this.file});
                            FileUtil.rm((File)this.file);
                        } else {
                            clog.info(Messages.CacheManager_checking_repair_failed_restoring_file, new Object[]{this.file, this.backupFile});
                            FileUtil.mv((File)this.backupFile, (File)this.file, (boolean)true, (boolean)true, (IProgressMonitor)monitor);
                        }
                    }
                    catch (IOException e) {
                        clog.error(Messages.CacheManager_checking_failed_to_restore_file, new Object[]{this.file, this.backupFile, e});
                    }
                }
            }
        }
    }

    private class Cleanup {
        private Cleanup() {
        }

        IStatus cleanup(boolean includeInactive, IProgressMonitor monitor) {
            if (AgentUserOptions.CIC_CACHE_KEEP_ARTIFACTS.isSet()) {
                log.debug("Skipping cache cleanup");
                return Status.OK_STATUS;
            }
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor).split(1, 8);
            try {
                Agent.IPurgeableFiles purgeableFiles = this.determineCleanup(includeInactive, pm.next());
                return purgeableFiles.purgeFiles(pm.next());
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }

        Agent.IPurgeableFiles determineCleanup(boolean includeInactive, IProgressMonitor monitor) throws CoreException {
            List<IArtifact> listHave;
            CacheManager.this.checkOpen();
            CacheManager.this.openArtifactSession();
            SplitProgressMonitor pm = new SplitProgressMonitor((IProgressMonitor)(monitor == null ? null : new OmitSubTaskProgressMonitor(monitor)), Messages.CacheManager_Searching_For_Saved_Artifacts).split(5, 1, 2);
            plog.start(plog.debug("get needed artifacts"));
            Set<IArtifact> need = this.getArtifactsToKeep(includeInactive, pm.checkCanceled().next());
            plog.stop();
            plog.start(plog.debug("get current artifacts"));
            try {
                listHave = CacheManager.this.getArtifacts(pm.checkCanceled().next());
            }
            catch (CoreException e) {
                log.debug("Error from getArtifacts: {0}", new Object[]{e});
                throw e;
            }
            plog.stop();
            plog.start(plog.debug("computing artifacts to remove"));
            LinkedHashSet<IArtifact> have = new LinkedHashSet<IArtifact>(listHave);
            int n = Math.max(have.size() - need.size(), 0);
            PurgeableArtifacts purgeableArtifacts = new PurgeableArtifacts(CacheManager.this, n);
            this.computeArtifactsToRemove(need, have, purgeableArtifacts, pm.checkCanceled().next());
            PurgeableFiles purgeable = new PurgeableFiles();
            purgeable.addPurgeable(CacheManager.getAllIncompleteDownloads(CacheManager.this));
            purgeable.addPurgeable(purgeableArtifacts);
            plog.stop();
            pm.checkCanceled().done();
            purgeable.logDebug();
            return purgeable;
        }

        private void computeArtifactsToRemove(Set<IArtifact> need, Collection<IArtifact> have, PurgeableArtifacts purgeable, IProgressMonitor monitor) {
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, have.size());
            for (IArtifact artifact : have) {
                if (!need.contains(artifact)) {
                    try {
                        purgeable.addArtifact(artifact, pm.next());
                    }
                    catch (CacheManagerException e) {
                        log.status(e.getStatus());
                    }
                }
                if (monitor.isCanceled()) break;
            }
            pm.done();
        }

        private Set<IArtifact> getArtifactsToKeep(boolean activeOnly, IProgressMonitor monitor) {
            LinkedHashSet<IArtifact> result = new LinkedHashSet<IArtifact>(1024);
            InstallRegistry.ProfileInstallRegistry[] registries = CacheManager.this.getProfileInstallRegistries();
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, registries.length);
            InstallRegistry.ProfileInstallRegistry[] profileInstallRegistryArray = registries;
            int n = registries.length;
            int n2 = 0;
            while (n2 < n) {
                InstallRegistry.ProfileInstallRegistry registry = profileInstallRegistryArray[n2];
                if (registry.isEmpty()) {
                    new PreservedArtifacts(registry).delete();
                } else {
                    result.addAll(this.getArtifactsToKeep(activeOnly, registry, pm.next()));
                }
                ++n2;
            }
            plog.debug("activeOnly: {0}", new Object[]{activeOnly});
            plog.debug("{0} artifacts to keep", new Object[]{result.size()});
            return result;
        }

        private Collection<IArtifact> getArtifactsToKeep(boolean activeOnly, InstallRegistry.ProfileInstallRegistry registry, IProgressMonitor monitor) {
            PreservedArtifacts preservedArtifacts = new PreservedArtifacts(registry);
            List<IArtifact> cached = preservedArtifacts.get(activeOnly);
            if (cached != null) {
                this.checkArtifactsToKeep(activeOnly, cached, registry, monitor);
                return cached;
            }
            Collection<IArtifact> result = this.getArtifactsToKeepUncached(activeOnly, registry, monitor);
            preservedArtifacts.save(result, activeOnly);
            return result;
        }

        private void checkArtifactsToKeep(boolean activeOnly, Collection<IArtifact> cached, InstallRegistry.ProfileInstallRegistry registry, IProgressMonitor monitor) {
            HashSet<IArtifact> cachedSet;
            if (!AgentUserOptions.CIC_CACHE_CHECK_ARTIFACTS_TO_KEEP.isSet()) {
                return;
            }
            Collection<IArtifact> computed = this.getArtifactsToKeepUncached(activeOnly, registry, monitor);
            if (!computed.equals(cachedSet = new HashSet<IArtifact>(cached))) {
                Set missing = Util.setDiff(computed, cachedSet);
                Set extra = Util.setDiff(cachedSet, computed);
                log.error("Missing:\n{0}", new Object[]{Util.toString((Collection)missing, (Util.Formatter)new Util.Formatter("\n"))});
                log.error("Extra:\n{0}", new Object[]{Util.toString((Collection)extra, (Util.Formatter)new Util.Formatter("\n"))});
                throw new AssertionError((Object)"Wrong cached artifacts");
            }
        }

        private Collection<IArtifact> getNeededArtifactsUncached(InstallRegistry.ProfileInstallRegistry registry, IProgressMonitor monitor) {
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
            Collection<IInstallableUnit> installedIUs = registry.getAllInstalledIUs(pm.next());
            HashSet<IInstallableUnit> neededIUs = new HashSet<IInstallableUnit>(2 * installedIUs.size());
            neededIUs.addAll(installedIUs);
            CacheManager.this.addNeededIUs(neededIUs, registry, pm.next());
            return this.getArtifactsForIUs(neededIUs, false);
        }

        private Collection<IArtifact> getArtifactsToKeepUncached(boolean activeOnly, InstallRegistry.ProfileInstallRegistry registry, IProgressMonitor monitor) {
            return activeOnly ? this.getActiveArtifactsUncached(registry, monitor) : this.getNeededArtifactsUncached(registry, monitor);
        }

        private Collection<IArtifact> getActiveArtifactsUncached(InstallRegistry.ProfileInstallRegistry registry, IProgressMonitor monitor) {
            Collection<IInstallableUnit> installedIUs = registry.getAllInstalledIUs(monitor);
            return this.getArtifactsForIUs(installedIUs, true);
        }

        private Collection<IArtifact> getArtifactsForIUs(Collection<IInstallableUnit> ius, boolean activeOnly) {
            LinkedHashSet<IArtifact> result = new LinkedHashSet<IArtifact>(ius.size());
            for (IInstallableUnit iu : ius) {
                result.addAll(this.getArtifactsForIU(iu, activeOnly));
            }
            return result;
        }

        private List<IArtifact> getArtifactsForIU(IInstallableUnit iu, boolean activeOnly) {
            IAdapterData adapterData = iu.getAdapterData();
            Collection artifacts = adapterData.getArtifacts();
            ArrayList<IArtifact> activeNativeZips = new ArrayList<IArtifact>(artifacts.size());
            ArrayList<IArtifact> result = new ArrayList<IArtifact>(artifacts.size());
            for (IArtifact artifact : artifacts) {
                boolean isActive = adapterData.isActiveArtifact(artifact);
                if (activeOnly && !isActive) continue;
                result.add(artifact);
                if (!isActive || !this.isNativeZip(artifact)) continue;
                activeNativeZips.add(artifact);
            }
            this.logActiveNativeZips(iu, activeNativeZips);
            return result;
        }

        private boolean isNativeZip(IArtifact artifact) {
            IArtifactKey key = artifact.getKey();
            return key.getNamespace().equals("native") && key.getQualifier().equals("zip");
        }

        private void logActiveNativeZips(IInstallableUnit iu, List<IArtifact> activeNativeZips) {
            if (!log.isDebugLoggable() || activeNativeZips.isEmpty()) {
                return;
            }
            String orderDependenciesValue = InstallableUnitUtil.getOrderDependenciesValue((IInstallableUnit)iu);
            if (orderDependenciesValue.length() > 0) {
                String msg = NLS.bind((String)"Native zip artifacts needed due to {0}={1} of {2}:", (Object[])new Object[]{"order.dependencies", orderDependenciesValue, iu});
                CacheManager.logArtifacts(msg, activeNativeZips);
            } else {
                String msg = "Native zip artifacts needed (possibly due to phases):";
                CacheManager.logArtifacts(msg, activeNativeZips);
                log.debug(iu.getAdapterData().toXML(false));
            }
        }

        private class PreservedArtifacts {
            private final Logger palog = Logger.getLogger();
            private static final String SEPARATOR = ",";
            private final Util.Formatter FORMATTER = new Util.Formatter(",");
            private static final String NL_PROPERTY = ".nl";
            private static final String COUNT_PROPERTY = ".count";
            private static final String OFFERING_PREFIX = ".offering.";
            private static final String FIX_PREFIX = ".fix.";
            private static final String ID_SUFFIX = ".id";
            private static final String VERSION_SUFFIX = ".version";
            private static final String FEATURES_SUFFIX = ".features";
            private final InstallRegistry.ProfileInstallRegistry registry;
            private final String profileId;
            private final File dir;

            PreservedArtifacts(InstallRegistry.ProfileInstallRegistry registry) {
                this.registry = registry;
                this.profileId = registry.getProfileId();
                this.dir = CacheManager.this.getExtraSubdir("preserve/" + this.profileId);
            }

            public String toString() {
                return "PreservedArtifacts for " + this.profileId;
            }

            void delete() {
                assert (this.registry.isEmpty());
                FileUtil.rm_r((File)this.dir, (boolean)true);
                this.dir.getParentFile().delete();
            }

            List<IArtifact> get(boolean activeOnly) {
                IArtifact[] artifacts;
                block7: {
                    if (this.registry.isEmpty()) {
                        return Collections.emptyList();
                    }
                    File file = this.getFile(activeOnly);
                    if (!file.exists()) {
                        this.palog.debug("No cached artifacts for {0} due to {1} not found", new Object[]{this.profileId, file.getName()});
                        return null;
                    }
                    try {
                        Properties props = FileUtil.readProperties((File)file);
                        TreeMap<String, String> prevInstalled = new TreeMap<String, String>();
                        artifacts = new IArtifact[Integer.parseInt(props.getProperty(COUNT_PROPERTY))];
                        props.remove(COUNT_PROPERTY);
                        for (Map.Entry entry : FileUtil.toMap((Properties)props).entrySet()) {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            if (Character.isDigit(key.charAt(0))) {
                                IArtifact artifact;
                                artifacts[Integer.parseInt((String)key)] = artifact = this.fromPersistentString(value);
                                continue;
                            }
                            prevInstalled.put(key, value);
                        }
                        SortedMap<String, String> currInstalled = this.getInstalledProperties();
                        if (((Object)prevInstalled).equals(currInstalled)) break block7;
                        this.palog.debug("Not using cached artifacts for {0} due to installed state:", new Object[]{this.profileId});
                        this.palog.debug("Old: {0}", new Object[]{prevInstalled});
                        this.palog.debug("New: {0}", new Object[]{currInstalled});
                        return null;
                    }
                    catch (IOException e) {
                        log.warning(Messages.CacheManager_Error_Reading, new Object[]{file, e});
                        return null;
                    }
                }
                this.palog.debug("Using cached artifacts for {0}", new Object[]{this.profileId});
                return Arrays.asList(artifacts);
            }

            void save(Collection<IArtifact> artifacts, boolean activeOnly) {
                if (artifacts.isEmpty()) {
                    return;
                }
                SortedProperties props = new SortedProperties();
                props.putAll((Map<?, ?>)this.getInstalledProperties());
                props.setProperty(COUNT_PROPERTY, Integer.toString(artifacts.size()));
                int i = 0;
                for (IArtifact artifact : artifacts) {
                    props.setProperty(Integer.toString(i++), this.toPersistentString(artifact));
                }
                File file = this.getFile(activeOnly);
                file.getParentFile().mkdirs();
                try {
                    FileUtil.writeProperties((File)file, (Properties)props);
                }
                catch (IOException e) {
                    log.warning(Messages.CacheManager_Error_Writing, new Object[]{file, e});
                }
            }

            private SortedMap<String, String> getInstalledProperties() {
                TreeMap<String, String> result = new TreeMap<String, String>();
                IOffering[] offerings = this.registry.getInstalledOfferings();
                int i = 0;
                while (i < offerings.length) {
                    IOffering offering = offerings[i];
                    String prefix = OFFERING_PREFIX + i;
                    result.put(String.valueOf(prefix) + ID_SUFFIX, offering.getIdentity().getId());
                    result.put(String.valueOf(prefix) + VERSION_SUFFIX, offering.getVersion().toString());
                    result.put(String.valueOf(prefix) + FEATURES_SUFFIX, Util.toString(this.registry.getInstalledFeatureIds(offering), (Util.Formatter)this.FORMATTER));
                    ++i;
                }
                IFix[] fixes = this.registry.getInstalledFixes();
                int i2 = 0;
                while (i2 < fixes.length) {
                    IFix fix = fixes[i2];
                    String prefix = FIX_PREFIX + i2;
                    result.put(String.valueOf(prefix) + ID_SUFFIX, fix.getIdentity().getId());
                    result.put(String.valueOf(prefix) + VERSION_SUFFIX, fix.getVersion().toString());
                    ++i2;
                }
                String nl = this.registry.getProfile().getData("cic.selector.nl");
                result.put(NL_PROPERTY, nl != null ? nl : "");
                return result;
            }

            private File getFile(boolean activeOnly) {
                return new File(this.dir, String.valueOf(activeOnly ? "active" : "needed") + ".properties");
            }

            private String toPersistentString(IArtifact artifact) {
                IArtifactKey key = artifact.getKey();
                return Util.toString((Object[])new Object[]{key.getPath().toPortableString(), key.getNamespace(), key.getQualifier(), key.getId(), key.getVersion(), artifact.isExploded()}, (Util.Formatter)this.FORMATTER);
            }

            private IArtifact fromPersistentString(String string) {
                String[] parts = string.split(SEPARATOR);
                assert (parts.length == 6);
                return new KeyBasedArtifact((IArtifactKey)new ArtifactKey(Path.fromPortableString((String)parts[0]), parts[1], parts[2], (IIdentity)new SimpleIdentity(parts[3]), new Version(parts[4])), Boolean.valueOf(parts[5]).booleanValue());
            }
        }
    }

    private static class CollectInfo {
        final Profile profile;
        final IAlternativeRepositories alternativeRepositories;
        final VisibleDiskSetsUtil diskSetUtil;

        CollectInfo(Profile profile, IAlternativeRepositories alternativeRepositories, VisibleDiskSetsUtil diskSetUtil) {
            this.profile = profile;
            this.alternativeRepositories = alternativeRepositories;
            this.diskSetUtil = diskSetUtil;
        }
    }

    private static class DirectAccessInfo {
        final IRepository repo;
        final IArtifactOperation.IArtifactOperationRecord record;

        DirectAccessInfo(IRepository repo, IArtifactOperation.IArtifactOperationRecord record) {
            this.repo = repo;
            this.record = record;
        }
    }

    private static class DirectoryDeleter {
        private final File deletionDir;
        private int next;

        DirectoryDeleter(File deletionDir) {
            this.deletionDir = deletionDir;
            this.deletionDir.mkdirs();
            String[] list = this.deletionDir.list();
            this.next = 0;
            if (list != null) {
                String[] stringArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    try {
                        int j = Integer.parseInt(element);
                        if (j >= this.next) {
                            this.next = j + 1;
                        }
                    }
                    catch (NumberFormatException e) {
                        ExceptionUtil.debugLogToReview((Throwable)e);
                    }
                    ++n2;
                }
            }
        }

        void cleanup(IProgressMonitor monitor) {
            FileUtil.rm_r((File)this.deletionDir, (boolean)true, (IProgressMonitor)monitor);
        }

        void delete(File dir, IProgressMonitor monitor) {
            if (!dir.exists()) {
                return;
            }
            File deletion = this.moveToDeletionDir(dir);
            if (deletion != null) {
                FileUtil.rm_r((File)deletion, (boolean)true, (IProgressMonitor)monitor);
            }
        }

        private File moveToDeletionDir(File dir) {
            int i = 0;
            while (i < 100) {
                File deletion;
                if (!(deletion = new File(this.deletionDir, Integer.toString(this.next++))).exists()) {
                    if (dir.renameTo(deletion)) {
                        return deletion;
                    }
                    if (!deletion.exists()) {
                        return null;
                    }
                }
                ++i;
            }
            return null;
        }
    }

    private static class Exploder {
        private Exploder() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static File explodeFile(File file, String destRoot, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
            File dest = Exploder.getLocation(destRoot, artifact);
            if (!dest.exists()) {
                String path = file.getPath();
                String suffix = FileName.getSuffix((String)path);
                if (CicConstants.getZipFileDotExt().equalsIgnoreCase(suffix)) {
                    Exploder.explodeZip(file, dest, artifact, monitor);
                    return dest;
                } else {
                    if (!CicConstants.getJarFileDotExt().equalsIgnoreCase(suffix)) throw new CacheManagerException(Messages.CacheManager_Dont_Know_How_To_Explode, file);
                    Exploder.explodeJar(file, dest, artifact, monitor);
                }
                return dest;
            } else {
                if (dest.isDirectory()) return dest;
                throw new CacheManagerException(Messages.CacheManager_File_Already_Exists_In_Exploded_Location, dest);
            }
        }

        private static File getLocation(String destRoot, IArtifact artifact) {
            String path = artifact.toNamespaceUniquePath().toOSString();
            String suffix = FileName.getSuffix((String)path);
            return new File(destRoot, path.substring(0, path.length() - suffix.length()));
        }

        static File getLocation(File file) {
            String path = file.getPath();
            String suffix = FileName.getSuffix((String)path);
            return new File(path.substring(0, path.length() - suffix.length()));
        }

        private static void explodeJar(File file, File dest, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
            Exploder.explodeZip(file, dest, artifact, monitor);
        }

        private static void explodeZip(File file, File dest, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
            IStatus status;
            log.debug("Exploding {0}", new Object[]{artifact});
            String msg = NLS.bind((String)Messages.CacheManager_Extracting, (Object)artifact.toUserString());
            File explodedArtifact = AgentInstall.getInstance().getExplodedInstallerArtifact(file);
            if (explodedArtifact != null) {
                status = AgentInstall.getInstance().installExplodedInstallerArtifact(explodedArtifact, dest, msg, monitor);
            } else {
                boolean sync = true;
                status = Util.unzipFile((boolean)true, (File)file, (File)dest, (String)msg, (boolean)sync, (IProgressMonitor)monitor);
            }
            if (!status.isOK()) {
                FileUtil.rm_r((File)dest, (boolean)true);
                throw new CacheManagerException(status);
            }
        }
    }

    public static interface IArtifactsToDownload
    extends Agent.IAssignedArtifacts {
        public ArtifactsToDownload download(CicMultiStatus var1, AgentJob[] var2, CacheManager var3, IProgressMonitor var4);
    }

    private static interface ILogDebug {
        public void logDebug();
    }

    public static interface IStoredArtifacts {
        public int getArtifactsCount();

        public Collection<IArtifact> getArtifacts();

        public long getStoredSize(IArtifact var1);

        public long getTotalStoredSize();

        public IStatus purge(CacheManager var1, IProgressMonitor var2);
    }

    private class OnDemandFetching {
        private final ArtifactsToDownload atdOnDemand;
        private final ProvideAlternativeRepositories sharedRepoProvider;

        OnDemandFetching(ArtifactsToDownload atd) {
            IAlternativeRepositories prevAltRepo = atd.getAlternativeRepos();
            if (prevAltRepo instanceof ProvideAlternativeRepositories) {
                this.sharedRepoProvider = (ProvideAlternativeRepositories)prevAltRepo;
                this.atdOnDemand = new ArtifactsToDownload(this.sharedRepoProvider, null);
            } else {
                ProvideAlternativeRepositories onDemandAltRepo = new ProvideAlternativeRepositories(CacheManager.this.getProvideAlternativeRepoHelper(), true);
                this.atdOnDemand = new ArtifactsToDownload(onDemandAltRepo, null);
                this.sharedRepoProvider = null;
            }
        }

        void begin() {
            if (this.sharedRepoProvider != null) {
                this.sharedRepoProvider.setWantAbort(true);
            }
        }

        void end() {
            if (this.sharedRepoProvider != null) {
                this.sharedRepoProvider.setWantAbort(false);
            }
        }

        ArtifactsToDownload getArtifactsToDownload() {
            return this.atdOnDemand;
        }
    }

    private static class PurgeableArtifacts
    implements Agent.IPurgeableFiles,
    IAdaptable,
    ILogDebug {
        private final CacheManager cm;
        private final StoredArtifacts storedArtifacts;

        PurgeableArtifacts(CacheManager cm, int capacity) {
            this.cm = cm;
            this.storedArtifacts = new StoredArtifacts(capacity);
        }

        void addArtifact(IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
            this.storedArtifacts.addArtifact(this.cm, artifact, monitor);
        }

        @Override
        public int getFileCount() {
            return this.storedArtifacts.getFileCount();
        }

        @Override
        public long getTotalSize() {
            return this.storedArtifacts.getTotalStoredSize();
        }

        @Override
        public IStatus purgeFiles(IProgressMonitor monitor) {
            boolean opened = false;
            if (!this.cm.isOpen()) {
                try {
                    this.cm.open();
                    opened = true;
                }
                catch (CacheManagerException e) {
                    return e.getStatus();
                }
            }
            try {
                this.cm.openArtifactSession();
                IStatus iStatus = this.storedArtifacts.purge(this.cm, (IProgressMonitor)new WebUiSafeProgressMonitor(monitor));
                return iStatus;
            }
            finally {
                this.cm.closeArtifactSession();
                if (opened) {
                    this.cm.close();
                }
            }
        }

        public String toString() {
            return "PurgeableArtifacts: " + this.getFileCount() + " files; " + this.getTotalSize() + " bytes";
        }

        @Deprecated
        public Object getAdapter(Class adapter) {
            if (adapter == Agent.IPurgeableFiles.class) {
                return this;
            }
            if (adapter == IStoredArtifacts.class) {
                return this.storedArtifacts;
            }
            return null;
        }

        @Override
        public void logDebug() {
            this.storedArtifacts.logDebug();
        }
    }

    private static class PurgeableDownloadsInProgress
    implements Agent.IPurgeableFiles,
    ILogDebug {
        private final List<DownloadInProgressManager.IDownloadInProgress> dips;
        private long totalSize;

        PurgeableDownloadsInProgress(List<DownloadInProgressManager.IDownloadInProgress> dips) {
            this.dips = dips;
            this.totalSize = 0L;
            for (DownloadInProgressManager.IDownloadInProgress dlr : dips) {
                this.totalSize += dlr.getInProgressLocation().toFile().length();
            }
        }

        @Override
        public int getFileCount() {
            return this.dips.size();
        }

        @Override
        public long getTotalSize() {
            return this.totalSize;
        }

        @Override
        public IStatus purgeFiles(IProgressMonitor monitor) {
            for (DownloadInProgressManager.IDownloadInProgress dlr : this.dips) {
                File file = dlr.getInProgressLocation().toFile();
                long len = file.length();
                DownloadInProgressManager.INSTANCE.release(dlr);
                this.totalSize -= len;
            }
            this.dips.clear();
            return Status.OK_STATUS;
        }

        public String toString() {
            return "PurgeableDownloadsInProgress: " + this.getFileCount() + " files totalSize=" + this.getTotalSize() + " bytes";
        }

        @Override
        public void logDebug() {
            log.debug((Object)this);
        }
    }

    private static class PurgeableFile
    implements Agent.IPurgeableFiles,
    ILogDebug {
        private final List<File> files;
        private long totalSize;

        PurgeableFile(List<File> files) {
            this.files = files;
            this.totalSize = 0L;
            for (File file : files) {
                this.totalSize += file.length();
            }
        }

        @Override
        public int getFileCount() {
            return this.files.size();
        }

        @Override
        public long getTotalSize() {
            return this.totalSize;
        }

        @Override
        public IStatus purgeFiles(IProgressMonitor monitor) {
            for (File file : this.files) {
                long len = file.length();
                FileUtil.rm((File)file);
                this.totalSize -= len;
            }
            this.files.clear();
            return Status.OK_STATUS;
        }

        public String toString() {
            return "PurgeableFile: " + this.getFileCount() + " files totalSize=" + this.getTotalSize() + " bytes";
        }

        @Override
        public void logDebug() {
            log.debug((Object)this);
        }
    }

    private static class PurgeableFiles
    implements Agent.IPurgeableFiles,
    IAdaptable {
        private final List<Agent.IPurgeableFiles> purgeables = new ArrayList<Agent.IPurgeableFiles>();

        PurgeableFiles() {
        }

        void addPurgeable(Agent.IPurgeableFiles purgeable) {
            this.purgeables.add(purgeable);
        }

        @Override
        public int getFileCount() {
            int n = 0;
            for (Agent.IPurgeableFiles p : this.purgeables) {
                n += p.getFileCount();
            }
            return n;
        }

        @Override
        public long getTotalSize() {
            long sz = 0L;
            for (Agent.IPurgeableFiles p : this.purgeables) {
                sz += p.getTotalSize();
            }
            return sz;
        }

        @Override
        public IStatus purgeFiles(IProgressMonitor monitor) {
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            for (Agent.IPurgeableFiles p : this.purgeables) {
                status.add(p.purgeFiles(monitor));
                if (!status.matches(8)) continue;
                return status;
            }
            return status;
        }

        public String toString() {
            return "PurgeableFiles: " + this.getFileCount() + " files; " + this.getTotalSize() + " bytes";
        }

        @Deprecated
        public Object getAdapter(Class adapter) {
            if (adapter == Agent.IPurgeableFiles.class) {
                return this;
            }
            for (Agent.IPurgeableFiles purgeable : this.purgeables) {
                IAdaptable adaptable;
                Object adapterObj;
                if (!(purgeable instanceof IAdaptable) || (adapterObj = (adaptable = (IAdaptable)purgeable).getAdapter(adapter)) == null) continue;
                return adapterObj;
            }
            return null;
        }

        void logDebug() {
            for (Agent.IPurgeableFiles purgeable : this.purgeables) {
                if (!(purgeable instanceof ILogDebug)) continue;
                ILogDebug ld = (ILogDebug)((Object)purgeable);
                ld.logDebug();
            }
        }
    }

    private static class StoredArtifacts
    implements IStoredArtifacts {
        private final Map<IArtifact, StoredInfo> storedInfo;
        private long totalSize = 0L;

        StoredArtifacts(int capacity) {
            this.storedInfo = new HashMap<IArtifact, StoredInfo>(capacity);
        }

        void addArtifact(CacheManager cm, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
            StoredInfo si;
            if (!this.storedInfo.containsKey(artifact) && (si = this.determineStoredInfo(cm, artifact, monitor)) != null) {
                this.storedInfo.put(artifact, si);
                this.totalSize += si.getTotalSize();
            }
        }

        private StoredInfo determineStoredInfo(CacheManager cm, IArtifact artifact, IProgressMonitor monitor) throws CacheManagerException {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            try {
                if (artifact.isExploded()) {
                    File file;
                    long sizeExploded = 0L;
                    long sizeNotYetExploded = 0L;
                    File explodedLoc = cm.getExistingExplodedLocation(artifact);
                    if (explodedLoc != null) {
                        sizeExploded = FileUtil.getFileSizeOnDisk4kBlocks((File)explodedLoc);
                    }
                    if ((file = cm.getLocationNoExplode(artifact, false)).exists() && !cm.haveArtifactInOppositeExplodedState(artifact, (IProgressMonitor)sm.newChild(1))) {
                        sizeNotYetExploded = file.length();
                    }
                    StoredInfo storedInfo = StoredInfo.createStoredInfoForExploded(sizeExploded, sizeNotYetExploded);
                    return storedInfo;
                }
                long size = 0L;
                File file = cm.getLocationNoExplode(artifact, false);
                if (file.exists()) {
                    size += file.length();
                }
                StoredInfo storedInfo = StoredInfo.createStoredInfoForUnexploded(size);
                return storedInfo;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }

        private void removeArtifacts(Collection<IArtifact> toRemove) {
            for (IArtifact artifact : toRemove) {
                StoredInfo storedInfoRemoved = this.storedInfo.remove(artifact);
                if (storedInfoRemoved == null) continue;
                this.totalSize -= storedInfoRemoved.getTotalSize();
                log.debug("Removed {0}, {1}", new Object[]{artifact, storedInfoRemoved});
            }
        }

        int getFileCount() {
            return this.storedInfo.size();
        }

        @Override
        public long getTotalStoredSize() {
            return this.totalSize;
        }

        @Override
        public long getStoredSize(IArtifact artifact) {
            return this.getStoredInfo(artifact).getTotalSize();
        }

        private StoredInfo getStoredInfo(IArtifact artifact) {
            return this.storedInfo.get(artifact);
        }

        @Override
        public IStatus purge(CacheManager cm, IProgressMonitor amonitor) {
            plog.start(plog.debug("cleaning up artifacts"));
            SplitProgressMonitor pm = new SplitProgressMonitor(amonitor, Messages.CacheManager_Cleaning_Up_Downloaded_Artifacts, 2);
            pm.subTask(Messages.CacheManager_Cleaning_Up_Downloaded_Artifacts);
            List<IArtifact> exploded = this.getArtifacts(true);
            List<IArtifact> unexploded = this.getArtifacts(false);
            this.removeArtifacts(cm.doRemoveExplodedArtifacts(exploded, pm.next()));
            this.removeArtifacts(cm.doRemoveArtifacts(unexploded, pm.next()));
            plog.stop();
            CheckConsistency.purgeCheckConsistencyExceptions(cm);
            return amonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        void logDebug() {
            if (log.isDebugLoggable()) {
                CacheManager.logArtifacts("exploded artifacts to remove", this.getArtifacts(true));
                CacheManager.logArtifacts("artifacts to remove", this.getArtifacts(false));
            }
        }

        private List<IArtifact> getArtifacts(boolean wantExploded) {
            Set<IArtifact> artifacts = this.storedInfo.keySet();
            ArrayList<IArtifact> result = new ArrayList<IArtifact>(artifacts.size());
            for (IArtifact artifact : artifacts) {
                if (artifact.isExploded() != wantExploded) continue;
                result.add(artifact);
            }
            return result;
        }

        @Override
        public Collection<IArtifact> getArtifacts() {
            return Collections.unmodifiableCollection(this.storedInfo.keySet());
        }

        @Override
        public int getArtifactsCount() {
            return this.storedInfo.size();
        }
    }

    private static class StoredInfo {
        private final long storedExplodedSize;
        private final long storedUnexplodedSize;

        static StoredInfo createStoredInfoForUnexploded(long size) {
            return new StoredInfo(0L, size);
        }

        static StoredInfo createStoredInfoForExploded(long sizeExploded, long sizeNotYetExploded) {
            return new StoredInfo(sizeExploded, sizeNotYetExploded);
        }

        private StoredInfo(long storedExplodedSize, long storedUnexplodedSize) {
            this.storedExplodedSize = storedExplodedSize;
            this.storedUnexplodedSize = storedUnexplodedSize;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("storedExplodedSize: ");
            sb.append(this.storedExplodedSize);
            sb.append(" storedUnexplodedSize: ");
            sb.append(this.storedUnexplodedSize);
            return sb.toString();
        }

        long getTotalSize() {
            return this.storedExplodedSize + this.storedUnexplodedSize;
        }
    }
}

