/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AgentRegressingUpdateWarningUtil {
    private static void storeProblemsToMap(IOfferingOrFix[] packages, HashMap problemsMap) {
        IOfferingOrFix[] iOfferingOrFixArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix p = iOfferingOrFixArray[n2];
            List problemsResolvedList = p.getProblemsResolvedList();
            if (problemsResolvedList.size() > 0) {
                IProblemsResolved problems = (IProblemsResolved)problemsResolvedList.get(0);
                List problemsList = problems.getProblems();
                for (IProblemResolved problemResolved : problemsList) {
                    ArrayList<IOfferingOrFix> packagesList = (ArrayList<IOfferingOrFix>)problemsMap.get(problemResolved);
                    if (packagesList == null) {
                        packagesList = new ArrayList<IOfferingOrFix>();
                        problemsMap.put(problemResolved, packagesList);
                    }
                    packagesList.add(p);
                }
            }
            ++n2;
        }
    }

    private static HashMap getProblemsInstalledInPackages(Agent agent, Profile profile) {
        HashMap problemsMap = new HashMap();
        AgentRegressingUpdateWarningUtil.storeProblemsToMap((IOfferingOrFix[])agent.getInstalledOfferings(profile), problemsMap);
        AgentRegressingUpdateWarningUtil.storeProblemsToMap((IOfferingOrFix[])agent.getInstalledFixes(profile), problemsMap);
        return problemsMap;
    }

    private static HashMap getProblemsUnderOfferings(Agent agent, Profile profile) {
        IOffering[] installedOfferings;
        HashMap problemsMap = new HashMap();
        AgentRegressingUpdateWarningUtil.storeProblemsToMap((IOfferingOrFix[])agent.getInstalledOfferings(profile), problemsMap);
        IOffering[] iOfferingArray = installedOfferings = agent.getInstalledOfferings(profile);
        int n = installedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IFix[] installedFixes;
            IOffering installedOffering = iOfferingArray[n2];
            IFix[] iFixArray = installedFixes = agent.getInstalledFixes(profile, installedOffering);
            int n3 = installedFixes.length;
            int n4 = 0;
            while (n4 < n3) {
                IFix fix = iFixArray[n4];
                List problemsResolvedList = fix.getProblemsResolvedList();
                if (problemsResolvedList.size() > 0) {
                    IProblemsResolved problems = (IProblemsResolved)problemsResolvedList.get(0);
                    List problemsList = problems.getProblems();
                    for (IProblemResolved problemResolved : problemsList) {
                        ArrayList<IOffering> packagesList = (ArrayList<IOffering>)problemsMap.get(problemResolved);
                        if (packagesList == null) {
                            packagesList = new ArrayList<IOffering>();
                            problemsMap.put(problemResolved, packagesList);
                        }
                        if (packagesList.contains(installedOffering)) continue;
                        packagesList.add(installedOffering);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return problemsMap;
    }

    private static Set getProblems(List<IOfferingOrFix> packages) {
        HashSet<IProblemResolved> problemsSet = new HashSet<IProblemResolved>();
        for (IOfferingOrFix offeringOrFix : packages) {
            List problemsResolvedList = offeringOrFix.getProblemsResolvedList();
            if (problemsResolvedList.size() <= 0) continue;
            IProblemsResolved problems = (IProblemsResolved)problemsResolvedList.get(0);
            List pList = problems.getProblems();
            for (IProblemResolved problemResolved : pList) {
                problemsSet.add(problemResolved);
            }
        }
        return problemsSet;
    }

    private static List getEnabledRegressingUpdateWarningOfferings(List packages) {
        ArrayList<IOffering> offeringsList = new ArrayList<IOffering>();
        int i = 0;
        while (i < packages.size()) {
            IOffering offering;
            if (packages.get(i) instanceof IOffering && OfferingProperty.enableRegressingUpdateWarning((IOffering)(offering = (IOffering)packages.get(i)))) {
                offeringsList.add(offering);
            }
            ++i;
        }
        return offeringsList;
    }

    private static IOffering findOffering(List<IOffering> offerings, String offeringId) {
        for (IOffering offering : offerings) {
            if (!offering.getIdentity().getId().equals(offeringId)) continue;
            return offering;
        }
        return null;
    }

    private static boolean hasUpdateJob(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            if (job.isUpdate()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String getWarning(IProblemResolved problem, IOfferingOrFix offeringOrFix, boolean showInternalVersion) {
        if (offeringOrFix instanceof IOffering) {
            return NLS.bind((String)Messages.Director_removedProblemInOffering, (Object)problem.getDisplayId(), (Object)OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix, (boolean)showInternalVersion));
        }
        return NLS.bind((String)Messages.Director_removedProblemInPackage, (Object)problem.getDisplayId(), (Object)offeringOrFix.getName());
    }

    public static IStatus checkRegressingUpdateWarning(Agent agent, AgentJob[] jobs, boolean showPackageGroupName, boolean showInternalVersion) {
        CicMultiStatus warning = Statuses.ST.createMultiStatus();
        if (!AgentRegressingUpdateWarningUtil.hasUpdateJob(jobs)) {
            return warning;
        }
        Profile profile = jobs[0].getProfile();
        HashMap problemsInPackagesBeforeUpdate = AgentRegressingUpdateWarningUtil.getProblemsInstalledInPackages(agent, profile);
        HashMap problemsUnderOfferingsBeforeUpdate = AgentRegressingUpdateWarningUtil.getProblemsUnderOfferings(agent, profile);
        ArrayList<IOfferingOrFix> expectedPackages = new ArrayList<IOfferingOrFix>();
        AgentUtil.getResultingOfferingsAndFixesAndChanges(profile, jobs, false, expectedPackages, new ArrayList());
        Set problemsAfterUpdate = AgentRegressingUpdateWarningUtil.getProblems(expectedPackages);
        List offeringsEnabledWarning = AgentRegressingUpdateWarningUtil.getEnabledRegressingUpdateWarningOfferings(expectedPackages);
        HashMap<IOffering, ArrayList<String>> warningsMap = new HashMap<IOffering, ArrayList<String>>();
        for (Map.Entry entry : problemsUnderOfferingsBeforeUpdate.entrySet()) {
            IProblemResolved problem = (IProblemResolved)entry.getKey();
            if (problemsAfterUpdate.contains(problem)) continue;
            List offerings = (List)entry.getValue();
            for (IOffering offering : offerings) {
                IOffering offeringEnabledWarning = AgentRegressingUpdateWarningUtil.findOffering(offeringsEnabledWarning, offering.getIdentity().getId());
                if (offeringEnabledWarning == null) continue;
                List packages = (List)problemsInPackagesBeforeUpdate.get(problem);
                for (IOfferingOrFix p : packages) {
                    ArrayList<String> warningsList = (ArrayList<String>)warningsMap.get(offeringEnabledWarning);
                    if (warningsList == null) {
                        warningsList = new ArrayList<String>();
                        warningsMap.put(offeringEnabledWarning, warningsList);
                    }
                    warningsList.add(AgentRegressingUpdateWarningUtil.getWarning(problem, p, showInternalVersion));
                }
            }
        }
        Collator collator = Collator.getInstance();
        Iterator i = warningsMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            IOffering offering = (IOffering)entry.getKey();
            List warningList = (List)entry.getValue();
            StringBuffer sb = new StringBuffer(350 + 100 * warningList.size());
            if (showPackageGroupName) {
                sb.append(NLS.bind((String)Messages.Director_problemsWillBeRemovedWithPackageGroup, (Object[])new Object[]{offering.getName(), profile.getProfileId(), OfferingUtil.getOfferingOrFixVersion((IOfferingOrFix)offering, (boolean)showInternalVersion)}));
            } else {
                sb.append(NLS.bind((String)Messages.Director_problemsWillBeRemoved, (Object)offering.getName(), (Object)OfferingUtil.getOfferingOrFixVersion((IOfferingOrFix)offering, (boolean)showInternalVersion)));
            }
            Object[] keys = new CollationKey[warningList.size()];
            int j = 0;
            while (j < warningList.size()) {
                keys[j] = collator.getCollationKey((String)warningList.get(j));
                ++j;
            }
            Arrays.sort(keys);
            Object[] objectArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                sb.append(key.getSourceString());
                ++n2;
            }
            if (i.hasNext()) {
                sb.append("\n");
            }
            warning.add((IStatus)new Status(2, Agent.PI_AGENT, sb.toString()));
        }
        return warning;
    }
}

