/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallOperationEventManager;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactFormatterUtil;
import com.ibm.cic.common.core.model.Action;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.IHasAdapterDataChildren;
import com.ibm.cic.common.core.model.adapterdata.impl.AdapterDataParseUtil;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactReferenceParseUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractInstallOperation
extends SubstitutionOperation
implements IInstallOperation {
    public static final String INSTALLATION_PHASE_VAR = "phase";
    public static final String INSTALLABLE_UNIT_VAR = "unit";
    public static final String UNIT_ID_VAR = "unitId";
    public static final String UNIT_VERSION_VAR = "unitVersion";
    public static final String UNIT_DATA_DIR_VAR = "unitDataDir";
    public static final String ARTIFACT_VAR = "artifact";
    public static final String INSTALLATION_ACTION_VAR = "action";
    private int phase;
    private final IInstallableUnit unit;

    public AbstractInstallOperation(int phase, IInstallableUnit unit, InstallContext context) {
        super(context);
        this.phase = phase;
        this.unit = unit;
    }

    public String toString() {
        return String.valueOf(Phases.phaseToName((int)this.phase)) + ' ' + this.getVersionedUnitId();
    }

    public CommonAdapterData getOperationData() {
        return this.getData();
    }

    public int getPhase() {
        return this.phase;
    }

    public IInstallableUnit getUnit() {
        return this.unit;
    }

    protected abstract CommonAdapterData getData();

    protected boolean shouldPerform() {
        return true;
    }

    protected boolean isUndoable() {
        return this.getInstallContext().isInstallableUnitTransactionUndoable();
    }

    public boolean isUndoing() {
        return this.getInstallContext().isInstallableUnitTransactionUndoing();
    }

    protected abstract IStatus doPerform(IProgressMonitor var1) throws CoreException;

    @Override
    public final IStatus perform(InstallTransaction transaction, IProgressMonitor monitor) {
        if (this.shouldPerform()) {
            IStatus status;
            assert (this.isUndoing() || !transaction.isUndoing());
            CicMultiStatus result = Statuses.ST.createMultiStatus();
            InstallOperationEventManager.IAction finish = InstallOperationEventManager.INSTANCE.perform(this, result, monitor);
            if (result.isErrorOrCancel()) {
                return StatusUtil.toSingleStatus((IStatus)result);
            }
            try {
                status = this.doPerform(monitor);
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            result.add(status);
            result.add(finish.perform(this, status, monitor));
            return StatusUtil.toSingleStatus((IStatus)result);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus undoPerform(InstallTransaction transaction, IProgressMonitor monitor) {
        this.phase = Phases.getUndoPhase((int)this.phase);
        return this.perform(transaction, monitor);
    }

    @Override
    public boolean shouldUndoOnError() {
        return true;
    }

    @Override
    protected String substitute(String variableName, String variableArg, AbstractVariableSubstitution.AllowAbsolutePath allowAbsolutePath) throws AbstractVariableSubstitution.VariableSubstitutionException {
        if (variableName.equals(INSTALLATION_PHASE_VAR)) {
            return Phases.phaseToName((int)this.phase);
        }
        if (variableName.equals(INSTALLABLE_UNIT_VAR)) {
            return this.getVersionedUnitId();
        }
        if (variableName.equals(UNIT_ID_VAR)) {
            return this.unit.getIdentity().getId();
        }
        if (variableName.equals(UNIT_VERSION_VAR)) {
            return this.unit.getVersion().toString();
        }
        if (variableName.equals(UNIT_DATA_DIR_VAR)) {
            return this.getUnitDataDir();
        }
        if (variableName.equals(ARTIFACT_VAR)) {
            return this.getArtifactPath(variableArg, allowAbsolutePath);
        }
        if (variableName.equals(INSTALLATION_ACTION_VAR)) {
            try {
                Action action = this.getIUAction(variableArg);
                if (action != null) {
                    return action.getName();
                }
                throw new AbstractVariableSubstitution.VariableSubstitutionException(NLS.bind((String)Messages.AbstractInstallOperation_cannot_find_action, (Object)variableArg), new Object[0]);
            }
            catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                IStatus stat = e.getStatus();
                if (stat == null) {
                    Logger.getLogger(AbstractInstallOperation.class).status((IStatus)new Status(4, Agent.PI_AGENT, 0, e.getLocalizedMessage(), (Throwable)((Object)e)));
                } else {
                    Logger.getLogger(AbstractInstallOperation.class).status(stat);
                }
                throw e;
            }
        }
        return super.substitute(variableName, variableArg, allowAbsolutePath);
    }

    private String getArtifactPath(String variableArg, AbstractVariableSubstitution.AllowAbsolutePath allowAbsolutePath) throws AbstractVariableSubstitution.VariableSubstitutionException {
        IArtifact artifact = this.getReferencedArtifact(variableArg);
        try {
            File file = CacheManager.getDefaultInstance().getArtifactLocation(this.getUnit(), artifact, null);
            return this.makeRelativeToContextLocationInPortableMode(file.getPath(), allowAbsolutePath);
        }
        catch (CacheManager.CacheManagerException e) {
            String msg = NLS.bind((String)Messages.AbstractInstallOperation_variableEvalErrorGettingFileForInstallation, (Object)AdapterDataParseUtil.getSubstitutionExpression((String)ARTIFACT_VAR, (String)variableArg));
            CicMultiStatus ms = Statuses.ST.createMultiStatusWithChild(e.getStatus(), Messages.AbstractInstallOperation_formatIUAndSentence, new Object[]{this.formatIU(), msg});
            throw new AbstractVariableSubstitution.VariableSubstitutionException((IStatus)ms);
        }
    }

    private String formatIU() {
        return NLS.bind((String)"IU {0}", (Object)IdentityUtil.getQualifiedVersionedId((IInstallableUnit)this.unit));
    }

    private String getDirectAccessErrorMsg(IArtifact artifact) {
        if (CacheManager.supportsDirectAccess(this.unit, artifact)) {
            return NLS.bind((String)Messages.AbstractInstallOperation_cannotAccessAsFileDueToDirectAccessMode, (Object)ArtifactFormatterUtil.toUserString((IArtifactKey)artifact.getKey()));
        }
        return null;
    }

    private IArtifact getReferencedArtifact(String variableArg) throws AbstractVariableSubstitution.VariableSubstitutionException {
        ArtifactReferenceParseUtil.ArtifactVariableEval eval = new ArtifactReferenceParseUtil.ArtifactVariableEval(){

            protected Collection getArtifacts() {
                return new LinkedHashSet(AbstractInstallOperation.this.unit.getAdapterData().getArtifacts());
            }

            protected String getMultipleMatchesExplanation(List matches) {
                return NLS.bind((String)Messages.AbstractInstallOperation_multipleMatchingArtifactsExplanation, (Object)matches.size());
            }

            protected String getNoMatchExplanation() {
                return Messages.AbstractInstallOperation_noMatchingArtifactsExplanation;
            }

            protected void verifyCanAccess(IArtifact artifact) throws ArtifactReferenceParseUtil.ArtifactVariableEvalException {
                String errorMsg = AbstractInstallOperation.this.getDirectAccessErrorMsg(artifact);
                if (errorMsg != null) {
                    throw new ArtifactReferenceParseUtil.ArtifactVariableEvalException(NLS.bind((String)Messages.AbstractInstallOperation_artifactEvaluationFailed, (Object)this.getVariableMsg(), (Object)errorMsg));
                }
            }
        };
        try {
            return eval.getReferencedArtifact(variableArg);
        }
        catch (ArtifactReferenceParseUtil.ArtifactVariableEvalException e) {
            throw new AbstractVariableSubstitution.VariableSubstitutionException(Messages.AbstractInstallOperation_formatIUAndSentence, this.formatIU(), e.getLocalizedMessage());
        }
    }

    private String getUnitDataDir() {
        String unitDataDir = String.valueOf(this.getProfile().getAdapterStorage(this.unit.getAdapterId()).getPath()) + '/' + this.getVersionedUnitId();
        return this.getCanonicalLocation(unitDataDir);
    }

    private String getVersionedUnitId() {
        return IdentityUtil.getVersionedId((IContent)this.unit);
    }

    private Action getIUAction(String iuIdStr) throws AbstractVariableSubstitution.VariableSubstitutionException {
        Action action = null;
        InstallContext curInstallContext = this.getInstallContext();
        if (iuIdStr == null) {
            action = curInstallContext.getIUAction(this.unit);
        } else {
            InstallContext installContext = null;
            String[] segments = iuIdStr.split("/");
            String qualifiedIuId = null;
            if (segments.length == 1) {
                installContext = curInstallContext;
                qualifiedIuId = segments[0];
            } else if (segments.length == 2) {
                Profile profile = this.getInstallContext().getEnclosingProfile();
                String contextId = segments[0].trim();
                installContext = contextId.length() == 0 ? profile.getRootContext() : profile.findInstallContext(contextId);
                qualifiedIuId = segments[1];
            } else {
                throw new AbstractVariableSubstitution.VariableSubstitutionException(Messages.AbstractInstallOperation_invalid_format_iu_id, iuIdStr);
            }
            if (installContext == null) {
                throw new AbstractVariableSubstitution.VariableSubstitutionException(Messages.AbstractInstallOperation_cannot_find_install_context, iuIdStr);
            }
            String[] splitIds = IdentityUtil.splitQualifiedId((String)qualifiedIuId);
            if (splitIds[0] == null) {
                splitIds[0] = this.unit.getParent().getIdentity().getId();
            }
            if (curInstallContext.isDependsOnOrSame(this.unit, qualifiedIuId = IdentityUtil.createQualifiedId((String)splitIds[0], (String)splitIds[1]), installContext)) {
                action = installContext.getIUAction(qualifiedIuId, curInstallContext);
            } else {
                throw new AbstractVariableSubstitution.VariableSubstitutionException(Messages.AbstractInstallOperation_Action_No_OrderDependency, qualifiedIuId, installContext.getId(), this.unit.getQualifiedId(), curInstallContext.getId());
            }
        }
        return action;
    }

    public int getOperationIndex() {
        IAdapterData adapterData = this.getUnit().getAdapterData();
        if (adapterData == null) {
            return 0;
        }
        return new Finder(this.getData()).find((IHasAdapterDataChildren)adapterData);
    }

    @Override
    protected Locale getNLPropertyLocale(String localeString) {
        if ((localeString == null || localeString.length() == 0) && this.getData().useProfileLocaleForNLProperty()) {
            return super.getNLPropertyLocale(this.getProfile().getData("locale"));
        }
        return super.getNLPropertyLocale(localeString);
    }

    protected void verifySymLinkTargetIsRelative(AbstractInstallOperation operation, String theTarget) throws CoreException {
        if (new File(theTarget).isAbsolute()) {
            throw new CoreException((IStatus)Statuses.ERROR.get(Messages.AbsoluteTargetPathInSymbolicLinkIsIncompatibleithThePortableOption, new Object[]{this.unit.getIdentity().getId(), this.getData().getElementName()}));
        }
    }

    private static class Finder {
        private final CommonAdapterData toFind;
        private int seenPreviously = 0;

        Finder(CommonAdapterData toFind) {
            this.toFind = toFind;
        }

        int find(IHasAdapterDataChildren root) {
            CommonAdapterData[] children;
            CommonAdapterData[] commonAdapterDataArray = children = root.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                CommonAdapterData data = commonAdapterDataArray[n2];
                if (data == this.toFind || this.find((IHasAdapterDataChildren)data) >= 0) {
                    return this.seenPreviously;
                }
                if (data.getElementName().equals(this.toFind.getElementName())) {
                    ++this.seenPreviously;
                }
                ++n2;
            }
            return -1;
        }
    }
}

