/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.iwm.internal.model;

import com.ibm.cic.common.core.iwm.internal.model.IwmLayoutPolicy;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.LayoutPolicy;
import com.ibm.cic.common.core.repository.RemoteRepository;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.logging.Logger;

public class IwmRepository
extends RemoteRepository {
    private static final String VERSION_IWM_REPOSITORY = "0.0.0.1";
    private static final String TYPE_IWM_REPOSITORY = "Iwm";
    private static final String CAMPAIGN = "Campaign";
    private static final String GET_NURTURE_QUESTIONS_URL = "iwm.getNurtureQuestions.url";
    private static final String NOTIFY_NURTURE_ANSWERS_URL = "iwm.notifyNurtureAnswers.url";
    private static final Logger logger = Logger.getLogger(IwmRepository.class);
    private final String name;

    public IwmRepository() {
        this("");
    }

    public IwmRepository(String name) {
        super(TYPE_IWM_REPOSITORY, VERSION_IWM_REPOSITORY, false);
        this.name = name;
        this.setLayoutPolicy((LayoutPolicy)new IwmLayoutPolicy((IRepository)this));
        this.setSiteProperties((RepositorySiteProperties)new RepositoryFileBasedSiteProperties(this.getLP()));
    }

    public String getNotifyNurtureAnswersUrl() {
        String notifyUrl = this.getSiteProperties().getProperty(NOTIFY_NURTURE_ANSWERS_URL).trim();
        if (notifyUrl == null || notifyUrl.length() == 0) {
            logger.warning("Unable to obtain notify nurturing answers since the IWM repository is misconfigured.");
            logger.warning("Missing configuration parameter: iwm.notifyNurtureAnswers.url");
        }
        return notifyUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getOfferingSourceId() {
        return this.getSiteProperties().getProperty(CAMPAIGN);
    }

    public String getNurturingQuestionsUrl() {
        return this.getSiteProperties().getProperty(GET_NURTURE_QUESTIONS_URL);
    }
}

