/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.Messages;
import com.ibm.cic.licensing.common.util.ProductInformation;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import java.util.Date;

public class LicenseStatus {
    private static final String SOON_THRESHOLD_PROPERTY = "com.ibm.cic.licensing.soon.threshold";
    private static final int MIN_SOON_THRESHOLD = 15;
    private int statusCode;
    private String errMsg;
    private Exception errException;
    private long expireDate;
    private String expireDateString = null;
    private int daysToExpire = -1;
    private boolean lumTrial = false;
    private boolean licensedFeature = false;
    private boolean licenseGranted = false;
    private boolean licenseWillExpire = false;
    private long serverStatus = 0L;
    private String localizedStatusString;
    private String localizedLicenseType;
    private String offeringName;
    private String offeringVersion;
    private int licensesCount;
    private static int soonThreshold = 0;

    public LicenseStatus() {
    }

    public LicenseStatus(ProductInformation pi) {
        this.setOfferingName(pi.getProductName());
        this.setOfferingVersion(pi.getDisplayVersion());
    }

    public LicenseStatus(int status, String err, Exception ex) {
        this.statusCode = status;
        this.errMsg = err;
        this.errException = ex;
    }

    public int getDaysToExpire() {
        return this.daysToExpire;
    }

    public void setDaysToExpire(int daysToExpire) {
        this.daysToExpire = daysToExpire;
    }

    public Exception getErrException() {
        return this.errException;
    }

    public void setErrException(Exception errException) {
        this.errException = errException;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public long getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(long expireDate) {
        this.expireDate = expireDate;
    }

    public String getExpireDateString() {
        if (Logger.isTracing(Logger.DEBUG_METHODS)) {
            Logger.logNtrace("ExpireDateString: " + this.expireDateString);
        }
        return this.expireDateString;
    }

    public void setExpireDateString(String expireDateString) {
        this.expireDateString = expireDateString;
    }

    public void setExpireDateString() {
        String expiryDateString;
        int[] expiryDays = new int[]{this.getDaysToExpire()};
        if (expiryDays[0] >= 3650000) {
            this.expireDateString = Messages.permanent_license;
            return;
        }
        DateFormat dateFormat = DateFormat.getDateInstance();
        new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, expiryDays[0]);
        Date newDate = cal.getTime();
        this.expireDateString = expiryDateString = dateFormat.format(newDate);
    }

    public boolean isLicenseGranted() {
        return this.licenseGranted;
    }

    public void setLicenseGranted(boolean licenseGranted) {
        this.licenseGranted = licenseGranted;
    }

    public boolean isLicensedFeature() {
        return this.licensedFeature;
    }

    public void setLicensedFeature(boolean licensedFeature) {
        this.licensedFeature = licensedFeature;
    }

    public long getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(long serverStatus) {
        this.serverStatus = serverStatus;
    }

    public boolean isLicenseWillExpire() {
        return this.licenseWillExpire;
    }

    public void setLicenseWillExpire(boolean licenseWillExpire) {
        this.licenseWillExpire = licenseWillExpire;
    }

    public boolean isLumTrial() {
        return this.lumTrial;
    }

    public void setLumTrial(boolean lumTrial) {
        this.lumTrial = lumTrial;
    }

    public String getLocalizedLicenseType() {
        return this.localizedLicenseType;
    }

    public void setLocalizedLicenseType(String localizedLicenseType) {
        this.localizedLicenseType = localizedLicenseType;
    }

    public String getLocalizedStatusString() {
        return this.localizedStatusString;
    }

    public void setLocalizedStatusString(String localizedStatusString) {
        this.localizedStatusString = localizedStatusString;
    }

    public String getOfferingName() {
        return this.offeringName;
    }

    public void setOfferingName(String offeringName) {
        this.offeringName = offeringName;
    }

    public String getOfferingVersion() {
        return this.offeringVersion;
    }

    public void setOfferingVersion(String offeringVersion) {
        this.offeringVersion = offeringVersion;
    }

    public static boolean isExpiringSoon(int daysleft) {
        return daysleft >= 0 && daysleft < LicenseStatus.getSoonThreshold();
    }

    public static boolean isTermLicense(int daysleft) {
        return daysleft >= 0 && daysleft < 1096;
    }

    public int getLicensesCount() {
        return this.licensesCount;
    }

    public void setLicensesCount(int licensesCount) {
        this.licensesCount = licensesCount;
    }

    private static int getSoonThreshold() {
        if (soonThreshold == 0) {
            soonThreshold = 15;
            String override = System.getProperty(SOON_THRESHOLD_PROPERTY);
            if (override != null) {
                try {
                    int threshold = Integer.parseInt(override);
                    if (threshold > 15) {
                        soonThreshold = threshold;
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return soonThreshold;
    }
}

