/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.LicUserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.osgi.framework.Version;

public class LicensePolicyData {
    public static final String POLICY_ELEMENT_NAME = "license";
    public static final String POLICY_FILE_EXT = "opt";
    public static final String POLICY_FILE_NAME = "license.opt";
    public static final String POLICY_FILE_NAME_P2 = "licensep2.opt";
    private FlexData flexData = new FlexData(false, true);
    private OfferingMapData offeringMapData = new OfferingMapData(false);
    private ComponentMapData componentMapData = new ComponentMapData(false);

    public LicensePolicyData() {
    }

    public LicensePolicyData(LicensePolicyData toBeCopied) {
        this();
        this.flexData = new FlexData(toBeCopied.flexData);
        this.offeringMapData = new OfferingMapData(toBeCopied.offeringMapData);
        this.componentMapData = new ComponentMapData(toBeCopied.getComponentMapData());
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<license>\n");
        String indent = "   ";
        this.flexData.toXML(sb, indent);
        sb.append('\n');
        this.offeringMapData.toXML(sb, indent);
        sb.append('\n');
        this.componentMapData.toXML(sb, indent);
        sb.append('\n');
        sb.append("</license>");
        return sb.toString();
    }

    public ComponentMapData getComponentMapData() {
        return this.componentMapData;
    }

    public FlexData getFlexData() {
        return this.flexData;
    }

    public OfferingMapData getOfferingMapData() {
        return this.offeringMapData;
    }

    public void merge(LicensePolicyData policyData) {
        this.getFlexData().removeAllChildren();
        this.getFlexData().merge(policyData.getFlexData());
        this.getOfferingMapData().merge(policyData.getOfferingMapData());
        this.getComponentMapData().removeAllChildren();
        this.getComponentMapData().merge(policyData.getComponentMapData());
    }

    public static abstract class AbstractData {
        private AbstractData parent = null;
        private ArrayList childList;
        private ArrayList listeners = null;
        protected static final AbstractData[] NO_CHILDREN = new AbstractData[0];
        protected static final String[] NO_ATTRIBUTES = new String[0];
        protected static final String NO_ELEMENT_TEXT = new String();

        protected AbstractData() {
            this(null);
        }

        protected AbstractData(ArrayList childList) {
            this.childList = childList;
        }

        public String toString() {
            return this.toXML();
        }

        public String toXML() {
            StringBuffer sb = new StringBuffer();
            this.toXML(sb, "");
            return sb.toString();
        }

        public void toXML(StringBuffer sb, String indent) {
            String elemName = this.getElementName();
            String[] nameValuePairs = this.getAttrNameValuePairs();
            sb.append(indent).append('<').append(elemName);
            String attrPrefix = " ";
            int totalLen = indent.length() + elemName.length() + 3;
            int i = 0;
            while (i < nameValuePairs.length) {
                if ((totalLen += nameValuePairs[i].length() + 2) >= 72) {
                    attrPrefix = String.valueOf('\n') + indent + "    ";
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < nameValuePairs.length) {
                String name = nameValuePairs[i++];
                String value = this.escape(nameValuePairs[i++]);
                sb.append(attrPrefix).append(name);
                sb.append("=\"").append(value).append('\"');
            }
            AbstractData[] children = this.getChildren();
            String elemText = this.getElementText();
            if (children.length == 0 && elemText.length() == 0) {
                sb.append("/>");
                return;
            }
            sb.append('>');
            sb.append(this.escape(elemText));
            String newIndent = String.valueOf(indent) + "  ";
            int i2 = 0;
            while (i2 < children.length) {
                AbstractData child = children[i2];
                sb.append('\n');
                child.toXML(sb, newIndent);
                ++i2;
            }
            if (children.length != 0) {
                sb.append('\n').append(indent);
            }
            sb.append("</").append(elemName).append('>');
        }

        public AbstractData getParent() {
            return this.parent;
        }

        private void setParent(AbstractData parent) {
            this.parent = parent;
        }

        public AbstractData[] getChildren() {
            if (this.childList == null) {
                return NO_CHILDREN;
            }
            return this.childList.toArray(new AbstractData[this.childList.size()]);
        }

        protected ArrayList getChildList() {
            return this.childList;
        }

        public void addChild(AbstractData child) {
            this.addChild(-1, child);
        }

        public void addChild(int index, AbstractData child) {
            if (this.childList == null) {
                return;
            }
            if (this.childList.contains(child)) {
                return;
            }
            AbstractData currentParent = child.getParent();
            if (currentParent != null) {
                currentParent.removeChild(child);
            }
            child.setParent(this);
            if (index < 0) {
                this.childList.add(child);
            } else {
                this.childList.add(index, child);
            }
            this.notifyAdd(index, child);
        }

        public void removeChild(AbstractData child) {
            if (this.childList == null) {
                return;
            }
            int i = this.childList.indexOf(child);
            if (i >= 0) {
                child.setParent(null);
                this.childList.remove(i);
                this.notifyRemove(i, child);
            }
        }

        public void removeAllChildren() {
            if (this.childList == null) {
                return;
            }
            for (AbstractData child : this.childList) {
                child.setParent(null);
            }
            this.childList.clear();
            this.notifyRemove(-1, null);
        }

        public void addDataChangeListener(IDataChangeListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        public void removeDataChangeListener(IDataChangeListener listener) {
            if (this.listeners != null && listener != null) {
                this.listeners.remove(listener);
            }
        }

        public void notifyAdd(int childIndex, AbstractData childData) {
            if (this.listeners != null) {
                DataAddEvent event = new DataAddEvent(this, childIndex, childData);
                this.notifyEvent(event);
            } else if (this.parent != null) {
                this.parent.notifyAdd(childIndex, childData);
            }
        }

        public void notifyRemove(int childIndex, AbstractData childData) {
            if (this.listeners != null) {
                DataRemoveEvent event = new DataRemoveEvent(this, childIndex, childData);
                this.notifyEvent(event);
            } else if (this.parent != null) {
                this.parent.notifyRemove(childIndex, childData);
            }
        }

        public void notifyChange() {
            if (this.listeners != null) {
                DataChangeEvent event = new DataChangeEvent(this);
                this.notifyEvent(event);
            } else if (this.parent != null) {
                this.parent.notifyChange();
            }
        }

        private void notifyEvent(DataEvent event) {
            if (this.listeners != null) {
                for (IDataChangeListener listener : this.listeners) {
                    try {
                        listener.dataChanged(event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.parent != null) {
                this.parent.notifyEvent(event);
            }
        }

        protected abstract String getElementName();

        protected String[] getAttrNameValuePairs() {
            return NO_ATTRIBUTES;
        }

        protected String getElementText() {
            return NO_ELEMENT_TEXT;
        }

        protected String escape(String x) {
            int i = x.length() - 1;
            while (i >= 0) {
                block8: {
                    String replace;
                    switch (x.charAt(i)) {
                        case '<': {
                            replace = "&lt;";
                            break;
                        }
                        case '>': {
                            replace = "&gt;";
                            break;
                        }
                        case '\"': {
                            replace = "&quot;";
                            break;
                        }
                        case '\'': {
                            replace = "&apos;";
                            break;
                        }
                        case '&': {
                            replace = "&amp;";
                            break;
                        }
                        default: {
                            break block8;
                        }
                    }
                    x = String.valueOf(x.substring(0, i)) + replace + x.substring(i + 1);
                }
                --i;
            }
            return x;
        }

        protected boolean isDifferent(Object o1, Object o2) {
            if (o1 == o2) {
                return false;
            }
            if (o1 == null) {
                return true;
            }
            return !o1.equals(o2);
        }

        protected void merge(AbstractData data) {
            String[] nameValuePairs = data.getAttrNameValuePairs();
            int i = 0;
            while (i < nameValuePairs.length) {
                this.setAttributeValue(nameValuePairs[i], nameValuePairs[i + 1]);
                i += 2;
            }
            AbstractData[] children = data.getChildren();
            int i2 = 0;
            while (i2 < children.length) {
                this.addChild(children[i2]);
                ++i2;
            }
        }

        protected abstract void setAttributeValue(String var1, String var2);
    }

    public static abstract class AbstractTopLevelData
    extends AbstractData {
        public static final String READONLY_ATTR = "readonly";
        private boolean readonly;

        protected AbstractTopLevelData(boolean readonly) {
            super(new ArrayList());
            this.readonly = readonly;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setReadonly(boolean readonly) {
            if (this.readonly != readonly) {
                this.readonly = readonly;
                this.notifyChange();
            }
        }
    }

    public static abstract class ChildDataEvent
    extends DataEvent {
        private int childIndex;
        private AbstractData childData;

        protected ChildDataEvent(int eventKind, AbstractData parentData, int childIndex, AbstractData childData) {
            super(eventKind, parentData);
            this.childIndex = childIndex;
            this.childData = childData;
        }

        public AbstractData getParentData() {
            return this.getChangedData();
        }

        public AbstractData getChildData() {
            return this.childData;
        }

        public int getChildIndex() {
            return this.childIndex;
        }
    }

    public static class ComponentData
    extends AbstractData {
        public static final String ELEMENT_NAME = "component";
        public static final String ID_ATTR = "id";
        public static final String VERSION_ATTR = "version";
        private String id;
        private Version version;

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComponentData other = (ComponentData)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
        }

        public ComponentData(String id, Version version) {
            super(new ArrayList());
            this.id = id;
            this.version = version;
        }

        public ComponentData(ComponentData toBeCopied) {
            this(toBeCopied.getId(), toBeCopied.getVersion());
        }

        public static String toKeyString(String id, String version) {
            return String.valueOf(id) + '_' + version.toString();
        }

        public String toKeyString() {
            return ComponentData.toKeyString(this.id, this.version.toString());
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            if (this.isDifferent(this.id, id)) {
                this.id = id;
                this.notifyChange();
            }
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            if (this.isDifferent(this.version, version)) {
                this.version = version;
                this.notifyChange();
            }
        }

        public OfferingData[] getOfferings() {
            ArrayList childList = this.getChildList();
            return childList.toArray(new OfferingData[childList.size()]);
        }

        public void addOffering(OfferingData data) {
            this.addChild(data);
        }

        public void removeOffering(OfferingData data) {
            this.removeChild(data);
        }

        @Override
        protected String getElementName() {
            return ELEMENT_NAME;
        }

        @Override
        protected String[] getAttrNameValuePairs() {
            return new String[]{ID_ATTR, this.id, VERSION_ATTR, this.version.toString()};
        }

        @Override
        protected void setAttributeValue(String name, String value) {
            if (ID_ATTR.endsWith(name)) {
                this.setId(value);
            } else if (VERSION_ATTR.equals(name)) {
                this.setVersion(new Version(value));
            }
        }
    }

    public static class ComponentMapData
    extends AbstractTopLevelData {
        public static final String ELEMENT_NAME = "componentorder";
        private HashMap components = new HashMap();

        public ComponentMapData(boolean readonly) {
            super(readonly);
        }

        public ComponentMapData(ComponentMapData toBeCopied) {
            this(toBeCopied.isReadonly());
            ComponentData[] componentDataArray = toBeCopied.getComponents();
            int n = componentDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentData iCompData = componentDataArray[n2];
                this.addComponent(new ComponentData(iCompData));
                ++n2;
            }
        }

        public ComponentData getComponent(String key) {
            return (ComponentData)this.components.get(key);
        }

        public ComponentData[] getComponents() {
            ArrayList childList = this.getChildList();
            return childList.toArray(new ComponentData[childList.size()]);
        }

        public void addComponent(ComponentData data) {
            this.addChild(data);
        }

        public void removeComponent(ComponentData data) {
            this.removeChild(data);
        }

        @Override
        protected String getElementName() {
            return ELEMENT_NAME;
        }

        @Override
        protected String[] getAttrNameValuePairs() {
            return new String[]{"readonly", Boolean.toString(this.isReadonly())};
        }

        @Override
        public void addChild(int index, AbstractData child) {
            super.addChild(index, child);
            ComponentData data = (ComponentData)child;
            this.components.put(data.toKeyString(), data);
        }

        @Override
        public void removeChild(AbstractData child) {
            super.removeChild(child);
            ComponentData data = (ComponentData)child;
            this.components.remove(data.toKeyString());
        }

        @Override
        public void removeAllChildren() {
            super.removeAllChildren();
            this.components.clear();
        }

        @Override
        protected void setAttributeValue(String name, String value) {
            if ("readonly".equals(name)) {
                this.setReadonly(Boolean.valueOf(value));
            }
        }
    }

    public static class DataAddEvent
    extends ChildDataEvent {
        public DataAddEvent(AbstractData parentData, int childIndex, AbstractData childData) {
            super(1, parentData, childIndex, childData);
        }
    }

    public static class DataChangeEvent
    extends DataEvent {
        public DataChangeEvent(AbstractData changedData) {
            super(3, changedData);
        }
    }

    public static abstract class DataEvent {
        public static final int ADD_EVENT = 1;
        public static final int REMOVE_EVENT = 2;
        public static final int CHANGE_EVENT = 3;
        private int eventKind;
        private AbstractData changedData;

        protected DataEvent(int eventKind, AbstractData changedData) {
            this.eventKind = eventKind;
            this.changedData = changedData;
        }

        public AbstractData getChangedData() {
            return this.changedData;
        }

        public int getEventKind() {
            return this.eventKind;
        }
    }

    public static class DataRemoveEvent
    extends ChildDataEvent {
        public DataRemoveEvent(AbstractData parentData, int childIndex, AbstractData childData) {
            super(2, parentData, childIndex, childData);
        }
    }

    public static class FlexData
    extends AbstractTopLevelData {
        public static final String ELEMENT_NAME = "flex";
        public static final String ENABLED_ATTR = "enabled";
        private boolean enabled;

        public FlexData(boolean readonly, boolean enabled) {
            super(readonly);
            this.enabled = enabled;
        }

        public FlexData(FlexData flexData) {
            this(flexData.isReadonly(), flexData.enabled);
            ServerData[] serverDataArray = flexData.getServers();
            int n = serverDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServerData iserverData = serverDataArray[n2];
                this.addServer(new ServerData(iserverData));
                ++n2;
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            if (this.enabled != enabled) {
                this.enabled = enabled;
                this.notifyChange();
            }
        }

        public ServerData[] getServers() {
            ArrayList childList = this.getChildList();
            return childList.toArray(new ServerData[childList.size()]);
        }

        public void addServer(ServerData data) {
            this.addChild(data);
        }

        public void removeServer(ServerData data) {
            this.removeChild(data);
        }

        @Override
        protected String getElementName() {
            return ELEMENT_NAME;
        }

        @Override
        protected String[] getAttrNameValuePairs() {
            return new String[]{ENABLED_ATTR, Boolean.toString(this.enabled), "readonly", Boolean.toString(this.isReadonly())};
        }

        @Override
        protected void setAttributeValue(String name, String value) {
            if (ENABLED_ATTR.equals(name)) {
                this.setEnabled(Boolean.valueOf(value));
            } else if ("readonly".equals(name)) {
                this.setReadonly(Boolean.valueOf(value));
            }
        }
    }

    public static interface IDataChangeListener {
        public void dataChanged(DataEvent var1);
    }

    public static class OfferingData
    extends AbstractData {
        public static final String ELEMENT_NAME = "offering";
        public static final String ID_ATTR = "id";
        public static final String VERSION_ATTR = "version";
        public static final String NAME_ATTR = "name";
        public static final String DISPLAYABLE_VER = "displayVersion";
        private String id;
        private int order;
        private Version version;
        private String name;
        private String displayableVersion = "";

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OfferingData other = (OfferingData)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
        }

        public OfferingData(String id, Version version, String name) {
            this.id = id;
            this.version = version;
            this.name = name;
        }

        public OfferingData(String id, Version version, String name, String displayableVersion) {
            this(id, version, name);
            this.displayableVersion = displayableVersion;
        }

        public OfferingData(OfferingData toBeCopied) {
            this(toBeCopied.id, toBeCopied.version, toBeCopied.name, toBeCopied.displayableVersion);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            if (this.isDifferent(this.id, id)) {
                this.id = id;
                this.notifyChange();
            }
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            if (this.isDifferent(this.version, version)) {
                this.version = version;
                this.notifyChange();
            }
        }

        public static String toKeyString(String id, Version ver) {
            Version licver = LicUserUtils.getMajorMinorMicroVersion(ver);
            return String.valueOf(id) + '_' + licver;
        }

        public String toKeyString() {
            return OfferingData.toKeyString(this.id, this.version);
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        @Override
        protected String getElementName() {
            return ELEMENT_NAME;
        }

        @Override
        protected String[] getAttrNameValuePairs() {
            return new String[]{ID_ATTR, this.id, VERSION_ATTR, this.version.toString(), NAME_ATTR, this.name};
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (this.isDifferent(this.name, name)) {
                this.name = name;
                this.notifyChange();
            }
        }

        public String getDisplayableVersion() {
            return this.displayableVersion;
        }

        public void setDisplayableVersion(String versionString) {
            this.displayableVersion = versionString;
        }

        @Override
        protected void setAttributeValue(String name, String value) {
            if (ID_ATTR.equals(name)) {
                this.setId(value);
            } else if (VERSION_ATTR.equals(name)) {
                this.setVersion(new Version(name));
            } else if (NAME_ATTR.equals(value)) {
                this.setName(value);
            }
        }
    }

    public static class OfferingMapData
    extends AbstractTopLevelData {
        public static final String ELEMENT_NAME = "offeringorder";
        private HashMap offerings = new HashMap();

        public OfferingMapData(boolean readonly) {
            super(readonly);
        }

        public OfferingMapData(OfferingMapData toBeCopied) {
            super(toBeCopied.isReadonly());
            OfferingData[] offeringDataArray = toBeCopied.getOfferings();
            int n = offeringDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                OfferingData iOfferingData = offeringDataArray[n2];
                this.addOffering(new OfferingData(iOfferingData));
                ++n2;
            }
        }

        public OfferingData getOffering(String key) {
            return (OfferingData)this.offerings.get(key);
        }

        public OfferingData[] getOfferings() {
            ArrayList childList = this.getChildList();
            return childList.toArray(new OfferingData[childList.size()]);
        }

        public void addOffering(OfferingData data) {
            this.addChild(data);
        }

        public void removeOffering(OfferingData data) {
            this.removeChild(data);
        }

        @Override
        protected String getElementName() {
            return ELEMENT_NAME;
        }

        @Override
        protected String[] getAttrNameValuePairs() {
            return new String[]{"readonly", Boolean.toString(this.isReadonly())};
        }

        @Override
        public void addChild(int index, AbstractData child) {
            super.addChild(index, child);
            int i = this.offerings.size();
            OfferingData data = (OfferingData)child;
            data.setOrder(i);
            this.offerings.put(data.toKeyString(), data);
        }

        @Override
        public void removeChild(AbstractData child) {
            super.removeChild(child);
            OfferingData data = (OfferingData)child;
            this.offerings.remove(data.toKeyString());
        }

        @Override
        public void removeAllChildren() {
            super.removeAllChildren();
            this.offerings.clear();
        }

        @Override
        protected void setAttributeValue(String name, String value) {
            if ("readonly".equals(name)) {
                this.setReadonly(Boolean.valueOf(value));
            }
        }
    }

    public static class ServerData
    extends AbstractData {
        public static final String ELEMENT_NAME = "server";
        public static final String NAME_ATTR = "name";
        public static final String PORT_ATTR = "port";
        private String name;
        private String port;
        private boolean isCluster;

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerData other = (ServerData)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.port == null ? other.port != null : !this.port.equals(other.port));
        }

        public ServerData(String name, String port) {
            this.name = name;
            this.port = port;
        }

        public ServerData(ServerData tobeCopied) {
            this(tobeCopied.name, tobeCopied.port);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (this.isDifferent(this.name, name)) {
                this.name = name;
                this.notifyChange();
            }
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            if (this.isDifferent(this.port, port)) {
                this.port = port;
                this.notifyChange();
            }
        }

        @Override
        protected String getElementName() {
            return ELEMENT_NAME;
        }

        @Override
        protected String[] getAttrNameValuePairs() {
            return new String[]{NAME_ATTR, this.name, PORT_ATTR, this.port};
        }

        public boolean isCluster() {
            this.isCluster = this.name.indexOf(44) > 0;
            return this.isCluster;
        }

        public void setCluster(boolean iscluster) {
            this.isCluster = iscluster;
        }

        @Override
        protected void setAttributeValue(String name, String value) {
            if (NAME_ATTR.equals(name)) {
                this.setName(value);
            } else if (PORT_ATTR.equals(value)) {
                this.setPort(value);
            }
        }
    }
}

