/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class LicenseInfoData {
    private String componentName;
    private String componentVersion;
    private String offeringID;
    private String offeringName;
    private String offeringVersion;
    private String offeringDisplayVersion;
    private String licenseType;
    private String licenseStatus;
    private String expirationDateStr;
    private String errorCode;
    private String errorMessage;
    private String combinationID;
    private boolean tryAndBuy;
    private String purchaseUrl;
    private int statusCode;
    private LicenseInfoData parentLicenseInfoData = null;
    private List subLicenseInfoData = new ArrayList();

    public LicenseInfoData(String offeringID, String productName, String productVersion, String productDisplayVersion, String licType, String licstat, String expiration) {
        this.offeringID = offeringID == null ? "" : offeringID;
        this.offeringName = productName == null ? "" : productName;
        this.offeringVersion = productVersion == null ? "" : productVersion;
        this.offeringDisplayVersion = productDisplayVersion == null ? "" : productDisplayVersion;
        this.licenseType = licType == null ? "" : licType;
        this.licenseStatus = licstat == null ? "" : licstat;
        this.expirationDateStr = expiration == null ? "" : expiration;
    }

    public LicenseInfoData(LicenseInfoData toBeCopied) {
        this(toBeCopied.getOfferingID(), toBeCopied.getOfferingName(), toBeCopied.getOfferingVersion(), toBeCopied.getOfferingDisplayVersion(), toBeCopied.getLicenseType(), toBeCopied.getLicenseStatus(), toBeCopied.getExpirationDateStr());
    }

    public LicenseInfoData(String offeringID, String productName, String productVersion, String productDisplayVersion, String licType, String licstat, String expiration, boolean istrial, String purchaseurl) {
        this(offeringID, productName, productVersion, productDisplayVersion, licType, licstat, expiration);
        this.tryAndBuy = istrial;
        this.purchaseUrl = purchaseurl;
    }

    public LicenseInfoData(String offeringID, String productName, String productVersion, String productDisplayVersion, String licType, String licstat, String expiration, boolean istrial, String purchaseurl, int statusCode) {
        this(offeringID, productName, productVersion, productDisplayVersion, licType, licstat, expiration, istrial, purchaseurl);
        this.statusCode = statusCode;
    }

    public String getLicenseStatus() {
        return this.licenseStatus;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getOfferingID() {
        return this.offeringID;
    }

    public String getOfferingName() {
        return this.offeringName;
    }

    public String getOfferingVersion() {
        return this.offeringVersion;
    }

    public String getOfferingDisplayVersion() {
        return this.offeringDisplayVersion;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public String getExpirationDateStr() {
        return this.expirationDateStr;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getCombinationID() {
        if (this.combinationID == null) {
            this.combinationID = String.valueOf(this.getOfferingID()) + "_" + this.getOfferingVersion();
        }
        return this.combinationID;
    }

    public String getPurchaseUrl() {
        return this.purchaseUrl;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void addSubLicenseInfoData(LicenseInfoData data) {
        LicenseInfoData info = this;
        while (info != null) {
            if (info == data) {
                throw new IllegalArgumentException("cycle in license information");
            }
            info = info.parentLicenseInfoData;
        }
        if (data.parentLicenseInfoData != null) {
            data.parentLicenseInfoData.subLicenseInfoData.remove(data);
            data.parentLicenseInfoData = null;
        }
        this.subLicenseInfoData.add(data);
        data.parentLicenseInfoData = this;
    }

    public LicenseInfoData getParentLicenseInfoData() {
        return this.parentLicenseInfoData;
    }

    public LicenseInfoData[] getSubLicenseInfoData() {
        return this.subLicenseInfoData.toArray(new LicenseInfoData[this.subLicenseInfoData.size()]);
    }

    private static void reverse(LicenseInfoData[] infos) {
        List<LicenseInfoData> infoList = Arrays.asList(infos);
        Collections.reverse(infoList);
        int i = 0;
        while (i < infos.length) {
            infos[i] = infoList.get(i);
            ++i;
        }
    }

    public static void sortByComponentName(boolean reverse, LicenseInfoData[] infos) {
        if (reverse) {
            LicenseInfoData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object a, Object b) {
                String comp2;
                LicenseInfoData info1 = (LicenseInfoData)a;
                LicenseInfoData info2 = (LicenseInfoData)b;
                String comp1 = info1.getComponentName();
                if (!comp1.equals(comp2 = info2.getComponentName())) {
                    return this.collator.compare(comp1, comp2);
                }
                return this.collator.compare(info1.getComponentVersion(), info2.getComponentVersion());
            }
        });
    }

    public static void sortByComponentVersion(boolean reverse, LicenseInfoData[] infos) {
        if (reverse) {
            LicenseInfoData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object a, Object b) {
                LicenseInfoData info1 = (LicenseInfoData)a;
                LicenseInfoData info2 = (LicenseInfoData)b;
                return this.collator.compare(info1.getComponentVersion(), info2.getComponentVersion());
            }
        });
    }

    public static void sortByOfferingID(boolean reverse, LicenseInfoData[] infos) {
        if (reverse) {
            LicenseInfoData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object a, Object b) {
                String offering2;
                LicenseInfoData info1 = (LicenseInfoData)a;
                LicenseInfoData info2 = (LicenseInfoData)b;
                String offering1 = info1.getOfferingID();
                if (!offering1.equals(offering2 = info2.getOfferingID())) {
                    return this.collator.compare(offering1, offering2);
                }
                return this.collator.compare(info1.getOfferingVersion(), info2.getOfferingVersion());
            }
        });
    }

    public static void sortByOfferingName(boolean reverse, LicenseInfoData[] infos) {
        if (reverse) {
            LicenseInfoData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object a, Object b) {
                String comp2;
                LicenseInfoData info1 = (LicenseInfoData)a;
                LicenseInfoData info2 = (LicenseInfoData)b;
                String comp1 = info1.getOfferingName();
                if (!comp1.equals(comp2 = info2.getOfferingName())) {
                    return this.collator.compare(comp1, comp2);
                }
                return this.collator.compare(info1.getOfferingVersion(), info2.getOfferingVersion());
            }
        });
    }

    public static void sortByOfferingVersion(boolean reverse, LicenseInfoData[] infos) {
        if (reverse) {
            LicenseInfoData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object a, Object b) {
                LicenseInfoData info1 = (LicenseInfoData)a;
                LicenseInfoData info2 = (LicenseInfoData)b;
                return this.collator.compare(info1.getOfferingVersion(), info2.getOfferingVersion());
            }
        });
    }

    public static void sortByLicenseType(boolean reverse, LicenseInfoData[] infos) {
        if (reverse) {
            LicenseInfoData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object a, Object b) {
                String lic2;
                LicenseInfoData info1 = (LicenseInfoData)a;
                LicenseInfoData info2 = (LicenseInfoData)b;
                String lic1 = info1.getLicenseType();
                if (!lic1.equals(lic2 = info2.getLicenseType())) {
                    return this.collator.compare(lic1, lic2);
                }
                return this.collator.compare(info1.getOfferingName(), info2.getOfferingName());
            }
        });
    }

    public static void sortByLicenseStatus(boolean reverse, LicenseInfoData[] infos) {
        if (reverse) {
            LicenseInfoData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object a, Object b) {
                String lic2;
                LicenseInfoData info1 = (LicenseInfoData)a;
                LicenseInfoData info2 = (LicenseInfoData)b;
                String lic1 = info1.getLicenseStatus();
                if (!lic1.equals(lic2 = info2.getLicenseStatus())) {
                    return this.collator.compare(lic1, lic2);
                }
                return this.collator.compare(info1.getOfferingName(), info2.getOfferingName());
            }
        });
    }

    public static void sortByExpirationDate(boolean reverse, LicenseInfoData[] infos) {
        if (reverse) {
            LicenseInfoData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object a, Object b) {
                LicenseInfoData info2;
                LicenseInfoData info1;
                block8: {
                    info1 = (LicenseInfoData)a;
                    info2 = (LicenseInfoData)b;
                    String lic1 = info1.getExpirationDateStr();
                    String lic2 = info2.getExpirationDateStr();
                    if (lic1 == "" && lic2 == "") {
                        return 0;
                    }
                    if (lic1 == "") {
                        return -1;
                    }
                    if (lic2 == "") {
                        return 1;
                    }
                    SimpleDateFormat aDateFormat = new SimpleDateFormat("MMMM dd, yyyy");
                    if (!lic1.equals(lic2)) {
                        if (lic1.equalsIgnoreCase("permanent")) {
                            return 1;
                        }
                        if (lic2.equalsIgnoreCase("permanent")) {
                            return -1;
                        }
                        try {
                            Date lic1date = aDateFormat.parse(lic1);
                            Date lic2date = aDateFormat.parse(lic2);
                            return lic1date.compareTo(lic2date);
                        }
                        catch (ParseException e) {
                            if (!Logger.isTracing(Logger.DEBUG_EXCEPTIONS)) break block8;
                            Logger.logNtrace("Date parsing error", e);
                        }
                    }
                }
                return this.collator.compare(info1.getOfferingName(), info2.getOfferingName());
            }
        });
    }

    public boolean isTryAndBuy() {
        return this.tryAndBuy;
    }
}

