/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.VersionUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import com.ibm.ws.pak.internal.utils.product.ProductPlugin;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class UninstallablePakListMacroResolver
extends MacroResolver {
    private static final String COMMA_VERSION = ",version";
    private static final String S_BOOLEAN_ATTRIBUTE_MACRO_ID = "UNINSTALLABLEPAKLIST";
    private static final String className = "UninstallablePakListMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_BOOLEAN_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        String[] arg = sMacroText.split(COMMA_VERSION);
        String sIDs = null;
        String sVersionParam = null;
        if (arg.length > 0) {
            sIDs = arg[0].trim();
        }
        if (arg.length > 1) {
            sVersionParam = arg[1].trim();
        }
        String ret = null;
        try {
            ret = this.getUninstallableBackupPaksList(sIDs, sVersionParam);
        }
        catch (IOException e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
            ret = sMacroText;
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
            ret = sMacroText;
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
            ret = sMacroText;
        }
        catch (SAXException e) {
            Logr.warn(className, "resolveMacro", e.getMessage(), e);
            ret = sMacroText;
        }
        Logr.methodReturn(className, "resolveMacro", ret);
        return ret;
    }

    private String getUninstallableBackupPaksList(String commonPakIds, String sVersionParam) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        if (!NIFStack.isOpen()) {
            FileSystemEntry fseBackupPath = new FileSystemEntry(URIUtils.convertPathToURI(ProductPlugin.getCurrentBackupPath(), this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
            NIFStack.open(fseBackupPath, this.getInstallToolkitBridge());
        }
        String sCurrentOffering = ProductPlugin.getCurrentProductOffering();
        String sBackupDir = ProductPlugin.getCurrentBackupPath();
        Vector vNIFStackElements = NIFStack.getAllNIFStackElements();
        LinkedList<String> paksQueue = new LinkedList<String>();
        int i = 0;
        while (i < vNIFStackElements.size()) {
            NIFPackageEntry nifpeThis = (NIFPackageEntry)vNIFStackElements.elementAt(i);
            String sCurrentPakPayloadid = nifpeThis.getParamValue("payloadid");
            if (sCurrentPakPayloadid != null && StringUtils.isThisStringContainingThisToken(commonPakIds, sCurrentPakPayloadid, ";")) {
                paksQueue.addFirst(new StringBuffer().append("$NIFDEFFSSOURCEURI{").append(sBackupDir).append("/").append(nifpeThis.getParamValue("filename")).append("}").toString());
            } else {
                String targetproductid = nifpeThis.getParamValue("targetproductids");
                String autouninstallable = nifpeThis.getParamValue("autouninstallable");
                if (targetproductid != null && StringUtils.isThisStringContainingThisToken(targetproductid, sCurrentOffering, ";") && !new Boolean(autouninstallable).booleanValue()) {
                    String pakversion = nifpeThis.getParamValue("pakversion");
                    if (sVersionParam == null || pakversion == null || VersionUtils.isVersionAcceptableToTheseVersionParams(pakversion, sVersionParam)) {
                        String wasinstallasprimary = nifpeThis.getParamValue("wasinstalledasprimary");
                        if (wasinstallasprimary != null && wasinstallasprimary.equalsIgnoreCase(Boolean.TRUE.toString())) {
                            paksQueue.addLast(new StringBuffer().append("$NIFDEFFSSOURCEURI{").append(sBackupDir).append("/").append(nifpeThis.getParamValue("filename")).append("}").toString());
                        } else {
                            paksQueue.addFirst(new StringBuffer().append("$NIFDEFFSSOURCEURI{").append(sBackupDir).append("/").append(nifpeThis.getParamValue("filename")).append("}").toString());
                        }
                    }
                }
            }
            ++i;
        }
        return this.convertCollectionToString(paksQueue, ";");
    }

    private String convertCollectionToString(Collection collection, String sDelim) {
        Iterator iterator = collection.iterator();
        StringBuffer sb = new StringBuffer();
        while (iterator.hasNext()) {
            sb.append(iterator.next().toString());
            sb.append(sDelim);
        }
        return sb.toString();
    }
}

