/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Document;

public class PathToFileSystemURIMacroResolver
extends MacroResolver {
    private static final String S_DOT = ".";
    private static final String S_EXTENSION_TO_SCHEME_MAPPING = "extensiontoschememapping";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"extensiontoschememapping"};
    private static final String S_SEMI_COLON = ";";
    private static final String className = "PathToFileSystemURIMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return "NIFURI".equals(sMacroID) || "NIFDEFFSTARGETURI".equals(sMacroID) || "NIFDEFFSSOURCEURI".equals(sMacroID);
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        String sScheme = null;
        if (sMacroID.equals("NIFURI")) {
            sScheme = this.getSchemeForLocalFile(sMacroText);
        }
        if (sMacroID.equals("NIFDEFFSTARGETURI")) {
            sScheme = this.getDefaultFSTypeForTargetMachine(sMacroText);
        }
        if (sMacroID.equals("NIFDEFFSSOURCEURI")) {
            sScheme = this.getDefaultFSSchemeForSourceMachine(sMacroText);
        }
        if (!sScheme.equals("i5osrf://")) {
            URI uriThis = new File(sMacroText).toURI();
            String sFSPath = uriThis.toString().substring(uriThis.getScheme().length() + 1);
            Logr.methodReturn(className, "resolveMacro", String.valueOf(sScheme) + sFSPath);
            return String.valueOf(sScheme) + sFSPath;
        }
        try {
            String s = new URI("i5osrf", null, sMacroText, null).toString();
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
        catch (URISyntaxException e) {
            String s = MacroResolver.getUnresolvedMacro(sMacroID, sMacroID);
            Logr.methodReturn(className, "resolveMacro", s);
            return s;
        }
    }

    private boolean shouldWeResolveFileSystemTypeForThisPathFromExtension(String sPath) {
        File filePath = new File(sPath);
        if (!filePath.exists()) {
            return true;
        }
        return filePath.isFile();
    }

    private String getDefaultFSTypeForTargetMachine(String sMacroText) {
        if (NIFConstants.getProperty("targetdeffstype") != null) {
            return NIFConstants.getProperty("targetdeffstype");
        }
        return this.getSchemeForLocalFile(sMacroText);
    }

    private String getDefaultFSSchemeForSourceMachine(String sMacroText) {
        if (NIFConstants.getProperty("sourcedeffstype") != null) {
            return NIFConstants.getProperty("sourcedeffstype");
        }
        return this.getSchemeForLocalFile(sMacroText);
    }

    private String getSchemeForLocalFile(String sMacroText) {
        int nExtensionPosition;
        String sExtension;
        if (this.shouldWeResolveFileSystemTypeForThisPathFromExtension(sMacroText) && this.getSchemeForThisExtension(sExtension = sMacroText.substring((nExtensionPosition = sMacroText.lastIndexOf(S_DOT)) + 1)) != null) {
            return this.getSchemeForThisExtension(sExtension);
        }
        return "file://";
    }

    private String getSchemeForThisExtension(String sExtension) {
        String[] asExtensionToSchemeMappings;
        String[] stringArray = asExtensionToSchemeMappings = this.getParamValues(S_EXTENSION_TO_SCHEME_MAPPING);
        int n = asExtensionToSchemeMappings.length;
        int n2 = 0;
        while (n2 < n) {
            String asExtensionToSchemeMapping = stringArray[n2];
            int nSemiColonPosition = asExtensionToSchemeMapping.indexOf(S_SEMI_COLON);
            if (nSemiColonPosition != -1) {
                String sExtensionThis = asExtensionToSchemeMapping.substring(0, nSemiColonPosition);
                String sSchemeThis = asExtensionToSchemeMapping.substring(nSemiColonPosition + 1);
                if (sExtensionThis.equalsIgnoreCase(sExtension)) {
                    return sSchemeThis;
                }
            }
            ++n2;
        }
        return null;
    }
}

