/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.logging;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.logging.ILogr;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class Logr
extends ILogr {
    public static void initLogger(String sLogLocation) throws Exception {
        Logr.initLogger(sLogLocation, "pakengine.log");
    }

    public static void initLogger(String sLogLocation, String sLogFileName) throws Exception {
        File logPath = new File(String.valueOf(sLogLocation) + File.separatorChar + sLogFileName);
        if (sLogLocation == null || sLogFileName == null) {
            if (Logr.isLoggerInitialized()) {
                Logr.debug(PakCoreMessages.PAK_CORE_LOG_ALREADY_INITIALIZED);
                return;
            }
            throw new Exception(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_INVALID_LOG, (Object)logPath.getAbsolutePath()));
        }
        if (Logr.isLoggerInitialized() && Logr.getLogFileFullPath() != null && Logr.getLogFileFullPath().equals(logPath.getAbsoluteFile())) {
            Logr.debug(PakCoreMessages.PAK_CORE_LOG_ALREADY_INITIALIZED);
            return;
        }
        Logr.verifyLogLocation(sLogLocation);
        Logr.setLogger(new Logr());
        Logr.setLogFileFullPath(logPath.getAbsolutePath());
        Logr.backupLogFile(new File(Logr.getLogFileFullPath()));
    }

    private static void verifyLogLocation(String sLogLocation) throws Exception {
        if (sLogLocation == null || sLogLocation.equals("")) {
            throw new Exception(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_INVALID_LOG, (Object)sLogLocation));
        }
        File logDir = new File(sLogLocation);
        if (logDir.exists()) {
            if (!logDir.canWrite()) {
                throw new Exception(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_INVALID_LOG, (Object)sLogLocation));
            }
        } else {
            boolean success = logDir.mkdir();
            if (!success) {
                throw new Exception(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_LOG_INVALID_LOG, (Object)logDir));
            }
        }
    }

    @Override
    protected void log(String msg, int LEVEL) {
        this.log(null, msg, null, LEVEL);
    }

    @Override
    protected void log(String prefx, String msg, int LEVEL) {
        this.log(prefx, msg, null, LEVEL);
    }

    @Override
    protected void log(String prefx, String msg, Exception e, int LEVEL) {
        if (!Logr.isLogEnabled()) {
            return;
        }
        if (prefx == null || prefx.length() == 0) {
            prefx = String.valueOf(Logr.getPrefix()) + PakCoreMessages.PAK_CORE_LOG_LOG_TITLE;
        }
        Logr.writeLog(String.valueOf(Logr.getTimeString()) + prefx + msg + "\n", true);
        if (e != null) {
            StackTraceElement[] elements;
            this.log(prefx, "EXCP=" + e.getMessage(), LEVEL);
            StackTraceElement[] stackTraceElementArray = elements = e.getStackTrace();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                this.log(prefx, "... " + element, LEVEL);
                ++n2;
            }
        }
    }

    private static void backupLogFile(File logFile) {
        if (logFile.exists() && Logr.getFileSize(logFile) >= Logr.getLogMaxSize()) {
            String sLogLocation = logFile.getParentFile().getAbsolutePath();
            File newLogFile = new File(String.valueOf(sLogLocation) + File.separatorChar + "pakengine" + "_" + System.currentTimeMillis() + ".log");
            logFile.renameTo(newLogFile);
        }
    }

    private static void writeLog(String sMessage, boolean append) {
        try {
            boolean appendTo = append;
            if (Logr.getLogFileFullPath() == null) {
                return;
            }
            if (!new File(Logr.getLogFileFullPath()).exists()) {
                appendTo = false;
            }
            if (appendTo) {
                Logr.appendToFile(sMessage, Logr.getLogFileFullPath());
            } else {
                Logr.StringToFile(sMessage, Logr.getLogFileFullPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void appendToFile(String msg, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(filename, true));
            out.write(msg);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean StringToFile(String s, String filename) throws Exception {
        File logFile = new File(filename);
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
        FileWriter file = new FileWriter(filename);
        file.write(s);
        file.close();
        return true;
    }

    private static String getTimeString() {
        String timeString = null;
        long localTime = System.currentTimeMillis();
        Date local = new Date(localTime);
        timeString = DateFormat.getDateTimeInstance().format(local);
        return timeString;
    }

    private static long getFileSize(File file) {
        long size = 0L;
        if (file.exists()) {
            File[] fs;
            if (file.isFile()) {
                size = file.length();
            } else if (file.isDirectory() && (fs = file.listFiles()) != null) {
                File[] fileArray = fs;
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File element = fileArray[n2];
                    size += Logr.getFileSize(element);
                    ++n2;
                }
            }
        }
        if (size > 0L) {
            return size / 0x100000L;
        }
        return size;
    }
}

