/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.filesystems;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.Checksum;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemNotSupportedException;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.UnifiedFileIO;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class FileSystem
extends NIFPlugin {
    private static FileSystem[] m_afsProviders = null;
    private static int AB_SIZE = 262144;
    private static final byte[] AB_IO_BUFFER = new byte[AB_SIZE];
    private static final String[] AS_EMPTY = new String[0];
    private static final String S_UTF_8 = "UTF-8";
    private static final String className = "FileSystem";

    public static FileSystem getFileSystem(URI uriFS, InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, FileSystemNotSupportedException {
        FileSystem.registerFileSystemProviders(itb);
        FileSystem[] fileSystemArray = m_afsProviders;
        int n = m_afsProviders.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystem m_afsProvider = fileSystemArray[n2];
            if (m_afsProvider.getSupportedScheme().equalsIgnoreCase(uriFS.getScheme())) {
                return m_afsProvider;
            }
            ++n2;
        }
        throw new FileSystemNotSupportedException(uriFS);
    }

    public static void flushAllFileSystems() throws IOException {
        if (m_afsProviders != null) {
            FileSystem[] fileSystemArray = m_afsProviders;
            int n = m_afsProviders.length;
            int n2 = 0;
            while (n2 < n) {
                FileSystem m_afsProvider = fileSystemArray[n2];
                m_afsProvider.flush();
                ++n2;
            }
        }
        m_afsProviders = null;
    }

    public FileSystemEntry getEntry(URI uriPath) throws IOException {
        return new FileSystemEntry(uriPath, this.getInstallToolkitBridge());
    }

    public String getChecksum(InputStream in) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return Checksum.getChecksum(in, "SHA");
    }

    public String getUTF8Contents(URI uriPath) throws IOException {
        InputStream inputstreamThis = this.readEntry(uriPath);
        String sReturn = this.readInputStreamCompletelyWithGivenEncoding(inputstreamThis, S_UTF_8);
        inputstreamThis.close();
        return sReturn;
    }

    public String getContents(URI uriPath) throws IOException {
        InputStream inputstreamThis = this.readEntry(uriPath);
        String sReturn = this.readInputStreamCompletely(inputstreamThis);
        inputstreamThis.close();
        return sReturn;
    }

    public void copyTo(URI uriPath, URI uriPathTo) throws IOException {
        try {
            FileSystem fsTo = FileSystem.getFileSystem(uriPathTo, this.getInstallToolkitBridge());
            OutputStream outThis = fsTo.writeEntry(uriPathTo, false);
            InputStream inThis = this.readEntry(uriPath);
            this.transferInputStreamToOutputStreamCompletely(inThis, outThis);
            inThis.close();
            outThis.close();
        }
        catch (Exception e) {
            Logr.warn(className, "copyTo", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    public void moveTo(URI uriPath, URI uriPathTo) throws IOException {
        try {
            this.renameTo(uriPath, uriPathTo);
        }
        catch (IOException e) {
            this.copyTo(uriPath, uriPathTo);
            this.deleteEntry(uriPath);
        }
    }

    public void writeUTF8Entry(URI uriPath, String sMessage, boolean fAppend) throws IOException {
        OutputStream out = this.writeEntry(uriPath, fAppend);
        ByteArrayInputStream in = new ByteArrayInputStream(sMessage.getBytes(S_UTF_8));
        this.transferInputStreamToOutputStreamCompletely(in, out);
        ((InputStream)in).close();
        out.close();
    }

    public void touch(URI uriPath) throws IOException {
        if (!this.exists(uriPath)) {
            this.writeEntry(uriPath).close();
        } else {
            this.setLastModifiedTime(uriPath, new Date().getTime());
        }
    }

    public void deleteThisDirectoryRecursively(URI uriPath) throws IOException {
        if (this.isDirectory(uriPath)) {
            URI[] auriEntries = this.getDirectoryEntries(uriPath);
            if (auriEntries.length == 0) {
                this.deleteEntry(uriPath);
                return;
            }
            URI[] uRIArray = auriEntries;
            int n = auriEntries.length;
            int n2 = 0;
            while (n2 < n) {
                URI auriEntrie = uRIArray[n2];
                if (this.isDirectory(auriEntrie)) {
                    this.deleteThisDirectoryRecursively(auriEntrie);
                } else {
                    this.deleteEntry(auriEntrie);
                }
                ++n2;
            }
        } else {
            this.deleteEntry(uriPath);
        }
    }

    public boolean isSymbolicLink(URI uriPath) throws IOException {
        return this.getSymbolicLinkTarget(uriPath) != null;
    }

    public URI getParentDirOrFSRoot(URI uriPath) throws IOException {
        return this.getParent(uriPath);
    }

    public URI[] getEntriesDirectlyUnderThisDir(URI uriPath) {
        return this.getDirectoryEntries(uriPath);
    }

    protected URI normalizeLocationURI(URI uriLocation, String child) throws URISyntaxException {
        String sPathLocation = uriLocation.getPath();
        if (!sPathLocation.endsWith("/")) {
            sPathLocation = String.valueOf(sPathLocation) + "/";
        }
        if (child != null) {
            sPathLocation = String.valueOf(sPathLocation) + child;
        }
        URI uriPathLocation = new URI(uriLocation.getScheme(), null, sPathLocation, null);
        return uriPathLocation;
    }

    public abstract long getSize(URI var1) throws IOException;

    public abstract void setLastModifiedTime(URI var1, long var2) throws IOException;

    public abstract InputStream readEntry(URI var1) throws IOException;

    public abstract OutputStream writeEntry(URI var1) throws IOException;

    public abstract OutputStream writeEntry(URI var1, boolean var2) throws IOException;

    public abstract void deleteEntry(URI var1) throws IOException;

    public abstract void deleteEntryOnExit(URI var1) throws IOException;

    public abstract void setPermissions(URI var1, int var2) throws IOException;

    public abstract int getPermissions(URI var1) throws IOException;

    public abstract long getLastModified(URI var1) throws IOException;

    public abstract void createSymbolicLink(URI var1, String var2) throws IOException;

    public abstract URI getFSURI(URI var1, String var2) throws URISyntaxException;

    public abstract boolean exists(URI var1);

    public abstract boolean isDirectory(URI var1);

    public abstract void mkdirs(URI var1) throws IOException;

    public abstract URI getParent(URI var1) throws IOException;

    public abstract String getCanonicalPath(URI var1) throws IOException;

    public abstract String getAbsolutePath(URI var1) throws IOException;

    public String getAbsolutePathWithFlagment(URI uriPath) throws IOException {
        return this.getAbsolutePath(uriPath);
    }

    public abstract void renameTo(URI var1, URI var2) throws IOException;

    public abstract String getEntryName(URI var1) throws IOException;

    public abstract URI[] getDirectoryEntries(URI var1);

    public abstract void flushFileSystemFor(URI var1) throws IOException;

    protected abstract void flush() throws IOException;

    protected abstract String getSupportedScheme();

    public abstract String getSymbolicLinkTarget(URI var1) throws IOException;

    public abstract void setHidden(URI var1);

    public abstract boolean isReadable(URI var1);

    public abstract boolean isWriteable(URI var1);

    public abstract void copyThisEntryInThisSourceToThisZipFileWithThisName(URI var1, String var2, ZipOutputStream var3, String var4) throws IOException;

    protected final UnifiedFileIO getUnifiedFileIOObject() {
        return this.getInstallToolkitBridge().getUnifiedFileIO();
    }

    @Override
    protected final String[] getRequiredParams() {
        return AS_EMPTY;
    }

    @Override
    protected final String[] getOptionalParams() {
        return AS_EMPTY;
    }

    protected void transferInputStreamToOutputStreamCompletely(InputStream inputstreamThis, OutputStream outputstreamThis) throws IOException {
        int nBytesRead = 0;
        int totBytesRead = 0;
        while (nBytesRead != -1) {
            nBytesRead = 0;
            totBytesRead = 0;
            while (totBytesRead < AB_SIZE && nBytesRead != -1) {
                nBytesRead = inputstreamThis.read(AB_IO_BUFFER, totBytesRead, AB_SIZE - totBytesRead);
                if (nBytesRead <= 0) continue;
                totBytesRead += nBytesRead;
            }
            outputstreamThis.write(AB_IO_BUFFER, 0, totBytesRead);
        }
    }

    private static void registerFileSystemProviders(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (m_afsProviders != null) {
            return;
        }
        File fileFSDB = new File(NIFConstants.getMetadataDirectory(), "framework/filesystems.xml");
        SimpleXMLParser sxp = new SimpleXMLParser(fileFSDB);
        NIFPlugin[] anifp = NIFPlugin.createPlugins(sxp.getDocument(), "filesystems/fsprovider-plugin", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(FileSystem.class, anifp);
        m_afsProviders = new FileSystem[anifp.length];
        int i = 0;
        while (i < anifp.length) {
            FileSystem.m_afsProviders[i] = (FileSystem)anifp[i];
            ++i;
        }
    }

    private String readInputStreamCompletely(InputStream inputstreamThis) throws IOException {
        return this.readInputStreamCompletelyWithGivenEncoding(inputstreamThis, null);
    }

    private String readInputStreamCompletelyWithGivenEncoding(InputStream inputstreamThis, String sEncoding) throws IOException {
        byte[] abTotal = new byte[inputstreamThis.available()];
        int nRead = 0;
        while (nRead != abTotal.length) {
            nRead += inputstreamThis.read(abTotal, nRead, abTotal.length - nRead);
        }
        String sFileContents = null;
        sFileContents = sEncoding == null ? new String(abTotal) : new String(abTotal, sEncoding);
        return sFileContents;
    }
}

