/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.util.Hashtable;

public class ReplaceFileActionPlugin
extends FileActionPlugin {
    private static final String S_FILE_ACTION_ID = "replace";
    private static final String S_INVERSE_FILE_ACTION_ID = "replace";
    private static final String S_REMOVE_FILE_ACTION_ID = "remove";
    private static final String S_TRUE = "true";
    private static final String S_SKIP_DELETE_ON_REPLACE = "com.ibm.was.updi.skipDeleteOnReplace";
    private static final String className = "ReplaceFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        if (this.isThisReallyABackupForAnAddOperation(hashtableFileDetails)) {
            return;
        }
        String sPathOfTheFileToBeUpdated = (String)hashtableFileDetails.get("relativepath");
        Logr.debug("It is replace operation :" + sPathOfTheFileToBeUpdated);
        try {
            String skipDelete;
            FileSystemEntry fseSourceRepositoryPath = ReplaceFileActionPlugin.resolveSourceRepository(hashtableFileDetails);
            FileSystemEntry fseInstallLocationPath = ReplaceFileActionPlugin.resolveInstallLocation(hashtableFileDetails);
            String sFilePermissions = hashtableFileDetails.get("permissions").toString();
            String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
            FileSystemEntry fseFrom = new FileSystemEntry(fseSourceRepositoryPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
            FileSystemEntry fseTo = new FileSystemEntry(fseInstallLocationPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
            if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails) && FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseFrom);
            }
            if ((skipDelete = System.getProperty(S_SKIP_DELETE_ON_REPLACE)) == null || !skipDelete.equalsIgnoreCase(S_TRUE)) {
                this.deleteTargetFileSystemEntryIfItExists(hashtableFileDetails);
            }
            Logr.debug("ReplaceFileAction - fseFrom :" + fseFrom.getAbsolutePath() + " fseTo :" + fseTo.getAbsolutePath());
            fseFrom.copyTo(fseTo);
            if (!FileActionPlugin.isBackupFlagActive(hashtableFileDetails) && !PlatformConstants.isCurrentPlatformWindows()) {
                fseTo.setPermissions(sFilePermissions);
            }
        }
        catch (IOException e) {
            Logr.warn(className, "execute", e.getMessage(), e);
            throw new NIFFileActionIOException(e.getMessage(), this.getIOExceptionDescription(sPathOfTheFileToBeUpdated), sPathOfTheFileToBeUpdated);
        }
    }

    protected boolean isThisFileActionAcceptable(String sFileActionID) {
        return "replace".equals(sFileActionID);
    }

    protected static FileSystemEntry resolveSourceRepository(Hashtable hashtableFileDetails) {
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            return (FileSystemEntry)hashtableFileDetails.get("installlocation");
        }
        return (FileSystemEntry)hashtableFileDetails.get("sourcerepository");
    }

    protected static FileSystemEntry resolveInstallLocation(Hashtable hashtableFileDetails) {
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            Logr.methodReturn(className, "resolveInstallLocation", hashtableFileDetails.get("backuprepository"));
            return (FileSystemEntry)hashtableFileDetails.get("backuprepository");
        }
        Logr.methodReturn(className, "resolveInstallLocation", hashtableFileDetails.get("installlocation"));
        return (FileSystemEntry)hashtableFileDetails.get("installlocation");
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return "replace".equals(sFileActionID);
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) throws IOException {
        if (this.isThisReallyABackupForAnAddOperation(hashtableFileDetails)) {
            return S_REMOVE_FILE_ACTION_ID;
        }
        return "replace";
    }

    private boolean isThisReallyABackupForAnAddOperation(Hashtable hashtableFileDetails) {
        return !this.doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(hashtableFileDetails) && FileActionPlugin.isBackupFlagActive(hashtableFileDetails);
    }

    private boolean doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(Hashtable hashtableFileDetails) {
        FileSystemEntry fseInstallRoot = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sRelativePath = hashtableFileDetails.get("relativepath").toString();
        try {
            FileSystemEntry fseCheck = new FileSystemEntry(fseInstallRoot.getURI(), sRelativePath, this.getInstallToolkitBridge());
            return fseCheck.exists();
        }
        catch (IOException e) {
            Logr.warn(className, "doesTheFileToBeOperatedUponAlreadyExistInInstallRoot", e.getMessage(), e);
            return false;
        }
    }

    private void deleteTargetFileSystemEntryIfItExists(Hashtable hashtableFileDetails) throws IOException {
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            return;
        }
        FileSystemEntry fseInstallLocationPath = ReplaceFileActionPlugin.resolveInstallLocation(hashtableFileDetails);
        String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
        FileSystemEntry fseTo = new FileSystemEntry(fseInstallLocationPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
        if (fseTo.exists()) {
            fseTo.delete();
        }
    }

    private String getIOExceptionDescription(String sPathOfTheFileToBeUpdated) {
        return PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_REPLACEFILEACTIONPLUGIN_IOEXCEPTIONDESCRIPTION, (Object)sPathOfTheFileToBeUpdated);
    }
}

