/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.RemoveFileActionPlugin;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.util.Hashtable;

public class RemoveSymLinkFileActionPlugin
extends RemoveFileActionPlugin {
    public static final String S_SYMBOLIC_LINK_KEY = "symbolic-link";
    private static final String S_FILE_ACTION_ID = "removesymlink";
    private static final String S_INVERSE_FILE_ACTION_ID = "addsymlink";
    private static final String className = "RemoveSymLinkFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            FileSystemEntry fseInstallLocationPath = (FileSystemEntry)hashtableFileDetails.get("installlocation");
            String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
            FileSystemEntry fseFrom = new FileSystemEntry(fseInstallLocationPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
            if (FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseFrom);
            }
            return;
        }
        super.execute(hashtableFileDetails);
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return S_FILE_ACTION_ID.equals(sFileActionID);
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) {
        if (!this.doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(hashtableFileDetails)) {
            return "nop";
        }
        return S_INVERSE_FILE_ACTION_ID;
    }

    private boolean doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(Hashtable hashtableFileDetails) {
        FileSystemEntry fseInstallRoot = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sRelativePath = hashtableFileDetails.get("relativepath").toString();
        try {
            FileSystemEntry fseCheck = new FileSystemEntry(fseInstallRoot.getURI(), sRelativePath, this.getInstallToolkitBridge());
            return fseCheck.exists();
        }
        catch (IOException e) {
            Logr.warn(className, "doesTheFileToBeOperatedUponAlreadyExistInInstallRoot", e.getMessage(), e);
            return false;
        }
    }
}

