/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.utils.componentactions.ComponentMapParser;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentizedRepositoryConstants;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class ComponentMapRepositoryParser {
    private final Vector m_vcmpAllComponentMaps = new Vector();

    public ComponentMapRepositoryParser(FileSystemEntry fseComponentMapRepositoryPath, InstallToolkitBridge itb) throws IOException {
        this.initComponentmapsPresentInTheRepository(fseComponentMapRepositoryPath, itb);
    }

    public Vector getTheListOfComponentsToInstallOrUninstall() throws IOException {
        return new Vector(this.getTheSetOfComponentsToInstallOrUninstall());
    }

    public Vector getTheListOfFeaturesAlreadyInstalled() throws IOException {
        return new Vector(this.getTheSetOfFeaturesAlreadyInstalled());
    }

    public Set getTheSetOfComponentsToInstallOrUninstall() throws IOException {
        TreeSet setReturn = new TreeSet();
        int i = 0;
        while (i < this.m_vcmpAllComponentMaps.size()) {
            ComponentMapParser cmpComponentMapThis = (ComponentMapParser)this.m_vcmpAllComponentMaps.elementAt(i);
            Set setOfComponentsInThisMap = cmpComponentMapThis.getSetOfComponentsInThisComponentMap();
            setReturn.addAll(setOfComponentsInThisMap);
            ++i;
        }
        return setReturn;
    }

    public Set getTheSetOfFeaturesAlreadyInstalled() throws IOException {
        TreeSet setReturn = new TreeSet();
        int i = 0;
        while (i < this.m_vcmpAllComponentMaps.size()) {
            ComponentMapParser cmpComponentMapThis = (ComponentMapParser)this.m_vcmpAllComponentMaps.elementAt(i);
            Set setOfFeaturesInThisMap = cmpComponentMapThis.getSetOfFeaturesInThisComponentMap();
            setReturn.addAll(setOfFeaturesInThisMap);
            ++i;
        }
        return setReturn;
    }

    public static void moveAllComponentMapsInSourceRepositoryToDestinationRepository(FileSystemEntry fseSourceComponentMapRepositoryPath, FileSystemEntry fseDestinationComponentMapRepositoryPath, InstallToolkitBridge itb) throws IOException {
        Vector vfseAllComponentMaps = ComponentMapRepositoryParser.getTheListOfAllComponentMapsInTheRepository(fseSourceComponentMapRepositoryPath);
        int i = 0;
        while (i < vfseAllComponentMaps.size()) {
            FileSystemEntry fseOriginal = (FileSystemEntry)vfseAllComponentMaps.elementAt(i);
            FileSystemEntry fseDestination = new FileSystemEntry(fseOriginal.getParent().getURI(), fseOriginal.getEntryName(), itb);
            fseOriginal.moveTo(fseDestination);
            ++i;
        }
    }

    public boolean isThisFeaturePresent(String sFeatureID) {
        int i = 0;
        while (i < this.m_vcmpAllComponentMaps.size()) {
            ComponentMapParser cmpComponentMapThis = (ComponentMapParser)this.m_vcmpAllComponentMaps.elementAt(i);
            try {
                if (cmpComponentMapThis.getFeatureID().equals(sFeatureID)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        return false;
    }

    public void addComponentToThisComponentMap(String sFeatureID, String sComponentName) throws IOException {
        int i = 0;
        while (i < this.m_vcmpAllComponentMaps.size()) {
            ComponentMapParser cmpComponentMapThis = (ComponentMapParser)this.m_vcmpAllComponentMaps.elementAt(i);
            if (cmpComponentMapThis.getFeatureID().equals(sFeatureID)) {
                cmpComponentMapThis.addComponent(sComponentName);
                return;
            }
            ++i;
        }
    }

    private static Vector getTheListOfAllComponentMapsInTheRepository(FileSystemEntry fseComponentMapRepositoryPath) throws IOException {
        FileSystemEntry[] afseAllFilesFoundInTheComponentMapRepository = fseComponentMapRepositoryPath.getDirectoryEntries();
        Vector<FileSystemEntry> vfseComponentMapFilesFound = new Vector<FileSystemEntry>();
        FileSystemEntry[] fileSystemEntryArray = afseAllFilesFoundInTheComponentMapRepository;
        int n = afseAllFilesFoundInTheComponentMapRepository.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystemEntry element = fileSystemEntryArray[n2];
            String sFileNameThis = element.getEntryName();
            if (ComponentizedRepositoryConstants.PATTERN_COMPONENT_MAP_FILE_NAMES.matcher(sFileNameThis).matches()) {
                vfseComponentMapFilesFound.add(element);
            }
            ++n2;
        }
        return vfseComponentMapFilesFound;
    }

    private void initComponentmapsPresentInTheRepository(FileSystemEntry fseComponentMapRepositoryPath, InstallToolkitBridge itb) throws IOException {
        FileSystemEntry[] afseAllFilesFoundInTheComponentMapRepository;
        FileSystemEntry[] fileSystemEntryArray = afseAllFilesFoundInTheComponentMapRepository = fseComponentMapRepositoryPath.getDirectoryEntries();
        int n = afseAllFilesFoundInTheComponentMapRepository.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystemEntry element = fileSystemEntryArray[n2];
            String sFileNameThis = element.getEntryName();
            if (ComponentizedRepositoryConstants.PATTERN_COMPONENT_MAP_FILE_NAMES.matcher(sFileNameThis).matches()) {
                this.m_vcmpAllComponentMaps.add(new ComponentMapParser(element, itb));
            }
            ++n2;
        }
    }
}

