/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils;

import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class URIUtils {
    private static final char S_WINDOWS_FILE_SEPARATOR = '\\';
    private static final char S_LINUX_FILE_SEPARATOR = '/';
    private static final String className = "URIUtils";

    public static URI convertPathToURI(String sPath, InstallToolkitBridge itb) throws URISyntaxException {
        int nIndex = sPath.indexOf("#");
        if (nIndex < 0) {
            String sResolvedPath = null;
            sResolvedPath = MacroResolver.resolveMacro("$NIFURI{" + sPath + "}", itb, null);
            return new URI(sResolvedPath);
        }
        String sEntryPath = sPath.substring(nIndex + 1);
        String sParentPath = sPath.substring(0, nIndex);
        URI uriParent = URIUtils.convertPathToURI(sParentPath, itb);
        try {
            return new FileSystemEntry(uriParent, sEntryPath, itb).getURI();
        }
        catch (IOException e) {
            Logr.warn(className, "convertPathToURI", e.getMessage(), e);
            return null;
        }
    }

    public static URI convertPathToDefaultTargetMachineFSURI(String sPath, InstallToolkitBridge itb) throws URISyntaxException {
        String sResolvedPath = MacroResolver.resolveMacro("$NIFDEFFSTARGETURI{" + sPath + "}", itb, null);
        return new URI(sResolvedPath);
    }

    public static URI convertPathToDefaultSourceMachineFSURI(String sPath, InstallToolkitBridge itb) throws URISyntaxException {
        String sResolvedPath = MacroResolver.resolveMacro("$NIFDEFFSSOURCEURI{" + sPath + "}", itb, null);
        return new URI(sResolvedPath);
    }

    public static FileSystemEntry convertPathToFSE(String sPath, InstallToolkitBridge itb) throws IOException, URISyntaxException {
        URI uriPath = URIUtils.convertPathToURI(sPath, itb);
        return new FileSystemEntry(uriPath, itb);
    }

    public static FileSystemEntry convertPathToDefaultTargetMachineFSE(String sPath, InstallToolkitBridge itb) throws IOException, URISyntaxException {
        URI uriPath = URIUtils.convertPathToDefaultTargetMachineFSURI(sPath, itb);
        return new FileSystemEntry(uriPath, itb);
    }

    public static FileSystemEntry convertPathToDefaultSourceMachineFSE(String sPath, InstallToolkitBridge itb) throws IOException, URISyntaxException {
        URI uriPath = URIUtils.convertPathToDefaultSourceMachineFSURI(sPath, itb);
        return new FileSystemEntry(uriPath, itb);
    }

    public static String convertURIPathToPlatformFilePath(URI uriLocation) {
        if (uriLocation != null) {
            String sPath = uriLocation.getPath();
            if (sPath.endsWith("/")) {
                sPath = sPath.substring(0, sPath.length() - 1);
            }
            if (PlatformConstants.isCurrentPlatformWindows() && !PlatformConstants.isOS400Install()) {
                return sPath.substring(1).replace('/', '\\');
            }
            return sPath;
        }
        return null;
    }
}

