/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.install.registry.NIFRegistryHelper;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryObjectEntry;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryOfferingEntry;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.w3c.dom.Node;

public class NIFRegistryPAKEntry
extends NIFRegistryObjectEntry {
    private final String className = "NIFRegistryPAKEntry";
    protected String m_sNIFPackageName = null;
    protected URI m_uriBackupPakLocationURI = null;
    protected URI m_uriOfferingLocationURI = null;
    protected String m_sOffering = null;
    private boolean m_bSamePAKName = true;
    private boolean m_bSameBackupPAKLocation = true;
    private boolean m_bSameOfferingLocation = true;
    private boolean m_bSameOffering = true;

    public NIFRegistryPAKEntry() throws URISyntaxException {
        this((String)null, (URI)null, (String)null, (URI)null);
    }

    public NIFRegistryPAKEntry(NIFRegistryPAKEntry nifrpe) throws URISyntaxException {
        this(nifrpe.getNIFPackageName(), nifrpe.getBackupPakLocationURI(), nifrpe.getOffering(), nifrpe.getOfferingLocationURI());
    }

    public NIFRegistryPAKEntry(String sNIFPackageName, URI uriBackupPakLocationURI, String sOffering, String sOfferingLocation) throws URISyntaxException {
        this(sNIFPackageName, uriBackupPakLocationURI, sOffering, NIFRegistryHelper.normalizeLocation(sOfferingLocation));
    }

    public NIFRegistryPAKEntry(String sNIFPackageName, URI uriBackupPakLocationURI, String sOffering, URI uriOfferingLocationURI) throws URISyntaxException {
        this.setNIFRegistryObjectName("pak");
        this.setNIFPackageName(sNIFPackageName);
        this.setBackupPakLocationURI(uriBackupPakLocationURI);
        this.setOfferingLocationURI(uriOfferingLocationURI);
        this.setOffering(sOffering);
    }

    public NIFRegistryPAKEntry(Node nodePAKEntry) throws URISyntaxException {
        super(nodePAKEntry);
        this.updateMemberVariablesFromRawData();
    }

    public String getNIFPackageName() {
        return this.m_sNIFPackageName;
    }

    public void setNIFPackageName(String sNIFPackageName) {
        this.m_sNIFPackageName = sNIFPackageName;
        if (this.m_sNIFPackageName != null) {
            this.setAttribute("name", this.m_sNIFPackageName);
        }
    }

    public String getBackupPakLocationPath() {
        return URIUtils.convertURIPathToPlatformFilePath(this.m_uriBackupPakLocationURI);
    }

    URI getBackupPakLocationURI() {
        return this.m_uriBackupPakLocationURI;
    }

    public void setBackupPakLocationURI(URI uriBackupPakLocationURI) throws URISyntaxException {
        this.m_uriBackupPakLocationURI = NIFRegistryHelper.normalizeLocationURI(uriBackupPakLocationURI);
        if (this.m_uriBackupPakLocationURI != null) {
            this.setAttribute("paklocationuri", this.m_uriBackupPakLocationURI.toString());
        }
    }

    public String getOfferingLocationPath() {
        return URIUtils.convertURIPathToPlatformFilePath(this.m_uriOfferingLocationURI);
    }

    URI getOfferingLocationURI() {
        return this.m_uriOfferingLocationURI;
    }

    public void setOfferingLocationURI(URI uriOfferingLocation) throws URISyntaxException {
        this.m_uriOfferingLocationURI = NIFRegistryHelper.normalizeLocationURI(uriOfferingLocation);
        if (this.m_uriOfferingLocationURI != null) {
            this.setAttribute("installrooturi", this.m_uriOfferingLocationURI.toString());
        }
    }

    public String getOffering() {
        return this.m_sOffering;
    }

    public void setOffering(String sOffering) {
        this.m_sOffering = sOffering;
        if (this.m_sOffering != null) {
            this.setAttribute("productid", this.m_sOffering);
        }
    }

    public boolean doesThisPAKEntryHasTheseAttributes(NIFRegistryPAKEntry nifrpeThis) {
        this.setCompareFlags(true);
        return this.comparePAKEntry(nifrpeThis);
    }

    @Override
    public boolean doesThisNodeRepresentThisRegistryEntry(Node nodeEntry) {
        try {
            String sPAKName = SimpleXMLParser.getNodeAttributeValue(nodeEntry, "name");
            String sPAKLocationURI = SimpleXMLParser.getNodeAttributeValue(nodeEntry, "paklocationuri");
            URI uriPAKLocationURI = new URI(sPAKLocationURI);
            String sOffering = SimpleXMLParser.getNodeAttributeValue(nodeEntry, "productid");
            String sOfferingLocationURI = SimpleXMLParser.getNodeAttributeValue(nodeEntry, "installrooturi");
            URI uriOfferingLocationURI = new URI(sOfferingLocationURI);
            NIFRegistryPAKEntry nifrpeThisNode = new NIFRegistryPAKEntry(sPAKName, uriPAKLocationURI, sOffering, uriOfferingLocationURI);
            return nifrpeThisNode.equals(this);
        }
        catch (Exception e) {
            Logr.warn("NIFRegistryPAKEntry", "doesThisNodeRepresentThisRegistryEntry", e.getMessage(), e);
            return false;
        }
    }

    public boolean isThisPAKEntryAssociatedWithThisOffering(NIFRegistryOfferingEntry nifroeThis) throws URISyntaxException {
        if (nifroeThis == null) {
            return false;
        }
        NIFRegistryPAKEntry nifrpeTemp = new NIFRegistryPAKEntry(null, null, nifroeThis.getOffering(), nifroeThis.getOfferingLocationURI());
        return this.doesThisPAKEntryHasTheseAttributes(nifrpeTemp);
    }

    public boolean equals(Object nifrpePAK) {
        NIFRegistryPAKEntry nifrpePAKThis = (NIFRegistryPAKEntry)nifrpePAK;
        this.setCompareFlags(false);
        return this.comparePAKEntry(nifrpePAKThis);
    }

    public int hashCode() {
        if (this.m_sNIFPackageName == null || this.m_uriOfferingLocationURI == null) {
            return super.hashCode();
        }
        String sHashString = String.valueOf(this.m_sNIFPackageName) + this.m_uriOfferingLocationURI.getPath().toLowerCase();
        return sHashString.hashCode();
    }

    protected void updateMemberVariablesFromRawData() throws URISyntaxException {
        Map mapAttribute = this.getAttributesMap();
        for (String sAttribName : mapAttribute.keySet()) {
            if (sAttribName.equals("name")) {
                this.m_sNIFPackageName = (String)mapAttribute.get(sAttribName);
                continue;
            }
            if (sAttribName.equals("paklocationuri")) {
                this.m_uriBackupPakLocationURI = new URI((String)mapAttribute.get(sAttribName));
                continue;
            }
            if (sAttribName.equals("productid")) {
                this.m_sOffering = (String)mapAttribute.get(sAttribName);
                continue;
            }
            if (!sAttribName.equals("installrooturi")) continue;
            this.m_uriOfferingLocationURI = new URI((String)mapAttribute.get(sAttribName));
        }
    }

    private boolean comparePAKEntry(NIFRegistryPAKEntry nifrpeInput) {
        String sPAKNameInput = nifrpeInput.getNIFPackageName();
        URI uriBackupPakLocationURIInput = nifrpeInput.getBackupPakLocationURI();
        URI uriOfferingLocationURIInput = nifrpeInput.getOfferingLocationURI();
        String sOfferingInput = nifrpeInput.getOffering();
        if (sPAKNameInput != null && this.m_sNIFPackageName != null) {
            this.m_bSamePAKName = this.m_sNIFPackageName.equals(sPAKNameInput);
        }
        if (uriBackupPakLocationURIInput != null && this.m_uriBackupPakLocationURI != null) {
            this.m_bSameBackupPAKLocation = NIFRegistryHelper.AreTheseURIsPointToSameLocation(this.m_uriBackupPakLocationURI, uriBackupPakLocationURIInput);
        }
        if (uriOfferingLocationURIInput != null && this.m_uriOfferingLocationURI != null) {
            this.m_bSameOfferingLocation = NIFRegistryHelper.AreTheseURIsPointToSameLocation(this.m_uriOfferingLocationURI, uriOfferingLocationURIInput);
        }
        if (sOfferingInput != null && this.m_sOffering != null) {
            this.m_bSameOffering = this.m_sOffering.equals(sOfferingInput);
        }
        return this.m_bSameOfferingLocation & this.m_bSamePAKName & this.m_bSameBackupPAKLocation & this.m_bSameOffering;
    }

    private void setCompareFlags(boolean bFlag) {
        this.m_bSamePAKName = bFlag;
        this.m_bSameBackupPAKLocation = bFlag;
        this.m_bSameOfferingLocation = bFlag;
        this.m_bSameOffering = bFlag;
    }
}

