/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.install.registry.NIFRegistryHelper;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryObjectEntry;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Node;

public class NIFRegistryOfferingEntry
extends NIFRegistryObjectEntry {
    private final String className = "NIFRegistryOfferingEntry";
    private String m_sOffering = null;
    private URI m_uriOfferingLocationURI = null;
    private String m_sOfferingLastVisited = null;
    private String m_sOfferingVersion = null;
    private boolean m_bSameOffering = true;
    private boolean m_bSameOfferingLocation = true;
    private boolean m_bSameOfferingVersion = true;

    public NIFRegistryOfferingEntry() throws URISyntaxException {
        this((String)null, (URI)null, (String)null, (String)null);
    }

    public NIFRegistryOfferingEntry(NIFRegistryOfferingEntry nifroe) throws URISyntaxException {
        this(nifroe.getOffering(), nifroe.getOfferingLocationURI(), nifroe.getOfferingLastVisited(), nifroe.getOfferingVersion());
    }

    public NIFRegistryOfferingEntry(String sOffering, String sOfferingLocation, String sOfferingLastVisited, String sOfferingVersion) throws URISyntaxException {
        this(sOffering, NIFRegistryHelper.normalizeLocation(sOfferingLocation), sOfferingLastVisited, sOfferingVersion);
    }

    public NIFRegistryOfferingEntry(String sOffering, URI uriOfferingLocation, String sOfferingLastVisited, String sOfferingVersion) throws URISyntaxException {
        this.setNIFRegistryObjectName("product");
        this.setOfferingLocationURI(uriOfferingLocation);
        this.setOfferingLastVisited(sOfferingLastVisited);
        this.setOfferingVersion(sOfferingVersion);
        this.setOffering(sOffering);
    }

    public NIFRegistryOfferingEntry(Node nodeOfferingEntry) throws URISyntaxException {
        super(nodeOfferingEntry);
        this.updateMemberVariablesFromRawData();
    }

    public String getOffering() {
        return this.m_sOffering;
    }

    public void setOffering(String sOffering) {
        this.m_sOffering = sOffering;
        if (this.m_sOffering != null) {
            this.setAttribute("productid", this.m_sOffering);
        }
    }

    public String getOfferingLocationPath() {
        return URIUtils.convertURIPathToPlatformFilePath(this.m_uriOfferingLocationURI);
    }

    URI getOfferingLocationURI() {
        return this.m_uriOfferingLocationURI;
    }

    public void setOfferingLocationURI(URI uriOfferingLocation) throws URISyntaxException {
        this.m_uriOfferingLocationURI = NIFRegistryHelper.normalizeLocationURI(uriOfferingLocation);
        if (this.m_uriOfferingLocationURI != null) {
            this.setAttribute("installrooturi", this.m_uriOfferingLocationURI.toString());
        }
    }

    public String getOfferingLastVisited() {
        return this.m_sOfferingLastVisited;
    }

    public Date getOfferingLastVisitedDate() throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ").parse(this.m_sOfferingLastVisited);
    }

    public void setOfferingLastVisited(String offeringLastVisited) {
        this.m_sOfferingLastVisited = offeringLastVisited;
        if (this.m_sOfferingLastVisited != null) {
            this.setAttribute("lastvisited", this.m_sOfferingLastVisited);
        }
    }

    public String getOfferingVersion() {
        return this.m_sOfferingVersion;
    }

    public void setOfferingVersion(String offeringVersion) {
        this.m_sOfferingVersion = offeringVersion;
        if (this.m_sOfferingVersion != null) {
            this.setAttribute("version", this.m_sOfferingVersion);
        }
    }

    public boolean doesThisOfferingEntryHasTheseAttributes(NIFRegistryOfferingEntry nifroeThis) {
        String sOfferingLastVisited = nifroeThis.getOfferingLastVisited();
        this.setCompareFlags(true);
        boolean bSameOfferingLastVisited = true;
        if (sOfferingLastVisited != null && this.m_sOfferingLastVisited != null) {
            bSameOfferingLastVisited = this.m_sOfferingLastVisited.equals(sOfferingLastVisited);
        }
        return this.compareOfferingEntry(nifroeThis) & bSameOfferingLastVisited;
    }

    @Override
    public boolean doesThisNodeRepresentThisRegistryEntry(Node nodeEntry) {
        try {
            String sOffering = SimpleXMLParser.getNodeAttributeValue(nodeEntry, "productid");
            String sOfferingLocationURI = SimpleXMLParser.getNodeAttributeValue(nodeEntry, "installrooturi");
            URI uriOfferingLocationURI = new URI(sOfferingLocationURI);
            String sOfferingVersion = SimpleXMLParser.getNodeAttributeValue(nodeEntry, "version");
            NIFRegistryOfferingEntry nifroeThisNode = new NIFRegistryOfferingEntry(sOffering, uriOfferingLocationURI, null, sOfferingVersion);
            return nifroeThisNode.equals(this);
        }
        catch (Exception e) {
            Logr.warn("NIFRegistryOfferingEntry", "doesThisNodeRepresentThisRegistryEntry", e.getMessage(), e);
            return false;
        }
    }

    public boolean equals(Object nifroeOffering) {
        NIFRegistryOfferingEntry nifroeOfferingThis = (NIFRegistryOfferingEntry)nifroeOffering;
        this.setCompareFlags(false);
        return this.compareOfferingEntry(nifroeOfferingThis);
    }

    public int hashCode() {
        if (this.m_sOffering == null || this.m_uriOfferingLocationURI == null) {
            return super.hashCode();
        }
        String sHashString = String.valueOf(this.m_sOffering) + this.m_uriOfferingLocationURI.getPath().toLowerCase();
        return sHashString.hashCode();
    }

    protected void updateMemberVariablesFromRawData() throws URISyntaxException {
        Map mapAttribute = this.getAttributesMap();
        for (String sAttribName : mapAttribute.keySet()) {
            if (sAttribName.equals("productid")) {
                this.m_sOffering = (String)mapAttribute.get(sAttribName);
                continue;
            }
            if (sAttribName.equals("installrooturi")) {
                this.m_uriOfferingLocationURI = new URI((String)mapAttribute.get(sAttribName));
                continue;
            }
            if (sAttribName.equals("lastvisited")) {
                this.m_sOfferingLastVisited = (String)mapAttribute.get(sAttribName);
                continue;
            }
            if (!sAttribName.equals("version")) continue;
            this.m_sOfferingVersion = (String)mapAttribute.get(sAttribName);
        }
    }

    protected boolean compareOfferingEntry(NIFRegistryOfferingEntry nifroeInput) {
        String sOffering = nifroeInput.getOffering();
        URI uriOfferingLocationURI = nifroeInput.getOfferingLocationURI();
        String sOfferingVersion = nifroeInput.getOfferingVersion();
        if (sOffering != null && this.getOffering() != null) {
            this.m_bSameOffering = this.getOffering().equals(sOffering);
        }
        if (uriOfferingLocationURI != null && this.m_uriOfferingLocationURI != null) {
            this.m_bSameOfferingLocation = NIFRegistryHelper.AreTheseURIsPointToSameLocation(this.m_uriOfferingLocationURI, uriOfferingLocationURI);
        }
        if (sOfferingVersion != null && this.m_sOfferingVersion != null) {
            this.m_bSameOfferingVersion = this.m_sOfferingVersion.equals(sOfferingVersion);
        }
        return this.m_bSameOffering & this.m_bSameOfferingLocation & this.m_bSameOfferingVersion;
    }

    protected void setCompareFlags(boolean bFlag) {
        this.m_bSameOfferingLocation = bFlag;
        this.m_bSameOffering = bFlag;
        this.m_bSameOfferingVersion = bFlag;
    }
}

