/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.install.registry.NIFRegistryDirectory;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryOfferingEntry;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryPAKEntry;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class NIFRegistryMergerDelta {
    protected Vector m_vnifroeAddToCorrectReg = new Vector();
    protected Vector m_vnifroeRemoveFromCorrectReg = new Vector();
    protected LinkedHashMap m_lhmCorrectRegEntries = null;
    protected LinkedHashMap m_lhmRegToMergeEntries = null;
    protected LinkedHashMap m_lhmMergedEntries = null;
    protected InstallToolkitBridge m_itb = null;

    public NIFRegistryMergerDelta(LinkedHashMap lhmCorrectRegEntries, LinkedHashMap lhmRegToMergeEntries, InstallToolkitBridge itb) throws IOException, URISyntaxException, ParseException {
        this.m_lhmCorrectRegEntries = lhmCorrectRegEntries;
        this.m_lhmRegToMergeEntries = lhmRegToMergeEntries;
        this.m_lhmMergedEntries = this.cloneLinkedHashMapEntries(this.m_lhmCorrectRegEntries);
        this.m_itb = itb;
        this.merge();
    }

    public Vector getRegistryObjectVectorAddToCorrectRegistry() {
        return this.m_vnifroeAddToCorrectReg;
    }

    public Vector getRegistryObjectVectorRemoveFromCorrectRegistry() {
        return this.m_vnifroeRemoveFromCorrectReg;
    }

    public LinkedHashMap getMergedRegistry() {
        return this.m_lhmMergedEntries;
    }

    protected void merge() throws IOException, URISyntaxException, ParseException {
        String sMsg = null;
        Vector vnifroeFromCorrectReg = new Vector(this.m_lhmCorrectRegEntries.keySet());
        Vector vnifroeFromRegToMerge = new Vector(this.m_lhmRegToMergeEntries.keySet());
        int i = 0;
        while (i < vnifroeFromCorrectReg.size()) {
            NIFRegistryOfferingEntry nifroeFromCorrectReg = (NIFRegistryOfferingEntry)vnifroeFromCorrectReg.get(i);
            String sOffering = nifroeFromCorrectReg.getOffering();
            String sInstallLocationPath = nifroeFromCorrectReg.getOfferingLocationPath();
            NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(sOffering, sInstallLocationPath, null, null);
            int j = 0;
            boolean bFoundMatchOffering = false;
            while (j < vnifroeFromRegToMerge.size() && !bFoundMatchOffering) {
                NIFRegistryOfferingEntry nifroeFromRegToMerge = (NIFRegistryOfferingEntry)vnifroeFromRegToMerge.get(j);
                if (nifroeFromRegToMerge.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                    Date dateRegToMerge;
                    bFoundMatchOffering = true;
                    Date dateCorrectReg = nifroeFromCorrectReg.getOfferingLastVisitedDate();
                    if (dateCorrectReg.compareTo(dateRegToMerge = nifroeFromRegToMerge.getOfferingLastVisitedDate()) < 0) {
                        Vector vnifrpeCorrectReg = (Vector)this.m_lhmCorrectRegEntries.get(nifroeFromCorrectReg);
                        this.m_vnifroeRemoveFromCorrectReg.addAll(vnifrpeCorrectReg);
                        this.m_vnifroeRemoveFromCorrectReg.add(nifroeFromCorrectReg);
                        this.m_lhmMergedEntries.remove(nifroeFromCorrectReg);
                        sMsg = "\nThis offering and pak entries are removed from correct registry as they are out-dated.\nOffering: " + nifroeFromCorrectReg.getOffering() + "\nInstall Location: " + nifroeFromCorrectReg.getOfferingLocationPath();
                        Logr.debug(sMsg);
                        Vector vnifrpeRegToMerge = (Vector)this.m_lhmRegToMergeEntries.get(nifroeFromRegToMerge);
                        this.m_vnifroeAddToCorrectReg.addAll(vnifrpeRegToMerge);
                        this.m_vnifroeAddToCorrectReg.add(nifroeFromRegToMerge);
                        this.m_lhmMergedEntries.put(nifroeFromRegToMerge, vnifrpeRegToMerge);
                        sMsg = "\nThis offering and pak entries are added to correct registry as they are up-to-date.\nOffering: " + nifroeFromRegToMerge.getOffering() + "\nInstall Location: " + nifroeFromRegToMerge.getOfferingLocationPath();
                        Logr.debug(sMsg);
                    }
                    this.m_lhmCorrectRegEntries.remove(nifroeFromCorrectReg);
                    this.m_lhmRegToMergeEntries.remove(nifroeFromRegToMerge);
                }
                ++j;
            }
            ++i;
        }
        for (NIFRegistryOfferingEntry nifroeThis : this.m_lhmCorrectRegEntries.keySet()) {
            URI uriInstallLocation = URIUtils.convertPathToDefaultTargetMachineFSURI(nifroeThis.getOfferingLocationPath(), this.m_itb);
            NIFRegistryDirectory nifrdThisLocation = NIFRegistryDirectory.getNIFRegistryDirectoryInstance(uriInstallLocation, this.m_itb);
            if (nifrdThisLocation == null || nifrdThisLocation.isThisProductInstalled(nifroeThis.getOffering())) continue;
            Vector vnifrpeThisOffering = (Vector)this.m_lhmCorrectRegEntries.get(nifroeThis);
            int i2 = 0;
            while (i2 < vnifrpeThisOffering.size()) {
                NIFRegistryPAKEntry nifrpeThis = (NIFRegistryPAKEntry)vnifrpeThisOffering.get(i2);
                this.m_vnifroeRemoveFromCorrectReg.add(nifrpeThis);
                ((Vector)this.m_lhmMergedEntries.get(nifroeThis)).remove(nifrpeThis);
                sMsg = "This pak entry is removed from correct registry as it does not exist.\nBackup pak location: " + nifrpeThis.getBackupPakLocationPath();
                Logr.debug(sMsg);
                ++i2;
            }
            this.m_vnifroeRemoveFromCorrectReg.add(nifroeThis);
            this.m_lhmMergedEntries.remove(nifroeThis);
            sMsg = "This offering entry is removed from correct registry as all its paks do not exist.\n\nOffering: " + nifroeThis.getOffering() + "\nInstall Location: " + nifroeThis.getOfferingLocationPath();
            Logr.debug(sMsg);
        }
        Iterator itRegToMergeOffering = this.m_lhmRegToMergeEntries.keySet().iterator();
        while (itRegToMergeOffering.hasNext()) {
            Vector<NIFRegistryPAKEntry> vPakEntryAddToMergedRegistry = new Vector<NIFRegistryPAKEntry>();
            NIFRegistryOfferingEntry nifroeThis = (NIFRegistryOfferingEntry)itRegToMergeOffering.next();
            URI uriInstallLocation = URIUtils.convertPathToDefaultTargetMachineFSURI(nifroeThis.getOfferingLocationPath(), this.m_itb);
            NIFRegistryDirectory nifrdThisLocation = NIFRegistryDirectory.getNIFRegistryDirectoryInstance(uriInstallLocation, this.m_itb);
            if (nifrdThisLocation == null || !nifrdThisLocation.isThisProductInstalled(nifroeThis.getOffering())) continue;
            Vector vnifrpeThisOffering = (Vector)this.m_lhmRegToMergeEntries.get(nifroeThis);
            int i3 = 0;
            while (i3 < vnifrpeThisOffering.size()) {
                NIFRegistryPAKEntry nifrpeThis = (NIFRegistryPAKEntry)vnifrpeThisOffering.get(i3);
                FileSystemEntry fseThisPak = URIUtils.convertPathToDefaultTargetMachineFSE(nifrpeThis.getBackupPakLocationPath(), this.m_itb);
                if (fseThisPak.exists()) {
                    this.m_vnifroeAddToCorrectReg.add(nifrpeThis);
                    vPakEntryAddToMergedRegistry.add(nifrpeThis);
                    sMsg = "This pak entry is added to correct registry from registry-to-merge as it exists.\nBackup pak location: " + nifrpeThis.getBackupPakLocationPath();
                    Logr.debug(sMsg);
                }
                ++i3;
            }
            this.m_vnifroeAddToCorrectReg.add(nifroeThis);
            this.m_lhmMergedEntries.put(nifroeThis, vPakEntryAddToMergedRegistry);
            sMsg = "This offering entry is added to correct registry as its paks exist.\n\nOffering: " + nifroeThis.getOffering() + "\nInstall Location: " + nifroeThis.getOfferingLocationPath();
            Logr.debug(sMsg);
        }
    }

    private LinkedHashMap cloneLinkedHashMapEntries(LinkedHashMap lhmSource) {
        LinkedHashMap lhmReturn = new LinkedHashMap(lhmSource);
        Vector vOffering = new Vector(lhmSource.keySet());
        int i = 0;
        while (i < vOffering.size()) {
            Vector vPaks = new Vector((Vector)lhmSource.get(vOffering.get(i)));
            lhmReturn.put(vOffering.get(i), vPaks);
            ++i;
        }
        return lhmReturn;
    }
}

