/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.install.registry.NIFRegistryProductFile;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryProductInfo;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Vector;

public class NIFRegistryDirectory {
    private final String className = "NIFRegistryDirectory";
    private URI m_uriInstallLocation = null;
    private InstallToolkitBridge m_itb = null;
    private NIFRegistryProductInfo[] m_nifrpiProductInstances = null;
    private static Hashtable m_htProductInstanceByLocationURI = new Hashtable();
    private static String S_RELATIVE_PATH_TO_VERSION_DIRECTORY = "properties/version";
    private static String S_PRODUCT_FILE_EXTENSION = ".product";

    public static NIFRegistryDirectory getNIFRegistryDirectoryInstance(URI uriInstallLocation, InstallToolkitBridge itb) {
        NIFRegistryDirectory nifrdReturn = null;
        if (uriInstallLocation == null) {
            return null;
        }
        nifrdReturn = (NIFRegistryDirectory)m_htProductInstanceByLocationURI.get(uriInstallLocation);
        if (nifrdReturn == null) {
            nifrdReturn = new NIFRegistryDirectory(uriInstallLocation, itb);
            m_htProductInstanceByLocationURI.put(uriInstallLocation, nifrdReturn);
        }
        return nifrdReturn;
    }

    public URI getInstallLocationURI() {
        return this.m_uriInstallLocation;
    }

    public InstallToolkitBridge getInstallToolkitBridge() {
        return this.m_itb;
    }

    public NIFRegistryProductInfo[] getProductInfoInstances() {
        return this.m_nifrpiProductInstances;
    }

    public NIFRegistryProductInfo getProductInfo(String id) {
        if (this.m_nifrpiProductInstances == null) {
            return null;
        }
        NIFRegistryProductInfo[] nIFRegistryProductInfoArray = this.m_nifrpiProductInstances;
        int n = this.m_nifrpiProductInstances.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryProductInfo m_nifrpiProductInstance = nIFRegistryProductInfoArray[n2];
            if (m_nifrpiProductInstance.getId().equalsIgnoreCase(id)) {
                return m_nifrpiProductInstance;
            }
            ++n2;
        }
        return null;
    }

    public boolean isThisProductInstalled(String id) {
        NIFRegistryProductInfo p = this.getProductInfo(id);
        return p != null;
    }

    public String getName(String id) {
        NIFRegistryProductInfo p = this.getProductInfo(id);
        if (p != null) {
            return p.getName();
        }
        return null;
    }

    public String getVersion(String id) {
        NIFRegistryProductInfo p = this.getProductInfo(id);
        if (p != null) {
            return p.getVersion();
        }
        return null;
    }

    public String getBuildDate(String id) {
        NIFRegistryProductInfo p = this.getProductInfo(id);
        if (p != null) {
            return p.getBuildDate();
        }
        return null;
    }

    public String getBuildLevel(String id) {
        NIFRegistryProductInfo p = this.getProductInfo(id);
        if (p != null) {
            return p.getBuildLevel();
        }
        return null;
    }

    public static boolean refreshCache(URI uriInstallLocation) {
        boolean fReturn = false;
        if (m_htProductInstanceByLocationURI != null && uriInstallLocation != null) {
            if (m_htProductInstanceByLocationURI.remove(uriInstallLocation) != null) {
                fReturn = true;
            } else {
                String sMsg = "Can not refresh cache with this URI: " + uriInstallLocation.toString();
                Logr.debug(sMsg);
            }
        }
        return fReturn;
    }

    public static void refreshAllCache() {
        m_htProductInstanceByLocationURI.clear();
    }

    private NIFRegistryDirectory(URI uriInstallLocation, InstallToolkitBridge itb) {
        this.setInstallLocationURI(uriInstallLocation);
        this.setInstallToolkitBridge(itb);
        this.m_nifrpiProductInstances = this.parse(uriInstallLocation);
    }

    private void setInstallLocationURI(URI uriInstallLocation) {
        this.m_uriInstallLocation = uriInstallLocation;
    }

    private void setInstallToolkitBridge(InstallToolkitBridge itb) {
        this.m_itb = itb;
    }

    private NIFRegistryProductInfo[] parse(URI uriInstallLocation) {
        Vector<NIFRegistryProductInfo> vProductInfo = new Vector<NIFRegistryProductInfo>();
        try {
            URI uriNormalizedInstallLocation = this.normalizeDirectoryURI(uriInstallLocation);
            URI uriVersionLocation = this.composeURI(uriNormalizedInstallLocation, S_RELATIVE_PATH_TO_VERSION_DIRECTORY);
            FileSystemEntry[] afseAllProductFiles = this.getAllProductFSEDirectlyUnderDir(uriVersionLocation);
            if (afseAllProductFiles != null) {
                FileSystemEntry[] fileSystemEntryArray = afseAllProductFiles;
                int n = afseAllProductFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    NIFRegistryProductInfo[] pArray;
                    FileSystemEntry afseAllProductFile = fileSystemEntryArray[n2];
                    NIFRegistryProductFile nifrpfThis = new NIFRegistryProductFile(afseAllProductFile);
                    NIFRegistryProductInfo[] nIFRegistryProductInfoArray = pArray = nifrpfThis.getProductInfoArray();
                    int n3 = pArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        NIFRegistryProductInfo element = nIFRegistryProductInfoArray[n4];
                        vProductInfo.add(element);
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (URISyntaxException e) {
            Logr.warn("NIFRegistryDirectory", "parse", e.getMessage(), e);
        }
        return vProductInfo.toArray(new NIFRegistryProductInfo[vProductInfo.size()]);
    }

    private FileSystemEntry[] getAllProductFSEDirectlyUnderDir(URI uriDirectory) {
        Vector<FileSystemEntry> vfseProductFile = new Vector<FileSystemEntry>();
        try {
            if (uriDirectory != null) {
                FileSystemEntry fseDirectory = new FileSystemEntry(uriDirectory, this.getInstallToolkitBridge());
                FileSystemEntry[] afseEntries = fseDirectory.getEntriesDirectlyUnderThisDir();
                int i = 0;
                while (i < afseEntries.length) {
                    if (afseEntries[i].getEntryName().endsWith(S_PRODUCT_FILE_EXTENSION) && !afseEntries[i].isDirectory()) {
                        vfseProductFile.add(afseEntries[i]);
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            Logr.warn("NIFRegistryDirectory", "getAllProductFSEDirectlyUnderDir", e.getMessage(), e);
        }
        return vfseProductFile.toArray(new FileSystemEntry[vfseProductFile.size()]);
    }

    private URI normalizeDirectoryURI(URI uriDirectory) throws URISyntaxException {
        String sURIDirectoryString;
        if (uriDirectory != null && !(sURIDirectoryString = uriDirectory.toString()).endsWith("/")) {
            sURIDirectoryString = String.valueOf(uriDirectory.toString()) + "/";
            return new URI(sURIDirectoryString);
        }
        return uriDirectory;
    }

    private URI composeURI(URI uriParent, String sPathName) throws URISyntaxException {
        URI uriNormalizedParent = this.normalizeDirectoryURI(uriParent);
        String sURIReturn = String.valueOf(uriNormalizedParent.toString()) + sPathName;
        return new URI(sURIReturn);
    }
}

