/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.registry;

import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryHelper;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryObjectEntry;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryOfferingEntry;
import com.ibm.ws.pak.internal.install.registry.NIFRegistryPAKEntry;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NIFRegistry {
    protected static NIFRegistry m_nifregSingleton = null;
    protected static Document m_documentSingleton = null;
    protected static File m_fileNIFRegistryFile = null;
    protected static String m_sSystemRootOnWindows = null;
    protected LinkedHashSet m_linkedhashsetNIFRegistryPAKEntry = new LinkedHashSet();
    protected LinkedHashSet m_linkedhashsetNIFRegistryOfferingEntry = new LinkedHashSet();
    protected LinkedHashSet m_linkedhashsetNIFRegistryAllEntry = new LinkedHashSet();
    protected LinkedHashSet m_linkedhashsetNIFRegistryAllEntryToBeAdded = new LinkedHashSet();
    protected LinkedHashSet m_linkedhashsetNIFRegistryAllEntryToBeRemoved = new LinkedHashSet();
    protected static final String[] AS_MUTUALLY_EXCLUSIVE_OFFERING_ID = new String[]{"ND", "BASE", "BASETRIAL", "EXPRESS", "EXPRESSTRIAL", "embeddedEXPRESS", "NDDMZ"};
    protected static final String S_NIFREGISTRY_COMMENT = "NIFRegistry.doNotDeleteThisFileComment";
    protected static final String S_NIFREGISTRY_FILE_NAME = ".nifregistry";
    protected static final String S_NIFREGISTRY_PARENT_OS400 = "/QIBM/WAS/.ibm/.nif";
    protected static final String S_NIFREGISTRY_RELATIVEPATH = "/.ibm/.nif";
    protected static final String S_NIFREGISTRY_PARENT_UNIX_FORROOT = "/opt";
    protected static final String S_NIFREGISTRY_PARENT_AIX_FORROOT = "/usr";
    private static final String S_USER_HOME = "user.home";
    private static final String S_UNDERSCORE = "_";
    private static final String S_DRIVE_A = "A";
    private static final String S_DRIVE_B = "B";
    private static final String S_SYSTEM_ROOT = "SYSTEMROOT";
    private static final String S_SYSTEM_DRIVE = "SYSTEMDRIVE";
    private static final String S_LOCALAPPDATA = "LOCALAPPDATA";
    private static final String S_VIRTUAL_STORE = "VirtualStore";

    public static NIFRegistry getNIFRegistryInstance() throws FileNotFoundException, SecurityException, IOException, ParserConfigurationException, SAXException, URISyntaxException {
        return NIFRegistry.getNIFRegistryInstance(null, S_NIFREGISTRY_FILE_NAME);
    }

    public static NIFRegistry getNIFRegistryInstance(String sUserHomePath, String sNIFRegistryFileName) throws FileNotFoundException, SecurityException, IOException, ParserConfigurationException, SAXException, URISyntaxException {
        m_fileNIFRegistryFile = new File(NIFRegistry.getNIFRegistryPath(sUserHomePath, sNIFRegistryFileName));
        FileInputStream inputStreamThis = null;
        if (m_fileNIFRegistryFile.exists()) {
            inputStreamThis = new FileInputStream(m_fileNIFRegistryFile);
        }
        if (m_nifregSingleton == null) {
            m_nifregSingleton = new NIFRegistry(inputStreamThis);
        } else {
            m_nifregSingleton.parseInputStream(inputStreamThis);
        }
        if (inputStreamThis != null) {
            ((InputStream)inputStreamThis).close();
        }
        return m_nifregSingleton;
    }

    public static NIFRegistry getNIFRegistryInstance(InputStream inputstream) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        m_fileNIFRegistryFile = null;
        if (m_nifregSingleton == null) {
            m_nifregSingleton = new NIFRegistry(inputstream);
        } else {
            m_nifregSingleton.parseInputStream(inputstream);
        }
        return m_nifregSingleton;
    }

    public String getNIFRegistryFilePath() {
        if (m_fileNIFRegistryFile != null) {
            return m_fileNIFRegistryFile.getAbsolutePath();
        }
        return null;
    }

    @Deprecated
    public String[] getPAKNameArrayByOffering(String sOffering) throws ParserConfigurationException, SAXException, URISyntaxException {
        return this.getPAKNameArrayByOfferingLocationAndOffering(sOffering, null);
    }

    @Deprecated
    public String[] getPAKNameArrayByOfferingLocation(String sOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException {
        return this.getPAKNameArrayByOfferingLocationAndOffering(null, sOfferingLocation);
    }

    @Deprecated
    public String[] getPAKNameArrayByOfferingLocationAndOffering(String sOffering, String sOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException {
        String[] asPAKNameReturned = null;
        NIFRegistryPAKEntry[] anifrpe = null;
        int nnifrpeReturnedSize = 0;
        NIFRegistryOfferingEntry nifroeThis = new NIFRegistryOfferingEntry(sOffering, sOfferingLocation, null, null);
        anifrpe = this.getPAKArrayForThisProduct(nifroeThis);
        nnifrpeReturnedSize = anifrpe.length;
        asPAKNameReturned = new String[nnifrpeReturnedSize];
        int i = 0;
        while (i < nnifrpeReturnedSize) {
            asPAKNameReturned[i] = anifrpe[i].getNIFPackageName();
            ++i;
        }
        return asPAKNameReturned;
    }

    protected URI[] getOfferingLocationURIArrayByOffering(String sCurrentOffering) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryOfferingEntry[] anifroe = null;
        URI[] auriOfferingLocationReturned = null;
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        int nnifroeReturnedSize = 0;
        NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(sCurrentOffering, null, null, null);
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroe = this.getAllInstalledProducts();
        int n = anifroe.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
            if (element.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                vnifroeReturned.add(element);
            }
            ++n2;
        }
        nnifroeReturnedSize = vnifroeReturned.size();
        auriOfferingLocationReturned = new URI[nnifroeReturnedSize];
        int i = 0;
        while (i < nnifroeReturnedSize) {
            auriOfferingLocationReturned[i] = ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(i)).getOfferingLocationURI();
            ++i;
        }
        return auriOfferingLocationReturned;
    }

    public String[] getOfferingLocationStringArrayByOffering(String sCurrentOffering) throws ParserConfigurationException, SAXException, URISyntaxException {
        URI[] auriOfferingLocationThisOffering = this.getOfferingLocationURIArrayByOffering(sCurrentOffering);
        String[] asOfferingLocation = new String[auriOfferingLocationThisOffering.length];
        int i = 0;
        while (i < auriOfferingLocationThisOffering.length) {
            asOfferingLocation[i] = URIUtils.convertURIPathToPlatformFilePath(auriOfferingLocationThisOffering[i]);
            ++i;
        }
        return asOfferingLocation;
    }

    @Deprecated
    public String[] getOfferingArrayByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryOfferingEntry[] anifroe;
        int nnifroeReturnedSize = 0;
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(null, uriOfferingLocation, null, null);
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroe = this.getAllInstalledProducts();
        int n = anifroe.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
            if (element.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                vnifroeReturned.add(element);
            }
            ++n2;
        }
        nnifroeReturnedSize = vnifroeReturned.size();
        String[] asOfferingReturned = new String[nnifroeReturnedSize];
        int i = 0;
        while (i < nnifroeReturnedSize) {
            asOfferingReturned[i] = ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(i)).getOffering();
            ++i;
        }
        return asOfferingReturned;
    }

    @Deprecated
    public String getWASSpecificOfferingByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryOfferingEntry nifroe = this.getInstalledWASSpecificProductByOfferingLocationURI(uriOfferingLocation);
        if (nifroe != null) {
            return nifroe.getOffering();
        }
        return null;
    }

    protected String getMutuallyExclusiveOfferingByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryOfferingEntry nifroe = this.getInstalledMutuallyExclusiveOfferingByOfferingLocationURI(uriOfferingLocation);
        if (nifroe != null) {
            return nifroe.getOffering();
        }
        return null;
    }

    @Deprecated
    public String[] getLastVisitedArrayByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryOfferingEntry[] anifroe;
        int nnifroeReturnedSize = 0;
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(null, uriOfferingLocation, null, null);
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroe = this.getAllInstalledProducts();
        int n = anifroe.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
            if (element.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                vnifroeReturned.add(element);
            }
            ++n2;
        }
        nnifroeReturnedSize = vnifroeReturned.size();
        String[] asLastVisitedReturned = new String[nnifroeReturnedSize];
        int i = 0;
        while (i < nnifroeReturnedSize) {
            asLastVisitedReturned[i] = ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(i)).getOfferingLastVisited();
            ++i;
        }
        return asLastVisitedReturned;
    }

    @Deprecated
    public String getLastVisitedByOfferingLocationURIAndOffering(String sOffering, URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryOfferingEntry[] anifroe;
        int nnifroeReturnedSize = 0;
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(sOffering, uriOfferingLocation, null, null);
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroe = this.getAllInstalledProducts();
        int n = anifroe.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
            if (element.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                vnifroeReturned.add(element);
            }
            ++n2;
        }
        nnifroeReturnedSize = vnifroeReturned.size();
        if (nnifroeReturnedSize == 0) {
            return null;
        }
        if (nnifroeReturnedSize == 1) {
            return ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(0)).getOfferingLastVisited();
        }
        Object[] stringArrayInput = new String[]{NIFRegistryHelper.normalizePathFromURI(uriOfferingLocation), sOffering};
        throw new NIFException(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_MORE_THAN_ONE_OFFERING_REGISTERED_UNDER_SAME_OFFERING_LOCATION_AND_OFFERING_ID_ERROR_MSG, (Object[])stringArrayInput));
    }

    @Deprecated
    public String[] getVersionArrayByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryOfferingEntry[] anifroe;
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        int nnifroeReturnedSize = 0;
        NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(null, uriOfferingLocation, null, null);
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroe = this.getAllInstalledProducts();
        int n = anifroe.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
            if (element.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                vnifroeReturned.add(element);
            }
            ++n2;
        }
        nnifroeReturnedSize = vnifroeReturned.size();
        String[] asVersionReturned = new String[nnifroeReturnedSize];
        int i = 0;
        while (i < nnifroeReturnedSize) {
            asVersionReturned[i] = ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(i)).getOfferingVersion();
            ++i;
        }
        return asVersionReturned;
    }

    @Deprecated
    public String getVersionByOfferingLocationURIAndOffering(String sOffering, URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryOfferingEntry[] anifroe;
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        int nnifroeReturnedSize = 0;
        NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(sOffering, uriOfferingLocation, null, null);
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroe = this.getAllInstalledProducts();
        int n = anifroe.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
            if (element.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                vnifroeReturned.add(element);
            }
            ++n2;
        }
        nnifroeReturnedSize = vnifroeReturned.size();
        if (nnifroeReturnedSize == 0) {
            return null;
        }
        if (nnifroeReturnedSize == 1) {
            return ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(0)).getOfferingVersion();
        }
        Object[] stringArrayInput = new String[]{NIFRegistryHelper.normalizePathFromURI(uriOfferingLocation), sOffering};
        throw new NIFException(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_MORE_THAN_ONE_OFFERING_REGISTERED_UNDER_SAME_OFFERING_LOCATION_AND_OFFERING_ID_ERROR_MSG, (Object[])stringArrayInput));
    }

    @Deprecated
    public String getWASSpecificVersionByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryOfferingEntry nifroe = this.getInstalledWASSpecificProductByOfferingLocationURI(uriOfferingLocation);
        if (nifroe != null) {
            return nifroe.getOfferingVersion();
        }
        return null;
    }

    @Deprecated
    public NIFRegistryPAKEntry[] getAllInstalledPAKs() throws ParserConfigurationException, SAXException, URISyntaxException {
        int nNIFRegistryPAKEntrySize = this.m_linkedhashsetNIFRegistryPAKEntry.size();
        NIFRegistryPAKEntry[] anifrpe = new NIFRegistryPAKEntry[nNIFRegistryPAKEntrySize];
        if (nNIFRegistryPAKEntrySize > 0) {
            int x = 0;
            Iterator itNIFRegistryPAKEntry = this.m_linkedhashsetNIFRegistryPAKEntry.iterator();
            while (itNIFRegistryPAKEntry.hasNext()) {
                anifrpe[x] = (NIFRegistryPAKEntry)itNIFRegistryPAKEntry.next();
                ++x;
            }
        }
        return anifrpe;
    }

    public NIFRegistryOfferingEntry[] getAllInstalledProducts() {
        int nNIFRegistryOfferingEntrySize = this.m_linkedhashsetNIFRegistryOfferingEntry.size();
        NIFRegistryOfferingEntry[] anifroe = new NIFRegistryOfferingEntry[nNIFRegistryOfferingEntrySize];
        if (nNIFRegistryOfferingEntrySize > 0) {
            int x = 0;
            Iterator itNIFRegistryOfferingEntry = this.m_linkedhashsetNIFRegistryOfferingEntry.iterator();
            while (itNIFRegistryOfferingEntry.hasNext()) {
                anifroe[x] = (NIFRegistryOfferingEntry)itNIFRegistryOfferingEntry.next();
                ++x;
            }
        }
        return anifroe;
    }

    @Deprecated
    public NIFRegistryPAKEntry getInstalledPAKByPAKLocationURI(URI uriPAKLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryPAKEntry[] nifrpeAllInstalledPAKs;
        Vector<NIFRegistryPAKEntry> vnifrpeReturned = new Vector<NIFRegistryPAKEntry>();
        NIFRegistryPAKEntry nifrpeTemp = new NIFRegistryPAKEntry(null, uriPAKLocation, null, null);
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = nifrpeAllInstalledPAKs = this.getAllInstalledPAKs();
        int n = nifrpeAllInstalledPAKs.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry nifrpeAllInstalledPAK = nIFRegistryPAKEntryArray[n2];
            if (nifrpeAllInstalledPAK.doesThisPAKEntryHasTheseAttributes(nifrpeTemp)) {
                vnifrpeReturned.add(nifrpeAllInstalledPAK);
            }
            ++n2;
        }
        int nReturnedSize = vnifrpeReturned.size();
        if (nReturnedSize == 0) {
            return null;
        }
        if (nReturnedSize == 1) {
            return (NIFRegistryPAKEntry)vnifrpeReturned.elementAt(0);
        }
        throw new NIFException(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_MORE_THAN_ONE_PAK_REGISTERED_UNDER_SAME_PAK_LOCATION_ERROR_MSG, (Object)NIFRegistryHelper.normalizePathFromURI(uriPAKLocation)));
    }

    @Deprecated
    public NIFRegistryPAKEntry[] getInstalledPAKArrayByPAKNameAndOfferingLocationURI(String sPAKName, URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryPAKEntry[] nifrpeAllInstalledPAKs;
        Vector<NIFRegistryPAKEntry> vnifrpeReturned = new Vector<NIFRegistryPAKEntry>();
        NIFRegistryPAKEntry nifrpeTemp = new NIFRegistryPAKEntry(sPAKName, null, null, uriOfferingLocation);
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = nifrpeAllInstalledPAKs = this.getAllInstalledPAKs();
        int n = nifrpeAllInstalledPAKs.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry nifrpeAllInstalledPAK = nIFRegistryPAKEntryArray[n2];
            if (nifrpeAllInstalledPAK.doesThisPAKEntryHasTheseAttributes(nifrpeTemp)) {
                vnifrpeReturned.add(nifrpeAllInstalledPAK);
            }
            ++n2;
        }
        int nReturnedSize = vnifrpeReturned.size();
        NIFRegistryPAKEntry[] aNIFRPEReturned = new NIFRegistryPAKEntry[nReturnedSize];
        int i = 0;
        while (i < nReturnedSize) {
            aNIFRPEReturned[i] = (NIFRegistryPAKEntry)vnifrpeReturned.elementAt(i);
            ++i;
        }
        return aNIFRPEReturned;
    }

    @Deprecated
    public NIFRegistryPAKEntry[] getInstalledPAKArrayByPAKName(String sPAKName) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryPAKEntry[] nifrpeAllInstalledPAKs;
        Vector<NIFRegistryPAKEntry> vnifrpeReturned = new Vector<NIFRegistryPAKEntry>();
        NIFRegistryPAKEntry nifrpeTemp = new NIFRegistryPAKEntry(sPAKName, null, null, null);
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = nifrpeAllInstalledPAKs = this.getAllInstalledPAKs();
        int n = nifrpeAllInstalledPAKs.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry nifrpeAllInstalledPAK = nIFRegistryPAKEntryArray[n2];
            if (nifrpeAllInstalledPAK.doesThisPAKEntryHasTheseAttributes(nifrpeTemp)) {
                vnifrpeReturned.add(nifrpeAllInstalledPAK);
            }
            ++n2;
        }
        int nReturnedSize = vnifrpeReturned.size();
        NIFRegistryPAKEntry[] aNIFRPEReturned = new NIFRegistryPAKEntry[nReturnedSize];
        int i = 0;
        while (i < nReturnedSize) {
            aNIFRPEReturned[i] = (NIFRegistryPAKEntry)vnifrpeReturned.elementAt(i);
            ++i;
        }
        return aNIFRPEReturned;
    }

    @Deprecated
    public NIFRegistryOfferingEntry[] getInstalledProductArrayByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryOfferingEntry[] nifroeAllInstalledProducts;
        Vector<NIFRegistryOfferingEntry> vNIFRegistryOfferingEntryReturned = new Vector<NIFRegistryOfferingEntry>();
        NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(null, uriOfferingLocation, null, null);
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = nifroeAllInstalledProducts = this.getAllInstalledProducts();
        int n = nifroeAllInstalledProducts.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry nifroeAllInstalledProduct = nIFRegistryOfferingEntryArray[n2];
            if (nifroeAllInstalledProduct.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                vNIFRegistryOfferingEntryReturned.add(nifroeAllInstalledProduct);
            }
            ++n2;
        }
        int nReturnedSize = vNIFRegistryOfferingEntryReturned.size();
        NIFRegistryOfferingEntry[] aNIFROEReturned = new NIFRegistryOfferingEntry[nReturnedSize];
        int i = 0;
        while (i < nReturnedSize) {
            aNIFROEReturned[i] = (NIFRegistryOfferingEntry)vNIFRegistryOfferingEntryReturned.elementAt(i);
            ++i;
        }
        return aNIFROEReturned;
    }

    @Deprecated
    public NIFRegistryOfferingEntry getInstalledProductByOfferingLocationURIAndOffering(String sOffering, URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryOfferingEntry[] nifroeAllInstalledProducts;
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(sOffering, uriOfferingLocation, null, null);
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = nifroeAllInstalledProducts = this.getAllInstalledProducts();
        int n = nifroeAllInstalledProducts.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry nifroeAllInstalledProduct = nIFRegistryOfferingEntryArray[n2];
            if (nifroeAllInstalledProduct.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                vnifroeReturned.add(nifroeAllInstalledProduct);
            }
            ++n2;
        }
        int nnifroeReturnedSize = vnifroeReturned.size();
        if (nnifroeReturnedSize == 0) {
            return null;
        }
        if (nnifroeReturnedSize == 1) {
            return (NIFRegistryOfferingEntry)vnifroeReturned.elementAt(0);
        }
        Object[] stringArrayInput = new String[]{NIFRegistryHelper.normalizePathFromURI(uriOfferingLocation), sOffering};
        throw new NIFException(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_MORE_THAN_ONE_OFFERING_REGISTERED_UNDER_SAME_OFFERING_LOCATION_AND_OFFERING_ID_ERROR_MSG, (Object[])stringArrayInput));
    }

    @Deprecated
    public NIFRegistryOfferingEntry getInstalledWASSpecificProductByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryOfferingEntry[] nifroeThisOfferingLocation = this.getInstalledProductArrayByOfferingLocationURI(uriOfferingLocation);
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = nifroeThisOfferingLocation;
        int n = nifroeThisOfferingLocation.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
            if (NIFRegistryHelper.isWASOfferingID(element.getOffering())) {
                vnifroeReturned.add(element);
            }
            ++n2;
        }
        int nnifroeReturnedSize = vnifroeReturned.size();
        if (nnifroeReturnedSize == 0) {
            return null;
        }
        if (nnifroeReturnedSize == 1) {
            return (NIFRegistryOfferingEntry)vnifroeReturned.elementAt(0);
        }
        String sOfferingIDList = "";
        int i = 0;
        while (i < nnifroeReturnedSize) {
            sOfferingIDList = i < nnifroeReturnedSize - 1 ? String.valueOf(sOfferingIDList) + ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(i)).getOffering() + ", " : String.valueOf(sOfferingIDList) + ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(i)).getOffering();
            ++i;
        }
        Object[] stringArrayInput = new String[]{NIFRegistryHelper.normalizePathFromURI(uriOfferingLocation), sOfferingIDList};
        throw new NIFException(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_MORE_THAN_ONE_WAS_INSTANCE_REGISTERED_UNDER_SAME_OFFERING_LOCATION_ERROR_MSG_KEY, (Object[])stringArrayInput));
    }

    protected NIFRegistryOfferingEntry getInstalledMutuallyExclusiveOfferingByOfferingLocationURI(URI uriOfferingLocation) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryOfferingEntry[] nifroeThisOfferingLocation = this.getInstalledProductArrayByOfferingLocationURI(uriOfferingLocation);
        Vector<NIFRegistryOfferingEntry> vnifroeReturned = new Vector<NIFRegistryOfferingEntry>();
        NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = nifroeThisOfferingLocation;
        int n = nifroeThisOfferingLocation.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryOfferingEntry element = nIFRegistryOfferingEntryArray[n2];
            if (this.isMutuallyExclusiveOfferingID(element.getOffering())) {
                vnifroeReturned.add(element);
            }
            ++n2;
        }
        int nnifroeReturnedSize = vnifroeReturned.size();
        if (nnifroeReturnedSize == 0) {
            return null;
        }
        if (nnifroeReturnedSize == 1) {
            return (NIFRegistryOfferingEntry)vnifroeReturned.elementAt(0);
        }
        String sOfferingIDList = "";
        int i = 0;
        while (i < nnifroeReturnedSize) {
            sOfferingIDList = i < nnifroeReturnedSize - 1 ? String.valueOf(sOfferingIDList) + ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(i)).getOffering() + ", " : String.valueOf(sOfferingIDList) + ((NIFRegistryOfferingEntry)vnifroeReturned.elementAt(i)).getOffering();
            ++i;
        }
        Object[] stringArrayInput = new String[]{NIFRegistryHelper.normalizePathFromURI(uriOfferingLocation), sOfferingIDList};
        throw new NIFException(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_MORE_THAN_ONE_WAS_INSTANCE_REGISTERED_UNDER_SAME_OFFERING_LOCATION_ERROR_MSG_KEY, (Object[])stringArrayInput));
    }

    @Deprecated
    public NIFRegistryPAKEntry[] getPAKArrayForThisProduct(NIFRegistryOfferingEntry nifroeProduct) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryPAKEntry[] anifrpeInstalledPAKS = this.getAllInstalledPAKs();
        Vector<NIFRegistryPAKEntry> vnifrpeToBeReturned = new Vector<NIFRegistryPAKEntry>();
        int nnifrpeToBeReturnedSize = 0;
        Logr.debug("getPAKArrayForThisProduct: offering: " + nifroeProduct.getOffering());
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = anifrpeInstalledPAKS;
        int n = anifrpeInstalledPAKS.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry element = nIFRegistryPAKEntryArray[n2];
            if (element.isThisPAKEntryAssociatedWithThisOffering(nifroeProduct)) {
                vnifrpeToBeReturned.add(element);
            }
            ++n2;
        }
        nnifrpeToBeReturnedSize = vnifrpeToBeReturned.size();
        NIFRegistryPAKEntry[] anifrpeToBeReturned = new NIFRegistryPAKEntry[nnifrpeToBeReturnedSize];
        int i = 0;
        while (i < nnifrpeToBeReturnedSize) {
            anifrpeToBeReturned[i] = (NIFRegistryPAKEntry)vnifrpeToBeReturned.elementAt(i);
            ++i;
        }
        return anifrpeToBeReturned;
    }

    @Deprecated
    public NIFRegistryOfferingEntry[] getProductArrayThatHaveThisPAK(NIFRegistryPAKEntry nifrpePAK) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryOfferingEntry[] anifroeInstalledProducts = null;
        HashSet<NIFRegistryOfferingEntry> hashsetnifroeMatched = new HashSet<NIFRegistryOfferingEntry>();
        int nnifroeToBeReturnedSize = 0;
        NIFRegistryPAKEntry[] anifrpeInstalledPAKs = this.getAllInstalledPAKs();
        anifroeInstalledProducts = this.getAllInstalledProducts();
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = anifrpeInstalledPAKs;
        int n = anifrpeInstalledPAKs.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry anifrpeInstalledPAK = nIFRegistryPAKEntryArray[n2];
            if (anifrpeInstalledPAK.doesThisPAKEntryHasTheseAttributes(nifrpePAK)) {
                NIFRegistryOfferingEntry[] nIFRegistryOfferingEntryArray = anifroeInstalledProducts;
                int n3 = anifroeInstalledProducts.length;
                int n4 = 0;
                while (n4 < n3) {
                    NIFRegistryOfferingEntry anifroeInstalledProduct = nIFRegistryOfferingEntryArray[n4];
                    NIFRegistryOfferingEntry nifroeTemp = new NIFRegistryOfferingEntry(anifrpeInstalledPAK.getOffering(), anifrpeInstalledPAK.getOfferingLocationURI(), null, null);
                    if (anifroeInstalledProduct.doesThisOfferingEntryHasTheseAttributes(nifroeTemp)) {
                        hashsetnifroeMatched.add(anifroeInstalledProduct);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        nnifroeToBeReturnedSize = hashsetnifroeMatched.size();
        NIFRegistryOfferingEntry[] anifroeToBeReturned = new NIFRegistryOfferingEntry[nnifroeToBeReturnedSize];
        Iterator iteratornifroeMatched = hashsetnifroeMatched.iterator();
        int nIndex = 0;
        while (iteratornifroeMatched.hasNext()) {
            anifroeToBeReturned[nIndex] = (NIFRegistryOfferingEntry)iteratornifroeMatched.next();
            ++nIndex;
        }
        return anifroeToBeReturned;
    }

    public Document getNIFRegistryDocument() {
        return m_documentSingleton;
    }

    public void addRegistryEntryToNIFRegistry(Object nifregEntry) {
        if (nifregEntry != null) {
            this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.add(nifregEntry);
        }
    }

    public void removeRegistryEntryFromNIFRegistry(Object nifregEntry) {
        if (nifregEntry != null) {
            this.m_linkedhashsetNIFRegistryAllEntryToBeRemoved.add(nifregEntry);
        }
    }

    public void performInstallMaintenanceAddFeature(NIFRegistryOfferingEntry nifroeCurrent) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        if (nifroeCurrent.getOfferingVersion() == null) {
            Logr.debug("Skip performInstallMaintenanceAddFeature.  Offering version is null.");
            return;
        }
        NIFRegistryOfferingEntry nifroeFromNIFRegistry = this.getInstalledProductByOfferingLocationURIAndOffering(nifroeCurrent.getOffering(), nifroeCurrent.getOfferingLocationURI());
        if (nifroeFromNIFRegistry != null) {
            this.removeRegistryEntryFromNIFRegistry(nifroeFromNIFRegistry);
        }
        this.addRegistryEntryToNIFRegistry(nifroeCurrent);
    }

    protected void modifyOfferingFromPaksJustInstalled(NIFRegistryOfferingEntry owningOffering, String sNewOfferingID) throws URISyntaxException, ParserConfigurationException, SAXException {
        NIFRegistryPAKEntry[] anifrpeThisProduct;
        for (NIFRegistryObjectEntry currentObjectEntry : this.m_linkedhashsetNIFRegistryAllEntryToBeAdded) {
            if (!currentObjectEntry.getNIFRegistryObjectName().equals("pak")) continue;
            this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.remove(currentObjectEntry);
            NIFRegistryPAKEntry nifrpeNew = new NIFRegistryPAKEntry((NIFRegistryPAKEntry)currentObjectEntry);
            nifrpeNew.setOffering(sNewOfferingID);
            this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.add(nifrpeNew);
            Logr.debug("modifyOfferingFromPaksJustInstalled: replace just installed pak with PAKURI: " + nifrpeNew.getBackupPakLocationURI());
            Logr.debug("modifyOfferingFromPaksJustInstalled: replace just installed pak with Offering: " + nifrpeNew.getOffering());
            Logr.debug("modifyOfferingFromPaksJustInstalled: replace just installed pak with install location: " + nifrpeNew.getOfferingLocationPath());
        }
        LinkedHashSet linkedhashsetClone = null;
        if (!this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.isEmpty()) {
            linkedhashsetClone = (LinkedHashSet)this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.clone();
            this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.clear();
        }
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = anifrpeThisProduct = this.getPAKArrayForThisProduct(owningOffering);
        int n = anifrpeThisProduct.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry element = nIFRegistryPAKEntryArray[n2];
            if (!this.m_linkedhashsetNIFRegistryAllEntryToBeRemoved.contains(element)) {
                this.removeRegistryEntryFromNIFRegistry(element);
                Logr.debug("modifyOfferingFromPaksJustInstalled: Remove pak with PAKURI: " + element.getBackupPakLocationURI());
                Logr.debug("modifyOfferingFromPaksJustInstalled: Remove pak with Offering: " + element.getOffering());
                Logr.debug("modifyOfferingFromPaksJustInstalled: Remove pak with install location: " + element.getOfferingLocationPath());
                NIFRegistryPAKEntry nifrpeNew = new NIFRegistryPAKEntry(element);
                nifrpeNew.setOffering(sNewOfferingID);
                this.addRegistryEntryToNIFRegistry(nifrpeNew);
                Logr.debug("modifyOfferingFromPaksJustInstalled: Add pak with PAKURI: " + nifrpeNew.getBackupPakLocationURI());
                Logr.debug("modifyOfferingFromPaksJustInstalled: Add pak with Offering: " + nifrpeNew.getOffering());
                Logr.debug("modifyOfferingFromPaksJustInstalled: Add pak with install location: " + nifrpeNew.getOfferingLocationPath());
            }
            ++n2;
        }
        if (linkedhashsetClone != null && !linkedhashsetClone.isEmpty()) {
            this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.addAll(linkedhashsetClone);
        }
    }

    @Deprecated
    public void performUpgrade(NIFRegistryOfferingEntry nifroeCurrent) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        this.performUpgrade(nifroeCurrent, null);
    }

    public void performUpgrade(NIFRegistryOfferingEntry nifroeCurrent, NIFRegistryOfferingEntry nifroeInstalled) throws ParserConfigurationException, SAXException, URISyntaxException, NIFException {
        NIFRegistryPAKEntry[] anifrpeThisProduct;
        NIFRegistryOfferingEntry nifroeInstalledAndRegistered = null;
        if (nifroeInstalled != null) {
            nifroeInstalledAndRegistered = this.getInstalledProductByOfferingLocationURIAndOffering(nifroeInstalled.getOffering(), nifroeInstalled.getOfferingLocationURI());
            Logr.debug("performUpgrade: nifroeInstalledAndRegistered.offering: " + nifroeInstalledAndRegistered.getOffering());
            Logr.debug("performUpgrade: nifroeInstalledAndRegistered.version: " + nifroeInstalledAndRegistered.getOfferingVersion());
            Logr.debug("performUpgrade: nifroeInstalledAndRegistered.offeringlocation: " + nifroeInstalledAndRegistered.getOfferingLocationPath());
        } else {
            nifroeInstalledAndRegistered = this.getInstalledWASSpecificProductByOfferingLocationURI(nifroeCurrent.getOfferingLocationURI());
        }
        LinkedHashSet linkedhashsetClone = null;
        if (!this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.isEmpty()) {
            linkedhashsetClone = (LinkedHashSet)this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.clone();
            this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.clear();
        }
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = anifrpeThisProduct = this.getPAKArrayForThisProduct(nifroeInstalledAndRegistered);
        int n = anifrpeThisProduct.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry element = nIFRegistryPAKEntryArray[n2];
            if (!this.m_linkedhashsetNIFRegistryAllEntryToBeRemoved.contains(element)) {
                this.removeRegistryEntryFromNIFRegistry(element);
                Logr.debug("performUpgrade: Remove pak with Offering: " + element.getOffering());
                Logr.debug("performUpgrade: Remove pak with install location: " + element.getOfferingLocationPath());
                NIFRegistryPAKEntry nifrpeThis = new NIFRegistryPAKEntry(element);
                nifrpeThis.setOffering(nifroeCurrent.getOffering());
                this.addRegistryEntryToNIFRegistry(nifrpeThis);
                Logr.debug("performUpgrade: Add pak with Offering: " + nifrpeThis.getOffering());
                Logr.debug("performUpgrade: Add pak with install location: " + nifrpeThis.getOfferingLocationPath());
            }
            ++n2;
        }
        if (linkedhashsetClone != null && !linkedhashsetClone.isEmpty()) {
            this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.addAll(linkedhashsetClone);
        }
        NIFRegistryOfferingEntry nifroeUpgraded = null;
        if (nifroeInstalledAndRegistered != null) {
            nifroeUpgraded = new NIFRegistryOfferingEntry(nifroeInstalledAndRegistered);
            nifroeUpgraded.setOffering(nifroeCurrent.getOffering());
            this.removeRegistryEntryFromNIFRegistry(nifroeInstalledAndRegistered);
            Logr.debug("performUpgrade: Remove product with Offering: " + nifroeInstalledAndRegistered.getOffering());
            Logr.debug("performUpgrade: Remove product with install location: " + nifroeInstalledAndRegistered.getOfferingLocationPath());
        } else {
            nifroeUpgraded = nifroeCurrent;
        }
        this.addRegistryEntryToNIFRegistry(nifroeUpgraded);
        Logr.debug("performUpgrade: Add product with Offering: " + nifroeUpgraded.getOffering());
        Logr.debug("performUpgrade: Add product with install location: " + nifroeUpgraded.getOfferingLocationPath());
    }

    public void purgeRegistryEntriesOfThisProduct(NIFRegistryOfferingEntry nifroeThis) throws ParserConfigurationException, SAXException, URISyntaxException {
        NIFRegistryPAKEntry[] nifrpeOfThisProduct;
        if (nifroeThis == null) {
            return;
        }
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = nifrpeOfThisProduct = this.getPAKArrayForThisProduct(nifroeThis);
        int n = nifrpeOfThisProduct.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry element = nIFRegistryPAKEntryArray[n2];
            this.removeRegistryEntryFromNIFRegistry(element);
            ++n2;
        }
        this.removeRegistryEntryFromNIFRegistry(nifroeThis);
    }

    public void purgeNotExistingRegistryEntriesOfThisProduct(NIFRegistryOfferingEntry nifroeThis) throws ParserConfigurationException, SAXException, URISyntaxException {
        if (nifroeThis == null) {
            return;
        }
        NIFRegistryPAKEntry[] nifrpeOfThisProduct = this.getPAKArrayForThisProduct(nifroeThis);
        int numOfEntries = nifrpeOfThisProduct.length;
        NIFRegistryPAKEntry[] nIFRegistryPAKEntryArray = nifrpeOfThisProduct;
        int n = nifrpeOfThisProduct.length;
        int n2 = 0;
        while (n2 < n) {
            NIFRegistryPAKEntry element = nIFRegistryPAKEntryArray[n2];
            try {
                FileSystemEntry fsePak = new FileSystemEntry(element.getBackupPakLocationURI(), null);
                if (!fsePak.exists()) {
                    this.removeRegistryEntryFromNIFRegistry(element);
                    --numOfEntries;
                }
            }
            catch (IOException e) {
                Logr.debug(e.getMessage());
                return;
            }
            ++n2;
        }
        if (numOfEntries == 0) {
            this.removeRegistryEntryFromNIFRegistry(nifroeThis);
        }
    }

    public void commitNIFRegistry() throws ParserConfigurationException, SAXException, URISyntaxException {
        Iterator iteratorThis = this.m_linkedhashsetNIFRegistryAllEntryToBeRemoved.iterator();
        while (iteratorThis.hasNext()) {
            this.removeRegistryEntryFromDocument((NIFRegistryObjectEntry)iteratorThis.next());
        }
        iteratorThis = this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.iterator();
        while (iteratorThis.hasNext()) {
            this.addRegistryEntryToDocument((NIFRegistryObjectEntry)iteratorThis.next());
        }
        this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.clear();
        this.m_linkedhashsetNIFRegistryAllEntryToBeRemoved.clear();
    }

    public boolean hasRegistryChangedSinceLastCommit() {
        return !this.m_linkedhashsetNIFRegistryAllEntryToBeRemoved.isEmpty() || !this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.isEmpty();
    }

    public void resetNIFRegistry() {
        this.resetNIFRegistryDocument();
        this.m_linkedhashsetNIFRegistryAllEntry.clear();
        this.m_linkedhashsetNIFRegistryAllEntryToBeAdded.clear();
        this.m_linkedhashsetNIFRegistryAllEntryToBeRemoved.clear();
        this.m_linkedhashsetNIFRegistryOfferingEntry.clear();
        this.m_linkedhashsetNIFRegistryPAKEntry.clear();
    }

    public void resetNIFRegistryDocument() {
        m_documentSingleton = null;
    }

    protected NIFRegistry(InputStream inputstreamNIFRegistry) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        this.parseInputStream(inputstreamNIFRegistry);
    }

    protected void parseInputStream(InputStream inputstream) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (inputstream != null) {
            SimpleXMLParser sxpNIFRegistryFile = new SimpleXMLParser(inputstream, false);
            m_documentSingleton = sxpNIFRegistryFile.getDocument();
        } else if (m_documentSingleton == null) {
            m_documentSingleton = SimpleXMLParser.createNewDocument();
            SimpleXMLParser.addNestedElement("nifregistry", null, null, m_documentSingleton);
            Comment commentThis = m_documentSingleton.createComment("NIFRegistry - Do not delete!");
            m_documentSingleton.insertBefore(commentThis, m_documentSingleton.getLastChild());
        }
        if (m_documentSingleton.getDocumentElement().hasChildNodes()) {
            this.updateRegistryEntriesLinkedHashSetFromDocument();
        }
    }

    protected void addRegistryEntryToDocument(NIFRegistryObjectEntry nifregEntry) throws ParserConfigurationException, SAXException, URISyntaxException {
        Element nodeNIFRegistryRoot = m_documentSingleton.getDocumentElement();
        nifregEntry.addThisNIFRegistryEntryToThisDocument(nodeNIFRegistryRoot);
    }

    protected Node getNodeFromThisRegistryEntry(NIFRegistryObjectEntry nifre) throws URISyntaxException {
        Element nodeNIFRegistryRoot = m_documentSingleton.getDocumentElement();
        String sRegistryElementName = nifre.getNIFRegistryObjectName();
        Vector vnodeRegistryEntry = SimpleXMLParser.getAllNamedChildNodes((Node)nodeNIFRegistryRoot, sRegistryElementName);
        for (Node nodeRegistryEntry : vnodeRegistryEntry) {
            if (!nifre.doesThisNodeRepresentThisRegistryEntry(nodeRegistryEntry)) continue;
            return nodeRegistryEntry;
        }
        return null;
    }

    protected void removeRegistryEntryFromDocument(NIFRegistryObjectEntry nifregEntry) throws ParserConfigurationException, SAXException, URISyntaxException {
        Node nodesToBeRemoved;
        Element nodeNIFRegistryRoot = m_documentSingleton.getDocumentElement();
        if (nodeNIFRegistryRoot != null && nodeNIFRegistryRoot.hasChildNodes() && (nodesToBeRemoved = this.getNodeFromThisRegistryEntry(nifregEntry)) != null) {
            Node nodeTextNode = nodesToBeRemoved.getPreviousSibling();
            nodeNIFRegistryRoot.removeChild(nodesToBeRemoved);
            if (nodeTextNode.getNodeType() == 3) {
                nodeNIFRegistryRoot.removeChild(nodeTextNode);
            }
        }
    }

    protected void updateRegistryEntriesLinkedHashSetFromDocument() throws URISyntaxException {
        Vector vnodesEntries = new Vector();
        Element elementNIFRegistryRoot = m_documentSingleton.getDocumentElement();
        vnodesEntries.addAll(SimpleXMLParser.getChildElements(elementNIFRegistryRoot));
        this.m_linkedhashsetNIFRegistryAllEntry.clear();
        this.m_linkedhashsetNIFRegistryPAKEntry.clear();
        this.m_linkedhashsetNIFRegistryOfferingEntry.clear();
        for (Node nodeThis : vnodesEntries) {
            if (nodeThis.getNodeName().equals("pak")) {
                NIFRegistryPAKEntry nifrpe = new NIFRegistryPAKEntry(nodeThis);
                this.m_linkedhashsetNIFRegistryPAKEntry.add(nifrpe);
                this.m_linkedhashsetNIFRegistryAllEntry.add(nifrpe);
                Logr.debug("name: " + nifrpe.getNIFPackageName() + "\n" + "paklocationuri" + ": " + nifrpe.getBackupPakLocationURI() + "\n" + "productid" + ": " + nifrpe.getOffering() + "\n" + "installrooturi" + ": " + nifrpe.getOfferingLocationURI());
                continue;
            }
            if (nodeThis.getNodeName().equals("product")) {
                NIFRegistryOfferingEntry nifroe = new NIFRegistryOfferingEntry(nodeThis);
                this.m_linkedhashsetNIFRegistryOfferingEntry.add(nifroe);
                this.m_linkedhashsetNIFRegistryAllEntry.add(nifroe);
                Logr.debug("productid: " + nifroe.getOffering() + "\n" + "installrooturi" + ": " + nifroe.getOfferingLocationURI() + "\n" + "lastvisited" + ": " + nifroe.getOfferingLastVisited() + "\n" + "version" + ": " + nifroe.getOfferingVersion());
                continue;
            }
            NIFRegistryObjectEntry nifre = new NIFRegistryObjectEntry(nodeThis);
            this.m_linkedhashsetNIFRegistryAllEntry.add(nifre);
        }
    }

    protected boolean isMutuallyExclusiveOfferingID(String sID) {
        int i = 0;
        boolean bFound = false;
        while (i < AS_MUTUALLY_EXCLUSIVE_OFFERING_ID.length && !bFound) {
            if (AS_MUTUALLY_EXCLUSIVE_OFFERING_ID[i].equalsIgnoreCase(sID)) {
                bFound = true;
            }
            ++i;
        }
        return bFound;
    }

    public static boolean canCurrentUserAccessRootNIFRegistry(String sNIFRegistryFileName) {
        String sNIFRegistryPathForRootUser = NIFRegistry.getNIFRegistryPathForRootUser(sNIFRegistryFileName);
        try {
            Logr.debug("RegistryPathForRoot: " + sNIFRegistryPathForRootUser);
            File fileNIFRegistryPathForRootUser = new File(sNIFRegistryPathForRootUser);
            boolean fIsWriteable = NIFRegistry.isThisFileWriteable(fileNIFRegistryPathForRootUser);
            String string = " : ";
            Logr.debug("This user has writeable access to file: " + fileNIFRegistryPathForRootUser.getAbsolutePath() + string + fIsWriteable);
            return fIsWriteable;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getNIFRegistryPathForNonRootUser(String sNIFRegistyFileName) {
        String sUserHome = NIFRegistryHelper.normalizePathNoEndingSlash(System.getProperty(S_USER_HOME));
        String sNIFRegistryParent = String.valueOf(sUserHome) + S_NIFREGISTRY_RELATIVEPATH;
        Logr.debug("Non-root NIFRegistry parent: " + sNIFRegistryParent);
        return String.valueOf(sNIFRegistryParent) + "/" + sNIFRegistyFileName;
    }

    public static String getNIFRegistryPathForRootUser(String sNIFRegistryFileName) {
        String sNIFRegistryParent = null;
        sNIFRegistryParent = PlatformConstants.isCurrentPlatformWindows() ? NIFRegistry.getSystemRootOnWindows() : (PlatformConstants.getCurrentPlatform() == 1 ? "/usr/.ibm/.nif" : "/opt/.ibm/.nif");
        Logr.debug("Root NIFRegistry parent: " + sNIFRegistryParent);
        String sReturn = String.valueOf(sNIFRegistryParent) + "/" + sNIFRegistryFileName;
        return sReturn;
    }

    public static String getNIFRegistryPath(String sUserHome, String sNIFRegistryFileName) {
        if (PlatformConstants.isCurrentPlatformOS400() || PlatformConstants.isOS400Install()) {
            return "/QIBM/WAS/.ibm/.nif/" + sNIFRegistryFileName;
        }
        if (sUserHome != null) {
            sUserHome = NIFRegistryHelper.normalizePathNoEndingSlash(sUserHome);
            return String.valueOf(sUserHome) + S_NIFREGISTRY_RELATIVEPATH + "/" + sNIFRegistryFileName;
        }
        if (NIFRegistry.canCurrentUserAccessRootNIFRegistry(sNIFRegistryFileName)) {
            Logr.debug("root user");
            String sNIFRegistryPathForNonRootUser = NIFRegistry.getNIFRegistryPathForNonRootUser(sNIFRegistryFileName);
            try {
                File fileNIFRegistry = new File(sNIFRegistryPathForNonRootUser);
                if (fileNIFRegistry.exists()) {
                    Logr.debug("Use the non-root nifregistry.");
                    return sNIFRegistryPathForNonRootUser;
                }
                Logr.debug("Use the root nifregistry.");
                return NIFRegistry.getNIFRegistryPathForRootUser(sNIFRegistryFileName);
            }
            catch (Exception e) {
                Logr.debug("Use the root nifregistry due to exception.");
                return NIFRegistry.getNIFRegistryPathForRootUser(sNIFRegistryFileName);
            }
        }
        return NIFRegistry.getNIFRegistryPathForNonRootUser(sNIFRegistryFileName);
    }

    public static String getVistaVFSWindowsPath() {
        String sSystemDrive = NIFRegistry.getWindowsSystemEnv(S_SYSTEM_DRIVE);
        String sSystemRoot = NIFRegistry.getWindowsSystemEnv(S_SYSTEM_ROOT);
        String sSystemLocalAppData = NIFRegistry.getWindowsSystemEnv(S_LOCALAPPDATA);
        if (sSystemDrive != null && sSystemRoot != null && sSystemLocalAppData != null) {
            String sWindowsDirName = sSystemRoot.substring(sSystemDrive.length() + 1);
            return NIFRegistryHelper.normalizePathNoEndingSlash(String.valueOf(sSystemLocalAppData) + "/" + S_VIRTUAL_STORE + "/" + sWindowsDirName);
        }
        return null;
    }

    protected static String getFirstAvailableSystemDriveRootDirectory() {
        File[] aFileRoots = File.listRoots();
        String sRootAbsolutePath = null;
        File[] fileArray = aFileRoots;
        int n = aFileRoots.length;
        int n2 = 0;
        while (n2 < n) {
            File aFileRoot = fileArray[n2];
            sRootAbsolutePath = aFileRoot.getAbsolutePath();
            if (!sRootAbsolutePath.startsWith(S_DRIVE_A) && !sRootAbsolutePath.startsWith(S_DRIVE_B)) break;
            ++n2;
        }
        return NIFRegistryHelper.normalizePathNoEndingSlash(sRootAbsolutePath);
    }

    protected static String getSystemRootOnWindows() {
        if (m_sSystemRootOnWindows == null && (m_sSystemRootOnWindows = NIFRegistry.getWindowsSystemEnv(S_SYSTEM_ROOT)) == null) {
            m_sSystemRootOnWindows = NIFRegistry.getFirstAvailableSystemDriveRootDirectory();
        }
        return NIFRegistryHelper.normalizePathNoEndingSlash(m_sSystemRootOnWindows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getWindowsSystemEnv(String sEnvName) {
        String sSystemEnv = null;
        String cmdWindows = "cmd /c echo ";
        String cmdCygWin = "echo ";
        String macroWindows = "%";
        String macroCynWin = "$";
        String cmdInputParams = String.valueOf(macroWindows) + sEnvName + macroWindows;
        String cmdToBeExecuted = String.valueOf(cmdWindows) + cmdInputParams;
        Logr.debug("command is: " + cmdToBeExecuted);
        String line = null;
        Process p = null;
        InputStreamReader isr = null;
        try {
            BufferedReader brCommandResult;
            try {
                p = Runtime.getRuntime().exec(cmdToBeExecuted);
            }
            catch (IOException ioe) {
                cmdInputParams = String.valueOf(macroCynWin) + sEnvName;
                cmdToBeExecuted = String.valueOf(cmdCygWin) + cmdInputParams;
                Logr.debug("command is: " + cmdToBeExecuted);
                try {
                    p = Runtime.getRuntime().exec(cmdToBeExecuted);
                    isr = new InputStreamReader(p.getInputStream());
                    brCommandResult = new BufferedReader(isr);
                    line = brCommandResult.readLine();
                    if (line == null || line.equals("") || line.equals(cmdInputParams)) {
                        isr.close();
                        return null;
                    }
                    isr.close();
                    sSystemEnv = line;
                }
                catch (IOException ioe2) {
                    return null;
                }
            }
            if (sSystemEnv == null && (line = (brCommandResult = new BufferedReader(isr = new InputStreamReader(p.getInputStream()))).readLine()) != null && !line.equals("") && !line.equals(cmdInputParams)) {
                sSystemEnv = line;
            }
            Logr.debug("Value of system env variable: " + sEnvName + " is: " + sSystemEnv);
            isr.close();
            return NIFRegistryHelper.normalizePathNoEndingSlash(sSystemEnv);
        }
        catch (IOException ioe1) {
            return null;
        }
    }

    protected static String getTimeStamp() {
        return Long.toString(System.currentTimeMillis());
    }

    private static boolean canMakeDirsInThisPath(File dir) {
        block5: {
            File testDir;
            block6: {
                block7: {
                    try {
                        String sDirName = String.valueOf(dir.getName()) + S_UNDERSCORE + NIFRegistry.getTimeStamp();
                        String sTestDirPath = String.valueOf(dir.getParent()) + File.separator + sDirName;
                        Logr.debug("Dir Orig Path: " + sTestDirPath);
                        testDir = new File(sTestDirPath);
                        if (!testDir.mkdirs()) break block5;
                        if (!PlatformConstants.isCurrentPlatformWindowsVista()) break block6;
                        String sVistaVFSFilePath = NIFRegistry.getVistaVFSWindowsPath();
                        String sDirResultPath = String.valueOf(sVistaVFSFilePath) + File.separator + sDirName;
                        File fileNewDir = new File(sDirResultPath);
                        Logr.debug("Dir Result Path: " + sDirResultPath);
                        if (!fileNewDir.exists()) break block7;
                        Logr.debug("This is a non-root user with UAC on.");
                        NIFRegistry.deleteIfItIsAnEmptyDir(testDir);
                        return false;
                    }
                    catch (SecurityException e) {
                        return false;
                    }
                }
                Logr.debug("This is a root user.");
                NIFRegistry.deleteIfItIsAnEmptyDir(testDir);
                return true;
            }
            Logr.debug("CanMakeDirsInThisPath returns true on NON-VISTA.");
            NIFRegistry.deleteIfItIsAnEmptyDir(testDir);
            return true;
        }
        Logr.debug("CanMakeDirsInThisPath returns false.");
        return false;
    }

    private static void deleteIfItIsAnEmptyDir(File fileCurrentDir) {
        File[] children = fileCurrentDir.listFiles();
        if (children != null && children.length == 0) {
            fileCurrentDir.delete();
            NIFRegistry.deleteIfItIsAnEmptyDir(fileCurrentDir.getParentFile());
        }
    }

    private static boolean isThisPathWritable(File dir) {
        try {
            File fTemp = File.createTempFile("_write_", "_test_", dir);
            fTemp.delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isThisFileWriteable(File testFile) {
        Logr.debug("isThisFileWriteable.entry: testFilePath: " + testFile.getAbsolutePath());
        try {
            if (PlatformConstants.isCurrentPlatformWindows() && !testFile.exists()) {
                return NIFRegistry.canMakeDirsInThisPath(testFile);
            }
            while (true) {
                if (testFile.exists()) {
                    if (!testFile.isDirectory()) break;
                    return NIFRegistry.isThisPathWritable(testFile);
                }
                testFile = testFile.getParentFile();
            }
            if (!PlatformConstants.isCurrentPlatformWindows()) {
                return testFile.canWrite();
            }
            if (!PlatformConstants.isCurrentPlatformWindowsVista()) {
                try {
                    FileOutputStream fileoutputstreamThisFile = new FileOutputStream(testFile, true);
                    fileoutputstreamThisFile.close();
                    return true;
                }
                catch (FileNotFoundException fnfe) {
                    return false;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
            String sTestFilePathRealRoot = testFile.getAbsolutePath();
            sTestFilePathRealRoot = String.valueOf(sTestFilePathRealRoot) + S_UNDERSCORE + NIFRegistry.getTimeStamp();
            Logr.debug("File Path to test if it's a real root user: " + sTestFilePathRealRoot);
            File fileTestFileRealRoot = new File(sTestFilePathRealRoot);
            String sMsg = null;
            try {
                if (!fileTestFileRealRoot.createNewFile()) {
                    sMsg = "createNewFile method returns false. This is a non-root user with UAC off.";
                    Logr.debug(sMsg);
                    return false;
                }
                String sTestFileNameRealRoot = fileTestFileRealRoot.getName();
                String sWindowsVFSWindowsPath = NIFRegistry.getVistaVFSWindowsPath();
                String sWindowsVFSTestFilePath = String.valueOf(sWindowsVFSWindowsPath) + File.separator + sTestFileNameRealRoot;
                File fileVFSFile = new File(sWindowsVFSTestFilePath);
                if (!fileVFSFile.exists()) {
                    sMsg = "This is a real root user because the test file: " + sWindowsVFSTestFilePath + " doesn't exist in VFS.";
                    Logr.debug(sMsg);
                    fileTestFileRealRoot.delete();
                    return true;
                }
                sMsg = "This is a non-root user with UAC on because the test file exists in VFS.";
                Logr.debug(sMsg);
                fileVFSFile.delete();
                return false;
            }
            catch (Exception e) {
                sMsg = "Can not create file. This is a non-root user with UAC off.";
                Logr.debug(sMsg);
                return false;
            }
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

