/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.metadata;

import com.ibm.ws.pak.internal.utils.NameValuePair;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NIFPackageEntry {
    private String m_sNIFPackageName = "";
    private int m_nOrder = -1;
    private Vector m_vnamevaluepairParams = new Vector();
    private static final String S_EMPTY = "";
    private static final String className = "NIFPackageEntry";

    public NIFPackageEntry(Node nodeNIFPackageEntry) {
        Logr.methodEntry(className, "nodeNIFPackageEntry");
        this.m_sNIFPackageName = SimpleXMLParser.getNodeAttributeValue(nodeNIFPackageEntry, "name");
        String sOrder = SimpleXMLParser.getNodeAttributeValue(nodeNIFPackageEntry, "order");
        this.m_nOrder = Integer.parseInt(sOrder);
        this.setDefinedParamsForThisNode(nodeNIFPackageEntry);
        Logr.methodExit(className, "nodeNIFPackageEntry");
    }

    public NIFPackageEntry(String sNIFPackageName, int nOrder) {
        this.m_sNIFPackageName = sNIFPackageName;
        this.m_nOrder = nOrder;
    }

    public void addToThisDocument(Element elementParent) {
        Logr.methodEntry(className, "addToThisDocument");
        Hashtable<String, String> hashtableAttributes = new Hashtable<String, String>();
        hashtableAttributes.put("name", this.m_sNIFPackageName);
        hashtableAttributes.put("order", Integer.toString(this.m_nOrder));
        Element elementThis = SimpleXMLParser.addNestedElement("maintenance", null, hashtableAttributes, elementParent);
        int i = 0;
        while (i < this.m_vnamevaluepairParams.size()) {
            NameValuePair pairThis = (NameValuePair)this.m_vnamevaluepairParams.elementAt(i);
            this.addNestedElement(elementThis, pairThis.getName(), pairThis.getValue());
            ++i;
        }
        Logr.methodExit(className, "addToThisDocument");
    }

    public String getParamValue(String sName) {
        int i = 0;
        while (i < this.m_vnamevaluepairParams.size()) {
            NameValuePair pairThis = (NameValuePair)this.m_vnamevaluepairParams.elementAt(i);
            if (pairThis.getName().equals(sName)) {
                return pairThis.getValue();
            }
            ++i;
        }
        return null;
    }

    public void addParam(String sName, String sValue) {
        NameValuePair pair = new NameValuePair(sName, sValue);
        if (this.m_vnamevaluepairParams.contains(pair)) {
            return;
        }
        int nIndex = 0;
        int i = 0;
        while (i < this.m_vnamevaluepairParams.size()) {
            NameValuePair pairThis = (NameValuePair)this.m_vnamevaluepairParams.elementAt(i);
            if (pairThis.getName().equals(sName)) {
                nIndex = i;
                break;
            }
            ++i;
        }
        this.m_vnamevaluepairParams.add(nIndex, pair);
    }

    public void addParamOrReplaceParamValue(String sName, String sValue) {
        NameValuePair pair = new NameValuePair(sName, sValue);
        int nIndex = -1;
        int i = 0;
        while (i < this.m_vnamevaluepairParams.size()) {
            NameValuePair pairThis = (NameValuePair)this.m_vnamevaluepairParams.elementAt(i);
            if (pairThis.getName().equals(sName)) {
                nIndex = i;
                pairThis.setValue(sValue);
                return;
            }
            ++i;
        }
        if (nIndex > -1) {
            this.m_vnamevaluepairParams.add(pair);
        }
    }

    public void updateOrAddParam(String sName, String sValue) {
        int nIndex = -1;
        int i = 0;
        while (i < this.m_vnamevaluepairParams.size()) {
            NameValuePair pairThis = (NameValuePair)this.m_vnamevaluepairParams.elementAt(i);
            if (pairThis.getName().equals(sName)) {
                nIndex = i;
                break;
            }
            ++i;
        }
        NameValuePair pair = new NameValuePair(sName, sValue);
        if (nIndex == -1) {
            this.m_vnamevaluepairParams.add(0, pair);
        } else {
            this.m_vnamevaluepairParams.set(nIndex, pair);
        }
    }

    public int getOrder() {
        return this.m_nOrder;
    }

    public void setOrder(int nOrder) {
        this.m_nOrder = nOrder;
    }

    public String getNIFPackageName() {
        return this.m_sNIFPackageName;
    }

    public void setNIFPackageName(String sMaintenanceName) {
        this.m_sNIFPackageName = sMaintenanceName;
    }

    public Vector getParams() {
        return this.m_vnamevaluepairParams;
    }

    public void setParams(Vector vNameValuePairs) {
        this.m_vnamevaluepairParams = vNameValuePairs;
    }

    public void setParam(String sParam, String sValue) {
        if (this.m_vnamevaluepairParams == null) {
            this.m_vnamevaluepairParams = new Vector();
        }
        int i = 0;
        while (i < this.m_vnamevaluepairParams.size()) {
            NameValuePair nvpThis = (NameValuePair)this.m_vnamevaluepairParams.elementAt(i);
            if (nvpThis.getName().equals(sParam)) {
                nvpThis.setValue(sValue);
                return;
            }
            ++i;
        }
        NameValuePair nvpNew = new NameValuePair(sParam, sValue);
        this.m_vnamevaluepairParams.add(nvpNew);
    }

    private void setDefinedParamsForThisNode(Node nodeThis) {
        Vector vnodesParams = SimpleXMLParser.getAllNamedChildNodes(nodeThis, "param");
        int i = 0;
        while (i < vnodesParams.size()) {
            Node nodeParamThis = (Node)vnodesParams.elementAt(i);
            String sParamName = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "name");
            String sParamValue = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "value");
            this.m_vnamevaluepairParams.add(new NameValuePair(sParamName, sParamValue));
            ++i;
        }
    }

    private void addNestedElement(Element elementThis, String sAttriName, String sAttriValue) {
        Hashtable<String, String> hashtableParamThis = new Hashtable<String, String>();
        hashtableParamThis.put("name", sAttriName);
        hashtableParamThis.put("value", sAttriValue);
        SimpleXMLParser.addNestedElement("param", null, hashtableParamThis, elementThis);
    }
}

