/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.metadata;

import com.ibm.ws.pak.internal.NIFCachePlugin;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.NIFPackageApplicationPlugin;
import com.ibm.ws.pak.internal.install.metadata.MaintenanceInfoPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MaintenanceApplicationPlugin
extends NIFPackageApplicationPlugin {
    private static final String S_INSTALLPACKAGEURI_PARAM = "installpackageuri";
    private static final String S_METADATANAME_PARAM = "metadataname";
    private static final String S_BACKUPPACKAGEURI_PARAM = "backuppackageuri";
    private static final String S_BACKUPFLAG_PARAM = "backupflag";
    private static final String S_ISBACKUPPACKAGE_PARAM = "isbackuppackage";
    private static final String S_INFOPLUGINID_PARAM = "infopluginid";
    private static final String[] AS_EMPTY = new String[0];
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"installpackageuri", "metadataname", "backuppackageuri", "backupflag", "isbackuppackage", "infopluginid"};
    private static final String S_BACKUP_POSTIFX = ".backup";
    private final String className = "MaintenanceApplicationPlugin";

    @Override
    public void setBackuppackageuri(URI uriBackuppackageuri) {
        this.setPluginParam(S_BACKUPPACKAGEURI_PARAM, new String[]{uriBackuppackageuri.toString()});
    }

    @Override
    public void setInstallpackageuri(URI uriInstallpackageuri) {
        this.setPluginParam(S_INSTALLPACKAGEURI_PARAM, new String[]{uriInstallpackageuri.toString()});
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_EMPTY;
    }

    @Override
    protected void modifyNIFMetataData(int nStage) throws IOException, URISyntaxException, SAXException, IllegalAccessException, ParserConfigurationException, InstantiationException, ClassNotFoundException {
        Logr.methodEntry("MaintenanceApplicationPlugin", "modifyNIFMetataData");
        if (nStage == 2) {
            this.writeBackupMetaData();
        }
        Logr.methodExit("MaintenanceApplicationPlugin", "modifyNIFMetataData");
    }

    protected void writeBackupMetaData() throws IOException, URISyntaxException, SAXException, IllegalAccessException, ParserConfigurationException, InstantiationException, ClassNotFoundException {
        Logr.methodEntry("MaintenanceApplicationPlugin", "writeBackupMetaData");
        FileSystemEntry fseMaintenanceMetaDataTo = new FileSystemEntry(new URI(this.getBackuppackageuri()), this.getParamValue(S_METADATANAME_PARAM), this.getInstallToolkitBridge());
        Document documentMetaData = (Document)this.getPluginDefinitionDocument().cloneNode(true);
        this.markPackageAsABackupPackage(documentMetaData);
        this.markCacheIDAsABackupCacheID(documentMetaData);
        this.resolveTagetProductIDsAndTargetSubProductIDs(documentMetaData);
        XMLUtils.saveDocument(documentMetaData, fseMaintenanceMetaDataTo);
        Logr.methodExit("MaintenanceApplicationPlugin", "writeBackupMetaData");
    }

    private void markCacheIDAsABackupCacheID(Document documentMetaData) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        Logr.methodEntry("MaintenanceApplicationPlugin", "markCacheIDAsABackupCacheID");
        NIFPlugin[] anifp = NIFPlugin.createPlugins(documentMetaData, "install-package/nif-cache", this.getInstallToolkitBridge());
        if (anifp.length > 0) {
            NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(NIFCachePlugin.class, anifp);
            NIFCachePlugin nifc = (NIFCachePlugin)anifp[0];
            NIFPlugin.setPluginParamInThisDocument(documentMetaData, nifc.getPluginPath(), nifc.getID(), "cacheid", new String[]{String.valueOf(nifc.getCacheid()) + S_BACKUP_POSTIFX});
        }
        Logr.methodExit("MaintenanceApplicationPlugin", "markCacheIDAsABackupCacheID");
    }

    private void resolveTagetProductIDsAndTargetSubProductIDs(Document documentMetaData) throws SAXException {
        Logr.methodEntry("MaintenanceApplicationPlugin", "resolveTagetProductIDsAndTargetSubProductIDs");
        MaintenanceInfoPlugin mipThisPackage = this.getCachedMaintenanceInfoPlugin();
        NIFPlugin.setPluginParamInThisDocument(documentMetaData, mipThisPackage.getPluginPath(), mipThisPackage.getID(), "targetproductids", new String[]{mipThisPackage.getTargetproductids()});
        NIFPlugin.setPluginParamInThisDocument(documentMetaData, mipThisPackage.getPluginPath(), mipThisPackage.getID(), "targetsubproductids", new String[]{mipThisPackage.getTargetsubproductids()});
        Logr.methodExit("MaintenanceApplicationPlugin", "resolveTagetProductIDsAndTargetSubProductIDs");
    }

    private void markPackageAsABackupPackage(Document documentMetaData) throws SAXException {
        Logr.methodEntry("MaintenanceApplicationPlugin", "markPackageAsABackupPackage");
        MaintenanceInfoPlugin mipThisPackage = this.getCachedMaintenanceInfoPlugin();
        NIFPlugin.setPluginParamInThisDocument(documentMetaData, mipThisPackage.getPluginPath(), mipThisPackage.getID(), MaintenanceInfoPlugin.S_ISBACKUP_PACKAGE_PARAM, new String[]{Boolean.TRUE.toString()});
        Logr.methodExit("MaintenanceApplicationPlugin", "markPackageAsABackupPackage");
    }

    private MaintenanceInfoPlugin getCachedMaintenanceInfoPlugin() {
        Logr.methodEntry("MaintenanceApplicationPlugin", "getCachedMaintenanceInfoPlugin");
        return (MaintenanceInfoPlugin)NIFPlugin.getCachedPlugin(this.getParamValue(S_INFOPLUGINID_PARAM), this.getPluginDefinitionDocument(), this.getInstallToolkitBridge());
    }
}

