/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.failurerecovery;

import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusEntry;
import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusStage;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class UpdateStatusFile {
    private static final String className = "UpdateStatusFile";
    private URI m_uriBackupRepositoryURI = null;
    private static UpdateStatusFile _instance = null;
    private FileSystemEntry m_fseUpdateStatusFile = null;
    private FileSystemEntry m_fseBKUpdateStatusFile = null;
    private Vector m_vuseAllEntries = null;
    private UpdateStatusEntry m_useActiveEntry = null;
    private static final String S_EMPTY = "";
    private static final String S_RECOVERYREPOSITORY = "recovered";
    private static final String S_DEFAULT_TIMESTAMPFORMAT = "yyMMddHHmmss";
    private static final String S_DOT = ".";

    public static UpdateStatusFile getInstance(URI uriBackupRepositoryURI, InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "getInstance");
        if (_instance == null || _instance.isBackupRepositorySwitched(uriBackupRepositoryURI)) {
            _instance = new UpdateStatusFile(uriBackupRepositoryURI, itb);
        }
        return _instance;
    }

    public void resetUpdateStatusFile(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "resetUpdateStatusFile");
        URI uriBackupRepositoryURI = this.m_uriBackupRepositoryURI;
        int nReturnCode = 0;
        nReturnCode = this.backupAndClean(this.m_fseUpdateStatusFile, this.m_fseBKUpdateStatusFile, itb);
        if (nReturnCode != 1) {
            this.initialize(uriBackupRepositoryURI, itb);
        }
        Logr.methodExit(className, "resetUpdateStatusFile");
    }

    public void backupAndRemoveUpdateStatusFile(InstallToolkitBridge itb) {
        Logr.methodEntry(className, "backupAndRemoveUpdateStatusFile");
        this.backupAndClean(this.m_fseUpdateStatusFile, this.m_fseBKUpdateStatusFile, itb);
        Logr.methodExit(className, "backupAndRemoveUpdateStatusFile");
    }

    public void initializeUpdateStatusFile(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "initializeUpdateStatusFile");
        URI uriBackupRepositoryURI = this.m_uriBackupRepositoryURI;
        this.initialize(uriBackupRepositoryURI, itb);
        Logr.methodExit(className, "initializeUpdateStatusFile");
    }

    public static void initializeNewTopLevelEntry(String sFileName, String sMaintenanceName, String sUritoreinstall, String sUritouninstall, boolean fIsprimary) throws ParserConfigurationException, IOException {
        Logr.methodEntry(className, "initializeNewTopLevelEntry");
        if (_instance == null) {
            return;
        }
        UpdateStatusFile._instance.m_useActiveEntry = new UpdateStatusEntry(sFileName, sMaintenanceName, sUritoreinstall, sUritouninstall, fIsprimary);
        UpdateStatusFile._instance.m_vuseAllEntries.add(UpdateStatusFile._instance.m_useActiveEntry);
        _instance.commit();
        Logr.methodExit(className, "initializeNewTopLevelEntry");
    }

    public static void initializeAsCurrentStage(String sStage) throws ParserConfigurationException, IOException {
        Logr.methodEntry(className, "initializeAsCurrentStage");
        if (_instance == null || UpdateStatusFile._instance.m_useActiveEntry == null) {
            return;
        }
        UpdateStatusFile._instance.m_useActiveEntry.initializeAsCurrentStage(sStage);
        _instance.commit();
        Logr.methodExit(className, "initializeAsCurrentStage");
    }

    public static void initializeThisPackageInCurrentStage(String sFileName, String sMaintenanceName, String sUritoreinstall, String sUritouninstall, boolean fIsprimary) throws ParserConfigurationException, IOException {
        Logr.methodEntry(className, "initializeThisPackageInCurrentStage");
        if (_instance == null || UpdateStatusFile._instance.m_useActiveEntry == null) {
            return;
        }
        UpdateStatusFile._instance.m_useActiveEntry.initializeThisPackageInCurrentStage(sFileName, sMaintenanceName, sUritoreinstall, sUritouninstall, fIsprimary);
        _instance.commit();
        Logr.methodExit(className, "initializeThisPackageInCurrentStage");
    }

    public static void setMode(String sMaintenanceName, String sMode) throws ParserConfigurationException, IOException {
        Logr.methodEntry(className, "setMode");
        if (_instance == null || UpdateStatusFile._instance.m_useActiveEntry == null) {
            return;
        }
        UpdateStatusFile._instance.m_useActiveEntry.setMode(sMaintenanceName, sMode);
        _instance.commit();
        Logr.methodExit(className, "setMode");
    }

    public boolean hasFailure() {
        Logr.methodEntry(className, "hasFailure");
        int i = 0;
        while (i < this.m_vuseAllEntries.size()) {
            UpdateStatusEntry useThis = (UpdateStatusEntry)this.m_vuseAllEntries.elementAt(i);
            if (useThis.isFailed()) {
                Logr.methodReturn(className, "hasFailure", Boolean.TRUE);
                return true;
            }
            ++i;
        }
        Logr.methodReturn(className, "hasFailure", Boolean.FALSE);
        return false;
    }

    public UpdateStatusEntry[] getFailedEntries() {
        Logr.methodEntry(className, "getFailedEntries");
        Vector<UpdateStatusEntry> vuseFailed = new Vector<UpdateStatusEntry>();
        int i = 0;
        while (i < this.m_vuseAllEntries.size()) {
            UpdateStatusEntry useThis = (UpdateStatusEntry)this.m_vuseAllEntries.elementAt(i);
            if (useThis.isFailed()) {
                vuseFailed.add(useThis);
            }
            ++i;
        }
        Collections.sort(vuseFailed);
        return vuseFailed.toArray(new UpdateStatusEntry[vuseFailed.size()]);
    }

    public String[] getFailedPakNames() {
        Logr.methodEntry(className, "getFailedPakNames");
        Vector<String> vuseFailed = new Vector<String>();
        int i = 0;
        while (i < this.m_vuseAllEntries.size()) {
            UpdateStatusEntry useThis = (UpdateStatusEntry)this.m_vuseAllEntries.elementAt(i);
            if (useThis.isFailed()) {
                vuseFailed.add(useThis.getFileName());
            }
            ++i;
        }
        Collections.sort(vuseFailed);
        return vuseFailed.toArray(new String[vuseFailed.size()]);
    }

    public String getPackageNameOfTheLastestFailedOne() {
        Logr.methodEntry(className, "getPackageNameOfTheLastestFailedOne");
        UpdateStatusEntry[] useFailedOnes = this.getFailedEntries();
        if (useFailedOnes == null || useFailedOnes.length == 0) {
            return S_EMPTY;
        }
        return useFailedOnes[0].getMaintenanceName();
    }

    public UpdateStatusStage getFailedStage(UpdateStatusEntry useFailedEntry) {
        Logr.methodEntry(className, "getFailedStage");
        if (useFailedEntry == null) {
            return null;
        }
        int i = 0;
        while (i < useFailedEntry.getAllStages().size()) {
            UpdateStatusStage ussStage = (UpdateStatusStage)useFailedEntry.getAllStages().elementAt(i);
            if (ussStage.isFailed()) {
                return ussStage;
            }
            ++i;
        }
        return null;
    }

    public void commit() throws ParserConfigurationException, IOException {
        Logr.methodEntry(className, "commit");
        Document documentThis = this.buildDocument();
        XMLUtils.saveDocument(documentThis, this.m_fseBKUpdateStatusFile, true);
        XMLUtils.saveDocument(documentThis, this.m_fseUpdateStatusFile, true);
        Logr.methodExit(className, "commit");
    }

    public void markThisPackageOfThisEntryRecovered(String sURIPackage, UpdateStatusEntry useEntry) {
        Logr.methodEntry(className, "markThisPackageOfThisEntryRecovered");
        useEntry.getAttributes().put("modified", Boolean.TRUE.toString());
        String sURIsToBeExecuted = useEntry.getAttributeValue("URIsOfPackagesToBeExecuted");
        useEntry.getAttributes().put("URIsOfPackagesToBeExecuted", StringUtils.removeFirstOccurranceOfTokenFromString(sURIsToBeExecuted, sURIPackage, ";"));
        Logr.methodExit(className, "markThisPackageOfThisEntryRecovered");
    }

    public void markThisPackageNameOfThisEntryCleaned(String sMaintenanceName, UpdateStatusEntry useEntry) {
        Logr.methodEntry(className, "markThisPackageNameOfThisEntryCleaned");
        useEntry.getAttributes().put("modified", Boolean.TRUE.toString());
        String sMaintenanceNamesToBeCleaned = useEntry.getAttributeValue("MaintenanceNamesOfPackagesToBeCleaned");
        useEntry.getAttributes().put("MaintenanceNamesOfPackagesToBeCleaned", StringUtils.removeFirstOccurranceOfTokenFromString(sMaintenanceNamesToBeCleaned, sMaintenanceName, ";"));
        Logr.methodExit(className, "markThisPackageNameOfThisEntryCleaned");
    }

    public void markThisURIOfThisEntryCleaned(String sURIPackage, UpdateStatusEntry useEntry) {
        Logr.methodEntry(className, "markThisURIOfThisEntryCleaned");
        useEntry.getAttributes().put("modified", Boolean.TRUE.toString());
        String sURIsToBeCleaned = useEntry.getAttributeValue("URIsOfPackagesToBeCleaned");
        useEntry.getAttributes().put("URIsOfPackagesToBeCleaned", StringUtils.removeFirstOccurranceOfTokenFromString(sURIsToBeCleaned, sURIPackage, ";"));
        Logr.methodExit(className, "markThisURIOfThisEntryCleaned");
    }

    public void setAttributeOfThisEntry(UpdateStatusEntry useEntry, String sAttrName, String sAttrValue) {
        Logr.methodEntry(className, "setAttributeOfThisEntry");
        useEntry.setAttribute(sAttrName, sAttrValue);
        Logr.methodExit(className, "setAttributeOfThisEntry");
    }

    public Document buildDocument() throws ParserConfigurationException {
        Document documentThis = SimpleXMLParser.createNewDocument();
        Element elementRoot = SimpleXMLParser.addNestedElement("update", null, null, documentThis);
        int i = this.m_vuseAllEntries.size() - 1;
        while (i >= 0) {
            UpdateStatusEntry useEntryThis = (UpdateStatusEntry)this.m_vuseAllEntries.elementAt(i);
            useEntryThis.buildNode(elementRoot);
            --i;
        }
        return documentThis;
    }

    private UpdateStatusFile(URI uriBackupRepositoryURI, InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException {
        this.initialize(uriBackupRepositoryURI, itb);
    }

    private void initialize(URI uriBackupRepositoryURI, InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException {
        this.m_uriBackupRepositoryURI = uriBackupRepositoryURI;
        this.m_fseUpdateStatusFile = this.getFailureRecoveryFile(itb);
        this.m_fseBKUpdateStatusFile = this.getBKFailureRecoveryFile(itb);
        this.m_vuseAllEntries = this.parse(this.m_fseUpdateStatusFile, this.m_fseBKUpdateStatusFile);
    }

    private int backupAndClean(FileSystemEntry fseMetaData, FileSystemEntry fseBKMetaData, InstallToolkitBridge itb) {
        try {
            FileSystemEntry fseRecoveryRepository = new FileSystemEntry(this.m_uriBackupRepositoryURI, S_RECOVERYREPOSITORY, itb);
            if (!fseRecoveryRepository.exists()) {
                fseRecoveryRepository.mkdirs();
            }
            String sTimestamp = new SimpleDateFormat(S_DEFAULT_TIMESTAMPFORMAT).format(Calendar.getInstance().getTime());
            if (fseMetaData.exists()) {
                FileSystemEntry fseMetaDataTo = new FileSystemEntry(fseRecoveryRepository.getURI(), String.valueOf(sTimestamp) + S_DOT + fseMetaData.getEntryName(), itb);
                fseMetaData.moveTo(fseMetaDataTo);
            }
            if (fseBKMetaData.exists()) {
                FileSystemEntry fseBKMetaDataTo = new FileSystemEntry(fseRecoveryRepository.getURI(), String.valueOf(sTimestamp) + S_DOT + fseBKMetaData.getEntryName(), itb);
                fseBKMetaData.moveTo(fseBKMetaDataTo);
            }
            return 0;
        }
        catch (IOException e) {
            return 1;
        }
    }

    private Vector parse(FileSystemEntry fseMetaData, FileSystemEntry fseBKMetaData) throws IOException, ParserConfigurationException, SAXException {
        try {
            return this.parse(fseMetaData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.parse(fseBKMetaData);
        }
    }

    private Vector parse(FileSystemEntry fseMetaData) throws IOException, ParserConfigurationException, SAXException {
        Vector<UpdateStatusEntry> vuseAllEntries = new Vector<UpdateStatusEntry>();
        if (!fseMetaData.exists()) {
            return vuseAllEntries;
        }
        SimpleXMLParser sxpParser = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseMetaData);
        Vector vnodes = sxpParser.getNodes("update/package");
        if (vnodes == null || vnodes.size() == 0) {
            return vuseAllEntries;
        }
        int i = 0;
        while (i < vnodes.size()) {
            Node nodeThis = (Node)vnodes.elementAt(i);
            vuseAllEntries.add(UpdateStatusEntry.parse(nodeThis));
            ++i;
        }
        return vuseAllEntries;
    }

    private FileSystemEntry getFailureRecoveryFile(InstallToolkitBridge itb) throws IOException {
        return new FileSystemEntry(this.m_uriBackupRepositoryURI, "updateStatus.xml", itb);
    }

    private FileSystemEntry getBKFailureRecoveryFile(InstallToolkitBridge itb) throws IOException {
        return new FileSystemEntry(this.m_uriBackupRepositoryURI, "bk.updateStatus.xml", itb);
    }

    private boolean isBackupRepositorySwitched(URI uriNewBackupRepositoryURI) {
        Logr.methodEntry(className, "isBackupRepositorySwitched");
        if (this.m_uriBackupRepositoryURI == null) {
            Logr.methodReturn(className, "isBackupRepositorySwitched", Boolean.TRUE);
            return true;
        }
        File origBackupRepository = new File(this.m_uriBackupRepositoryURI.getPath());
        File newBackupRepository = new File(uriNewBackupRepositoryURI.getPath());
        if (origBackupRepository.getAbsolutePath().equals(newBackupRepository.getAbsolutePath())) {
            Logr.methodReturn(className, "isBackupRepositorySwitched", Boolean.FALSE);
            return false;
        }
        Logr.methodReturn(className, "isBackupRepositorySwitched", Boolean.TRUE);
        return true;
    }
}

