/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.failurerecovery;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusStage;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UpdateStatusEntry
implements Comparable {
    private static final String className = "UpdateStatusEntry";
    private Hashtable m_htAttributes = null;
    private Vector m_vussStages = null;
    private UpdateStatusStage m_ussCurrentStage = null;
    private static final String S_EMPTY = "";
    private static final Hashtable HT_MODE_PRIORITY = new Hashtable();
    private static final String[] AS_SUCCESS_MODES;

    static {
        HT_MODE_PRIORITY.put("complete", new Integer(0));
        HT_MODE_PRIORITY.put("init", new Integer(1));
        HT_MODE_PRIORITY.put("installbackup", new Integer(3));
        HT_MODE_PRIORITY.put("installupdate", new Integer(4));
        HT_MODE_PRIORITY.put("installconfig", new Integer(5));
        HT_MODE_PRIORITY.put("uninstallupdate", new Integer(6));
        HT_MODE_PRIORITY.put("uninstallconfig", new Integer(7));
        AS_SUCCESS_MODES = new String[]{"complete", "init"};
    }

    public UpdateStatusEntry(String sFileName, String sMaintenanceName, String sUritoreinstall, String sUritouninstall, boolean fIsprimary) {
        this(new Hashtable());
        Logr.methodEntry(className, className);
        this.getAttributes().put("maintenancefilename", sFileName);
        Logr.debug("maintenancefilename : " + sFileName);
        this.getAttributes().put("maintenancename", sMaintenanceName);
        Logr.debug("maintenancename : " + sMaintenanceName);
        this.getAttributes().put("uritoreinstall", sUritoreinstall);
        Logr.debug("uritoreinstall : " + sUritoreinstall);
        this.getAttributes().put("uritouninstall", sUritouninstall);
        Logr.debug("uritouninstall : " + sUritouninstall);
        this.getAttributes().put("mode", "init");
        Logr.debug("mode : init");
        this.getAttributes().put("timestamp", NIFConstants.getCurrentTimestamp());
        Logr.debug("timestamp : " + NIFConstants.getCurrentTimestamp());
        this.getAttributes().put("isprimary", new Boolean(fIsprimary).toString());
        Logr.debug("isprimary : " + new Boolean(fIsprimary).toString().toString());
    }

    public UpdateStatusEntry(Hashtable htAttributes) {
        this.m_htAttributes = htAttributes;
        this.m_ussCurrentStage = null;
        this.m_ussCurrentStage = null;
        this.m_vussStages = new Vector();
    }

    public static UpdateStatusEntry parse(Node nodeThis) {
        Hashtable htAttri = SimpleXMLParser.getAttriNameAndValueMap(nodeThis);
        UpdateStatusEntry frnThis = new UpdateStatusEntry(htAttri);
        frnThis.setStages(UpdateStatusStage.parseStages(nodeThis));
        return frnThis;
    }

    public void initializeAsCurrentStage(String sStage) {
        Logr.methodEntry(className, "initializeAsCurrentStage");
        this.m_ussCurrentStage = new UpdateStatusStage(sStage, new Vector());
        Logr.debug("Current stage : " + this.m_ussCurrentStage);
        this.m_vussStages.add(this.m_ussCurrentStage);
        Logr.methodExit(className, "initializeAsCurrentStage");
    }

    public void initializeThisPackageInCurrentStage(String sFileName, String sMaintenanceName, String sUritoreinstall, String sUritouninstall, boolean fIsprimary) {
        Logr.methodEntry(className, "initializeThisPackageInCurrentStage");
        if (this.m_ussCurrentStage == null) {
            Logr.debug("Current stage = null.");
            return;
        }
        UpdateStatusEntry useEntryFound = this.m_ussCurrentStage.findTheInitializedEntry(sMaintenanceName);
        if (useEntryFound != null) {
            Logr.debug("Found existing entry.");
            return;
        }
        this.m_ussCurrentStage.initializeThisPackage(sFileName, sMaintenanceName, sUritoreinstall, sUritouninstall, fIsprimary);
        Logr.debug("Initialize : " + sFileName + " , " + sMaintenanceName + " , " + sUritoreinstall + " , " + sUritouninstall + " , " + fIsprimary);
        Logr.methodExit(className, "initializeThisPackageInCurrentStage");
    }

    public boolean hasBeenInitialized(String sMaintenanceName) {
        Logr.methodEntry(className, "hasBeenInitialized");
        boolean hasBeenInitialized = this.findTheInitializedEntryFromStages(sMaintenanceName) != null;
        Logr.methodReturn(className, "hasBeenInitialized", new Boolean(hasBeenInitialized).toString());
        return hasBeenInitialized;
    }

    public UpdateStatusEntry findTheInitializedEntry(String sMaintenanceName) {
        Logr.methodEntry(className, "findTheInitializedEntry");
        if (this.isThisALeafNode()) {
            if (this.getAttributeValue("maintenancename").equals(sMaintenanceName)) {
                return this;
            }
            return null;
        }
        return this.findTheInitializedEntryFromStages(sMaintenanceName);
    }

    public boolean isThisALeafNode() {
        return this.m_vussStages.isEmpty();
    }

    public void setMode(String sMaintenanceName, String sMode) {
        Logr.methodEntry(className, "setMode");
        Logr.debug("Set mode for : " + sMaintenanceName + " , mode : " + sMode);
        if (this.isThisALeafNode()) {
            if (this.getMaintenanceName().equals(sMaintenanceName)) {
                this.getAttributes().put("mode", sMode);
            }
            return;
        }
        this.setModeOfStages(sMaintenanceName, sMode);
        String sModeStages = this.getModeOfStages();
        this.getAttributes().put("mode", sModeStages);
        Logr.methodExit(className, "setMode");
    }

    public void markThisPackageRecovered(String sURIPackage) {
        Logr.methodEntry(className, "markThisPackageRecovered");
        Logr.debug("Mark this package to be recovered : " + sURIPackage);
        this.getAttributes().put("modified", Boolean.TRUE.toString());
        String sURIsToBeExecuted = this.getAttributeValue("URIsOfPackagesToBeExecuted");
        this.getAttributes().put("URIsOfPackagesToBeExecuted", StringUtils.removeFirstOccurranceOfTokenFromString(sURIsToBeExecuted, sURIPackage, ";"));
        Logr.methodExit(className, "markThisPackageRecovered");
    }

    public void markThisPackageNameCleaned(String sMaintenanceName) {
        Logr.methodEntry(className, "markThisPackageNameCleaned");
        Logr.debug("Mark this package name to be cleaned : " + sMaintenanceName);
        this.getAttributes().put("modified", Boolean.TRUE.toString());
        String sMaintenanceNamesToBeCleaned = this.getAttributeValue("MaintenanceNamesOfPackagesToBeCleaned");
        this.getAttributes().put("MaintenanceNamesOfPackagesToBeCleaned", StringUtils.removeFirstOccurranceOfTokenFromString(sMaintenanceNamesToBeCleaned, sMaintenanceName, ";"));
        Logr.methodExit(className, "markThisPackageNameCleaned");
    }

    public void markThisURICleaned(String sURIPackage) {
        Logr.methodEntry(className, "markThisURICleaned");
        Logr.debug("Mark this uri to be cleaned : " + sURIPackage);
        this.getAttributes().put("modified", Boolean.TRUE.toString());
        String sURIsToBeCleaned = this.getAttributeValue("URIsOfPackagesToBeCleaned");
        this.getAttributes().put("URIsOfPackagesToBeCleaned", StringUtils.removeFirstOccurranceOfTokenFromString(sURIsToBeCleaned, sURIPackage, ";"));
        Logr.methodExit(className, "markThisURICleaned");
    }

    public String[] findAttrValuesForPackagesInThisStageForThisAttrWithOrWithoutTheseModes(String sStageThis, String sAttrName, String[] asModesThese, boolean fWithTheseModes, boolean fReverseOrder, boolean fPrimaryOnly) {
        Logr.methodEntry(className, "findAttrValuesForPackagesInThisStageForThisAttrWithOrWithoutTheseModes");
        UpdateStatusEntry[] auseEntries = this.findAllPackagesInThisStageWithOrWithoutTheseModes(sStageThis, asModesThese, fWithTheseModes);
        if (auseEntries == null) {
            return new String[0];
        }
        Vector<String> vsAttriValues = new Vector<String>();
        if (fReverseOrder) {
            int i = auseEntries.length - 1;
            while (i >= 0) {
                String sValue;
                if (!(fPrimaryOnly && !auseEntries[i].isprimary() || (sValue = auseEntries[i].getAttributeValue(sAttrName)) == null || sValue.trim().equals(S_EMPTY))) {
                    vsAttriValues.add(sValue);
                }
                --i;
            }
        } else {
            UpdateStatusEntry[] updateStatusEntryArray = auseEntries;
            int n = auseEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String sValue;
                UpdateStatusEntry auseEntrie = updateStatusEntryArray[n2];
                if (!(fPrimaryOnly && !auseEntrie.isprimary() || (sValue = auseEntrie.getAttributeValue(sAttrName)) == null || sValue.trim().equals(S_EMPTY))) {
                    vsAttriValues.add(sValue);
                }
                ++n2;
            }
        }
        return vsAttriValues.toArray(new String[vsAttriValues.size()]);
    }

    public UpdateStatusEntry[] findAllPackagesInThisStageWithOrWithoutTheseModes(String sStageThis, String[] asModeThese, boolean fWithTheseModes) {
        Logr.methodEntry(className, "findAllPackagesInThisStageWithOrWithoutTheseModes");
        UpdateStatusEntry[] auseEntries = this.findAllPackagesInThisStage(sStageThis);
        if (auseEntries == null) {
            return null;
        }
        Vector<UpdateStatusEntry> vuseEntriesForThisMode = new Vector<UpdateStatusEntry>();
        UpdateStatusEntry[] updateStatusEntryArray = auseEntries;
        int n = auseEntries.length;
        int n2 = 0;
        while (n2 < n) {
            UpdateStatusEntry auseEntrie = updateStatusEntryArray[n2];
            if (StringUtils.isThisTokenInThisArray(auseEntrie.getMode(), asModeThese) == fWithTheseModes) {
                vuseEntriesForThisMode.add(auseEntrie);
            }
            ++n2;
        }
        return vuseEntriesForThisMode.toArray(new UpdateStatusEntry[vuseEntriesForThisMode.size()]);
    }

    public UpdateStatusEntry[] findAllPackagesInThisStage(String sStageThis) {
        Logr.methodEntry(className, "findAllPackagesInThisStage");
        UpdateStatusStage ussStage = this.findThisStage(sStageThis);
        if (ussStage == null) {
            return null;
        }
        Vector vuseEntries = ussStage.getAllPackages();
        return vuseEntries.toArray(new UpdateStatusEntry[vuseEntries.size()]);
    }

    public UpdateStatusStage findThisStage(String sStage) {
        Logr.methodEntry(className, "findThisStage");
        Vector vussAllStages = this.getAllStages();
        if (vussAllStages == null) {
            return null;
        }
        int i = 0;
        while (i < vussAllStages.size()) {
            UpdateStatusStage ussStageThis = (UpdateStatusStage)vussAllStages.elementAt(i);
            if (ussStageThis.getStageName().equals(sStage)) {
                return ussStageThis;
            }
            ++i;
        }
        return null;
    }

    public boolean isInInstallBackupMode() {
        Logr.methodEntry(className, "isInInstallBackupMode");
        return "installbackup".equals(this.getAttributes().get("mode"));
    }

    public boolean isprimary() {
        return true;
    }

    public String getUritoreinstall() {
        return (String)this.getAttributes().get("uritoreinstall");
    }

    public String getUritouninstall() {
        return (String)this.getAttributes().get("uritouninstall");
    }

    public String getFileName() {
        return (String)this.getAttributes().get("maintenancefilename");
    }

    public String getMaintenanceName() {
        return (String)this.getAttributes().get("maintenancename");
    }

    public String getTimestamp() {
        return (String)this.getAttributes().get("timestamp");
    }

    public boolean isFailed() {
        Logr.methodEntry(className, "isFailed");
        if (this.hasBeenRecovered()) {
            Logr.methodReturn(className, "isFailed", Boolean.FALSE);
            return false;
        }
        String sMode = this.getAttributeValue("mode");
        if (this.isFailedMode(sMode)) {
            Logr.methodReturn(className, "isFailed", Boolean.TRUE);
            return true;
        }
        int i = 0;
        while (i < this.m_vussStages.size()) {
            UpdateStatusStage ussStage = (UpdateStatusStage)this.m_vussStages.elementAt(i);
            if (ussStage.isFailed()) {
                Logr.methodReturn(className, "isFailed", Boolean.TRUE);
                return true;
            }
            ++i;
        }
        Logr.methodReturn(className, "isFailed", Boolean.FALSE);
        return false;
    }

    public boolean hasBeenRecovered() {
        Logr.methodEntry(className, "hasBeenRecovered");
        if (!this.hasBeenModified()) {
            Logr.methodReturn(className, "hasBeenRecovered", Boolean.FALSE);
            return false;
        }
        String sURIToBeExecuted = this.getAttributeValue("URIsOfPackagesToBeExecuted");
        if (sURIToBeExecuted != null && !sURIToBeExecuted.trim().equals(S_EMPTY)) {
            Logr.methodReturn(className, "hasBeenRecovered", Boolean.FALSE);
            return false;
        }
        String sURIToBeCleaned = this.getAttributeValue("URIsOfPackagesToBeCleaned");
        if (sURIToBeCleaned != null && !sURIToBeCleaned.trim().equals(S_EMPTY)) {
            Logr.methodReturn(className, "hasBeenRecovered", Boolean.FALSE);
            return false;
        }
        String sMaintenanceNamesToBeCleaned = this.getAttributeValue("MaintenanceNamesOfPackagesToBeCleaned");
        if (sMaintenanceNamesToBeCleaned != null && !sMaintenanceNamesToBeCleaned.trim().equals(S_EMPTY)) {
            Logr.methodReturn(className, "hasBeenRecovered", Boolean.FALSE);
            return false;
        }
        Logr.methodReturn(className, "hasBeenRecovered", Boolean.TRUE);
        return true;
    }

    public boolean hasBeenModified() {
        return new Boolean(this.getAttributeValue("modified"));
    }

    public UpdateStatusStage getFailedStage() {
        int i = 0;
        while (i < this.m_vussStages.size()) {
            UpdateStatusStage ussStage = (UpdateStatusStage)this.m_vussStages.elementAt(i);
            if (ussStage.isFailed()) {
                return ussStage;
            }
            ++i;
        }
        return null;
    }

    public void setAttribute(String sAttr, String sValue) {
        this.getAttributes().put(sAttr, sValue);
    }

    public String getMode() {
        return (String)this.getAttributes().get("mode");
    }

    public Hashtable getAttributes() {
        if (this.m_htAttributes == null) {
            this.m_htAttributes = new Hashtable();
        }
        return this.m_htAttributes;
    }

    public String getAttributeValue(String sAttr) {
        return (String)this.getAttributes().get(sAttr);
    }

    public Vector getAllStages() {
        return this.m_vussStages;
    }

    public UpdateStatusStage getCurrentStage() {
        return this.m_ussCurrentStage;
    }

    public void setStages(Vector vussStages) {
        this.m_vussStages = vussStages;
        if (this.m_vussStages == null) {
            this.m_vussStages = new Vector();
        }
    }

    public void buildNode(Node nodeRoot) {
        Element elementPackageRoot = SimpleXMLParser.addNestedElement("package", null, this.getAttributes(), nodeRoot);
        Vector vussAllStages = this.getAllStages();
        int i = 0;
        while (i < vussAllStages.size()) {
            UpdateStatusStage ussStage = (UpdateStatusStage)vussAllStages.elementAt(i);
            ussStage.buildNode(elementPackageRoot);
            ++i;
        }
    }

    public int compareTo(Object obj) {
        UpdateStatusEntry useObj = (UpdateStatusEntry)obj;
        try {
            Date dateObj = NIFConstants.parseDateString(this.getTimestamp());
            Date dateThis = NIFConstants.parseDateString(useObj.getTimestamp());
            return dateThis.compareTo(dateObj);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String findHighestMode(String[] asModes) {
        String sReturn = null;
        String[] stringArray = asModes;
        int n = asModes.length;
        int n2 = 0;
        while (n2 < n) {
            String asMode = stringArray[n2];
            if (asMode != null) {
                if (sReturn == null) {
                    sReturn = asMode;
                } else {
                    int nPriorityCurrent = (Integer)HT_MODE_PRIORITY.get(sReturn);
                    int nPriorityThis = (Integer)HT_MODE_PRIORITY.get(asMode);
                    if (nPriorityThis > nPriorityCurrent) {
                        sReturn = asMode;
                    }
                }
            }
            ++n2;
        }
        return sReturn;
    }

    private boolean isFailedMode(String sMode) {
        return !StringUtils.isThisTokenInThisArray(sMode, AS_SUCCESS_MODES);
    }

    private UpdateStatusEntry findTheInitializedEntryFromStages(String sMaintenanceName) {
        int i = 0;
        while (i < this.m_vussStages.size()) {
            UpdateStatusStage ussStageThis = (UpdateStatusStage)this.m_vussStages.elementAt(i);
            UpdateStatusEntry useEntryThis = ussStageThis.findTheInitializedEntry(sMaintenanceName);
            if (useEntryThis != null) {
                return useEntryThis;
            }
            ++i;
        }
        return null;
    }

    private String getModeOfStages() {
        Vector<String> vsModes = new Vector<String>();
        int i = 0;
        while (i < this.m_vussStages.size()) {
            UpdateStatusStage useStage = (UpdateStatusStage)this.m_vussStages.elementAt(i);
            vsModes.add(useStage.getMode());
            ++i;
        }
        return UpdateStatusEntry.findHighestMode(vsModes.toArray(new String[vsModes.size()]));
    }

    private void setModeOfStages(String sMaintenanceName, String sMode) {
        int i = 0;
        while (i < this.m_vussStages.size()) {
            UpdateStatusStage ussStage = (UpdateStatusStage)this.m_vussStages.elementAt(i);
            ussStage.setMode(sMaintenanceName, sMode);
            ++i;
        }
    }
}

