/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.failurerecovery;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.failurerecovery.ICleaningPackagesPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CleaningPackagesPlugin
extends NIFPlugin {
    private static final String className = "CleaningPackagesPlugin";
    private static final String S_PARAM_CHILDPLUGINSRELATIVEPATH = "childpluginsrelativepath";
    private static final String S_PARAM_HASFAILURE = "hasFailure";
    private static final String S_PARAM_ENABLED = "enabled";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"childpluginsrelativepath", "hasFailure", "enabled"};
    private static final String[] AS_OPTIONAL_PARAMS = new String[0];

    public static CleaningPackagesPlugin getCleaningPackagesPlugin(InstallToolkitBridge itb) throws IOException, URISyntaxException, ParserConfigurationException, SAXException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Logr.methodEntry(className, "getCleaningPackagesPlugin");
        FileSystemEntry fseFailureRecovery = new FileSystemEntry(NIFConstants.getCurrentAppDirectoryURI(itb), "framework/failurerecovery.xml", itb);
        SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseFailureRecovery);
        NIFPlugin[] anifp = NIFPlugin.createPlugins(sxp.getDocument(), "failure-recovery-plugins/clean-packages", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(CleaningPackagesPlugin.class, anifp);
        Logr.methodReturn(className, "getCleaningPackagesPlugin", anifp[0]);
        return (CleaningPackagesPlugin)anifp[0];
    }

    public void clean() throws NIFException {
        Logr.methodEntry(className, "clean");
        if (!new Boolean(this.getParamValue(S_PARAM_ENABLED)).booleanValue()) {
            Logr.debug("enabled = false.");
            return;
        }
        if (!new Boolean(this.getParamValue(S_PARAM_HASFAILURE)).booleanValue()) {
            Logr.debug("hasFailure = false.");
            return;
        }
        try {
            NIFPlugin[] anifp = NIFPlugin.createChildPlugins(this, this.getParamValue(S_PARAM_CHILDPLUGINSRELATIVEPATH), this.getInstallToolkitBridge());
            NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(ICleaningPackagesPlugin.class, anifp);
            if (anifp == null || anifp.length == 0) {
                Logr.debug("CleaningPackagesPlugin = null or empty.");
                return;
            }
            NIFPlugin[] nIFPluginArray = anifp;
            int n = anifp.length;
            int n2 = 0;
            while (n2 < n) {
                NIFPlugin element = nIFPluginArray[n2];
                ((ICleaningPackagesPlugin)((Object)element)).clean();
                ++n2;
            }
        }
        catch (Exception e) {
            Logr.warn(className, "clean", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        Logr.methodExit(className, "clean");
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }
}

