/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.CollectionUtils;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class NIFPluginParamOverridePlugin
extends NIFPlugin {
    private String m_sCallerCacheID = null;
    private static NIFPluginParamOverridePlugin[] m_anifppop = null;
    private static final String S_PLUGINID_PARAM = "pluginid";
    private static final String S_PARAMNAME_PARAM = "paramname";
    private static final String S_PARAMVALUE_PARAM = "paramvalue";
    private static final String S_OVERRIDEENGAGED_PARAM = "overrideengaged";
    private static final String S_DOCREATE_PARAM = "docreate";
    private static final String S_NOREPLACE_PARAM = "noreplace";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"pluginid", "paramname", "paramvalue", "docreate", "overrideengaged"};
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"noreplace"};
    private static final String className = "NIFPluginParamOverridePlugin";

    public static void bootstrapPluginParamOverrides(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, URISyntaxException {
        Logr.methodEntry(className, "bootstrapPluginParamOverrides");
        NIFPluginParamOverridePlugin.registerPluginParamOverrides(itb);
        Logr.methodExit(className, "bootstrapPluginParamOverrides");
    }

    public static Hashtable overrideParamsIfInstructed(String sPluginID, Hashtable hashtableParams, String sCallerCacheId) {
        if (!NIFPluginParamOverridePlugin.havePluginParamOverridesBeenBootstrapped()) {
            return hashtableParams;
        }
        Hashtable hashtableReturn = CollectionUtils.shallowCloneHashtable(hashtableParams);
        NIFPluginParamOverridePlugin[] nIFPluginParamOverridePluginArray = m_anifppop;
        int n = m_anifppop.length;
        int n2 = 0;
        while (n2 < n) {
            NIFPluginParamOverridePlugin element = nIFPluginParamOverridePluginArray[n2];
            element.setCallercacheid(sCallerCacheId);
            if (element.getParamValue(S_PLUGINID_PARAM).equals(sPluginID) && new Boolean(element.getParamValue(S_OVERRIDEENGAGED_PARAM)).booleanValue()) {
                Vector<String> vsValue = new Vector<String>();
                String sParamToReplace = element.getParamValue(S_PARAMNAME_PARAM);
                String sReplacementValue = element.getParamValue(S_PARAMVALUE_PARAM);
                if (!(!hashtableReturn.containsKey(sParamToReplace) && !new Boolean(element.getParamValue(S_DOCREATE_PARAM)).booleanValue() || hashtableReturn.containsKey(sParamToReplace) && new Boolean(element.getParamValue(S_NOREPLACE_PARAM)).booleanValue())) {
                    vsValue.add(sReplacementValue);
                    hashtableReturn.put(sParamToReplace, vsValue);
                }
            }
            ++n2;
        }
        return hashtableReturn;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    private static boolean havePluginParamOverridesBeenBootstrapped() {
        return m_anifppop != null;
    }

    private static void registerPluginParamOverrides(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, URISyntaxException {
        Logr.methodEntry(className, "registerPluginParamOverrides");
        if (NIFPluginParamOverridePlugin.havePluginParamOverridesBeenBootstrapped()) {
            return;
        }
        FileSystemEntry fsePluginImplOverridesDB = new FileSystemEntry(NIFConstants.getCurrentAppDirectoryURI(itb), "framework/pluginparamoverrides.xml", itb);
        SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fsePluginImplOverridesDB);
        NIFPlugin[] anifp = NIFPlugin.createPlugins(sxp.getDocument(), "pluginparamoverrides/pluginparamoverride", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(NIFPluginParamOverridePlugin.class, anifp);
        m_anifppop = new NIFPluginParamOverridePlugin[anifp.length];
        int i = 0;
        while (i < anifp.length) {
            NIFPluginParamOverridePlugin.m_anifppop[i] = (NIFPluginParamOverridePlugin)anifp[i];
            ++i;
        }
        Logr.methodExit(className, "registerPluginParamOverrides");
    }

    public void setCallercacheid(String cacheid) {
        this.m_sCallerCacheID = cacheid;
    }

    public String getCallercacheid() {
        return this.m_sCallerCacheID;
    }
}

