/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal;

import com.ibm.ws.pak.internal.NIFCachePlugin;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.utils.NIFPluginUtils;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NIFCacheManager {
    private static Hashtable m_hashtableCachePlugins = new Hashtable();
    private static final String className = "NIFCacheManager";

    public static NIFPlugin getCachedPlugin(String sPluginID, Document documentPluginDefinitions, InstallToolkitBridge itb) {
        try {
            NIFCachePlugin nifcThis = NIFCacheManager.createDefinedCachePlugin(documentPluginDefinitions, itb);
            if (nifcThis == null) {
                return NIFCacheManager.getGlobalCachePlugin(itb).getCachedPlugin(sPluginID);
            }
            NIFCachePlugin nifcThisCacheID = (NIFCachePlugin)m_hashtableCachePlugins.get(nifcThis.getCacheid());
            if (nifcThisCacheID == null) {
                return NIFCacheManager.getGlobalCachePlugin(itb).getCachedPlugin(sPluginID);
            }
            NIFPlugin nifpReturn = nifcThisCacheID.getCachedPlugin(sPluginID);
            if (nifpReturn == null) {
                nifpReturn = NIFCacheManager.getGlobalCachePlugin(itb).getCachedPlugin(sPluginID);
            }
            return nifpReturn;
        }
        catch (Exception e) {
            Logr.warn(className, "getCachedPlugin", e.getMessage(), e);
            return null;
        }
    }

    public static void cachePlugin(NIFPlugin nifp, Document documentPluginDefinitions, InstallToolkitBridge itb) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        NIFCachePlugin nifcThisCacheID;
        NIFCachePlugin nifcThis = NIFCacheManager.createDefinedCachePlugin(documentPluginDefinitions, itb);
        if (nifcThis == null) {
            nifcThis = NIFCacheManager.getGlobalCachePlugin(itb);
        }
        if ((nifcThisCacheID = (NIFCachePlugin)m_hashtableCachePlugins.get(nifcThis.getCacheid())) != null) {
            nifcThisCacheID.cachePlugin(nifp);
        } else {
            nifcThis.cachePlugin(nifp);
            m_hashtableCachePlugins.put(nifcThis.getCacheid(), nifcThis);
        }
    }

    public static void flushCache() {
        Enumeration enumerationKeys = m_hashtableCachePlugins.keys();
        while (enumerationKeys.hasMoreElements()) {
            NIFCachePlugin nifcThis = (NIFCachePlugin)m_hashtableCachePlugins.get(enumerationKeys.nextElement());
            nifcThis.flushPluginCache();
        }
        m_hashtableCachePlugins.clear();
    }

    private static NIFCachePlugin createDefinedCachePlugin(Document documentPluginDefinitions, InstallToolkitBridge itb) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        NIFPlugin[] anifp = NIFPlugin.createPlugins(documentPluginDefinitions, "install-package/nif-cache", itb);
        NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(NIFCachePlugin.class, anifp);
        if (anifp.length > 0) {
            return (NIFCachePlugin)anifp[0];
        }
        return null;
    }

    private static NIFCachePlugin getGlobalCachePlugin(InstallToolkitBridge itb) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, IOException {
        if (m_hashtableCachePlugins.get("com.ibm.ws.pak.internal.GlobalCache") != null) {
            return (NIFCachePlugin)m_hashtableCachePlugins.get("com.ibm.ws.pak.internal.GlobalCache");
        }
        NIFCachePlugin nifcGlobal = NIFCacheManager.createDefinedCachePlugin(new SimpleXMLParser("<?xml version=\"1.0\" encoding=\"UTF-8\"?><install-package><nif-cache id=\"nifcache\" impl=\"com.ibm.ws.pak.internal.NIFCachePlugin\"><param name=\"cacheid\" value=\"com.ibm.ws.pak.internal.GlobalCache\"/></nif-cache></install-package>").getDocument(), itb);
        m_hashtableCachePlugins.put("com.ibm.ws.pak.internal.GlobalCache", nifcGlobal);
        return nifcGlobal;
    }
}

